/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseMapTileCache;
import org.unitime.timetable.model.base.MapTileCacheId;
import org.unitime.timetable.model.dao.MapTileCacheDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="map_tiles")
public class MapTileCache
extends BaseMapTileCache {
    private static final long serialVersionUID = 1L;

    public MapTileCache() {
    }

    public MapTileCache(int zoom, int x, int y) {
        this.setX(x);
        this.setY(y);
        this.setZ(zoom);
    }

    @Transient
    public boolean isTooOld() {
        return System.currentTimeMillis() - this.getTimeStamp().getTime() > 604800000L;
    }

    public static byte[] get(int zoom, int x, int y) {
        MapTileCache tile = (MapTileCache)MapTileCacheDAO.getInstance().get(new MapTileCacheId(zoom, x, y));
        return tile == null || tile.isTooOld() ? null : tile.getData();
    }

    public static void put(int zoom, int x, int y, byte[] data) {
        Session hibSession = MapTileCacheDAO.getInstance().getSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            MapTileCache tile = (MapTileCache)MapTileCacheDAO.getInstance().get(new MapTileCacheId(zoom, x, y), hibSession);
            if (tile == null) {
                tile = new MapTileCache();
                tile.setX(x);
                tile.setY(y);
                tile.setZ(zoom);
                tile.setData(data);
                tile.setTimeStamp(new Date());
                hibSession.persist((Object)tile);
            } else {
                tile.setData(data);
                tile.setTimeStamp(new Date());
                hibSession.merge((Object)tile);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
    }
}

