/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.Iterator;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class TableBuilder {
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static ExaminationMessages XMSG = Localization.create(ExaminationMessages.class);
    private SessionContext iContext;
    private String iBackType = null;
    private String iBackId = null;
    protected boolean iSticky = false;
    protected boolean iSimple = false;
    public String iInstructorNameFormat = "last-first";
    private Boolean iHighlightClassPrefs = null;
    private boolean iTimeVertical = false;
    private boolean iGridAsText = false;
    public String iDefaultTimeGridSize = null;

    public TableBuilder(SessionContext context, String backType, String backId) {
        this.setSessionContext(context);
        this.setInstructorNameFormat(UserProperty.NameFormat.get(context.getUser()));
        this.setBackType(backType);
        this.setBackId(backId);
        this.setUserSettings(context.getUser());
    }

    public SessionContext getSessionContext() {
        return this.iContext;
    }

    public void setSessionContext(SessionContext context) {
        this.iContext = context;
    }

    public UserContext getUser() {
        return this.getSessionContext().getUser();
    }

    public Long getCurrentAcademicSessionId() {
        return this.getUser().getCurrentAcademicSessionId();
    }

    public void setSimple(boolean simple) {
        this.iSimple = simple;
    }

    public boolean isSimple() {
        return this.iSimple;
    }

    public void setInstructorNameFormat(String instructorNameFormat) {
        this.iInstructorNameFormat = instructorNameFormat;
    }

    public String getInstructorNameFormat() {
        return this.iInstructorNameFormat;
    }

    public void setHighlightClassPrefs(boolean highlightClassPrefs) {
        this.iHighlightClassPrefs = highlightClassPrefs;
    }

    public boolean isHighlightClassPrefs() {
        if (this.iHighlightClassPrefs == null) {
            return ApplicationProperty.PreferencesHighlighClassPreferences.isTrue();
        }
        return this.iHighlightClassPrefs;
    }

    public String getBackType() {
        return this.iBackType;
    }

    public void setBackType(String backType) {
        this.iBackType = backType;
    }

    public String getBackId() {
        return this.iBackId;
    }

    public void setBackId(String backId) {
        this.iBackId = backId;
    }

    public void setTimeVertival(boolean timeVertical) {
        this.iTimeVertical = timeVertical;
    }

    public boolean getTimeVertival() {
        return this.iTimeVertical;
    }

    public void setGridAsText(boolean gridAsText) {
        this.iGridAsText = gridAsText;
    }

    public boolean getGridAsText() {
        return this.iGridAsText;
    }

    public void setDefaultTimeGridSize(String defaultTimeGridSize) {
        this.iDefaultTimeGridSize = defaultTimeGridSize;
    }

    public String getDefaultTimeGridSize() {
        return this.iDefaultTimeGridSize;
    }

    public void setUserSettings(UserContext user) {
        this.setTimeVertival(RequiredTimeTable.getTimeGridVertical(user));
        this.setGridAsText(RequiredTimeTable.getTimeGridAsText(user));
        this.setInstructorNameFormat(UserProperty.NameFormat.get(user));
        this.setDefaultTimeGridSize(RequiredTimeTable.getTimeGridSize(user));
        this.iSticky = CommonValues.Yes.eq(UserProperty.StickyTables.get(user));
        String highlighClassPreferences = UserProperty.HighlighClassPreferences.get(user);
        if (CommonValues.Yes.eq(highlighClassPreferences)) {
            this.setHighlightClassPrefs(true);
        } else if (CommonValues.No.eq(highlighClassPreferences)) {
            this.setHighlightClassPrefs(false);
        } else {
            this.setHighlightClassPrefs(ApplicationProperty.PreferencesHighlighClassPreferences.isTrue());
        }
    }

    protected TableInterface.CellInterface preferenceCell(Preference p) {
        TableInterface.CellInterface cell = new TableInterface.CellInterface();
        if (!this.isSimple()) {
            cell.addStyle("font-weight: bold;");
        }
        if (p.getPrefLevel().getPrefId() != 4) {
            cell.setColor(PreferenceLevel.prolog2color(p.getPrefLevel().getPrefProlog()));
        }
        Object owner = "";
        if (p.getOwner() != null && p.getOwner() instanceof Class_) {
            owner = " (" + MSG.prefOwnerClass() + ")";
        } else if (p.getOwner() != null && p.getOwner() instanceof SchedulingSubpart) {
            owner = " (" + MSG.prefOwnerSchedulingSubpart() + ")";
        } else if (p.getOwner() != null && p.getOwner() instanceof DepartmentalInstructor) {
            owner = " (" + MSG.prefOwnerInstructor() + ")";
        } else if (p.getOwner() != null && p.getOwner() instanceof Exam) {
            owner = " (" + MSG.prefOwnerExamination() + ")";
        } else if (p.getOwner() != null && p.getOwner() instanceof Department) {
            owner = " (" + MSG.prefOwnerDepartment() + ")";
        } else if (p.getOwner() != null && p.getOwner() instanceof Session) {
            owner = " (" + MSG.prefOwnerSession() + ")";
        }
        Object hint = HtmlUtils.htmlEscape((String)(p.preferenceTitle(this.getInstructorNameFormat()) + (String)owner));
        String description = p.preferenceDescription();
        if (description != null && !description.isEmpty()) {
            hint = (String)hint + "<br>" + HtmlUtils.htmlEscape((String)description.replace("'", "\\'")).replace("\n", "<br>");
        }
        cell.setAria(p.getPrefLevel().getPrefAbbv() + " " + p.preferenceAbbv(this.getInstructorNameFormat()));
        if (p.getOwner() != null && p.getOwner() instanceof Class_ && this.isHighlightClassPrefs()) {
            cell.add(p.preferenceAbbv(this.getInstructorNameFormat())).addStyle("background: #ffa;").setAria("");
        } else {
            cell.setText(p.preferenceAbbv(this.getInstructorNameFormat()));
        }
        cell.setInline(false);
        if (p instanceof RoomPref) {
            RoomPref rp = (RoomPref)p;
            cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + rp.getRoom().getUniqueId() + "', '" + p.getPrefLevel().getPrefName() + " " + MSG.prefRoom() + " {0} ({1}" + (String)owner + ")');");
            cell.setMouseOut("$wnd.hideGwtRoomHint();");
        } else if (p instanceof BuildingPref) {
            BuildingPref bp = (BuildingPref)p;
            cell.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '-" + bp.getBuilding().getUniqueId() + "', '" + p.getPrefLevel().getPrefName() + " " + MSG.prefBuilding() + " {0}" + (String)owner + "');");
            cell.setMouseOut("$wnd.hideGwtRoomHint();");
        } else if (p instanceof DistributionPref) {
            DistributionPref dp = (DistributionPref)p;
            hint = HtmlUtils.htmlEscape((String)(p.getPrefLevel().getPrefName() + " " + dp.getLabel() + (String)owner));
            if (dp.getDistributionObjects() != null && !dp.getDistributionObjects().isEmpty()) {
                hint = (String)hint + "<ul><li>";
                String aria = p.getPrefLevel().getPrefAbbv() + " " + p.preferenceAbbv(this.getInstructorNameFormat()) + " (";
                Iterator<DistributionObject> it = dp.getOrderedSetOfDistributionObjects().iterator();
                while (it.hasNext()) {
                    DistributionObject distObj = it.next();
                    hint = (String)hint + HtmlUtils.htmlEscape((String)distObj.preferenceText());
                    aria = aria + distObj.preferenceText();
                    if (!it.hasNext()) continue;
                    hint = (String)hint + "<li>";
                    aria = aria + ", ";
                }
                aria = aria + ")";
                cell.setAria(aria);
                hint = (String)hint + "</ul>";
            } else if (dp.getOwner() instanceof DepartmentalInstructor) {
                hint = (String)hint + "<ul><li>";
                Iterator<ClassInstructor> it = ((DepartmentalInstructor)dp.getOwner()).getClasses().iterator();
                while (it.hasNext()) {
                    ClassInstructor ci = it.next();
                    hint = (String)hint + HtmlUtils.htmlEscape((String)ci.getClassInstructing().getClassLabel());
                    if (!it.hasNext()) continue;
                    hint = (String)hint + "<li>";
                }
                hint = (String)hint + "</ul>";
            }
            if (description != null && !description.isEmpty()) {
                hint = (String)hint + "<br>" + HtmlUtils.htmlEscape((String)description.replace("'", "\\'")).replace("\n", "<br>");
            }
            cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + (String)hint + "');");
            cell.setMouseOut("$wnd.hideGwtHint();");
        } else {
            cell.setMouseOver("$wnd.showGwtHint($wnd.lastMouseOverElement, '" + (String)hint + "');");
            cell.setMouseOut("$wnd.hideGwtHint();");
        }
        return cell;
    }
}

