/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.MapWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class BuildingsEdit
extends Composite
implements TakesValue<RoomInterface.BuildingInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm = new SimpleForm();
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeWidget<TextBox> iName;
    private UniTimeWidget<TextBox> iAbbreviation;
    private TextBox iExternalId;
    private NumberBox iX;
    private NumberBox iY;
    private UniTimeWidget<P> iCoordinates;
    private P iCoordinatesFormat;
    private MapWidget iMap = null;
    private RoomInterface.BuildingInterface iBuilding = null;
    private CheckBox iUpdateRoomCoordinates = null;

    public BuildingsEdit() {
        this.iForm.addStyleName("unitime-BuildingEdit");
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("save", MESSAGES.buttonSave(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!BuildingsEdit.this.validate()) {
                    return;
                }
                RoomInterface.UpdateBuildingRequest request = new RoomInterface.UpdateBuildingRequest();
                request.setAction(RoomInterface.UpdateBuildingAction.CREATE);
                request.setBuilding(BuildingsEdit.this.getValue());
                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                RPC.execute(request, new AsyncCallback<RoomInterface.BuildingInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        BuildingsEdit.this.iHeader.setErrorMessage(MESSAGES.failedCreate(MESSAGES.objectBuilding(), caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedCreate(MESSAGES.objectBuilding(), caught.getMessage()), caught);
                    }

                    public void onSuccess(RoomInterface.BuildingInterface result) {
                        LoadingWidget.getInstance().hide();
                        BuildingsEdit.this.onBack(true, result.getId());
                    }
                });
            }
        });
        this.iHeader.addButton("update", MESSAGES.buttonUpdate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!BuildingsEdit.this.validate()) {
                    return;
                }
                RoomInterface.UpdateBuildingRequest request = new RoomInterface.UpdateBuildingRequest();
                request.setAction(RoomInterface.UpdateBuildingAction.UPDATE);
                request.setBuilding(BuildingsEdit.this.getValue());
                request.setUpdateRoomCoordinates(BuildingsEdit.this.iUpdateRoomCoordinates.getValue());
                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                RPC.execute(request, new AsyncCallback<RoomInterface.BuildingInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        BuildingsEdit.this.iHeader.setErrorMessage(MESSAGES.failedUpdate(MESSAGES.objectBuilding(), caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedUpdate(MESSAGES.objectBuilding(), caught.getMessage()), caught);
                    }

                    public void onSuccess(RoomInterface.BuildingInterface result) {
                        LoadingWidget.getInstance().hide();
                        BuildingsEdit.this.onBack(true, result.getId());
                    }
                });
            }
        });
        this.iHeader.addButton("delete", MESSAGES.buttonDelete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.confirm(MESSAGES.confirmBuildingDelete(), new Command(){

                    public void execute() {
                        RoomInterface.UpdateBuildingRequest request = new RoomInterface.UpdateBuildingRequest();
                        request.setAction(RoomInterface.UpdateBuildingAction.DELETE);
                        request.setBuilding(BuildingsEdit.this.getValue());
                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                        RPC.execute(request, new AsyncCallback<RoomInterface.BuildingInterface>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                BuildingsEdit.this.iHeader.setErrorMessage(MESSAGES.failedDelete(MESSAGES.objectBuilding(), caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedDelete(MESSAGES.objectBuilding(), caught.getMessage()), caught);
                            }

                            public void onSuccess(RoomInterface.BuildingInterface result) {
                                LoadingWidget.getInstance().hide();
                                BuildingsEdit.this.onBack(true, null);
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BuildingsEdit.this.onBack(false, BuildingsEdit.this.iBuilding.getId());
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iAbbreviation = new UniTimeWidget<TextBox>(new TextBox());
        this.iAbbreviation.getWidget().setStyleName("unitime-TextBox");
        this.iAbbreviation.getWidget().setMaxLength(20);
        this.iAbbreviation.getWidget().setWidth("100px");
        this.iAbbreviation.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                BuildingsEdit.this.iAbbreviation.clearHint();
                BuildingsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propAbbreviation(), (Widget)this.iAbbreviation);
        this.iName = new UniTimeWidget<TextBox>(new TextBox());
        this.iName.getWidget().setStyleName("unitime-TextBox");
        this.iName.getWidget().setMaxLength(100);
        this.iName.getWidget().setWidth("600px");
        this.iName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                BuildingsEdit.this.iName.clearHint();
                BuildingsEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        this.iExternalId = new TextBox();
        this.iExternalId.setStyleName("unitime-TextBox");
        this.iExternalId.setMaxLength(40);
        this.iExternalId.setWidth("200px");
        this.iForm.addRow(MESSAGES.propExternalId(), (Widget)this.iExternalId);
        this.iX = new NumberBox();
        this.iX.setMaxLength(12);
        this.iX.setWidth("80px");
        this.iX.setDecimal(true);
        this.iX.setNegative(true);
        this.iX.addStyleName("number");
        this.iY = new NumberBox();
        this.iY.setMaxLength(12);
        this.iY.setWidth("80px");
        this.iY.setDecimal(true);
        this.iY.setNegative(true);
        this.iY.addStyleName("number");
        this.iX.getElement().setId("coordX");
        this.iY.getElement().setId("coordY");
        this.iCoordinates = new UniTimeWidget<P>(new P("coordinates"));
        this.iCoordinates.getWidget().add((Widget)this.iX);
        P comma = new P("comma");
        comma.setText(", ");
        this.iCoordinates.getWidget().add((Widget)comma);
        this.iCoordinates.getWidget().add((Widget)this.iY);
        this.iCoordinatesFormat = new P("format");
        this.iCoordinates.getWidget().add((Widget)this.iCoordinatesFormat);
        this.iForm.addRow(MESSAGES.propCoordinates(), (Widget)this.iCoordinates);
        this.iFooter = this.iHeader.clonePanel("");
        this.iUpdateRoomCoordinates = new CheckBox(MESSAGES.checkBuildingUpdateRoomCoordinates());
        this.iUpdateRoomCoordinates.setVisible(false);
        this.iUpdateRoomCoordinates.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
        this.iFooter.insertLeft((Widget)this.iUpdateRoomCoordinates, true);
        MapWidget.createWidget(this.iX, this.iY, new AsyncCallback<MapWidget>(){

            public void onSuccess(MapWidget result) {
                BuildingsEdit.this.iMap = result;
                if (BuildingsEdit.this.iMap != null) {
                    BuildingsEdit.this.iMap.setEnabled(true);
                    BuildingsEdit.this.iForm.addRow(MESSAGES.propMap(), (Widget)BuildingsEdit.this.iMap);
                }
                BuildingsEdit.this.iForm.addBottomRow((Widget)BuildingsEdit.this.iFooter);
            }

            public void onFailure(Throwable caught) {
                BuildingsEdit.this.iForm.addBottomRow((Widget)BuildingsEdit.this.iFooter);
            }
        });
        this.initWidget((Widget)this.iForm);
    }

    protected void onBack(boolean refresh, Long buildingId) {
    }

    protected boolean isAbbreviationUnique(RoomInterface.BuildingInterface building) {
        return true;
    }

    public void show() {
        if (this.iMap != null) {
            this.iMap.onShow();
        }
    }

    public void setCoordinatesFormat(String format) {
        this.iCoordinatesFormat.setText(format);
    }

    public void setValue(RoomInterface.BuildingInterface building) {
        this.iName.clearHint();
        this.iAbbreviation.clearHint();
        this.iHeader.clearMessage();
        if (building == null) {
            this.iHeader.setHeaderTitle(MESSAGES.sectAddBuilding());
            this.iHeader.setEnabled("save", true);
            this.iHeader.setEnabled("update", false);
            this.iHeader.setEnabled("delete", false);
            this.iHeader.setEnabled("back", true);
            this.iName.getWidget().setText("");
            this.iAbbreviation.getWidget().setText("");
            this.iExternalId.setText("");
            this.iX.setValue(null);
            this.iY.setValue(null);
            if (this.iMap != null) {
                this.iMap.setMarker();
            }
            this.iBuilding = new RoomInterface.BuildingInterface();
            this.iUpdateRoomCoordinates.setVisible(false);
        } else {
            this.iHeader.setHeaderTitle(MESSAGES.sectEditBuilding());
            this.iHeader.setEnabled("save", false);
            this.iHeader.setEnabled("update", true);
            this.iHeader.setEnabled("delete", false);
            RPC.execute(new RoomInterface.BuildingCheckCanDeleteRequest(building.getId()), new AsyncCallback<GwtRpcResponseBoolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(GwtRpcResponseBoolean result) {
                    BuildingsEdit.this.iHeader.setEnabled("delete", (boolean)result.getValue());
                }
            });
            this.iHeader.setEnabled("back", true);
            this.iName.getWidget().setText(building.getName() == null ? "" : building.getName());
            this.iAbbreviation.getWidget().setText(building.getAbbreviation() == null ? "" : building.getAbbreviation());
            this.iExternalId.setText(building.getExternalId() == null ? "" : building.getExternalId());
            this.iX.setValue(building.getX());
            this.iY.setValue(building.getY());
            if (this.iMap != null) {
                this.iMap.setMarker();
            }
            this.iBuilding = building;
            this.iUpdateRoomCoordinates.setVisible(true);
            this.iUpdateRoomCoordinates.setValue(Boolean.valueOf(false));
        }
    }

    public RoomInterface.BuildingInterface getValue() {
        this.iBuilding.setName(this.iName.getWidget().getText());
        this.iBuilding.setAbbreviation(this.iAbbreviation.getWidget().getText());
        this.iBuilding.setExternalId(this.iExternalId.getText());
        this.iBuilding.setX(this.iX.toDouble());
        this.iBuilding.setY(this.iY.toDouble());
        return this.iBuilding;
    }

    protected boolean validate() {
        boolean ok = true;
        if (this.iAbbreviation.getWidget().getText().isEmpty()) {
            this.iAbbreviation.setErrorHint(MESSAGES.errorAbbreviationIsEmpty());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorAbbreviationIsEmpty());
            }
            ok = false;
        } else if (!this.isAbbreviationUnique(this.getValue())) {
            this.iAbbreviation.setErrorHint(MESSAGES.errorAbbreviationMustBeUnique());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorAbbreviationMustBeUnique());
            }
            ok = false;
        }
        if (this.iName.getWidget().getText().isEmpty()) {
            this.iName.setErrorHint(MESSAGES.errorNameIsEmpty());
            if (ok) {
                this.iHeader.setErrorMessage(MESSAGES.errorNameIsEmpty());
            }
            ok = false;
        }
        return ok;
    }
}

