/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.widgets.P;

public class MultiSelect<T>
extends ScrollPanel
implements HasValue<List<T>> {
    private P iPanel = null;
    private List<Item> iItems = new ArrayList<Item>();

    public MultiSelect() {
        this.setStyleName("unitime-MultiSelect");
        this.iPanel = new P("content");
        this.setWidget((Widget)this.iPanel);
    }

    public void addItem(T id, String text, boolean asHTML) {
        Item item = new Item(id, text, asHTML);
        this.iItems.add(item);
        this.iPanel.add((Widget)item);
    }

    public void addItem(T id, String text) {
        this.addItem(id, text, false);
    }

    public boolean isSelected(T id) {
        for (Item item : this.iItems) {
            if (!item.getId().equals(id)) continue;
            return item.getValue();
        }
        return false;
    }

    public void setSelected(T id, boolean value) {
        for (Item item : this.iItems) {
            if (!item.getId().equals(id)) continue;
            item.setValue(value);
        }
    }

    public List<T> getSelectedIds() {
        ArrayList ret = new ArrayList();
        for (Item item : this.iItems) {
            if (!item.getValue().booleanValue()) continue;
            ret.add(item.getId());
        }
        return ret;
    }

    public List<Item> getSelectedItems() {
        ArrayList<Item> ret = new ArrayList<Item>();
        for (Item item : this.iItems) {
            if (!item.getValue().booleanValue()) continue;
            ret.add(item);
        }
        return ret;
    }

    public List<Item> getItems() {
        return this.iItems;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<T>> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public List<T> getValue() {
        return this.getSelectedIds();
    }

    public void setValue(List<T> value) {
        this.setValue(value, false);
    }

    public void setValue(List<T> value, boolean fireEvents) {
        for (Item item : this.iItems) {
            item.setValue(value.contains(item.getId()));
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    class Item
    extends CheckBox
    implements HasClickHandlers {
        private T iId;

        Item(T id, String name, boolean asHTML) {
            super(name, asHTML);
            this.iId = id;
            this.addStyleName("item");
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)MultiSelect.this, (Object)MultiSelect.this.getValue());
                }
            });
        }

        public T getId() {
            return this.iId;
        }

        public void setId(T id) {
            this.iId = id;
        }
    }
}

