/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BasePosMajor;

public class PosMajorImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("posMajors")) {
            throw new Exception("Given XML file is not pos majors load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, PosMajor> id2major = new Hashtable<String, PosMajor>();
            Hashtable<CallSite, Object> code2major = new Hashtable<CallSite, Object>();
            for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId", PosMajor.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                if (((BasePosMajor)major).getExternalUniqueId() != null) {
                    id2major.put(((BasePosMajor)major).getExternalUniqueId(), (PosMajor)major);
                }
                for (AcademicArea area : ((BasePosMajor)major).getAcademicAreas()) {
                    code2major.put((CallSite)((Object)(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode())), major);
                }
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (AcademicArea area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId", AcademicArea.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                abbv2area.put(area.getAcademicAreaAbbreviation(), area);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                String code = this.trim(element.attributeValue("code"), "code", 40);
                AcademicArea area = (AcademicArea)abbv2area.get(element.attributeValue("academicArea"));
                if (area == null) {
                    this.warn("Unknown academic area " + element.attributeValue("academicArea"));
                    continue;
                }
                PosMajor major = null;
                if (externalId != null) {
                    major = (PosMajor)id2major.remove(externalId);
                }
                if (major == null) {
                    major = (PosMajor)code2major.get(area.getAcademicAreaAbbreviation() + ":" + code);
                }
                if (major == null) {
                    major = new PosMajor();
                    major.setSession(session);
                    major.setAcademicAreas(new HashSet<AcademicArea>());
                    this.info("Major " + area.getAcademicAreaAbbreviation() + " " + code + (String)(externalId == null ? "" : " (" + externalId + ")") + " created.");
                } else {
                    this.info("Major " + area.getAcademicAreaAbbreviation() + " " + code + (String)(externalId == null ? "" : " (" + externalId + ")") + " updated.");
                }
                major.setExternalUniqueId(externalId);
                major.setCode(code);
                major.setName(this.trim(element.attributeValue("name"), "name", 100));
                major.getAcademicAreas().clear();
                major.getAcademicAreas().add(area);
                area.getPosMajors().add(major);
                if (major.getUniqueId() == null) {
                    this.getHibSession().persist((Object)major);
                    continue;
                }
                this.getHibSession().merge((Object)major);
            }
            for (PosMajor major : id2major.values()) {
                String abbv = null;
                for (AcademicArea area : major.getAcademicAreas()) {
                    area.getPosMajors().remove(major);
                    abbv = area.getAcademicAreaAbbreviation();
                }
                this.info("Major " + abbv + " " + major.getCode() + " (" + major.getExternalUniqueId() + ") deleted.");
                this.getHibSession().remove((Object)major);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

