/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Session;

public class AcademicClassificationImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("academicClassifications")) {
            throw new Exception("Given XML file is not academic classifications load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, AcademicClassification> id2clasf = new Hashtable<String, AcademicClassification>();
            Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
            for (AcademicClassification clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId", AcademicClassification.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                if (clasf.getExternalUniqueId() != null) {
                    id2clasf.put(clasf.getExternalUniqueId(), clasf);
                }
                code2clasf.put(clasf.getCode(), clasf);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                String code = element.attributeValue("code");
                AcademicClassification clasf = null;
                if (externalId != null) {
                    clasf = (AcademicClassification)id2clasf.remove(externalId);
                }
                if (clasf == null) {
                    clasf = (AcademicClassification)code2clasf.get(code);
                }
                if (clasf == null) {
                    clasf = new AcademicClassification();
                    clasf.setSession(session);
                    this.info("Academic classification " + code + (String)(externalId == null ? "" : " (" + externalId + ")") + " created.");
                } else {
                    this.info("Academic classification " + code + (String)(externalId == null ? "" : " (" + externalId + ")") + " updated.");
                }
                clasf.setExternalUniqueId(externalId);
                clasf.setCode(code);
                clasf.setName(element.attributeValue("name"));
                if (clasf.getUniqueId() == null) {
                    this.getHibSession().persist((Object)clasf);
                    continue;
                }
                this.getHibSession().merge((Object)clasf);
            }
            for (AcademicClassification clasf : id2clasf.values()) {
                this.info("Academic classification " + clasf.getCode() + " (" + clasf.getExternalUniqueId() + ") deleted.");
                this.getHibSession().remove((Object)clasf);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

