/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.util;

import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.OracleSqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;

public class OracleDialectLegacyLimitQueries
extends OracleDialect {
    public OracleDialectLegacyLimitQueries() {
    }

    public OracleDialectLegacyLimitQueries(DatabaseVersion version) {
        super(version);
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return false;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new OracleSqlAstTranslatorLegacyLimitQueries(sessionFactory, statement);
            }
        };
    }

    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        OracleSqlAstTranslatorLegacyLimitQueries translator = new OracleSqlAstTranslatorLegacyLimitQueries(factory, (Statement)optionalTableUpdate);
        return translator.createMergeOperation(optionalTableUpdate);
    }

    protected static class OracleSqlAstTranslatorLegacyLimitQueries<T extends JdbcOperation>
    extends OracleSqlAstTranslator<T> {
        public OracleSqlAstTranslatorLegacyLimitQueries(SessionFactoryImplementor sessionFactory, Statement statement) {
            super(sessionFactory, statement);
        }

        protected void renderRowNumberingSelectItems(SelectClause selectClause, QueryPart queryPart) {
            FetchClauseType fetchClauseType = this.getFetchClauseTypeForRowNumbering(queryPart);
            if (fetchClauseType != FetchClauseType.ROWS_ONLY) {
                super.renderRowNumberingSelectItems(selectClause, queryPart);
            }
        }

        protected void emulateFetchOffsetWithWindowFunctions(final QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
            if (emulateFetchClause && fetchClauseType == FetchClauseType.ROWS_ONLY) {
                if (offsetExpression != null) {
                    this.appendSql("select * from (select row_.*,rownum rownum_ from (");
                    this.withRowNumbering(queryPart, true, new Runnable(){

                        @Override
                        public void run() {
                            queryPart.accept((SqlAstWalker)this);
                        }
                    });
                    this.visitOrderBy(queryPart.getSortSpecifications());
                    this.appendSql(") row_ where rownum<=");
                    offsetExpression.accept((SqlAstWalker)this);
                    this.appendSql('+');
                    fetchExpression.accept((SqlAstWalker)this);
                    this.appendSql(") where rownum_>");
                    offsetExpression.accept((SqlAstWalker)this);
                } else {
                    this.appendSql("select * from (");
                    this.withRowNumbering(queryPart, true, new Runnable(){

                        @Override
                        public void run() {
                            queryPart.accept((SqlAstWalker)this);
                        }
                    });
                    this.visitOrderBy(queryPart.getSortSpecifications());
                    this.appendSql(") where rownum<=");
                    fetchExpression.accept((SqlAstWalker)this);
                }
                if (queryPart instanceof QuerySpec) {
                    this.visitForUpdateClause((QuerySpec)queryPart);
                }
            } else {
                super.emulateFetchOffsetWithWindowFunctions(queryPart, offsetExpression, fetchExpression, fetchClauseType, emulateFetchClause);
            }
        }
    }
}

