/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class XmlAsStringJdbcType
extends XmlJdbcType
implements AdjustableJdbcType {
    public static final XmlAsStringJdbcType VARCHAR_INSTANCE = new XmlAsStringJdbcType(4001, null);
    public static final XmlAsStringJdbcType NVARCHAR_INSTANCE = new XmlAsStringJdbcType(4002, null);
    public static final XmlAsStringJdbcType CLOB_INSTANCE = new XmlAsStringJdbcType(2005, null);
    public static final XmlAsStringJdbcType NCLOB_INSTANCE = new XmlAsStringJdbcType(2011, null);
    private final boolean nationalized;
    private final int ddlTypeCode;

    public XmlAsStringJdbcType(int ddlTypeCode, EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
        this.ddlTypeCode = ddlTypeCode;
        this.nationalized = ddlTypeCode == 4002 || ddlTypeCode == 2011;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new XmlAsStringJdbcType(this.ddlTypeCode, mappingType);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.nationalized ? -9 : 12;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 2009;
    }

    @Override
    public int getDdlTypeCode() {
        return this.ddlTypeCode;
    }

    @Override
    public String toString() {
        return "XmlAsStringJdbcType";
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        if (this.getEmbeddableMappingType() == null) {
            if (this.needsLob(indicators)) {
                return indicators.isNationalized() ? NCLOB_INSTANCE : CLOB_INSTANCE;
            }
            return indicators.isNationalized() ? NVARCHAR_INSTANCE : VARCHAR_INSTANCE;
        }
        if (this.needsLob(indicators)) {
            return new XmlAsStringJdbcType(indicators.isNationalized() ? 2011 : 2005, this.getEmbeddableMappingType());
        }
        return new XmlAsStringJdbcType(indicators.isNationalized() ? 4002 : 4001, this.getEmbeddableMappingType());
    }

    protected boolean needsLob(JdbcTypeIndicators indicators) {
        long maxLength;
        Dialect dialect = indicators.getDialect();
        long length = indicators.getColumnLength();
        long l = maxLength = indicators.isNationalized() ? (long)dialect.getMaxNVarcharLength() : (long)dialect.getMaxVarcharLength();
        if (length > maxLength) {
            return true;
        }
        DdlTypeRegistry ddlTypeRegistry = indicators.getTypeConfiguration().getDdlTypeRegistry();
        String typeName = ddlTypeRegistry.getTypeName(this.getDdlTypeCode(), dialect);
        return typeName.equals(ddlTypeRegistry.getTypeName(2005, dialect)) || typeName.equals(ddlTypeRegistry.getTypeName(2011, dialect));
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        if (this.nationalized) {
            return new BasicBinder<X>(javaType, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    String xml = ((XmlAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                    if (options.getDialect().supportsNationalizedMethods()) {
                        st.setNString(index, xml);
                    } else {
                        st.setString(index, xml);
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    String xml = ((XmlAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                    if (options.getDialect().supportsNationalizedMethods()) {
                        st.setNString(name, xml);
                    } else {
                        st.setString(name, xml);
                    }
                }
            };
        }
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String xml = ((XmlAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(index, xml);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String xml = ((XmlAsStringJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setString(name, xml);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        if (this.nationalized) {
            return new BasicExtractor<X>(javaType, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    if (options.getDialect().supportsNationalizedMethods()) {
                        return this.getObject(rs.getNString(paramIndex), options);
                    }
                    return this.getObject(rs.getString(paramIndex), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    if (options.getDialect().supportsNationalizedMethods()) {
                        return this.getObject(statement.getNString(index), options);
                    }
                    return this.getObject(statement.getString(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    if (options.getDialect().supportsNationalizedMethods()) {
                        return this.getObject(statement.getNString(name), options);
                    }
                    return this.getObject(statement.getString(name), options);
                }

                private X getObject(String xml, WrapperOptions options) throws SQLException {
                    if (xml == null) {
                        return null;
                    }
                    return ((XmlAsStringJdbcType)this.getJdbcType()).fromString(xml, this.getJavaType(), options);
                }
            };
        }
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getString(name), options);
            }

            private X getObject(String xml, WrapperOptions options) throws SQLException {
                if (xml == null) {
                    return null;
                }
                return ((XmlAsStringJdbcType)this.getJdbcType()).fromString(xml, this.getJavaType(), options);
            }
        };
    }
}

