/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import org.jgroups.logging.Log;
import org.jgroups.util.SuppressCache;
import org.jgroups.util.Util;

public class SuppressLog<T> {
    protected final Log log;
    protected final SuppressCache<T> cache;
    protected final String message_format;
    protected final String suppress_format = Util.getMessage("SuppressMsg");

    public SuppressLog(Log log, String message_key) {
        this.log = log;
        this.cache = new SuppressCache();
        this.message_format = Util.getMessage(message_key);
    }

    public SuppressLog(Log log) {
        this(log, null);
    }

    public SuppressCache<T> getCache() {
        return this.cache;
    }

    public void log(Level level, T key, long timeout, Object ... args) {
        SuppressCache.Value val = this.cache.putIfAbsent(key, timeout);
        if (val == null) {
            return;
        }
        String message = this.createMessage(val, this.message_format, args);
        this.log(level, message);
    }

    public void log(Level level, T key, long timeout, String format, Object ... args) {
        SuppressCache.Value val = this.cache.putIfAbsent(key, timeout);
        if (val == null) {
            return;
        }
        String message = this.createMessage(val, format, args);
        this.log(level, message);
    }

    public void error(T key, long timeout, Object ... args) {
        this.log(Level.error, key, timeout, args);
    }

    public void warn(T key, long timeout, Object ... args) {
        this.log(Level.warn, key, timeout, args);
    }

    public void trace(T key, long timeout, Object ... args) {
        this.log(Level.trace, key, timeout, args);
    }

    public void error(T key, long timeout, String format, Object ... args) {
        this.log(Level.error, key, timeout, format, args);
    }

    public void warn(T key, long timeout, String format, Object ... args) {
        this.log(Level.warn, key, timeout, format, args);
    }

    public void trace(T key, long timeout, String format, Object ... args) {
        this.log(Level.trace, key, timeout, format, args);
    }

    protected String createMessage(SuppressCache.Value val, String format, Object ... args) {
        return val.count() == 1 ? String.format(format, args) : String.format(format, args) + " " + String.format(this.suppress_format, val.count(), Util.printTime(val.age(), TimeUnit.MILLISECONDS));
    }

    protected void log(Level level, String message) {
        switch (level) {
            case error: {
                this.log.error(message);
                break;
            }
            case warn: {
                this.log.warn(message);
                break;
            }
            case trace: {
                this.log.trace(message);
            }
        }
    }

    public void removeExpired(long timeout) {
        this.cache.removeExpired(timeout);
    }

    public static enum Level {
        error,
        warn,
        trace;

    }
}

