/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Date;
import java.util.TreeMap;
import org.apache.commons.logging.LogFactory;

public class ProgressTracker {
    private String label;
    private int total;
    private int count;
    private int percentInterval = 5;
    private int lastPrintedPercent;
    private Date timeOfLastPrint;
    private Class<?> cls;
    private long previousElapsedTime;
    private TreeMap<Integer, Long> elapseTimeLog = new TreeMap();

    public ProgressTracker(String label, int total, Class<?> cls) {
        this.label = label;
        this.total = total;
        this.cls = cls;
        this.count = 0;
        this.timeOfLastPrint = new Date();
    }

    public ProgressTracker(String label, int total, int percentInterval, Class<?> cls) {
        this.label = label;
        this.total = total;
        this.cls = cls;
        this.percentInterval = percentInterval;
        this.count = 0;
        this.timeOfLastPrint = new Date();
    }

    private String elapsedTimeString(long millisecondsElapsed) {
        long ms = millisecondsElapsed % 1000L;
        long totalSeconds = millisecondsElapsed / 1000L;
        long seconds = totalSeconds % 60L;
        long totalMinutes = totalSeconds / 60L;
        long minutes = totalMinutes % 60L;
        long hours = totalMinutes / 60L;
        StringBuilder sb = new StringBuilder();
        String comma = "";
        if (millisecondsElapsed == 0L) {
            sb.append("0 Milliseconds");
        }
        if (hours > 0L) {
            sb.append(hours).append(" Hours");
            comma = ", ";
        }
        if (minutes > 0L) {
            sb.append(comma).append(minutes).append(" Minutes");
            comma = ", ";
        }
        if (seconds > 0L) {
            sb.append(comma).append(seconds).append(" Seconds");
            comma = ", ";
        }
        if (ms > 0L) {
            sb.append(comma).append(ms).append(" Milliseconds");
        }
        return sb.toString();
    }

    private String calculateElapsedTimeSinceLastProgressPrint(Date timeNow) {
        long millisecondsElapsed = timeNow.getTime() - this.timeOfLastPrint.getTime();
        StringBuilder sb = new StringBuilder();
        sb.append("Time Since Last Message:  ");
        sb.append(this.elapsedTimeString(millisecondsElapsed));
        sb.append(";  Time Between Reports has ");
        if (this.previousElapsedTime < millisecondsElapsed) {
            sb.append("increased.");
        } else if (this.previousElapsedTime == millisecondsElapsed) {
            sb.append("not changed.");
        } else {
            sb.append("decreased.");
        }
        return sb.toString();
    }

    public void logProgressIfNeeded() {
        String progressString = this.getProgressStringIfNeeded();
        if (progressString != null) {
            LogFactory.getLog(this.cls).info((Object)progressString);
        }
    }

    public String getProgressStringIfNeeded() {
        String progressString = null;
        ++this.count;
        int printPct = this.count * 100 / this.total;
        Date timeNow = new Date();
        if (printPct % this.percentInterval == 0 && this.lastPrintedPercent < printPct || this.count == this.total) {
            progressString = timeNow.toString() + "  Processing " + this.label + " - progress:  " + printPct + "% (" + this.count + " of " + this.total + "), " + this.calculateElapsedTimeSinceLastProgressPrint(timeNow);
            this.lastPrintedPercent = printPct;
            this.previousElapsedTime = timeNow.getTime() - this.timeOfLastPrint.getTime();
            this.timeOfLastPrint = timeNow;
            this.elapseTimeLog.put(printPct, this.previousElapsedTime);
        }
        return progressString;
    }

    public String totalTimeToProcess() {
        StringBuilder sb = new StringBuilder();
        long totalTime = 0L;
        for (Integer pct : this.elapseTimeLog.keySet()) {
            totalTime += this.elapseTimeLog.get(pct).longValue();
        }
        sb.append("Total Time to Process ").append(this.label).append(":  ").append(this.elapsedTimeString(totalTime)).append("\n");
        return sb.toString();
    }

    public String totalTimeToProcessInMilliseconds() {
        StringBuilder sb = new StringBuilder();
        long totalTime = 0L;
        for (Integer pct : this.elapseTimeLog.keySet()) {
            totalTime += this.elapseTimeLog.get(pct).longValue();
        }
        sb.append("Total Time to Process in Milliseconds ").append(this.label).append(":  ").append(Long.toString(totalTime)).append("\n");
        return sb.toString();
    }

    public String getElapsedTimeAnalysisString() {
        if (this.count == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long lastElapsed = 0L;
        boolean prevIncreased = true;
        boolean prevDecreased = false;
        boolean prevSame = false;
        long totalIncreases = 0L;
        long totalDecreases = 0L;
        sb.append("\n\n\n").append(this.totalTimeToProcess()).append("\n").append("Summary of Time Between Status Reports\n").append("\t").append("0% - ");
        long cnt = 0L;
        long sumOfElapsedDifferences = 0L;
        for (Integer pct : this.elapseTimeLog.keySet()) {
            if (lastElapsed < this.elapseTimeLog.get(pct)) {
                if (prevDecreased) {
                    sb.append(pct).append("% elapsed time decreased.  Average change = ").append(this.elapsedTimeString(sumOfElapsedDifferences / cnt)).append(".\n").append("\t").append(pct).append("% - ");
                    prevIncreased = true;
                    prevDecreased = false;
                    cnt = 0L;
                    sumOfElapsedDifferences = this.elapseTimeLog.get(pct) - lastElapsed;
                } else if (prevSame) {
                    sb.append(pct).append("% elapsed time stayed the same.\n").append("\t").append(pct).append("% - ");
                    prevIncreased = true;
                    prevSame = false;
                    cnt = 0L;
                    sumOfElapsedDifferences = this.elapseTimeLog.get(pct) - lastElapsed;
                } else {
                    sumOfElapsedDifferences += this.elapseTimeLog.get(pct) - lastElapsed;
                }
                totalIncreases += this.elapseTimeLog.get(pct) - lastElapsed;
            } else if (lastElapsed > this.elapseTimeLog.get(pct)) {
                if (prevIncreased) {
                    sb.append(pct).append("% elapsed time increased.  Average change = ").append(this.elapsedTimeString(sumOfElapsedDifferences / cnt)).append(".\n").append("\t").append(pct).append("% - ");
                    prevIncreased = false;
                    prevDecreased = true;
                    cnt = 0L;
                    sumOfElapsedDifferences = lastElapsed - this.elapseTimeLog.get(pct);
                } else if (prevSame) {
                    sb.append(pct).append("% elapsed time stayed the same.\n").append("\t").append(pct).append("% - ");
                    prevDecreased = true;
                    prevSame = false;
                    cnt = 0L;
                    sumOfElapsedDifferences = lastElapsed - this.elapseTimeLog.get(pct);
                } else {
                    sumOfElapsedDifferences += lastElapsed - this.elapseTimeLog.get(pct);
                }
                totalDecreases += lastElapsed - this.elapseTimeLog.get(pct);
            } else if (prevIncreased) {
                sb.append(pct).append("% elapsed time increased.  Average change = ").append(this.elapsedTimeString(sumOfElapsedDifferences / cnt)).append(".\n").append("\t").append(pct).append("% - ");
                prevIncreased = false;
                prevSame = true;
                cnt = 0L;
                sumOfElapsedDifferences = 0L;
            } else if (prevDecreased) {
                sb.append(pct).append("% elapsed time decreased.  Average change = ").append(this.elapsedTimeString(sumOfElapsedDifferences / cnt)).append(".\n").append("\t").append(pct).append("% - ");
                prevSame = true;
                prevDecreased = false;
                cnt = 0L;
                sumOfElapsedDifferences = 0L;
            } else {
                sumOfElapsedDifferences = 0L;
            }
            ++cnt;
            lastElapsed = this.elapseTimeLog.get(pct);
        }
        if (prevIncreased) {
            sb.append(100).append("% elapsed time increased.  Average change = ").append(this.elapsedTimeString(sumOfElapsedDifferences / cnt)).append(".\n");
        } else if (prevDecreased) {
            sb.append(100).append("% elapsed time decreased.  Average change = ").append(this.elapsedTimeString(sumOfElapsedDifferences / cnt)).append(".\n");
        } else {
            sb.append(100).append("% elapsed time stayed the same.\n");
        }
        sb.append("Total increased time:").append(this.elapsedTimeString(totalIncreases)).append("\n").append("Total decreased time:").append(this.elapsedTimeString(totalDecreases)).append(".\n\n");
        return sb.toString();
    }

    public void logElapsedTimeAnalysis() {
        String analysis = this.getElapsedTimeAnalysisString();
        if (analysis != null) {
            LogFactory.getLog(this.cls).info((Object)analysis);
        }
    }
}

