/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Calendar;
import java.util.Date;
import org.unitime.timetable.defaults.ApplicationProperty;

public class FailedLoginAttempt {
    private String userId;
    private int count;
    private Date lastFailedAttempt;

    public FailedLoginAttempt(String userId, int count, Date lastFailedAttempt) {
        this.userId = userId;
        this.count = count;
        this.lastFailedAttempt = lastFailedAttempt;
    }

    public boolean isUserLockedOut(String user, Date attemptTime) {
        if (this.userId != null && user != null && this.userId.equals(user) && this.count >= ApplicationProperty.LoginMaxFailedAttempts.intValue()) {
            Calendar checkTime = Calendar.getInstance();
            checkTime.setTime(this.lastFailedAttempt);
            Calendar attempt = Calendar.getInstance();
            attempt.setTime(attemptTime);
            checkTime.add(12, ApplicationProperty.LoginFailedLockout.intValue());
            boolean lockedOut = attempt.before(checkTime);
            if (!lockedOut) {
                this.count = 0;
            }
            return lockedOut;
        }
        return false;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getLastFailedAttempt() {
        return this.lastFailedAttempt;
    }

    public void setLastFailedAttempt(Date lastFailedAttempt) {
        this.lastFailedAttempt = lastFailedAttempt;
    }
}

