/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.ArrayList;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.page.SolverWarnings;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;

@GwtRpcImplements(value=SolverWarnings.SolverWarningsRequest.class)
public class SolverWarningsBackend
implements GwtRpcImplementation<SolverWarnings.SolverWarningsRequest, SolverWarnings.SolverWarningsResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public SolverWarnings.SolverWarningsResponse execute(SolverWarnings.SolverWarningsRequest request, SessionContext context) {
        SolverWarnings.SolverWarningsResponse warn = null;
        switch (request.getType()) {
            case solver: {
                warn = this.getSolverWarningCheckSolution(context);
                if (warn != null) {
                    return warn.setWarning(true);
                }
                return this.getCurrentAssignmentWarning(context);
            }
            case assignments: {
                warn = this.getCurrentAssignmentWarning(context);
                if (warn != null) {
                    return warn;
                }
                return this.getExamAssignmentWarning(context, false);
            }
            case exam: {
                return this.getExamAssignmentWarning(context, true);
            }
        }
        return null;
    }

    public SolverWarnings.SolverWarningsResponse getSolverWarningCheckSolution(SessionContext context) {
        if (!context.hasPermission(Right.CourseTimetabling)) {
            return null;
        }
        try {
            SolverProxy proxy = this.courseTimetablingSolverService.getSolver();
            if (proxy != null) {
                return new SolverWarnings.SolverWarningsResponse(proxy.getProperties().getProperty("General.SolverWarnings"));
            }
        }
        catch (Exception proxy) {
            // empty catch block
        }
        String id = (String)context.getAttribute("Solver.selectedSolutionId");
        if (id != null && !id.isEmpty()) {
            Object warn = "";
            for (String solutionId : id.split(",")) {
                Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                for (SolverParameter p : solution.getParameters()) {
                    if (!"General.SolverWarnings".equals(p.getDefinition().getName()) || p.getValue() == null) continue;
                    if (!((String)warn).isEmpty()) {
                        warn = (String)warn + "<br>";
                    }
                    warn = (String)warn + p.getValue();
                }
            }
            return ((String)warn).isEmpty() ? null : new SolverWarnings.SolverWarningsResponse((String)warn);
        }
        TreeSet<SolverGroup> solverGroups = SolverGroup.getUserSolverGroups(context.getUser());
        if (solverGroups.isEmpty()) {
            return null;
        }
        Object warn = "";
        int maxDistPriority = Integer.MIN_VALUE;
        int nrWarns = 0;
        for (SolverGroup sg : solverGroups) {
            maxDistPriority = Math.max(maxDistPriority, sg.getMaxDistributionPriority());
        }
        for (SolverGroup sg : SolverGroup.findBySessionId(context.getUser().getCurrentAcademicSessionId())) {
            if (solverGroups.contains(sg) || sg.getMinDistributionPriority() >= maxDistPriority || sg.getCommittedSolution() != null) continue;
            if (nrWarns > 0) {
                warn = (String)warn + "<br>";
            }
            ArrayList<String> subjects = new ArrayList<String>();
            boolean dept = false;
            for (Department d : sg.getDepartments()) {
                if (d.isExternalManager().booleanValue()) {
                    subjects.add(d.getExternalMgrAbbv());
                    continue;
                }
                dept = true;
                for (SubjectArea sa : d.getSubjectAreas()) {
                    subjects.add(sa.getSubjectAreaAbbreviation());
                }
            }
            warn = dept ? (String)warn + MESSAGES.warnSolverNoCommittedSolutionDepartmental(sg.getAbbv(), SolverPageBackend.toString(subjects)) : (String)warn + MESSAGES.warnSolverNoCommittedSolutionExternal(sg.getAbbv(), SolverPageBackend.toString(subjects));
            if (++nrWarns < 3) continue;
            warn = (String)warn + "<br>...";
            break;
        }
        return ((String)warn).isEmpty() ? null : new SolverWarnings.SolverWarningsResponse((String)warn);
    }

    public SolverWarnings.SolverWarningsResponse getCurrentAssignmentWarning(SessionContext context) {
        if (!context.hasPermission(Right.Timetables)) {
            return null;
        }
        try {
            SolverProxy proxy = this.courseTimetablingSolverService.getSolver();
            if (proxy != null) {
                Long[] solverGroupId = proxy.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                ArrayList<String> names = new ArrayList<String>();
                boolean interactive = proxy.getProperties().getPropertyBoolean("General.InteractiveMode", false);
                if (solverGroupId != null) {
                    for (int i = 0; i < solverGroupId.length; ++i) {
                        SolverGroup sg = (SolverGroup)SolverGroupDAO.getInstance().get(solverGroupId[i]);
                        names.add(sg == null ? MESSAGES.notApplicable() : (solverGroupId.length <= 3 ? sg.getName() : sg.getAbbv()));
                    }
                }
                if (names == null || names.isEmpty()) {
                    names.add(MESSAGES.notApplicable());
                }
                return new SolverWarnings.SolverWarningsResponse(interactive ? "listSolutions" : "solver?type=course", MESSAGES.infoSolverShowingSolution(SolverPageBackend.toString(names)));
            }
        }
        catch (Exception proxy) {
            // empty catch block
        }
        String id = (String)context.getAttribute("Solver.selectedSolutionId");
        if (id != null && !id.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            String[] solutionIds = id.split(",");
            for (int i = 0; i < solutionIds.length; ++i) {
                Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionIds[i]));
                names.add(solutionIds.length <= 3 ? solution.getOwner().getName() : solution.getOwner().getAbbv());
            }
            return new SolverWarnings.SolverWarningsResponse("listSolutions", names.isEmpty() ? null : (names.size() == 1 ? MESSAGES.infoSolverShowingSelectedSolution((String)names.get(0)) : MESSAGES.infoSolverShowingSelectedSolutions(SolverPageBackend.toString(names))));
        }
        return null;
    }

    public SolverWarnings.SolverWarningsResponse getExamAssignmentWarning(SessionContext context, boolean checkExamType) {
        if (!context.hasPermission(Right.ExaminationSolver)) {
            return null;
        }
        try {
            ExamType type;
            ExamSolverProxy proxy = this.examinationSolverService.getSolver();
            if (proxy != null && (type = (ExamType)ExamTypeDAO.getInstance().get(proxy.getExamTypeId())) != null) {
                Long selectedExamTypeId;
                if (checkExamType && (selectedExamTypeId = (Long)context.getAttribute(SessionAttribute.ExamType)) != null && !selectedExamTypeId.equals(type.getUniqueId())) {
                    return null;
                }
                return new SolverWarnings.SolverWarningsResponse("solver?type=exam", MESSAGES.infoExamSolverShowingSolution(type.getLabel()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

