/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.online.selection.ResectioningWeights;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListComparatorProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequestComparator;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;

public class CheckOfferingAction
extends WaitlistedOnlineSectioningAction<Boolean>
implements HasCacheMode {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Collection<Long> iOfferingIds;
    private Collection<Long> iSkipStudentIds;
    private Collection<Long> iStudentIds;

    public CheckOfferingAction forOfferings(Long ... offeringIds) {
        this.iOfferingIds = new ArrayList<Long>();
        for (Long offeringId : offeringIds) {
            this.iOfferingIds.add(offeringId);
        }
        return this;
    }

    public CheckOfferingAction forOfferings(Collection<Long> offeringIds) {
        this.iOfferingIds = offeringIds;
        return this;
    }

    public CheckOfferingAction skipStudents(Long ... studentIds) {
        this.iSkipStudentIds = new HashSet<Long>();
        for (Long studentId : studentIds) {
            if (studentId == null) continue;
            this.iSkipStudentIds.add(studentId);
        }
        return this;
    }

    public CheckOfferingAction skipStudents(Collection<Long> studentIds) {
        this.iSkipStudentIds = studentIds;
        return this;
    }

    public CheckOfferingAction forStudents(Long ... studentIds) {
        this.iStudentIds = new HashSet<Long>();
        for (Long studentId : studentIds) {
            if (studentId == null) continue;
            this.iStudentIds.add(studentId);
        }
        return this;
    }

    public CheckOfferingAction forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public Collection<Long> getOfferingIds() {
        return this.iOfferingIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
            return true;
        }
        boolean result = true;
        HashSet<Long> recheck = new HashSet<Long>();
        for (Long offeringId : this.getOfferingIds()) {
            try {
                XOffering offering;
                if (server.isOfferingLocked(offeringId) || (offering = server.getOffering(offeringId)) == null || !offering.isWaitList()) continue;
                OnlineSectioningServer.Lock lock = server.lockOffering(offeringId, null, this.name());
                try {
                    helper.beginTransaction();
                    helper.getAction().addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offeringId).setName(offering.getName()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
                    this.checkOffering(server, helper, offering, recheck);
                    helper.commitTransaction();
                }
                finally {
                    lock.release();
                }
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                helper.fatal("Unable to check offering " + offeringId + ", reason: " + e.getMessage(), e);
                result = false;
            }
        }
        if (result && !recheck.isEmpty()) {
            helper.info("Re-checking " + recheck.size() + " offerings...");
            result = server.execute(server.createAction(CheckOfferingAction.class).forOfferings(recheck).skipStudents(this.iSkipStudentIds).forStudents(this.iStudentIds), helper.getUser());
        }
        return result;
    }

    public static boolean isCheckNeeded(OnlineSectioningServer server, OnlineSectioningHelper helper, XEnrollment oldEnrollment) {
        if (oldEnrollment == null) {
            return false;
        }
        XStudent newStudent = server.getStudent(oldEnrollment.getStudentId());
        XEnrollment newEnrollment = null;
        if (newStudent != null) {
            for (XRequest r : newStudent.getRequests()) {
                XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                if (e == null || !e.getOfferingId().equals(oldEnrollment.getOfferingId())) continue;
                newEnrollment = e;
                break;
            }
        }
        return CheckOfferingAction.isCheckNeeded(server, helper, oldEnrollment, newEnrollment);
    }

    public static boolean isCheckNeeded(OnlineSectioningServer server, OnlineSectioningHelper helper, XEnrollment oldEnrollment, XEnrollment newEnrollment) {
        XCourse xCourse;
        XConfig xConfig;
        Set<Long> oldSections;
        if (oldEnrollment == null) {
            return false;
        }
        if (!server.getAcademicSession().isSectioningEnabled()) {
            return false;
        }
        if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
            return false;
        }
        XOffering offering = server.getOffering(oldEnrollment.getOfferingId());
        if (offering == null || !offering.isWaitList()) {
            return false;
        }
        if (newEnrollment == null) {
            oldSections = oldEnrollment.getSectionIds();
        } else {
            oldSections = new HashSet<Long>();
            for (Long l : oldEnrollment.getSectionIds()) {
                if (newEnrollment.getSectionIds().contains(l)) continue;
                oldSections.add(l);
            }
        }
        if (oldSections.isEmpty()) {
            return false;
        }
        if (offering.hasReservations()) {
            for (XReservation xReservation : offering.getReservations()) {
                if (xReservation.isOverride() || xReservation.isExpired()) continue;
                helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": there are reservations.");
                return true;
            }
        }
        XEnrollments enrollments = server.getEnrollments(oldEnrollment.getOfferingId());
        for (Long sectionId : oldSections) {
            XSection section = offering.getSection(sectionId);
            if (section == null || section.getLimit() < 0 || section.getLimit() - enrollments.countEnrollmentsForSection(sectionId) != 1) continue;
            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": section " + String.valueOf(section) + " became available.");
            return true;
        }
        if (!(newEnrollment != null && newEnrollment.getConfigId().equals(oldEnrollment.getConfigId()) || (xConfig = offering.getConfig(oldEnrollment.getConfigId())) == null || xConfig.getLimit() < 0 || xConfig.getLimit() - enrollments.countEnrollmentsForConfig(xConfig.getConfigId()) != 1)) {
            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": config " + String.valueOf(xConfig) + " became available.");
            return true;
        }
        if (!(newEnrollment != null && newEnrollment.getCourseId().equals(oldEnrollment.getCourseId()) || (xCourse = offering.getCourse(oldEnrollment.getCourseId())) == null || xCourse.getLimit() < 0 || xCourse.getLimit() - enrollments.countEnrollmentsForCourse(xCourse.getCourseId()) != 1)) {
            helper.debug("Check offering for " + oldEnrollment.getCourseName() + ": course " + String.valueOf(xCourse) + " became available.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOffering(OnlineSectioningServer server, OnlineSectioningHelper helper, XOffering offering, Set<Long> recheckOfferingIds) {
        if (!server.getAcademicSession().isSectioningEnabled() || offering == null || !offering.isReSchedule()) {
            return;
        }
        if (recheckOfferingIds != null) {
            recheckOfferingIds.remove(offering.getOfferingId());
        }
        if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
            return;
        }
        WaitListComparatorProvider cmp = (WaitListComparatorProvider)Customization.WaitListComparatorProvider.getProvider();
        TreeSet<SectioningRequest> queue = new TreeSet<SectioningRequest>(cmp == null ? new SectioningRequestComparator() : cmp.getComparator(server, helper));
        XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
        for (XCourseRequest request : enrollments.getRequests()) {
            if (this.iSkipStudentIds != null && this.iSkipStudentIds.contains(request.getStudentId()) || this.iStudentIds != null && !this.iStudentIds.contains(request.getStudentId())) continue;
            XStudent student = server.getStudent(request.getStudentId());
            SectioningRequest.ReschedulingReason check = this.check(server, student, offering, request);
            if (!this.isWaitListed(student, request, offering, server, helper) && check == null) continue;
            OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
            action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offering.getOfferingId()).setName(offering.getName()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
            if (request.getEnrollment() != null) {
                OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XSection section : offering.getSections(request.getEnrollment())) {
                    enrollment.addSection(OnlineSectioningHelper.toProto(section, request.getEnrollment()));
                }
                action.addEnrollment(enrollment);
            }
            action.addRequest(OnlineSectioningHelper.toProto(request));
            queue.add(new SectioningRequest(offering, request, request.getCourseIdByOfferingId(offering.getOfferingId()), student, check, this.getStudentPriority(student, server, helper), action).setNewEnrollment(request.getEnrollment()));
        }
        boolean lockStudents = server.getConfig().getPropertyBoolean(this.name() + ".LockStudents", true);
        if (!queue.isEmpty()) {
            DataProperties properties = server.getConfig();
            ResectioningWeights w = new ResectioningWeights(properties);
            StudentQuality sq = new StudentQuality(server.getDistanceMetric(), properties);
            Date ts = new Date();
            int index = 1;
            for (SectioningRequest r : queue) {
                XOffering dropOffering;
                helper.debug("Resectioning " + String.valueOf(r.getRequest()) + " (was " + String.valueOf(r.getLastEnrollment() == null ? "not assigned" : r.getLastEnrollment()) + ")", r.getAction());
                r.getAction().setStartTime(System.currentTimeMillis());
                long c0 = OnlineSectioningHelper.getCpuTime();
                r.getAction().addOptionBuilder().setKey("Index").setValue(index + " of " + queue.size());
                ++index;
                if (r.isRescheduling()) {
                    r.getAction().addOptionBuilder().setKey("Issue").setValue(r.getReschedulingReason().name());
                }
                XEnrollment dropEnrollment = r.getDropEnrollment();
                XEnrollment enrollment = r.resection(server, w, sq, helper);
                if (dropEnrollment != null && (dropOffering = server.getOffering(dropEnrollment.getOfferingId())) != null) {
                    OnlineSectioningLog.Enrollment.Builder e = OnlineSectioningLog.Enrollment.newBuilder();
                    e.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                    for (Long sectionId : dropEnrollment.getSectionIds()) {
                        e.addSection(OnlineSectioningHelper.toProto(dropOffering.getSection(sectionId), dropEnrollment));
                    }
                    r.getAction().addEnrollment(e);
                }
                if (enrollment != null) {
                    enrollment.setTimeStamp(ts);
                    OnlineSectioningLog.Enrollment.Builder e = OnlineSectioningLog.Enrollment.newBuilder();
                    e.setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
                    for (Long sectionId : enrollment.getSectionIds()) {
                        e.addSection(OnlineSectioningHelper.toProto(offering.getSection(sectionId), enrollment));
                    }
                    r.getAction().addEnrollment(e);
                }
                if (enrollment == null && !r.isRescheduling()) {
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    r.getAction().setEndTime(System.currentTimeMillis());
                    continue;
                }
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    try {
                        enrollment = CustomStudentEnrollmentHolder.getProvider().resection(server, helper, r, enrollment);
                    }
                    catch (Exception e) {
                        r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        helper.warn((r.getCourseId() == null ? offering.getName() : r.getCourseId().getCourseName()) + ": " + (e.getMessage() == null ? "Unable to resection student." : e.getMessage()), r.getAction());
                        r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                        r.getAction().setEndTime(System.currentTimeMillis());
                        if (!ApplicationProperty.OnlineSchedulingEmailConfirmationWhenFailed.isTrue()) continue;
                        server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(r.getRequest().getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeEnrollmentFailed).oldEnrollment(offering, r.getCourseId(), r.getLastEnrollment()).failedEnrollment(offering, r.getCourseId(), enrollment, e).dropEnrollment(dropEnrollment).rescheduling(r.getReschedulingReason()), helper.getUser());
                        continue;
                    }
                }
                XCourseRequest prev = r.getRequest();
                Long studentId = prev.getStudentId();
                if (dropEnrollment != null && enrollment != null) {
                    server.assign(r.getDropRequest(), null);
                }
                if (enrollment != null) {
                    r.setRequest(server.assign(r.getRequest(), enrollment));
                } else if (r.getRequest() != null) {
                    r.setRequest(server.assign(r.getRequest(), null));
                }
                if (r.getRequest() == null) {
                    helper.fatal("Failed to assign " + studentId + ": " + (enrollment == null ? prev.toString() : enrollment.toString()));
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                    r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    r.getAction().setEndTime(System.currentTimeMillis());
                    continue;
                }
                helper.debug("New: " + String.valueOf(r.getRequest().getEnrollment() == null ? "not assigned" : r.getRequest().getEnrollment()), r.getAction());
                if (r.getLastEnrollment() == null && r.getRequest().getEnrollment() == null) {
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    r.getAction().setEndTime(System.currentTimeMillis());
                    continue;
                }
                if (r.getLastEnrollment() != null && r.getLastEnrollment().equals(r.getRequest().getEnrollment())) {
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    r.getAction().setEndTime(System.currentTimeMillis());
                    continue;
                }
                Session hibSession = helper.getHibSession();
                Transaction tx = null;
                if (!lockStudents) {
                    hibSession = new _RootDAO().createNewSession();
                    tx = hibSession.beginTransaction();
                }
                try {
                    CourseOffering co;
                    Date dropTS = null;
                    Student student = (Student)StudentDAO.getInstance().get(r.getRequest().getStudentId(), hibSession);
                    HashMap<Long, Object> oldEnrollments = new HashMap<Long, Object>();
                    String approvedBy = null;
                    Date approvedDate = null;
                    Iterator<StudentClassEnrollment> i = student.getClassEnrollments().iterator();
                    while (i.hasNext()) {
                        StudentClassEnrollment enrl = i.next();
                        if (enrl.getCourseRequest() != null && enrl.getCourseRequest().getCourseDemand().getUniqueId().equals(r.getRequest().getRequestId()) || r.getLastEnrollment() != null && enrl.getCourseOffering() != null && enrl.getCourseOffering().getUniqueId().equals(r.getLastEnrollment().getCourseId())) {
                            helper.debug("Deleting " + enrl.getClazz().getClassLabel(), r.getAction());
                            if (dropTS == null || enrl.getTimestamp() != null && enrl.getTimestamp().before(dropTS)) {
                                dropTS = enrl.getTimestamp();
                            }
                            oldEnrollments.put(enrl.getClazz().getUniqueId(), enrl);
                            if (approvedBy == null && enrl.getApprovedBy() != null) {
                                approvedBy = enrl.getApprovedBy();
                                approvedDate = enrl.getApprovedDate();
                            }
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            hibSession.remove((Object)enrl);
                            i.remove();
                            continue;
                        }
                        if (dropEnrollment == null || !dropEnrollment.getCourseId().equals(enrl.getCourseOffering().getUniqueId())) continue;
                        helper.debug("Deleting " + enrl.getClazz().getClassLabel(), r.getAction());
                        enrl.getClazz().getStudentEnrollments().remove(enrl);
                        hibSession.remove((Object)enrl);
                        i.remove();
                    }
                    CourseDemand cd = null;
                    for (CourseDemand x : student.getCourseDemands()) {
                        if (!x.getUniqueId().equals(r.getRequest().getRequestId())) continue;
                        cd = x;
                        break;
                    }
                    if (r.getRequest().getEnrollment() != null) {
                        cr = null;
                        Object co2 = null;
                        if (co2 == null) {
                            co2 = (CourseOffering)CourseOfferingDAO.getInstance().get(r.getRequest().getEnrollment().getCourseId(), hibSession);
                        }
                        for (Long sectionId : r.getRequest().getEnrollment().getSectionIds()) {
                            Class_ clazz = (Class_)Class_DAO.getInstance().get(sectionId, hibSession);
                            if (cd != null && cr == null) {
                                for (CourseRequest courseRequest : cd.getCourseRequests()) {
                                    if (!courseRequest.getCourseOffering().getUniqueId().equals(((BaseCourseOffering)co2).getUniqueId())) continue;
                                    cr = courseRequest;
                                    break;
                                }
                            }
                            if (co2 == null) {
                                co2 = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                            }
                            StudentClassEnrollment enrl = new StudentClassEnrollment();
                            enrl.setClazz(clazz);
                            StudentClassEnrollment studentClassEnrollment = (StudentClassEnrollment)oldEnrollments.get(sectionId);
                            enrl.setChangedBy(studentClassEnrollment != null ? studentClassEnrollment.getChangedBy() : (helper.getUser() == null ? StudentClassEnrollment.SystemChange.WAITLIST.toString() : helper.getUser().getExternalId()));
                            clazz.getStudentEnrollments().add(enrl);
                            enrl.setCourseOffering((CourseOffering)co2);
                            enrl.setCourseRequest(cr);
                            enrl.setTimestamp(studentClassEnrollment != null ? studentClassEnrollment.getTimestamp() : ts);
                            enrl.setStudent(student);
                            enrl.setApprovedBy(approvedBy);
                            enrl.setApprovedDate(approvedDate);
                            student.getClassEnrollments().add(enrl);
                            hibSession.persist((Object)enrl);
                            helper.debug("Adding " + enrl.getClazz().getClassLabel(), r.getAction());
                        }
                        if (cd != null && cd.isWaitlist().booleanValue()) {
                            cd.setWaitlist(false);
                            hibSession.merge((Object)cd);
                            student.addWaitList((CourseOffering)co2, WaitList.WaitListType.WAIT_LIST_PORCESSING, false, helper.getUser().getExternalId(), ts, hibSession);
                        } else if (cd != null) {
                            student.addWaitList((CourseOffering)co2, WaitList.WaitListType.RE_BATCH_ON_CHECK, false, helper.getUser().getExternalId(), ts, hibSession);
                        }
                        if (r.getRequest().isWaitlist()) {
                            server.waitlist(r.getRequest(), false);
                        }
                    } else if (r.getOffering().isWaitList() && this.hasWaitListingStatus(r.getStudent(), server)) {
                        if (cd != null && !cd.isWaitlist().booleanValue()) {
                            CourseRequest courseRequest = cr = r.getCourseId() == null ? null : cd.getCourseRequest(r.getCourseId().getCourseId());
                            if (cr != null && cr.getOrder() > 0) {
                                for (CourseRequest courseRequest2 : cd.getCourseRequests()) {
                                    if (courseRequest2.getOrder() >= cr.getOrder()) continue;
                                    courseRequest2.setOrder(courseRequest2.getOrder() + 1);
                                    hibSession.merge((Object)courseRequest2);
                                }
                                cr.setOrder(0);
                                hibSession.merge((Object)cr);
                            }
                            if (cd.isAlternative().booleanValue()) {
                                int priority = cd.getPriority();
                                for (CourseDemand x2 : cd.getStudent().getCourseDemands()) {
                                    if (!x2.isAlternative().booleanValue() || x2.getPriority() >= cd.getPriority()) continue;
                                    if (priority > x2.getPriority()) {
                                        priority = x2.getPriority();
                                    }
                                    x2.setPriority(1 + x2.getPriority());
                                    hibSession.merge((Object)x2);
                                }
                                cd.setPriority(priority);
                                cd.setAlternative(false);
                            }
                            cd.setWaitlist(true);
                            cd.setWaitlistedTimeStamp(dropTS == null ? ts : dropTS);
                            cd.setWaitListSwapWithCourseOffering(null);
                            hibSession.merge((Object)cd);
                            student.addWaitList((CourseOffering)CourseOfferingDAO.getInstance().get(r.getCourseId().getCourseId(), hibSession), WaitList.WaitListType.WAIT_LIST_PORCESSING, true, helper.getUser().getExternalId(), ts, hibSession);
                        }
                        if (!r.getRequest().isWaitlist()) {
                            int idx;
                            r.getRequest().setWaitListedTimeStamp(dropTS == null ? ts : dropTS);
                            r.getRequest().setWaitListSwapWithCourseOffering(null);
                            boolean otherRequestsChanged = false;
                            XStudent xs = r.getStudent();
                            XCourseId xCourseId = r.getCourseId();
                            int n = idx = xCourseId == null ? -1 : r.getRequest().getCourseIds().indexOf(xCourseId);
                            if (idx > 0) {
                                r.getRequest().getCourseIds().remove(idx);
                                r.getRequest().getCourseIds().add(0, xCourseId);
                                otherRequestsChanged = true;
                            }
                            if (r.getRequest().isAlternative()) {
                                int priority = r.getRequest().getPriority();
                                for (XRequest xRequest : xs.getRequests()) {
                                    if (!xRequest.isAlternative() || xRequest.getPriority() >= cd.getPriority()) continue;
                                    if (priority > xRequest.getPriority()) {
                                        priority = xRequest.getPriority();
                                    }
                                    xRequest.setPriority(1 + xRequest.getPriority());
                                }
                                r.getRequest().setPriority(priority);
                                r.getRequest().setAlternative(false);
                                otherRequestsChanged = true;
                            }
                            if (otherRequestsChanged) {
                                r.getRequest().setWaitlist(true);
                                server.update(xs, true);
                            } else {
                                r.setRequest(server.waitlist(r.getRequest(), true));
                            }
                        }
                    } else if (r.getLastEnrollment() != null && (co = (CourseOffering)CourseOfferingDAO.getInstance().get(r.getLastEnrollment().getCourseId(), hibSession)) != null) {
                        student.addWaitList(co, WaitList.WaitListType.RE_BATCH_ON_CHECK, false, helper.getUser().getExternalId(), ts, hibSession);
                    }
                    hibSession.merge((Object)student);
                    EnrollStudent.updateSpace(server, r.getRequest().getEnrollment() == null ? null : SectioningRequest.convert(r.getStudent(), r.getRequest(), server, offering, r.getRequest().getEnrollment(), OnlineSectioningInterface.WaitListMode.WaitList, helper), r.getLastEnrollment() == null ? null : SectioningRequest.convert(r.getOldStudent(), r.getRequest(), server, offering, r.getLastEnrollment(), OnlineSectioningInterface.WaitListMode.WaitList, helper), offering);
                    server.persistExpectedSpaces(offering.getOfferingId());
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(r.getRequest().getStudentId())).withType(StudentSectioningStatus.NotificationType.CourseChangeEnrollment).fromAction(this.name()).oldEnrollment(offering, r.getCourseId(), r.getLastEnrollment()).dropEnrollment(dropEnrollment).rescheduling(r.getReschedulingReason()), helper.getUser());
                    if (tx != null) {
                        tx.commit();
                    }
                    r.getAction().setResult(enrollment == null ? OnlineSectioningLog.Action.ResultType.NULL : OnlineSectioningLog.Action.ResultType.SUCCESS);
                    if (recheckOfferingIds != null && dropEnrollment != null && CheckOfferingAction.isCheckNeeded(server, helper, dropEnrollment, enrollment != null && enrollment.getOfferingId().equals(dropEnrollment.getOfferingId()) ? enrollment : null)) {
                        recheckOfferingIds.add(dropEnrollment.getOfferingId());
                    }
                }
                catch (Exception e) {
                    if (dropEnrollment != null) {
                        server.assign(r.getDropRequest(), dropEnrollment);
                    }
                    server.assign(r.getRequest(), r.getLastEnrollment());
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                    helper.error((r.getCourseId() == null ? offering.getName() : r.getCourseId().getCourseName()) + ": " + (e.getMessage() == null ? "Unable to resection student." : e.getMessage()), e, r.getAction());
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                finally {
                    if (!lockStudents) {
                        hibSession.close();
                    }
                }
                r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                r.getAction().setEndTime(System.currentTimeMillis());
            }
        }
    }

    public SectioningRequest.ReschedulingReason check(OnlineSectioningServer server, XStudent student, XOffering offering, XCourseRequest request) {
        if (request.getEnrollment() == null) {
            return null;
        }
        if (!offering.getOfferingId().equals(request.getEnrollment().getOfferingId())) {
            return null;
        }
        if (!server.getConfig().getPropertyBoolean("Enrollment.ReSchedulingEnabled", false)) {
            return null;
        }
        if (!this.hasReSchedulingStatus(student, server)) {
            return null;
        }
        List<XSection> sections = offering.getSections(request.getEnrollment());
        XConfig config = offering.getConfig(request.getEnrollment().getConfigId());
        if (config == null || sections.size() != config.getSubparts().size()) {
            for (XSection s1 : sections) {
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
                return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
            }
            return sections.size() < config.getSubparts().size() ? SectioningRequest.ReschedulingReason.MISSING_CLASS : SectioningRequest.ReschedulingReason.MULTIPLE_ENRLS;
        }
        boolean ignoreBreakTime = server.getConfig().getPropertyBoolean("ReScheduling.IgnoreBreakTimeConflicts", false);
        for (XSection s1 : sections) {
            for (XSection s2 : sections) {
                if (s1.getSectionId() < s2.getSectionId() && s1.isOverlapping(offering.getDistributions(), s2, ignoreBreakTime)) {
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
                if (s1.getSectionId().equals(s2.getSectionId()) || !s1.getSubpartId().equals(s2.getSubpartId())) continue;
                return SectioningRequest.ReschedulingReason.CLASS_LINK;
            }
            if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
            return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
        }
        if (!offering.isAllowOverlap(student, request.getEnrollment().getConfigId(), request.getEnrollment(), sections) && !server.getConfig().getPropertyBoolean("Enrollment.CanKeepTimeConflict", false)) {
            for (XRequest r : student.getRequests()) {
                XEnrollment e;
                XOffering other;
                if (request.getPriority() <= r.getPriority() || !(r instanceof XCourseRequest) || r.getRequestId().equals(request.getRequestId()) || ((XCourseRequest)r).getEnrollment() == null || (other = server.getOffering((e = ((XCourseRequest)r).getEnrollment()).getOfferingId())) == null) continue;
                List<XSection> assignment = other.getSections(e);
                if (other.isAllowOverlap(student, e.getConfigId(), e, assignment)) continue;
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment, ignoreBreakTime)) continue;
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
            }
        }
        if (!server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
            for (XSection section : sections) {
                if (!section.isCancelled()) continue;
                return SectioningRequest.ReschedulingReason.CLASS_CANCELLED;
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "check-offering";
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }
}

