/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.SolverInfo;

@MappedSuperclass
public abstract class BaseAssignmentInfo
extends SolverInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Assignment iAssignment;

    public BaseAssignmentInfo() {
    }

    public BaseAssignmentInfo(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="assignment_id", nullable=false)
    public Assignment getAssignment() {
        return this.iAssignment;
    }

    public void setAssignment(Assignment assignment) {
        this.iAssignment = assignment;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AssignmentInfo)) {
            return false;
        }
        if (this.getUniqueId() == null || ((AssignmentInfo)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((AssignmentInfo)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "AssignmentInfo[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "AssignmentInfo[\n\tAssignment: " + String.valueOf(this.getAssignment()) + "\n\tData: " + String.valueOf(this.getData()) + "\n\tDefinition: " + String.valueOf(this.getDefinition()) + "\n\tOpt: " + this.getOpt() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

