/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.offerings.PreferenceEditWidget;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorAssignmentPreferencesPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse iData;
    private PreferenceEditWidget iPreferences;

    public InstructorAssignmentPreferencesPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-InstructorAssignmentPreferences");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"instructorId");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoInstructorId());
        } else {
            this.load(Long.valueOf(id), PrefGroupEditInterface.Operation.GET, true, null);
        }
        this.iHeader.addButton("update", COURSE.actionUpdatePreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAssignmentPreferencesPage.this.iPreferences.update();
                if (InstructorAssignmentPreferencesPage.this.validate()) {
                    InstructorAssignmentPreferencesPage.this.load(InstructorAssignmentPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.UPDATE, true, null);
                }
            }
        });
        this.iHeader.getButton("update").setTitle(COURSE.titleUpdatePreferences(COURSE.accessUpdatePreferences()));
        this.iHeader.getButton("update").setAccessKey(COURSE.accessUpdatePreferences().charAt(0));
        this.iHeader.setEnabled("update", false);
        this.iHeader.addButton("clear", COURSE.actionClearInstructorPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAssignmentPreferencesPage.this.iPreferences.update();
                InstructorAssignmentPreferencesPage.this.load(InstructorAssignmentPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.CLEAR_CLASS_PREFS, true, null);
            }
        });
        this.iHeader.getButton("clear").setTitle(COURSE.titleClearInstructorPreferences(COURSE.accessClearInstructorPreferences()));
        this.iHeader.getButton("clear").setAccessKey(COURSE.accessClearInstructorPreferences().charAt(0));
        this.iHeader.setEnabled("clear", false);
        this.iHeader.addButton("previous", COURSE.actionPreviousInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAssignmentPreferencesPage.this.iPreferences.update();
                if (InstructorAssignmentPreferencesPage.this.validate()) {
                    InstructorAssignmentPreferencesPage.this.load(InstructorAssignmentPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.PREVIOUS, true, null);
                }
            }
        });
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousInstructorWithUpdate(COURSE.accessPreviousInstructor()));
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousInstructor().charAt(0));
        this.iHeader.setEnabled("previous", false);
        this.iHeader.addButton("next", COURSE.actionNextInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAssignmentPreferencesPage.this.iPreferences.update();
                if (InstructorAssignmentPreferencesPage.this.validate()) {
                    InstructorAssignmentPreferencesPage.this.load(InstructorAssignmentPreferencesPage.this.iData.getId(), PrefGroupEditInterface.Operation.NEXT, true, null);
                }
            }
        });
        this.iHeader.getButton("next").setTitle(COURSE.titleNextInstructorWithUpdate(COURSE.accessNextInstructor()));
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextInstructor().charAt(0));
        this.iHeader.setEnabled("next", false);
        this.iHeader.addButton("back", COURSE.actionBackToDetail(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + InstructorAssignmentPreferencesPage.this.iData.getId());
            }
        });
        this.iHeader.getButton("back").setTitle(COURSE.titleBackToDetail(COURSE.accessBackToDetail()));
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackToDetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(Long instructorId, final PrefGroupEditInterface.Operation op, final boolean showLoading, final Command command) {
        if (showLoading) {
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        }
        PrefGroupEditInterface.InstructorAssignmentPreferencesEditRequest req = new PrefGroupEditInterface.InstructorAssignmentPreferencesEditRequest();
        req.setOperation(op);
        if (op != null && this.iData != null) {
            this.iPreferences.update();
            req.setPayLoad(this.iData);
        }
        req.setId(instructorId);
        RPC.execute(req, new AsyncCallback<PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse>(){

            public void onFailure(Throwable caught) {
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                InstructorAssignmentPreferencesPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse response) {
                InstructorAssignmentPreferencesPage.this.iData = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                if (op == PrefGroupEditInterface.Operation.DATE_PATTERN) {
                    InstructorAssignmentPreferencesPage.this.iPreferences.setValue(response);
                    return;
                }
                InstructorAssignmentPreferencesPage.this.iPanel.clear();
                InstructorAssignmentPreferencesPage.this.iHeader.setHeaderTitle(response.getName());
                InstructorAssignmentPreferencesPage.this.iPanel.addHeaderRow((Widget)InstructorAssignmentPreferencesPage.this.iHeader);
                final ListBox teachingPref = new ListBox();
                for (PrefGroupEditInterface.PrefLevel pref : response.getPrefLevels()) {
                    teachingPref.addItem(pref.getTitle(), pref.getId().toString());
                    if (!pref.getId().equals(response.getTeachingPrefId())) continue;
                    teachingPref.setSelectedIndex(teachingPref.getItemCount() - 1);
                }
                teachingPref.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent arg0) {
                        InstructorAssignmentPreferencesPage.this.iData.setTeachingPrefId(Long.valueOf(teachingPref.getSelectedValue()));
                    }
                });
                P teachingPrefPanel = new P("teaching-preference");
                teachingPrefPanel.add((Widget)teachingPref);
                teachingPrefPanel.add((Widget)new Label(COURSE.descriptionTeachingPreference()));
                InstructorAssignmentPreferencesPage.this.iPanel.addRow(COURSE.propertyTeachingPreference(), (Widget)teachingPrefPanel);
                NumberBox maxUnits = new NumberBox();
                maxUnits.setNegative(false);
                maxUnits.setValue(response.getMaxTeachingLoad());
                maxUnits.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            InstructorAssignmentPreferencesPage.this.iData.setMaxTeachingLoad(Float.valueOf(Float.parseFloat((String)event.getValue())));
                        }
                        catch (Exception e) {
                            InstructorAssignmentPreferencesPage.this.iData.setMaxTeachingLoad(null);
                        }
                    }
                });
                P maxUnitsPanel = new P("max-units");
                maxUnitsPanel.add((Widget)maxUnits);
                maxUnitsPanel.add((Widget)new Label(COURSE.teachingLoadUnits()));
                InstructorAssignmentPreferencesPage.this.iPanel.addRow(COURSE.propertyMaxLoad(), (Widget)maxUnitsPanel);
                for (InstructorInterface.AttributeTypeInterface type : response.getAttributeTypes()) {
                    P p = new P("unitime-InstructorAttributes");
                    for (final InstructorInterface.AttributeInterface a : response.getAttributesOfType(type)) {
                        CheckBox ch = new CheckBox(a.getName());
                        ch.setValue(Boolean.valueOf(response.hasInstructorAttribute(a)));
                        ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                if (((Boolean)event.getValue()).booleanValue()) {
                                    InstructorAssignmentPreferencesPage.this.iData.addInstructorAttribute(a.getId());
                                } else {
                                    InstructorAssignmentPreferencesPage.this.iData.removeInstructorAttribute(a.getId());
                                }
                            }
                        });
                        ch.addStyleName("attribute");
                        p.add((Widget)ch);
                    }
                    InstructorAssignmentPreferencesPage.this.iPanel.addRow(type.getLabel() + ":", (Widget)p);
                }
                InstructorAssignmentPreferencesPage.this.iPreferences = new PreferenceEditWidget();
                InstructorAssignmentPreferencesPage.this.iPreferences.setValue(response);
                InstructorAssignmentPreferencesPage.this.iPanel.addRow((Widget)InstructorAssignmentPreferencesPage.this.iPreferences);
                InstructorAssignmentPreferencesPage.this.iPanel.addBottomRow((Widget)InstructorAssignmentPreferencesPage.this.iFooter);
                UniTimeNavigation.getInstance().refresh();
                InstructorAssignmentPreferencesPage.this.iHeader.setEnabled("update", true);
                InstructorAssignmentPreferencesPage.this.iHeader.setEnabled("previous", response.getPreviousId() != null);
                InstructorAssignmentPreferencesPage.this.iHeader.setEnabled("next", response.getNextId() != null);
                InstructorAssignmentPreferencesPage.this.iHeader.setEnabled("clear", response.canClearPrefs());
                if (command != null) {
                    command.execute();
                }
            }
        });
    }

    public boolean validate() {
        this.iHeader.clearMessage();
        String error = this.iPreferences.validate();
        if (error != null) {
            this.iHeader.setErrorMessage(error);
            return false;
        }
        return true;
    }
}

