/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.util.Constants;

public class PreferencesForm
implements UniTimeForm {
    private static final long serialVersionUID = -3578647598790726006L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op;
    protected List<String> timePatterns;
    protected List<String> roomGroups;
    protected List<String> roomGroupLevels;
    protected List<String> roomPrefs;
    protected List<String> roomPrefLevels;
    protected List<String> bldgPrefs;
    protected List<String> bldgPrefLevels;
    protected List<String> roomFeaturePrefs;
    protected List<String> roomFeaturePrefLevels;
    protected String timePattern;
    protected List<TimePattern> availableTimePatterns;
    protected List<String> distPrefs;
    protected List<String> distPrefLevels;
    protected List<String> datePatternPrefs;
    protected List<String> datePatternPrefLevels;
    protected List<String> coursePrefs;
    protected List<String> coursePrefLevels;
    protected List<String> instructorPrefs;
    protected List<String> instructorPrefLevels;
    protected List<String> attributePrefs;
    protected List<String> attributePrefLevels;
    protected String availability;
    private String nextId;
    private String previousId;
    protected boolean allowHardPrefs;
    private boolean hasNotAvailable;
    protected List<String> roomPrefIndexes;
    protected List<String> roomGroupIndexes;
    protected List<String> roomFeaturePrefIndexes;
    protected List<String> bldgPrefIndexes;

    public boolean checkPrefs(List ... lst) {
        if (lst == null || lst.length == 0 || lst[0] == null) {
            return true;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < lst[0].size(); ++i) {
            Object value = (String)lst[0].get(i);
            if (value == null || ((String)value).trim().equals("-")) continue;
            for (int j = 1; j < lst.length; ++j) {
                value = (String)value + "|" + (String)lst[j].get(i);
            }
            if (map.get(((String)value).trim()) != null) {
                return false;
            }
            map.put((String)value, (String)value);
        }
        return true;
    }

    public boolean checkPrefLevels(List<String> lst, List<String> prefList) {
        if (lst == null) {
            return true;
        }
        for (int i = 0; i < lst.size(); ++i) {
            String id = prefList.get(i);
            String value = lst.get(i);
            if (id == null || id.trim().equals("-") || value != null && !value.trim().equals("-")) continue;
            return false;
        }
        return true;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List<String> getTimePatterns() {
        return this.timePatterns;
    }

    public void setTimePatterns(List<String> timePatterns) {
        this.timePatterns = timePatterns;
    }

    public List<TimePattern> getAvailableTimePatterns() {
        return this.availableTimePatterns;
    }

    public boolean getCanChooseTimePattern() {
        return this.availableTimePatterns != null;
    }

    public List<TimePattern> getAvailableNotSelectedTimePatterns() {
        if (this.timePatterns == null || this.timePatterns.isEmpty()) {
            return this.getAvailableTimePatterns();
        }
        Vector<TimePattern> ret = new Vector<TimePattern>();
        for (TimePattern pattern : this.availableTimePatterns) {
            if (!pattern.getTimePatternModel().isExactTime() && this.timePatterns.contains(pattern.getUniqueId().toString())) continue;
            ret.add(pattern);
        }
        return ret;
    }

    public void setAvailableTimePatterns(List<TimePattern> availableTimePatterns) {
        this.availableTimePatterns = availableTimePatterns;
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(String timePattern) {
        this.timePattern = timePattern;
    }

    public List<String> getRoomGroups() {
        return this.roomGroups;
    }

    public void setRoomGroups(List<String> roomGroups) {
        this.roomGroups = roomGroups;
    }

    public void setRoomGroups(int key, String value) {
        Debug.debug("setting room group: " + key);
        this.roomGroups.set(key, value);
    }

    public List<String> getRoomGroupLevels() {
        return this.roomGroupLevels;
    }

    public boolean isRoomGroupDisabled(int idx) {
        String levelId = this.getRoomGroupLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isRoomDisabled(int idx) {
        String levelId = this.getRoomPrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isRoomFeatureDisabled(int idx) {
        String levelId = this.getRoomFeaturePrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isBuildingDisabled(int idx) {
        String levelId = this.getBldgPrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isDatePatternDisabled(int idx) {
        String levelId = this.getDatePatternPrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isDistPrefDisabled(int idx) {
        String levelId = this.getDistPrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isAttributePrefDisabled(int idx) {
        String levelId = this.getAttributePrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isCoursePrefDisabled(int idx) {
        String levelId = this.getCoursePrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public boolean isInstructorPrefDisabled(int idx) {
        String levelId = this.getInstructorPrefLevels(idx);
        return !this.getAllowHardPrefs() && !"-".equals(levelId) && PreferenceLevel.getPreferenceLevel(Integer.parseInt(levelId)).isHard();
    }

    public String getRoomGroupLevels(int key) {
        return this.roomGroupLevels.get(key).toString();
    }

    public void setRoomGroupLevels(int key, String value) {
        this.roomGroupLevels.set(key, value);
    }

    public String getRoomGroups(int key) {
        return this.roomGroups.get(key).toString();
    }

    public void setRoomGroupLevels(List<String> roomGroupLevels) {
        this.roomGroupLevels = roomGroupLevels;
    }

    public List<String> getBldgPrefs() {
        return this.bldgPrefs;
    }

    public String getBldgPrefs(int key) {
        return this.bldgPrefs.get(key).toString();
    }

    public void setBldgPrefs(int key, String value) {
        this.bldgPrefs.set(key, value);
    }

    public void setBldgPrefs(List<String> bldgPrefs) {
        this.bldgPrefs = bldgPrefs;
    }

    public List<String> getDistPrefs() {
        return this.distPrefs;
    }

    public String getDistPrefs(int key) {
        return this.distPrefs.get(key).toString();
    }

    public void setDistPrefs(int key, String value) {
        this.distPrefs.set(key, value);
    }

    public void setDistPrefs(List<String> distPrefs) {
        this.distPrefs = distPrefs;
    }

    public List<String> getCoursePrefs() {
        return this.coursePrefs;
    }

    public String getCoursePrefs(int key) {
        return this.coursePrefs.get(key).toString();
    }

    public void setCoursePrefs(int key, String value) {
        this.coursePrefs.set(key, value);
    }

    public void setCoursePrefs(List<String> coursePrefs) {
        this.coursePrefs = coursePrefs;
    }

    public List<String> getInstructorPrefs() {
        return this.instructorPrefs;
    }

    public String getInstructorPrefs(int key) {
        return this.instructorPrefs.get(key).toString();
    }

    public void setInstructorPrefs(int key, String value) {
        this.instructorPrefs.set(key, value);
    }

    public void setInstructorPrefs(List<String> instructorPrefs) {
        this.instructorPrefs = instructorPrefs;
    }

    public List<String> getAttributePrefs() {
        return this.attributePrefs;
    }

    public String getAttributePrefs(int key) {
        return this.attributePrefs.get(key).toString();
    }

    public void setAttributePrefs(int key, String value) {
        this.attributePrefs.set(key, value);
    }

    public void setAttributePrefs(List<String> attributePrefs) {
        this.attributePrefs = attributePrefs;
    }

    public List<String> getRoomPrefs() {
        return this.roomPrefs;
    }

    public String getRoomPrefs(int key) {
        Debug.debug("getting room pref: " + key);
        return this.roomPrefs.get(key).toString();
    }

    public void setRoomPrefs(int key, String value) {
        Debug.debug("setting room pref: " + key);
        this.roomPrefs.set(key, value);
    }

    public void setRoomPrefs(List<String> roomPrefs) {
        this.roomPrefs = roomPrefs;
    }

    public List<String> getRoomFeaturePrefs() {
        return this.roomFeaturePrefs;
    }

    public String getRoomFeaturePrefs(int key) {
        return this.roomFeaturePrefs.get(key).toString();
    }

    public void setRoomFeaturePrefs(int key, String value) {
        this.roomFeaturePrefs.set(key, value);
    }

    public void setRoomFeaturePrefs(List<String> roomFeaturePrefs) {
        this.roomFeaturePrefs = roomFeaturePrefs;
    }

    public List<String> getRoomPrefLevels() {
        return this.roomPrefLevels;
    }

    public String getRoomPrefLevels(int key) {
        return this.roomPrefLevels.get(key).toString();
    }

    public void setRoomPrefLevels(int key, String value) {
        this.roomPrefLevels.set(key, value);
    }

    public void setRoomPrefLevels(List<String> roomPrefLevels) {
        this.roomPrefLevels = roomPrefLevels;
    }

    public List<String> getBldgPrefLevels() {
        return this.bldgPrefLevels;
    }

    public String getBldgPrefLevels(int key) {
        return this.bldgPrefLevels.get(key).toString();
    }

    public void setBldgPrefLevels(int key, String value) {
        this.bldgPrefLevels.set(key, value);
    }

    public void setBldgPrefLevels(List<String> bldgPrefLevels) {
        this.bldgPrefLevels = bldgPrefLevels;
    }

    public List<String> getDistPrefLevels() {
        return this.distPrefLevels;
    }

    public String getDistPrefLevels(int key) {
        return this.distPrefLevels.get(key).toString();
    }

    public void setDistPrefLevels(int key, String value) {
        this.distPrefLevels.set(key, value);
    }

    public void setDistPrefLevels(List<String> distPrefLevels) {
        this.distPrefLevels = distPrefLevels;
    }

    public List<String> getCoursePrefLevels() {
        return this.coursePrefLevels;
    }

    public String getCoursePrefLevels(int key) {
        return this.coursePrefLevels.get(key).toString();
    }

    public void setCoursePrefLevels(int key, String value) {
        this.coursePrefLevels.set(key, value);
    }

    public void setCoursePrefLevels(List<String> coursePrefLevels) {
        this.coursePrefLevels = coursePrefLevels;
    }

    public List<String> getInstructorPrefLevels() {
        return this.instructorPrefLevels;
    }

    public String getInstructorPrefLevels(int key) {
        return this.instructorPrefLevels.get(key).toString();
    }

    public void setInstructorPrefLevels(int key, String value) {
        this.instructorPrefLevels.set(key, value);
    }

    public void setInstructorPrefLevels(List<String> instructorPrefLevels) {
        this.instructorPrefLevels = instructorPrefLevels;
    }

    public List<String> getAttributePrefLevels() {
        return this.attributePrefLevels;
    }

    public String getAttributePrefLevels(int key) {
        return this.attributePrefLevels.get(key).toString();
    }

    public void setAttributePrefLevels(int key, String value) {
        this.attributePrefLevels.set(key, value);
    }

    public void setAttributePrefLevels(List<String> attributePrefLevels) {
        this.attributePrefLevels = attributePrefLevels;
    }

    public List<String> getRoomFeaturePrefLevels() {
        return this.roomFeaturePrefLevels;
    }

    public String getRoomFeaturePrefLevels(int key) {
        return this.roomFeaturePrefLevels.get(key).toString();
    }

    public void setRoomFeaturePrefLevels(int key, String value) {
        this.roomFeaturePrefLevels.set(key, value);
    }

    public void setRoomFeaturePrefLevels(List<String> roomFeaturePrefLevels) {
        this.roomFeaturePrefLevels = roomFeaturePrefLevels;
    }

    public List<String> getDatePatternPrefs() {
        return this.datePatternPrefs;
    }

    public String getDatePatternPrefs(int key) {
        return this.datePatternPrefs.get(key).toString();
    }

    public void setDatePatternPrefs(int key, String value) {
        this.datePatternPrefs.set(key, value);
    }

    public void setDatePatternPrefs(List<String> datePatternPrefs) {
        this.datePatternPrefs = datePatternPrefs;
    }

    public List<String> getDatePatternPrefLevels() {
        return this.datePatternPrefLevels;
    }

    public String getDatePatternPrefLevels(int key) {
        return this.datePatternPrefLevels.get(key).toString();
    }

    public void setDatePatternPrefLevels(List<String> datePatternPrefLevels) {
        this.datePatternPrefLevels = datePatternPrefLevels;
    }

    public void setDatePatternPrefLevels(int key, String value) {
        this.datePatternPrefLevels.set(key, value);
    }

    public void addToRoomPrefs(String roomPref, String level, Integer index) {
        this.roomPrefs.add(roomPref);
        this.roomPrefLevels.add(level);
        this.roomPrefIndexes.add(index == null ? "-" : index.toString());
    }

    public void addToRoomFeatPrefs(String roomFeatPref, String level, Integer index) {
        this.roomFeaturePrefs.add(roomFeatPref);
        this.roomFeaturePrefLevels.add(level);
        this.roomFeaturePrefIndexes.add(index == null ? "-" : index.toString());
    }

    public void addToRoomGroups(String roomGroup, String level, Integer index) {
        this.roomGroups.add(roomGroup);
        this.roomGroupLevels.add(level);
        this.roomGroupIndexes.add(index == null ? "-" : index.toString());
    }

    public void addToBldgPrefs(String bldgPref, String level, Integer index) {
        this.bldgPrefs.add(bldgPref);
        this.bldgPrefLevels.add(level);
        this.bldgPrefIndexes.add(index == null ? "-" : index.toString());
    }

    public void addToDistPrefs(String distPref, String level) {
        this.distPrefs.add(distPref);
        this.distPrefLevels.add(level);
    }

    public void addToCoursePrefs(String coursePref, String level) {
        this.coursePrefs.add(coursePref);
        this.coursePrefLevels.add(level);
    }

    public void addToInstructorPrefs(String instructorPref, String level) {
        this.instructorPrefs.add(instructorPref);
        this.instructorPrefLevels.add(level);
    }

    public void addToAttributePrefs(String attributePref, String level) {
        this.attributePrefs.add(attributePref);
        this.attributePrefLevels.add(level);
    }

    public void addToDatePatternPrefs(String datePatternPref, String level) {
        this.datePatternPrefs.add(datePatternPref);
        this.datePatternPrefLevels.add(level);
    }

    public void sortDatePatternPrefs(List<String> prefs, List<String> prefLevels, List<DatePattern> patterns) {
        if (prefs == null) {
            return;
        }
        if (prefs.size() == patterns.size()) {
            Collections.sort(patterns);
            ArrayList<String> newPrefs = new ArrayList<String>();
            ArrayList<String> newPrefLevels = new ArrayList<String>();
            newPrefLevels.addAll(prefLevels);
            newPrefs.addAll(prefs);
            for (int i = 0; i < newPrefs.size(); ++i) {
                String ith_pattern = patterns.get(i).getUniqueId().toString();
                int indexOfPatternInPrefs = prefs.indexOf(ith_pattern);
                newPrefs.set(i, ith_pattern);
                newPrefLevels.set(i, prefLevels.get(indexOfPatternInPrefs));
            }
            prefs.clear();
            prefLevels.clear();
            prefs.addAll(newPrefs);
            prefLevels.addAll(newPrefLevels);
        }
    }

    public void addBlankPrefRows() {
        for (int i = 0; i < 2; ++i) {
            this.addToBldgPrefs("-", "-", null);
            this.addToRoomPrefs("-", "-", null);
            this.addToRoomFeatPrefs("-", "-", null);
            this.addToRoomGroups("-", "-", null);
            this.addToDistPrefs("-", "-");
            this.addToCoursePrefs("-", "-");
            this.addToAttributePrefs("-", "-");
            this.addToInstructorPrefs("-", "-");
        }
    }

    public void clearPrefs() {
        this.timePatterns.clear();
        this.roomGroups.clear();
        this.bldgPrefs.clear();
        this.bldgPrefLevels.clear();
        this.distPrefs.clear();
        this.distPrefLevels.clear();
        this.roomPrefs.clear();
        this.roomPrefLevels.clear();
        this.roomFeaturePrefs.clear();
        this.roomFeaturePrefLevels.clear();
        this.datePatternPrefs.clear();
        this.datePatternPrefLevels.clear();
        this.coursePrefs.clear();
        this.coursePrefLevels.clear();
        this.instructorPrefs.clear();
        this.instructorPrefLevels.clear();
        this.attributePrefs.clear();
        this.attributePrefLevels.clear();
        this.roomPrefIndexes.clear();
        this.roomFeaturePrefIndexes.clear();
        this.roomGroupIndexes.clear();
        this.bldgPrefIndexes.clear();
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    public String getPreviousId() {
        return this.previousId;
    }

    public void setPreviousId(String previousId) {
        this.previousId = previousId;
    }

    public boolean getAllowHardPrefs() {
        return this.allowHardPrefs;
    }

    public void setAllowHardPrefs(boolean allowHardPrefs) {
        this.allowHardPrefs = allowHardPrefs;
    }

    public boolean getHasNotAvailable() {
        return this.hasNotAvailable;
    }

    public void setHasNotAvailable(boolean hasNotAvailable) {
        this.hasNotAvailable = hasNotAvailable;
    }

    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    @Override
    public void validate(UniTimeAction action) {
        List<String> lst = this.getRoomGroups();
        if (!this.checkPrefs(lst, this.getRoomGroupIndexes())) {
            action.addFieldError("roomGroups", MSG.errorInvalidRoomGroup());
        }
        if (!this.checkPrefLevels(this.getRoomGroupLevels(), lst)) {
            action.addFieldError("roomGroups", MSG.errorInvalidRoomGroupLevel());
        }
        lst = this.getBldgPrefs();
        if (!this.checkPrefs(lst, this.getBldgPrefLevels())) {
            action.addFieldError("bldgPrefs", MSG.errorInvalidBuildingPreference());
        }
        if (!this.checkPrefLevels(this.getBldgPrefLevels(), lst)) {
            action.addFieldError("bldgPrefs", MSG.errorInvalidBuildingPreferenceLevel());
        }
        lst = this.getRoomPrefs();
        if (!this.checkPrefs(lst, this.getRoomPrefIndexes())) {
            action.addFieldError("roomPrefs", MSG.errorInvalidRoomPreference());
        }
        if (!this.checkPrefLevels(this.getRoomPrefLevels(), lst)) {
            action.addFieldError("roomPrefs", MSG.errorInvalidRoomPreferenceLevel());
        }
        lst = this.getRoomFeaturePrefs();
        if (!this.checkPrefs(lst, this.getRoomFeaturePrefIndexes())) {
            action.addFieldError("roomFeaturePrefs", MSG.errorInvalidRoomFeaturePreference());
        }
        if (!this.checkPrefLevels(this.getRoomFeaturePrefLevels(), lst)) {
            action.addFieldError("roomFeaturePrefs", MSG.errorInvalidRoomFeaturePreferenceLevel());
        }
        lst = this.getDistPrefs();
        if (!this.checkPrefs(lst)) {
            action.addFieldError("distPrefs", MSG.errorInvalidDistributionPreference());
        }
        if (!this.checkPrefLevels(this.getDistPrefLevels(), lst)) {
            action.addFieldError("distPrefs", MSG.errorInvalidDistributionPreferenceLevel());
        }
        lst = this.getCoursePrefs();
        if (!this.checkPrefs(lst)) {
            action.addFieldError("coursePrefs", MSG.errorInvalidCoursePreference());
        }
        if (!this.checkPrefLevels(this.getCoursePrefLevels(), lst)) {
            action.addFieldError("coursePrefs", MSG.errorInvalidCoursePreferenceLevel());
        }
        lst = this.getInstructorPrefs();
        if (!this.checkPrefs(lst)) {
            action.addFieldError("instructorPrefs", MSG.errorInvalidInstructorPreference());
        }
        if (!this.checkPrefLevels(this.getInstructorPrefLevels(), lst)) {
            action.addFieldError("instructorPrefs", MSG.errorInvalidInstructorPreferenceLevel());
        }
        lst = this.getAttributePrefs();
        if (!this.checkPrefs(lst)) {
            action.addFieldError("attributePrefs", MSG.errorInvalidAttributePreference());
        }
        if (!this.checkPrefLevels(this.getAttributePrefLevels(), lst)) {
            action.addFieldError("attributePrefs", MSG.errorInvalidAttributePreferenceLevel());
        }
        for (int i = 0; i < this.getTimePatterns().size(); ++i) {
            if (action.getRequest().getParameter("p" + i + "_hour") == null) continue;
            boolean daySelected = false;
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                if (action.getRequest().getParameter("p" + i + "_d" + j) == null) continue;
                daySelected = true;
            }
            if (!daySelected) {
                action.addFieldError("timePrefs", "No day is selected in time preferences.");
                break;
            }
            if ("".equals(action.getRequest().getParameter("p" + i + "_hour"))) {
                action.addFieldError("timePrefs", "No time is selected in time preferences.");
                break;
            }
            if ("".equals(action.getRequest().getParameter("p" + i + "_min"))) {
                action.addFieldError("timePrefs", "No time is selected in time preferences.");
                break;
            }
            if (!"".equals(action.getRequest().getParameter("p" + i + "_morn"))) continue;
            action.addFieldError("timePrefs", "No time is selected in time preferences.");
            break;
        }
    }

    @Override
    public void reset() {
        this.op = "";
        this.timePattern = null;
        this.timePatterns = new ArrayList<String>();
        this.availableTimePatterns = new ArrayList<TimePattern>();
        this.roomPrefs = new ArrayList<String>();
        this.roomPrefLevels = new ArrayList<String>();
        this.bldgPrefs = new ArrayList<String>();
        this.bldgPrefLevels = new ArrayList<String>();
        this.roomFeaturePrefs = new ArrayList<String>();
        this.roomFeaturePrefLevels = new ArrayList<String>();
        this.roomGroups = new ArrayList<String>();
        this.roomGroupLevels = new ArrayList<String>();
        this.distPrefs = new ArrayList<String>();
        this.distPrefLevels = new ArrayList<String>();
        this.datePatternPrefs = new ArrayList<String>();
        this.datePatternPrefLevels = new ArrayList<String>();
        this.coursePrefs = new ArrayList<String>();
        this.coursePrefLevels = new ArrayList<String>();
        this.attributePrefs = new ArrayList<String>();
        this.attributePrefLevels = new ArrayList<String>();
        this.instructorPrefs = new ArrayList<String>();
        this.instructorPrefLevels = new ArrayList<String>();
        this.roomPrefIndexes = new ArrayList<String>();
        this.roomFeaturePrefIndexes = new ArrayList<String>();
        this.roomGroupIndexes = new ArrayList<String>();
        this.bldgPrefIndexes = new ArrayList<String>();
        this.previousId = null;
        this.nextId = null;
        this.allowHardPrefs = true;
        this.hasNotAvailable = false;
        this.addBlankPrefRows();
        this.availability = null;
    }

    public boolean hasRequiredDatePatternPref() {
        PreferenceLevel req = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired);
        for (String prefId : this.datePatternPrefLevels) {
            if (!req.getUniqueId().toString().equals(prefId)) continue;
            return true;
        }
        return false;
    }

    public List<String> getRoomPrefIndexes() {
        return this.roomPrefIndexes;
    }

    public String getRoomPrefIndexes(int key) {
        return this.roomPrefIndexes.get(key).toString();
    }

    public void setRoomPrefIndexes(int key, String value) {
        this.roomPrefIndexes.set(key, value);
    }

    public void setRoomPrefIndexes(List<String> roomPrefIndexes) {
        this.roomPrefIndexes = roomPrefIndexes;
    }

    public List<String> getRoomGroupIndexes() {
        return this.roomGroupIndexes;
    }

    public String getRoomGroupIndexes(int key) {
        return this.roomGroupIndexes.get(key).toString();
    }

    public void setRoomGroupIndexes(int key, String value) {
        this.roomGroupIndexes.set(key, value);
    }

    public void setRoomGroupIndexes(List<String> roomGroupIndexes) {
        this.roomGroupIndexes = roomGroupIndexes;
    }

    public List<String> getRoomFeaturePrefIndexes() {
        return this.roomFeaturePrefIndexes;
    }

    public String getRoomFeaturePrefIndexes(int key) {
        return this.roomFeaturePrefIndexes.get(key).toString();
    }

    public void setRoomFeaturePrefIndexes(int key, String value) {
        this.roomFeaturePrefIndexes.set(key, value);
    }

    public void setRoomFeaturePrefIndexes(List<String> roomFeaturePrefIndexes) {
        this.roomFeaturePrefIndexes = roomFeaturePrefIndexes;
    }

    public List<String> getBldgPrefIndexes() {
        return this.bldgPrefIndexes;
    }

    public String getBldgPrefIndexes(int key) {
        return this.bldgPrefIndexes.get(key).toString();
    }

    public void setBldgPrefIndexes(int key, String value) {
        this.bldgPrefIndexes.set(key, value);
    }

    public void setBldgPrefIndexes(List<String> bldgPrefIndexes) {
        this.bldgPrefIndexes = bldgPrefIndexes;
    }
}

