/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.logging.client.ConsoleLogHandler;
import com.google.gwt.logging.client.DefaultLevel;
import com.google.gwt.logging.client.DevelopmentModeLogHandler;
import com.google.gwt.logging.client.HasWidgetsLogHandler;
import com.google.gwt.logging.client.NullLogHandler;
import com.google.gwt.logging.client.SimpleRemoteLogHandler;
import com.google.gwt.logging.client.SystemLogHandler;
import com.google.gwt.user.client.Window;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogConfiguration
implements EntryPoint {
    private static LogConfigurationImpl impl = (LogConfigurationImpl)GWT.create(LogConfigurationImplNull.class);

    public static boolean loggingIsEnabled() {
        if (impl == null) {
            return true;
        }
        return impl.loggingIsEnabled();
    }

    public static boolean loggingIsEnabled(Level level) {
        if (impl == null) {
            return true;
        }
        return impl.loggingIsEnabled(level);
    }

    @Override
    public void onModuleLoad() {
        impl.configureClientSideLogging();
        if (impl.loggingIsEnabled() && GWT.getUncaughtExceptionHandler() == null) {
            final Logger log = Logger.getLogger(LogConfiguration.class.getName());
            GWT.setUncaughtExceptionHandler(new GWT.UncaughtExceptionHandler(){

                @Override
                public void onUncaughtException(Throwable e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            });
        }
    }

    private static interface LogConfigurationImpl {
        public void configureClientSideLogging();

        public boolean loggingIsEnabled();

        public boolean loggingIsEnabled(Level var1);
    }

    private static class LogConfigurationImplNull
    implements LogConfigurationImpl {
        private LogConfigurationImplNull() {
        }

        @Override
        public void configureClientSideLogging() {
        }

        @Override
        public boolean loggingIsEnabled() {
            return false;
        }

        @Override
        public boolean loggingIsEnabled(Level level) {
            return false;
        }
    }

    private static class LogConfigurationImplWarning
    extends LogConfigurationImplRegular {
        private LogConfigurationImplWarning() {
        }

        @Override
        public boolean loggingIsEnabled(Level level) {
            return level.intValue() >= 900;
        }
    }

    private static class LogConfigurationImplSevere
    extends LogConfigurationImplRegular {
        private LogConfigurationImplSevere() {
        }

        @Override
        public boolean loggingIsEnabled(Level level) {
            return level.intValue() >= 1000;
        }
    }

    private static class LogConfigurationImplRegular
    implements LogConfigurationImpl {
        private Logger root;

        private LogConfigurationImplRegular() {
        }

        @Override
        public void configureClientSideLogging() {
            assert (GWT.isClient());
            this.root = Logger.getLogger("");
            this.root.setUseParentHandlers(false);
            this.setLevels(this.root);
            this.setDefaultHandlers(this.root);
        }

        @Override
        public boolean loggingIsEnabled() {
            return true;
        }

        @Override
        public boolean loggingIsEnabled(Level level) {
            return true;
        }

        private void addHandlerIfNotNull(Logger l, Handler h) {
            if (!(h instanceof NullLogHandler)) {
                l.addHandler(h);
            }
        }

        private void setDefaultHandlers(Logger l) {
            Handler console = (Handler)GWT.create(ConsoleLogHandler.class);
            this.addHandlerIfNotNull(l, console);
            Handler dev = (Handler)GWT.create(DevelopmentModeLogHandler.class);
            this.addHandlerIfNotNull(l, dev);
            Handler system = (Handler)GWT.create(SystemLogHandler.class);
            this.addHandlerIfNotNull(l, system);
            Handler remote = (Handler)GWT.create(SimpleRemoteLogHandler.class);
            this.addHandlerIfNotNull(l, remote);
            Handler loggingWidget = (Handler)GWT.create(HasWidgetsLogHandler.class);
            this.addHandlerIfNotNull(l, loggingWidget);
        }

        private void setLevels(Logger l) {
            Level level;
            String levelParam = Window.Location.getParameter("logLevel");
            Level level2 = level = levelParam == null ? null : Level.parse(levelParam);
            if (level != null) {
                l.setLevel(level);
            } else {
                DefaultLevel defaultLevel = (DefaultLevel)GWT.create(DefaultLevel.class);
                l.setLevel(defaultLevel.getLevel());
            }
        }
    }
}

