/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHelper;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;

public abstract class NeighbourSelectionWithContext<V extends Variable<V, T>, T extends Value<V, T>, C extends AssignmentContext>
implements NeighbourSelection<V, T>,
HasAssignmentContext<V, T, C>,
CanHoldContext {
    private AssignmentContextReference<V, T, C> iContextReference = null;
    private AssignmentContext[] iContext = new AssignmentContext[17];
    protected C iContextOverride = null;

    @Override
    public void init(Solver<V, T> solver) {
        this.iContextReference = solver.currentSolution().getModel().createReference(this);
        if (this.isSingleContextSolver(solver)) {
            this.iContextOverride = this.createAssignmentContext(solver.currentSolution().getAssignment());
        }
    }

    protected boolean isSingleContextSolver(Solver<V, T> solver) {
        return solver.hasSingleSolution();
    }

    @Override
    public C getContext(Assignment<V, T> assignment) {
        if (this.iContextOverride != null) {
            return this.iContextOverride;
        }
        return AssignmentContextHelper.getContext(this, assignment);
    }

    @Override
    public AssignmentContextReference<V, T, C> getAssignmentContextReference() {
        return this.iContextReference;
    }

    @Override
    public void setAssignmentContextReference(AssignmentContextReference<V, T, C> reference) {
        this.iContextReference = reference;
    }

    @Override
    public AssignmentContext[] getContext() {
        return this.iContext;
    }

    public boolean hasContextOverride() {
        return this.iContextOverride != null;
    }
}

