/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;

public class NeighbourSelector<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T> {
    protected static DecimalFormat sDF = new DecimalFormat("0.00");
    private boolean iUpdate = false;
    private NeighbourSelection<V, T> iSelection;
    private int iNrCalls = 0;
    private int iNrNotNull = 0;
    private int iNrSideMoves = 0;
    private int iNrImprovingMoves = 0;
    private double iBonus = 1.0;
    private double iPoints = 0.0;
    private long iTime = 0L;

    public NeighbourSelector(NeighbourSelection<V, T> sel, double bonus, boolean update) {
        this.iSelection = sel;
        this.iBonus = bonus;
        this.iUpdate = update;
    }

    @Override
    public void init(Solver<V, T> solver) {
        this.iSelection.init(solver);
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        if (this.iUpdate) {
            long t0 = System.currentTimeMillis();
            Neighbour<V, T> n = this.iSelection.selectNeighbour(solution);
            long t1 = System.currentTimeMillis();
            this.update(solution.getAssignment(), n, t1 - t0);
            return n;
        }
        return this.iSelection.selectNeighbour(solution);
    }

    public void update(Assignment<V, T> a, Neighbour<V, T> n, long time) {
        ++this.iNrCalls;
        this.iTime += time;
        if (n != null) {
            ++this.iNrNotNull;
            double val = n.value(a);
            if (val == 0.0) {
                ++this.iNrSideMoves;
                this.iPoints += 0.1;
            } else if (val < 0.0) {
                ++this.iNrImprovingMoves;
                this.iPoints -= n.value(a);
            } else {
                this.iPoints *= 0.9999;
            }
        } else {
            this.iPoints *= 0.999;
        }
    }

    public double getPoints() {
        return this.iBonus * Math.min(100.0, 0.1 + this.iPoints);
    }

    public double getBonus() {
        return this.iBonus;
    }

    public NeighbourSelection<V, T> selection() {
        return this.iSelection;
    }

    public int nrCalls() {
        return this.iNrCalls;
    }

    public int nrNotNull() {
        return this.iNrNotNull;
    }

    public int nrSideMoves() {
        return this.iNrSideMoves;
    }

    public int nrImprovingMoves() {
        return this.iNrImprovingMoves;
    }

    public long time() {
        return this.iTime;
    }

    public double speed() {
        return 1000.0 * (double)this.nrCalls() / (double)this.time();
    }

    public String toString() {
        return this.iSelection.getClass().getName().substring(this.iSelection.getClass().getName().lastIndexOf(46) + 1) + " " + this.nrCalls() + "x, " + sDF.format(100.0 * (double)(this.nrCalls() - this.nrNotNull()) / (double)this.nrCalls()) + "% null, " + sDF.format(100.0 * (double)this.nrSideMoves() / (double)this.nrCalls()) + "% side, " + sDF.format(100.0 * (double)this.nrImprovingMoves() / (double)this.nrCalls()) + "% imp, " + sDF.format(this.speed()) + " it/s";
    }
}

