/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.command.client.GwtRpc;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class LoadingWidget
extends Composite {
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    public static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static LoadingWidget sInstance = null;
    private AbsolutePanel iPanel = new AbsolutePanel();
    private Image iImage = null;
    private int iCount = 0;
    private Timer iWarningTimer = null;
    private HTML iWarning;
    private HTML iMessage = null;
    private HTML iCancel;
    private Timer iCancelTimer = null;
    private Long iExecutionId = null;

    public LoadingWidget() {
        this.iPanel.setStyleName("unitime-LoadingPanel");
        this.iImage = new Image(RESOURCES.loading());
        this.iImage.setStyleName("unitime-LoadingIcon");
        this.initWidget((Widget)this.iPanel);
        Window.addWindowScrollHandler((Window.ScrollHandler)new Window.ScrollHandler(){

            public void onWindowScroll(Window.ScrollEvent event) {
                if (LoadingWidget.this.iCount > 0) {
                    LoadingWidget.this.iPanel.getElement().getStyle().setProperty("left", String.valueOf(event.getScrollLeft()));
                    LoadingWidget.this.iPanel.getElement().getStyle().setProperty("top", String.valueOf(event.getScrollTop()));
                    LoadingWidget.this.iImage.getElement().getStyle().setProperty("left", String.valueOf(event.getScrollLeft() + Window.getClientWidth() / 2));
                    LoadingWidget.this.iImage.getElement().getStyle().setProperty("top", String.valueOf(event.getScrollTop() + Window.getClientHeight() / 2));
                    LoadingWidget.this.iWarning.getElement().getStyle().setProperty("left", String.valueOf(event.getScrollLeft() + Window.getClientWidth() / 2 - 225));
                    LoadingWidget.this.iWarning.getElement().getStyle().setProperty("top", String.valueOf(event.getScrollTop() + 5 * Window.getClientHeight() / 12));
                    LoadingWidget.this.iMessage.getElement().getStyle().setProperty("left", String.valueOf(event.getScrollLeft() + Window.getClientWidth() / 2 - 225));
                    LoadingWidget.this.iMessage.getElement().getStyle().setProperty("top", String.valueOf(event.getScrollTop() + Window.getClientHeight() / 3));
                    LoadingWidget.this.iCancel.getElement().getStyle().setProperty("left", String.valueOf(event.getScrollLeft() + Window.getClientWidth() / 2 - 225));
                    LoadingWidget.this.iCancel.getElement().getStyle().setProperty("top", String.valueOf(event.getScrollTop() + 5 * Window.getClientHeight() / 12));
                }
            }
        });
        this.iWarning = new HTML(MESSAGES.warnLoadingTooLong(), true);
        this.iWarning.setStyleName("unitime-Notification");
        this.iWarning.addStyleName("unitime-NotificationError");
        this.iCancel = new HTML(MESSAGES.warnLoadingTooLongCanCancel());
        this.iCancel.setStyleName("unitime-Notification");
        this.iCancel.addStyleName("unitime-NotificationWarning");
        this.iCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (LoadingWidget.this.iExecutionId != null) {
                    GwtRpc.cancel(LoadingWidget.this.iExecutionId);
                }
            }
        });
        this.iMessage = new HTML("", true);
        this.iMessage.setStyleName("unitime-Notification");
        this.iMessage.addStyleName("unitime-NotificationInfo");
        this.iWarningTimer = new Timer(){

            public void run() {
                RootPanel.get().add((Widget)LoadingWidget.this.iWarning, Window.getScrollLeft() + Window.getClientWidth() / 2 - 225, Window.getScrollTop() + 5 * Window.getClientHeight() / 12);
            }
        };
        this.iCancelTimer = new Timer(){

            public void run() {
                RootPanel.get().add((Widget)LoadingWidget.this.iCancel, Window.getScrollLeft() + Window.getClientWidth() / 2 - 225, Window.getScrollTop() + 5 * Window.getClientHeight() / 12);
            }
        };
    }

    public void show() {
        this.show(null);
    }

    public void show(String message) {
        this.show(message, 120000);
    }

    protected void showCancel(Long executionId) {
        this.iExecutionId = executionId;
        this.iWarningTimer.cancel();
        this.iCancelTimer.schedule(2500);
    }

    protected void hideCancel() {
        this.iCancelTimer.cancel();
        RootPanel.get().remove((Widget)this.iCancel);
    }

    public void show(String message, int warningDelayInMillis) {
        if (this.iCount == 0) {
            RootPanel.get().add((Widget)this, Window.getScrollLeft(), Window.getScrollTop());
            RootPanel.get().add((Widget)this.iImage, Window.getScrollLeft() + Window.getClientWidth() / 2, Window.getScrollTop() + Window.getClientHeight() / 2);
            this.iWarningTimer.schedule(warningDelayInMillis);
        }
        if (message != null) {
            boolean showing = this.iCount > 0 && !this.iMessage.getText().isEmpty();
            this.iMessage.setHTML(message);
            if (!showing && !this.iMessage.getText().isEmpty()) {
                RootPanel.get().add((Widget)this.iMessage, Window.getScrollLeft() + Window.getClientWidth() / 2 - 225, Window.getScrollTop() + Window.getClientHeight() / 3);
            } else if (showing && this.iMessage.getText().isEmpty()) {
                RootPanel.get().remove((Widget)this.iMessage);
            }
            AriaStatus.getInstance().setText(message.replace("...", "."));
        }
        ++this.iCount;
    }

    public void setMessage(String message) {
        this.iMessage.setHTML(message);
    }

    public void hide() {
        if (this.iCount > 0) {
            --this.iCount;
        }
        if (this.iCount == 0) {
            RootPanel.get().remove((Widget)this.iImage);
            RootPanel.get().remove((Widget)this);
            this.iWarningTimer.cancel();
            this.iCancelTimer.cancel();
            RootPanel.get().remove((Widget)this.iWarning);
            RootPanel.get().remove((Widget)this.iMessage);
            RootPanel.get().remove((Widget)this.iCancel);
            this.iMessage.setHTML("");
        }
    }

    public boolean isShowing() {
        return this.iCount > 0;
    }

    public static LoadingWidget getInstance() {
        if (sInstance == null) {
            sInstance = new LoadingWidget();
        }
        return sInstance;
    }

    public static native void createTriggers();

    public static void showLoading(String message) {
        LoadingWidget.getInstance().show(message == null || message.isEmpty() ? null : message);
    }

    public static void hideLoading() {
        LoadingWidget.getInstance().hide();
    }

    public static <T extends GwtRpcResponse> void execute(GwtRpcRequest<T> request, final AsyncCallback<T> callback, String loadingMessage) {
        LoadingWidget.showLoading(loadingMessage);
        GwtRpc.execute(request, new GwtRpc.CancellableCallback<T>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                callback.onFailure(caught);
            }

            public void onSuccess(T result) {
                LoadingWidget.hideLoading();
                callback.onSuccess(result);
            }

            @Override
            public void onExecution(Long executionId) {
                LoadingWidget.getInstance().showCancel(executionId);
            }
        });
    }
}

