/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;

public class CachedClassAssignmentProxy
implements ClassAssignmentProxy {
    private static Object sNULL = Boolean.FALSE;
    private ClassAssignmentProxy iProxy;
    private Hashtable iAssignmentTable = new Hashtable();
    private Hashtable iAssignmentInfoTable = new Hashtable();

    public CachedClassAssignmentProxy(ClassAssignmentProxy proxy) {
        this.iProxy = proxy;
    }

    @Override
    public Assignment getAssignment(Long classId) {
        Object cached = this.iAssignmentTable.get(classId);
        if (cached != null) {
            return sNULL.equals(cached) ? null : (Assignment)cached;
        }
        Assignment assignment = this.iProxy.getAssignment(classId);
        this.iAssignmentTable.put(classId, assignment == null ? sNULL : assignment);
        return assignment;
    }

    @Override
    public Assignment getAssignment(Class_ clazz) {
        Object cached = this.iAssignmentTable.get(clazz.getUniqueId());
        if (cached != null) {
            return sNULL.equals(cached) ? null : (Assignment)cached;
        }
        Assignment assignment = this.iProxy.getAssignment(clazz);
        this.iAssignmentTable.put(clazz.getUniqueId(), assignment == null ? sNULL : assignment);
        return assignment;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) {
        Object cached = this.iAssignmentInfoTable.get(classId);
        if (cached != null) {
            return sNULL.equals(cached) ? null : (AssignmentPreferenceInfo)cached;
        }
        AssignmentPreferenceInfo info = this.iProxy.getAssignmentInfo(classId);
        this.iAssignmentInfoTable.put(classId, info == null ? sNULL : info);
        return info;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) {
        Object cached = this.iAssignmentInfoTable.get(clazz.getUniqueId());
        if (cached != null) {
            return sNULL.equals(cached) ? null : (AssignmentPreferenceInfo)cached;
        }
        AssignmentPreferenceInfo info = this.iProxy.getAssignmentInfo(clazz);
        this.iAssignmentInfoTable.put(clazz.getUniqueId(), info == null ? sNULL : info);
        return info;
    }

    @Override
    public Hashtable getAssignmentTable(Collection classesOrClassIds) {
        Hashtable assignments = new Hashtable();
        Vector unknown = new Vector();
        for (Object classOrClassId : classesOrClassIds) {
            Long classId;
            Object cached;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((cached = this.iAssignmentTable.get(classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId)) != null) {
                if (sNULL.equals(cached)) continue;
                assignments.put(classId, cached);
                continue;
            }
            unknown.add(classOrClassId);
        }
        Hashtable newAssignments = this.iProxy.getAssignmentTable(unknown);
        Enumeration e = unknown.elements();
        while (e.hasMoreElements()) {
            Object classOrClassId = e.nextElement();
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            Long classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId;
            Assignment assignment = (Assignment)newAssignments.get(classId);
            this.iAssignmentTable.put(classId, assignment == null ? sNULL : assignment);
            if (assignment == null) continue;
            assignments.put(classId, assignment);
        }
        return assignments;
    }

    @Override
    public Hashtable getAssignmentInfoTable(Collection classesOrClassIds) {
        Hashtable infos = new Hashtable();
        Vector unknown = new Vector();
        for (Object classOrClassId : classesOrClassIds) {
            Long classId;
            Object cached;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((cached = this.iAssignmentInfoTable.get(classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId)) != null) {
                if (sNULL.equals(cached)) continue;
                infos.put(classId, cached);
                continue;
            }
            unknown.add(classOrClassId);
        }
        Hashtable newInfos = this.iProxy.getAssignmentInfoTable(unknown);
        Enumeration e = unknown.elements();
        while (e.hasMoreElements()) {
            Object classOrClassId = e.nextElement();
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            Long classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId;
            AssignmentPreferenceInfo info = (AssignmentPreferenceInfo)newInfos.get(classId);
            this.iAssignmentInfoTable.put(classId, info == null ? sNULL : info);
            if (info == null) continue;
            infos.put(classId, info);
        }
        return infos;
    }

    public void setCache(Collection classesOrClassIds) {
        Vector classesOrClassIdsVect = classesOrClassIds instanceof Vector ? (Vector)classesOrClassIds : new Vector(classesOrClassIds);
        Hashtable newAssignments = this.iProxy.getAssignmentTable(classesOrClassIdsVect);
        Hashtable newInfos = this.iProxy.getAssignmentInfoTable(classesOrClassIdsVect);
        Enumeration e = classesOrClassIdsVect.elements();
        while (e.hasMoreElements()) {
            Object classOrClassId = e.nextElement();
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            Long classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId;
            Assignment assignment = (Assignment)newAssignments.get(classId);
            this.iAssignmentTable.put(classId, assignment == null ? sNULL : assignment);
            AssignmentPreferenceInfo info = (AssignmentPreferenceInfo)newInfos.get(classId);
            this.iAssignmentInfoTable.put(classId, info == null ? sNULL : info);
        }
    }

    @Override
    public boolean hasConflicts(Long offeringId) {
        return this.iProxy.hasConflicts(offeringId);
    }

    @Override
    public Set<Assignment> getConflicts(Long classId) {
        return this.iProxy.getConflicts(classId);
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) {
        return this.iProxy.getConflictingTimeBlocks(classId);
    }
}

