/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TravelTime;

public class TravelTimesExport
extends BaseExport {
    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("traveltimes");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("created", new Date().toString());
            document.addDocType("traveltimes", "-//UniTime//UniTime Travel Times DTD/EN", "http://www.unitime.org/interface/TravelTimes.dtd");
            HashMap<Long, HashMap<Long, Integer>> matrix = new HashMap<Long, HashMap<Long, Integer>>();
            for (TravelTime travel : this.getHibSession().createQuery("from TravelTime where session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                HashMap<Long, Integer> m = (HashMap<Long, Integer>)matrix.get(travel.getLocation1Id());
                if (m == null) {
                    m = new HashMap<Long, Integer>();
                    matrix.put(travel.getLocation1Id(), m);
                }
                m.put(travel.getLocation2Id(), travel.getDistance());
            }
            List<Location> locations = Location.findAll(session.getUniqueId());
            Collections.sort(locations);
            for (Location from : locations) {
                Map m = (Map)matrix.get(from.getUniqueId());
                if (m == null || m.isEmpty()) continue;
                Element fromEl = root.addElement("from");
                this.fillLocationData(from, fromEl);
                for (Location to : locations) {
                    Integer distance = (Integer)m.get(to.getUniqueId());
                    if (distance == null) continue;
                    Element toEl = fromEl.addElement("to");
                    this.fillLocationData(to, toEl);
                    toEl.setText(distance.toString());
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    private void fillLocationData(Location location, Element element) {
        if (location instanceof Room) {
            Room room = (Room)location;
            element.addAttribute("building", room.getBuilding().getAbbreviation());
            element.addAttribute("roomNbr", room.getRoomNumber());
        } else {
            element.addAttribute("name", location.getLabel());
        }
        if (location.getExternalUniqueId() != null && !location.getExternalUniqueId().isEmpty()) {
            element.addAttribute("id", location.getExternalUniqueId());
        }
    }
}

