/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.jgroups.ExaminationSolverContainer;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

public class ExaminationSolverContainerRemote
extends ExaminationSolverContainer
implements RemoteSolverContainer<ExamSolverProxy> {
    private static Log sLog = LogFactory.getLog(ExaminationSolverContainerRemote.class);
    private RpcDispatcher iDispatcher;

    public ExaminationSolverContainerRemote(JChannel channel, short scope) {
        this.iDispatcher = new MuxRpcDispatcher(scope, (Channel)channel, null, null, (Object)this);
    }

    @Override
    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public boolean createRemoteSolver(String user, DataProperties config, Address caller) {
        super.createSolver(user, config);
        return true;
    }

    @Override
    public Object invoke(String method, String user, Class[] types, Object[] args) throws Exception {
        try {
            ExamSolverProxy solver = (ExamSolverProxy)this.iExamSolvers.get(user);
            if ("exists".equals(method) && types.length == 0) {
                Boolean bl = solver != null;
                return bl;
            }
            if (solver == null) {
                throw new Exception("Solver " + user + " does not exist.");
            }
            Object object = solver.getClass().getMethod(method, types).invoke((Object)solver, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        finally {
            _RootDAO.closeCurrentThreadSessions();
        }
    }

    @Override
    public Object dispatch(Address address, String user, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), user, method.getParameterTypes(), args}, new Class[]{String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            if ("exists".equals(method.getName()) && e instanceof SuspectedException) {
                return false;
            }
            sLog.error((Object)("Excution of " + method.getName() + " on solver " + user + " failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ExamSolverProxy createProxy(Address address, String user) {
        SolverInvocationHandler handler = new SolverInvocationHandler(address, user);
        return (ExamSolverProxy)Proxy.newProxyInstance(ExamSolverProxy.class.getClassLoader(), new Class[]{ExamSolverProxy.class, RemoteSolver.class}, (InvocationHandler)handler);
    }

    public class SolverInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private String iUser;

        private SolverInvocationHandler(Address address, String user) {
            this.iAddress = address;
            this.iUser = user;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return ExaminationSolverContainerRemote.this.dispatch(this.iAddress, this.iUser, method, args);
            }
        }
    }
}

