/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=preferences]")
public class PreferenceLevels
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pagePreferenceLevel(), MESSAGES.pagePreferenceLevels());
    }

    @Override
    @PreAuthorize(value="checkPermission('PreferenceLevels')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 40, 2, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 80, 10, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0, 1, 2);
        for (PreferenceLevel pref : PreferenceLevelDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord((long)pref.getPrefId(), false);
            r.setField(0, pref.getPrefProlog(), false);
            r.setField(1, pref.getPrefName());
            r.setField(2, pref.getAbbreviation());
        }
        data.setEditable(context.hasPermission(Right.PreferenceLevelEdit));
        data.setAddable(false);
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('PreferenceLevelEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (PreferenceLevel pref : PreferenceLevelDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord((long)pref.getUniqueId());
            if (r == null) {
                this.delete(pref, context, hibSession);
                continue;
            }
            this.update(pref, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('PreferenceLevelEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new IllegalArgumentException("Insert operation is not supported for preference level.");
    }

    protected void update(PreferenceLevel pref, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (pref == null) {
            return;
        }
        if (ToolBox.equals((Object)pref.getPrefProlog(), (Object)record.getField(0)) && ToolBox.equals((Object)pref.getPrefName(), (Object)record.getField(1)) && ToolBox.equals((Object)pref.getAbbreviation(), (Object)record.getField(2))) {
            return;
        }
        pref.setPrefName(record.getField(1));
        pref.setPrefAbbv(record.getField(2));
        hibSession.saveOrUpdate((Object)pref);
        ChangeLog.addChange(hibSession, context, pref, pref.getPrefProlog() + " " + pref.getPrefName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('PreferenceLevelEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((PreferenceLevel)PreferenceLevelDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(PreferenceLevel pref, SessionContext context, Session hibSession) {
        if (pref == null) {
            return;
        }
        throw new IllegalArgumentException("Delete operation is not supported for preference level.");
    }

    @Override
    @PreAuthorize(value="checkPermission('PreferenceLevelEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((PreferenceLevel)PreferenceLevelDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

