/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.AcademicSessionLookup;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.UserContext;

public class SubjectArea
extends BaseSubjectArea
implements Comparable<SubjectArea> {
    private static final long serialVersionUID = 3256439188198207794L;
    public static String SUBJ_AREA_ATTR_NAME = "subjectAreaList";

    public SubjectArea() {
    }

    public SubjectArea(Long uniqueId) {
        super(uniqueId);
    }

    public static List<SubjectArea> getSubjectAreaList(Long sessionId) throws HibernateException {
        SubjectAreaDAO subjDAO = new SubjectAreaDAO();
        org.hibernate.Session hibSession = subjDAO.getSession();
        List subjs = hibSession.createCriteria(SubjectArea.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)sessionId)).list();
        return subjs;
    }

    public static SubjectArea findByAbbv(Long sessionId, String subjectAreaAbbr) {
        return SubjectArea.findByAbbv(SubjectAreaDAO.getInstance().getSession(), sessionId, subjectAreaAbbr);
    }

    public static SubjectArea findByAbbv(org.hibernate.Session hibSession, Long sessionId, String subjectAreaAbbr) {
        return (SubjectArea)(hibSession == null ? SubjectAreaDAO.getInstance().getSession() : hibSession).createQuery("from SubjectArea where session.uniqueId = :sessionId and subjectAreaAbbreviation = :subjectAreaAbbr").setLong("sessionId", sessionId.longValue()).setString("subjectAreaAbbr", subjectAreaAbbr).setMaxResults(1).uniqueResult();
    }

    public static SubjectArea findUsingInitiativeYearTermSubjectAbbreviation(String academicInitiative, String academicYear, String term, String subjectAreaAbbreviation, org.hibernate.Session hibSession) {
        return (SubjectArea)hibSession.createQuery("from SubjectArea sa where sa.session.academicInitiative = :campus and sa.session.academicYear = :year and sa.session.academicTerm = :term and sa.subjectAreaAbbreviation = :subj").setString("campus", academicInitiative).setString("year", academicYear).setString("term", term).setString("subj", subjectAreaAbbreviation).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static SubjectArea findUsingCampusYearTermExternalSubjectAbbreviation(String campus, String year, String term, String externalSubjectAreaAbbreviation, org.hibernate.Session hibSession) {
        String className = ApplicationProperty.AcademicSessionLookupImplementation.value();
        AcademicSessionLookup academicSessionLookup = null;
        try {
            academicSessionLookup = (AcademicSessionLookup)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return SubjectArea.findByAbbv(hibSession, Session.getSessionUsingInitiativeYearTerm(campus, year, term, hibSession).getUniqueId(), externalSubjectAreaAbbreviation);
        }
        return academicSessionLookup.findSubjectAreaForCampusYearTerm(campus, year, term, externalSubjectAreaAbbreviation, hibSession);
    }

    public ArrayList<TimetableManager> getManagers() {
        if (this.getDepartment() != null) {
            ArrayList<TimetableManager> al = new ArrayList<TimetableManager>();
            al.addAll(this.getDepartment().getTimetableManagers());
            return al;
        }
        return new ArrayList<TimetableManager>();
    }

    @Override
    public int compareTo(SubjectArea s) {
        int cmp = new NaturalOrderComparator().compare(this.getSubjectAreaAbbreviation() == null ? "" : this.getSubjectAreaAbbreviation(), s.getSubjectAreaAbbreviation() == null ? "" : s.getSubjectAreaAbbreviation());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(s.getUniqueId() == null ? -1L : s.getUniqueId());
    }

    @Override
    public String toString() {
        return this.getSubjectAreaAbbreviation() + " - " + this.getTitle();
    }

    public String getLabel() {
        return this.getSubjectAreaAbbreviation() + " - " + this.getTitle();
    }

    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public Object clone() {
        SubjectArea newSubjectArea = new SubjectArea();
        newSubjectArea.setDepartment(this.getDepartment());
        newSubjectArea.setExternalUniqueId(this.getExternalUniqueId());
        newSubjectArea.setTitle(this.getTitle());
        newSubjectArea.setSession(this.getSession());
        newSubjectArea.setSubjectAreaAbbreviation(this.getSubjectAreaAbbreviation());
        return newSubjectArea;
    }

    public SubjectArea findSameSubjectAreaInSession(Session session) {
        return SubjectArea.findByAbbv(session.getUniqueId(), this.getSubjectAreaAbbreviation());
    }

    public boolean hasOfferedCourses() {
        for (CourseOffering co : this.getCourseOfferings()) {
            if (co.getInstructionalOffering().isNotOffered().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static TreeSet<SubjectArea> getAllSubjectAreas(Long sessionId) {
        return new TreeSet<SubjectArea>(SubjectAreaDAO.getInstance().getQuery("from SubjectArea where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
    }

    public static TreeSet<SubjectArea> getUserSubjectAreas(UserContext user) {
        return SubjectArea.getUserSubjectAreas(user, true);
    }

    public static TreeSet<SubjectArea> getUserSubjectAreas(UserContext user, boolean allSubjectsIfExternalManager) {
        TreeSet<SubjectArea> subjectAreas = new TreeSet<SubjectArea>();
        if (user == null || user.getCurrentAuthority() == null) {
            return subjectAreas;
        }
        for (Department department : Department.getUserDepartments(user)) {
            if (department.isExternalManager().booleanValue() && allSubjectsIfExternalManager) {
                subjectAreas.addAll(department.getSession().getSubjectAreas());
                break;
            }
            subjectAreas.addAll(department.getSubjectAreas());
        }
        return subjectAreas;
    }

    public Department getEffectiveFundingDept() {
        if (this.getFundingDept() == null) {
            return this.getDepartment();
        }
        return this.getFundingDept();
    }
}

