/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.LazyInitializationException;
import org.hibernate.Query;
import org.hibernate.engine.spi.SessionImplementor;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingAddAction;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.InstrOfferingPermIdGenerator;

public class CourseOffering
extends BaseCourseOffering
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static final String CRS_OFFERING_LIST_ATTR_NAME = "crsOfferingList";

    public CourseOffering() {
    }

    public CourseOffering(Long uniqueId) {
        super(uniqueId);
    }

    public String getCourseName() {
        return this.getSubjectAreaAbbv() + " " + this.getCourseNbr();
    }

    public String getCourseNameWithTitle() {
        return this.getSubjectAreaAbbv() + " " + this.getCourseNbr() + (this.getTitle() != null && !this.getTitle().isEmpty() ? " - " + this.getTitle() : "");
    }

    public String getCourseNumberWithTitle() {
        return this.getCourseNbr() + (this.getTitle() != null && !this.getTitle().isEmpty() ? " - " + this.getTitle() : "");
    }

    @Override
    public String toString() {
        return this.getSubjectAreaAbbv() + " " + this.getCourseNbr() + (this.getTitle() != null ? " - " + this.getTitle().replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("'", "&quot;").replaceAll("&", "&amp;") : "");
    }

    @Override
    public Boolean getIsControl() {
        return this.isIsControl();
    }

    public static CourseOffering findBySessionSubjAreaIdCourseNbr(Long acadSessionId, Long subjAreaId, String courseNbr) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("from CourseOffering co where co.uniqueCourseNbr.subjectArea.uniqueId = :subjArea and co.uniqueCourseNbr.courseNbr = :crsNbr and co.instructionalOffering.session.uniqueId = :acadSessionId").setString("crsNbr", courseNbr).setLong("subjArea", subjAreaId.longValue()).setLong("acadSessionId", acadSessionId.longValue()).setMaxResults(1).uniqueResult();
    }

    public static CourseOffering findBySessionSubjAreaAbbvCourseNbr(Long acadSessionId, String subjAreaAbbv, String courseNbr) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("from CourseOffering co where co.uniqueCourseNbr.subjectArea.subjectAreaAbbreviation = :subjArea and co.uniqueCourseNbr.courseNbr = :crsNbr and co.instructionalOffering.session.uniqueId = :acadSessionId").setString("crsNbr", courseNbr).setString("subjArea", subjAreaAbbv).setLong("acadSessionId", acadSessionId.longValue()).setMaxResults(1).uniqueResult();
    }

    public static CourseOffering findBySessionSubjAreaAbbvCourseNbrTitle(Long acadSessionId, String subjAreaAbbv, String courseNbr, String title) {
        InstructionalOfferingDAO iDao = new InstructionalOfferingDAO();
        org.hibernate.Session hibSession = iDao.getSession();
        String sql = " from CourseOffering co  where co.subjectArea.subjectAreaAbbreviation=:subjArea and co.courseNbr = :crsNbr and co.title = :title and co.instructionalOffering.session.uniqueId = :acadSessionId";
        Query query = hibSession.createQuery(sql);
        query.setString("crsNbr", courseNbr);
        query.setString("subjArea", subjAreaAbbv);
        query.setLong("acadSessionId", acadSessionId.longValue());
        query.setString("title", title);
        return (CourseOffering)query.uniqueResult();
    }

    public static synchronized CourseOffering addNew(Long subjAreaId, String courseNbr) throws Exception {
        CourseOffering co = null;
        InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
        org.hibernate.Session hibSession = idao.getSession();
        try {
            SubjectArea subjArea = (SubjectArea)new SubjectAreaDAO().get(subjAreaId);
            Session acadSession = subjArea.getSession();
            CourseOfferingDAO cdao = new CourseOfferingDAO();
            co = new CourseOffering();
            co.setSubjectArea(subjArea);
            co.setCourseNbr(courseNbr);
            co.setProjectedDemand(0);
            co.setDemand(0);
            co.setNbrExpectedStudents(0);
            co.setIsControl(true);
            co.setPermId(InstrOfferingPermIdGenerator.getGenerator().generate((SessionImplementor)new CourseOfferingDAO().getSession(), (Object)co).toString());
            HashSet<CourseOffering> s = new HashSet<CourseOffering>();
            s.add(co);
            InstructionalOffering io = new InstructionalOffering();
            io.setNotOffered(false);
            io.setSession(acadSession);
            io.generateInstrOfferingPermId();
            io.setLimit(0);
            io.setByReservationOnly(false);
            idao.saveOrUpdate(io);
            idao.getSession().refresh((Object)io);
            co.setInstructionalOffering(io);
            io.addTocourseOfferings(co);
            cdao.saveOrUpdate(co);
            cdao.getSession().refresh((Object)co);
            cdao.getSession().refresh((Object)subjArea);
            String className = ApplicationProperty.ExternalActionInstructionalOfferingAdd.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingAddAction addAction = (ExternalInstructionalOfferingAddAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                addAction.performExternalInstructionalOfferingAddAction(io, hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            throw new Exception("Could not create new course offering: " + e.getMessage());
        }
        return co;
    }

    public static Vector getControllingCourses(Long sessionId) {
        Vector<ComboBoxLookup> l = new Vector<ComboBoxLookup>();
        for (Object[] o : new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.subjectAreaAbbv, co.courseNbr from CourseOffering co where co.isControl=true and co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            l.addElement(new ComboBoxLookup(o[0].toString(), o[1] + " " + o[2]));
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Department getDepartment() {
        Department dept = null;
        try {
            dept = this.getSubjectArea().getDepartment();
            if (dept.toString() != null) return dept;
        }
        catch (LazyInitializationException lie) {
            new _RootDAO().getSession().refresh((Object)this);
            return this.getSubjectArea().getDepartment();
        }
        return dept;
    }

    public Department getManagingDept() {
        Department dept = null;
        for (InstrOfferingConfig config : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                Department mgr = subpart.getManagingDept();
                if (mgr == null) continue;
                if (dept == null) {
                    dept = mgr;
                    continue;
                }
                if (dept.equals(mgr)) continue;
                return this.getDepartment();
            }
        }
        return dept == null ? this.getDepartment() : dept;
    }

    public List getCourseOfferingDemands() {
        if (this.getPermId() != null) {
            return new CourseOfferingDAO().getSession().createQuery("select d from LastLikeCourseDemand d where d.coursePermId=:permId and d.subjectArea.session.uniqueId=:sessionId").setString("permId", this.getPermId()).setLong("sessionId", this.getSubjectArea().getSessionId().longValue()).setCacheable(true).list();
        }
        return new CourseOfferingDAO().getSession().createQuery("select d from LastLikeCourseDemand d where d.subjectArea.uniqueId=:subjectAreaId and d.courseNbr=:courseNbr").setLong("subjectAreaId", this.getSubjectArea().getUniqueId().longValue()).setString("courseNbr", this.getCourseNbr()).setCacheable(true).list();
    }

    public List getLastLikeSemesterCourseOfferingDemands() {
        return this.getCourseOfferingDemands();
    }

    public Object clone() {
        CourseOffering co = new CourseOffering();
        co.setCourseNbr(this.getCourseNbr());
        co.setDemand(this.getDemand());
        co.setPermId(this.getPermId());
        co.setNbrExpectedStudents(this.getNbrExpectedStudents());
        co.setProjectedDemand(this.getProjectedDemand());
        co.setSubjectArea(this.getSubjectArea());
        co.setSubjectAreaAbbv(this.getSubjectAreaAbbv());
        co.setTitle(this.getTitle());
        co.setDemandOffering(this.getDemandOffering());
        co.setDemandOfferingType(this.getDemandOfferingType());
        co.setExternalUniqueId(this.getExternalUniqueId());
        co.setScheduleBookNote(this.getScheduleBookNote());
        co.setIsControl(this.getIsControl());
        co.setFundingDept(this.getFundingDept());
        return co;
    }

    public static List findAll(Long sessionId) {
        return new CourseOfferingDAO().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    public static CourseOffering findBySubjectAreaCourseNbr(Long sessionId, String subjectAreaAbbv, String courseNbr) {
        return (CourseOffering)new CourseOfferingDAO().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId and c.subjectArea.subjectAreaAbbreviation=:subjectAreaAbbv and c.courseNbr=:courseNbr").setLong("sessionId", sessionId.longValue()).setString("subjectAreaAbbv", subjectAreaAbbv).setString("courseNbr", courseNbr).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByExternalId(Long sessionId, String externalId) {
        return (CourseOffering)new CourseOfferingDAO().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId and c.externalUniqueId=:externalId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByUniqueId(Long uniqueId) {
        return (CourseOffering)new CourseOfferingDAO().get(uniqueId);
    }

    public static CourseOffering findBySubjectCourseNbrInstrOffUniqueId(String subjectAreaAbbv, String courseNbr, Long instrOffrUniqueId) {
        return (CourseOffering)new CourseOfferingDAO().getSession().createQuery("select c from InstructionalOffering io inner join io.courseOfferings c where io.uniqueId=:instrOffrUniqueId and c.subjectArea.subjectAreaAbbreviation=:subjectAreaAbbv and c.courseNbr=:courseNbr").setLong("instrOffrUniqueId", instrOffrUniqueId.longValue()).setString("subjectAreaAbbv", subjectAreaAbbv).setString("courseNbr", courseNbr).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByName(String name, Long sessionId) {
        return (CourseOffering)new CourseOfferingDAO().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :name").setLong("sessionId", sessionId.longValue()).setString("name", name.toLowerCase()).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (CourseOffering)new CourseOfferingDAO().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId and c.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom").setLong("sessionId", sessionId.longValue()).setLong("uniqueIdRolledForwardFrom", uniqueIdRolledForwardFrom.longValue()).setCacheable(true).uniqueResult();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof CourseOffering)) {
            return -1;
        }
        CourseOffering co = (CourseOffering)o;
        int cmp = this.getSubjectAreaAbbv().compareTo(co.getSubjectAreaAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getCourseNbr().compareTo(co.getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(co.getUniqueId() == null ? -1L : co.getUniqueId());
    }

    public CourseCreditUnitConfig getCredit() {
        if (this.getCreditConfigs() == null || this.getCreditConfigs().size() != 1) {
            return null;
        }
        return this.getCreditConfigs().iterator().next();
    }

    public void setCredit(CourseCreditUnitConfig courseCreditUnitConfig) {
        if (this.getCreditConfigs() == null || this.getCreditConfigs().size() == 0) {
            this.addTocreditConfigs(courseCreditUnitConfig);
        } else if (!this.getCreditConfigs().contains(courseCreditUnitConfig)) {
            this.getCreditConfigs().clear();
            this.getCreditConfigs().add(courseCreditUnitConfig);
        }
    }

    public boolean isAllowStudentScheduling() {
        return this.getSubjectArea().getDepartment().isAllowStudentScheduling();
    }

    public List<StudentClassEnrollment> getClassEnrollments(Student s) {
        ArrayList<StudentClassEnrollment> ret = new ArrayList<StudentClassEnrollment>();
        for (StudentClassEnrollment e : s.getClassEnrollments()) {
            if (!this.equals(e.getCourseOffering())) continue;
            ret.add(e);
        }
        return ret;
    }

    public Set<OverrideType> getEnabledOverrides() {
        TreeSet<OverrideType> ret = new TreeSet<OverrideType>();
        for (OverrideType override : OverrideTypeDAO.getInstance().findAll()) {
            if (this.getDisabledOverrides().contains(override)) continue;
            ret.add(override);
        }
        return ret;
    }

    public Department getEffectiveFundingDept() {
        if (this.getFundingDept() == null) {
            return this.getSubjectArea().getEffectiveFundingDept();
        }
        return this.getFundingDept();
    }
}

