/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.awt.image.BufferedImage;
import java.util.Collection;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamChangesForm;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Action(value="unassignedExams", results={@Result(name={"showReport"}, type="tiles", location="unassignedExams.tiles")})
@TilesDefinition(name="unassignedExams.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Not-Assigned Examinations"), @TilesPutAttribute(name="body", value="/exam/unassigned.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class UnassignedExamsAction
extends UniTimeAction<ExamReportForm> {
    private static final long serialVersionUID = 1476233244372449453L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.NotAssignedExaminations);
        ExamSolverProxy solver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new ExamChangesForm();
            ((ExamReportForm)this.form).reset();
            if (solver != null) {
                ((ExamReportForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        if (((ExamReportForm)this.form).getOp() != null) {
            this.op = ((ExamReportForm)this.form).getOp();
        }
        if (MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op) || MSG.buttonApply().equals(this.op)) {
            ((ExamReportForm)this.form).save(this.sessionContext);
        } else if (MSG.buttonRefresh().equals(this.op)) {
            ((ExamReportForm)this.form).reset();
            if (solver != null) {
                ((ExamReportForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        ((ExamReportForm)this.form).load(this.sessionContext);
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        RoomAvailability.setAvailabilityWarning(this.request, session, ((ExamReportForm)this.form).getExamType(), true, false);
        Collection<ExamInfo> unassignedExams = null;
        if (((ExamReportForm)this.form).getSubjectArea() != null && ((ExamReportForm)this.form).getSubjectArea() != 0L && ((ExamReportForm)this.form).getExamType() != null) {
            unassignedExams = solver != null && solver.getExamTypeId().equals(((ExamReportForm)this.form).getExamType()) ? solver.getUnassignedExams(((ExamReportForm)this.form).getSubjectArea()) : Exam.findUnassignedExams(this.sessionContext.getUser().getCurrentAcademicSessionId(), ((ExamReportForm)this.form).getSubjectArea(), ((ExamReportForm)this.form).getExamType());
        }
        WebTable.setOrder(this.sessionContext, "unassignedExams.ord", this.request.getParameter("ord"), 1);
        PdfWebTable table = this.getTable(true, false, unassignedExams);
        if (MSG.actionExportPdf().equals(this.op) && table != null) {
            ExportUtils.exportPDF(this.getTable(false, true, unassignedExams), WebTable.getOrder(this.sessionContext, "unassignedExams.ord"), this.response, "unassigned");
            return null;
        }
        if (MSG.actionExportCsv().equals(this.op) && table != null) {
            ExportUtils.exportCSV(this.getTable(false, false, unassignedExams), WebTable.getOrder(this.sessionContext, "unassignedExams.ord"), this.response, "unassigned");
            return null;
        }
        if (table != null) {
            ((ExamReportForm)this.form).setTable(table.printTable(WebTable.getOrder(this.sessionContext, "unassignedExams.ord")), 9, unassignedExams.size());
        }
        if (this.request.getParameter("backId") != null) {
            this.request.setAttribute("hash", (Object)this.request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return "showReport";
    }

    public PdfWebTable getTable(boolean html, boolean color, Collection<ExamInfo> exams) {
        if (exams == null || exams.isEmpty()) {
            return null;
        }
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(this.sessionContext.getUser());
        boolean timeText = RequiredTimeTable.getTimeGridAsText(this.sessionContext.getUser());
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(9, MSG.sectionNotAssingedExaminations(), "unassignedExams.action?ord=%%", new String[]{((ExamReportForm)this.form).getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colExamLength(), MSG.colSeatingType().replace("\n", nl), MSG.colExamSize(), MSG.colExamMaxRooms().replace("\n", nl), MSG.colInstructor(), MSG.colExamPeriodPrefs().replace("\n", nl), MSG.colExamRoomPrefs().replace("\n", nl), MSG.colExamDistributionPrefs().replace("\n", nl)}, new String[]{"left", "right", "center", "right", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, false, false, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        try {
            for (ExamInfo exam : exams) {
                PeriodPreferenceModel px;
                MidtermPeriodPreferenceModel epx;
                String perPref = "";
                String roomPref = "";
                String distPref = "";
                if (html) {
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(RoomPref.class)).length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(BuildingPref.class)).length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(RoomFeaturePref.class)).length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(RoomGroupPref.class)).endsWith(nl)) {
                        roomPref = roomPref.substring(0, roomPref.length() - nl.length());
                    }
                    if (timeText) {
                        perPref = perPref + exam.getExam().getEffectivePrefHtmlForPrefType(ExamPeriodPref.class);
                    } else if (exam.getExam().getExamType().getType() == 1) {
                        epx = new MidtermPeriodPreferenceModel(exam.getExam().getSession(), exam.getExam().getExamType());
                        epx.load(exam.getExam());
                        perPref = perPref + epx.toString(true);
                    } else {
                        px = new PeriodPreferenceModel(exam.getExam().getSession(), exam.getExamTypeId());
                        px.load(exam.getExam());
                        perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getExamId() + "' title='" + px.toString() + "'>";
                    }
                    distPref = distPref + exam.getExam().getEffectivePrefHtmlForPrefType(DistributionPref.class);
                } else {
                    for (Preference pref : exam.getExam().effectivePreferences(RoomPref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(BuildingPref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(RoomFeaturePref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(RoomGroupPref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    if (1 == exam.getExamType().getType()) {
                        epx = new MidtermPeriodPreferenceModel(exam.getExam().getSession(), exam.getExamType());
                        epx.load(exam.getExam());
                        perPref = perPref + epx.toString(false, true);
                    } else if (timeText || !color) {
                        for (Preference pref : exam.getExam().effectivePreferences(ExamPeriodPref.class)) {
                            if (perPref.length() > 0) {
                                perPref = perPref + nl;
                            }
                            perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                        }
                    } else {
                        px = new PeriodPreferenceModel(exam.getExam().getSession(), exam.getExamType().getUniqueId());
                        px.load(exam.getExam());
                        RequiredTimeTable rtt = new RequiredTimeTable(px);
                        BufferedImage image = rtt.createBufferedImage(timeVertical);
                        if (image != null) {
                            table.addImage(exam.getExamId().toString(), image);
                            perPref = perPref + "@@IMAGE " + exam.getExamId().toString() + " ";
                        } else {
                            for (Preference pref : exam.getExam().effectivePreferences(ExamPeriodPref.class)) {
                                if (perPref.length() > 0) {
                                    perPref = perPref + nl;
                                }
                                perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                            }
                        }
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(DistributionPref.class)) {
                        if (distPref.length() > 0) {
                            distPref = distPref + nl;
                        }
                        distPref = distPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + ((DistributionPref)pref).preferenceText(true, true, " (", ", ", ")").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                    }
                }
                String instructors = exam.getInstructorName(", ");
                table.addLine("onClick=\"showGwtDialog('" + MSG.dialogExamAssign() + "', 'examInfo.action?examId=" + exam.getExamId() + "','900','90%');\"", new String[]{(html ? "<a name='" + exam.getExamId() + "'>" : "") + (((ExamReportForm)this.form).getShowSections() ? exam.getSectionName(nl) : exam.getExamName()) + (html ? "</a>" : ""), String.valueOf(exam.getLength()), 0 == exam.getSeatingType() ? MSG.seatingNormal() : MSG.seatingExam(), String.valueOf(exam.getNrStudents()), String.valueOf(exam.getMaxRooms()), instructors, perPref, roomPref, distPref}, new Comparable[]{exam, Integer.valueOf(exam.getLength()), Integer.valueOf(exam.getSeatingType()), Integer.valueOf(exam.getNrStudents()), Integer.valueOf(exam.getMaxRooms()), instructors, perPref, roomPref, distPref}, exam.getExamId().toString());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>" + MSG.error(e.getMessage()) + "</font>"}, null);
        }
        return table;
    }
}

