/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamPdfReportForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.queue.PdfExamReportQueueItem;
import org.unitime.timetable.util.queue.QueueItem;

@Action(value="examPdfReport", results={@Result(name={"show"}, type="tiles", location="examPdfReport.tiles")})
@TilesDefinition(name="examPdfReport.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination PDF Reports"), @TilesPutAttribute(name="body", value="/exam/pdfReport.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamPdfReportAction
extends UniTimeAction<ExamPdfReportForm> {
    private static final long serialVersionUID = -2736074007763182603L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String remove;

    public String getRemove() {
        return this.remove;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public String execute() throws Exception {
        WebTable table;
        String op;
        this.sessionContext.checkPermission(Right.ExaminationPdfReports);
        ExamSolverProxy examSolver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new ExamPdfReportForm();
            ((ExamPdfReportForm)this.form).reset();
            if (examSolver != null) {
                ((ExamPdfReportForm)this.form).setExamType(examSolver.getExamTypeId());
            }
        }
        if (((ExamPdfReportForm)this.form).getOp() != null) {
            this.op = ((ExamPdfReportForm)this.form).getOp();
        }
        if (examSolver != null) {
            if (ApplicationProperty.ExaminationPdfReportsCanUseSolution.isTrue()) {
                this.request.setAttribute("RqWarn", (Object)MSG.warnExamPdfReportsUsingSolution());
            } else {
                this.request.setAttribute("RqWarn", (Object)MSG.warnEamPdfReportsUsingSaved());
            }
        }
        String string = op = ((ExamPdfReportForm)this.form).getOp() != null ? ((ExamPdfReportForm)this.form).getOp() : this.request.getParameter("op");
        if (MSG.actionGenerateReport().equals(op)) {
            ((ExamPdfReportForm)this.form).save(this.sessionContext);
        }
        ((ExamPdfReportForm)this.form).load(this.sessionContext);
        if (((ExamPdfReportForm)this.form).getAddress() == null) {
            ((ExamPdfReportForm)this.form).setAddress(this.sessionContext.getUser().getEmail());
        }
        if (MSG.actionGenerateReport().equals(op)) {
            ((ExamPdfReportForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.getSolverServerService().getQueueProcessor().add(new PdfExamReportQueueItem((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()), this.sessionContext.getUser(), (ExamPdfReportForm)((ExamPdfReportForm)this.form).clone(), this.request, examSolver));
            }
        }
        if (this.remove != null && !this.remove.isEmpty()) {
            this.getSolverServerService().getQueueProcessor().remove(this.remove);
        }
        if ((table = this.getQueueTable(this.request)) != null) {
            this.request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "examPdfReport.ord")));
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        return "show";
    }

    private WebTable getQueueTable(HttpServletRequest request) {
        List<QueueItem> queue;
        WebTable.setOrder(this.sessionContext, "examPdfReport.ord", request.getParameter("ord"), 1);
        String log = request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        String ownerId = null;
        if (!this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            ownerId = this.sessionContext.getUser().getExternalUserId();
        }
        if ((queue = this.getSolverServerService().getQueueProcessor().getItems(ownerId, null, PdfExamReportQueueItem.TYPE)).isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, MSG.sectReportsInProgress(), "examPdfReport.action?ord=%%", new String[]{MSG.colTaskName(), MSG.colTaskStatus(), MSG.colTaskProgress(), MSG.colTaskOwner(), MSG.colTaskSession(), MSG.colTaskCreated(), MSG.colTaskStarted(), MSG.colTaskFinished(), MSG.colTaskOutput()}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            String name = item.name();
            if (name.length() > 60) {
                name = name.substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('" + MSG.questionDeleteReportInProgress() + "')) document.location='examPdfReport.action?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine(item.log().isEmpty() ? null : "onClick=\"document.location='examPdfReport.action?log=" + item.getId() + "';\"", new String[]{name + (delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.hasOutput() ? "<A href='" + item.getOutputLink() + "'>" + item.getOutputName().substring(item.getOutputName().lastIndexOf(46) + 1).toUpperCase() + "</A>" : ""}, new Comparable[]{Long.valueOf(item.created().getTime()), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log != null && log.equals(item.getId().toString())) {
                request.setAttribute("logname", (Object)name);
                request.setAttribute("logid", (Object)item.getId().toString());
                request.setAttribute("log", (Object)item.log());
                line.setBgColor("rgb(168,187,225)");
            }
            if (log != null || item.started() == null || item.finished() != null || !this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId())) continue;
            request.setAttribute("logname", (Object)name);
            request.setAttribute("logid", (Object)item.getId().toString());
            request.setAttribute("log", (Object)item.log());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }
}

