/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeSet;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassListForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.pdf.PdfInstructionalOfferingTableBuilder;

public class PdfClassListTableBuilder
extends PdfInstructionalOfferingTableBuilder {
    protected String additionalNote() {
        return new String();
    }

    protected String labelForTable(SubjectArea subjectArea) {
        StringBuffer sb = new StringBuffer();
        sb.append(subjectArea.getSubjectAreaAbbreviation());
        sb.append(" - ");
        sb.append(subjectArea.getSession().getLabel());
        sb.append(this.additionalNote());
        return sb.toString();
    }

    public void pdfTableForClasses(OutputStream out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, ClassListForm form, SessionContext context) throws Exception {
        this.setVisibleColumns(form);
        TreeSet classes = (TreeSet)form.getClasses();
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                if (classAssignment instanceof CachedClassAssignmentProxy) {
                    ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                }
                for (Object[] o : classes) {
                    Class_ clazz = (Class_)o[0];
                    if (classAssignment.getAssignment(clazz) == null) continue;
                    hasTimetable = true;
                    break;
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId()));
        }
        float[] widths = this.getWidths();
        float totalWidth = 0.0f;
        for (int i = 0; i < widths.length; ++i) {
            totalWidth += widths[i];
        }
        this.iDocument = new Document(new Rectangle(60.0f + totalWidth, 60.0f + 0.77f * totalWidth), 30.0f, 30.0f, 30.0f, 30.0f);
        this.iWriter = PdfEventHandler.initFooter(this.iDocument, out);
        this.iDocument.open();
        int ct = 0;
        Iterator it = classes.iterator();
        BaseSubjectArea subjectArea = null;
        String prevLabel = null;
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            Class_ c = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            if (subjectArea == null || !subjectArea.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                if (this.iPdfTable != null) {
                    this.iDocument.add((Element)this.iPdfTable);
                    this.iDocument.newPage();
                }
                this.iPdfTable = new PdfPTable(this.getWidths());
                this.iPdfTable.setWidthPercentage(100.0f);
                this.iPdfTable.getDefaultCell().setPadding(3.0f);
                this.iPdfTable.getDefaultCell().setBorderWidth(0.0f);
                this.iPdfTable.setSplitRows(false);
                subjectArea = co.getSubjectArea();
                ct = 0;
                this.iDocument.add((Element)new Paragraph(this.labelForTable((SubjectArea)subjectArea), PdfFont.getBigFont(true)));
                this.iDocument.add((Element)new Paragraph(" "));
                this.pdfBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            }
            this.pdfBuildClassRow(classAssignment, examAssignment, ++ct, co, c, "", context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        if (this.iPdfTable != null) {
            this.iDocument.add((Element)this.iPdfTable);
        }
        this.iDocument.close();
    }

    @Override
    protected PdfPCell pdfBuildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel) {
        if (prefGroup instanceof Class_) {
            Color color = isEditable ? Color.BLACK : Color.GRAY;
            String label = prefGroup.toString();
            Class_ aClass = (Class_)prefGroup;
            label = aClass.getClassLabel(co);
            if (prevLabel != null && label.equals(prevLabel)) {
                label = "";
            }
            PdfPCell cell = this.createCell();
            this.addText(cell, indentSpaces + label, co.isIsControl(), false, 0, color, true);
            InstructionalMethod im = aClass.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
            if (im != null) {
                this.addText(cell, " (" + im.getReference() + ")", false, false, 0, color, false);
            }
            return cell;
        }
        return super.pdfBuildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, null);
    }

    @Override
    protected TreeSet getExams(Class_ clazz) {
        TreeSet ret = new TreeSet(Exam.findAll(3, clazz.getUniqueId()));
        SchedulingSubpart subpart = clazz.getSchedulingSubpart();
        if (subpart.getParentSubpart() != null) {
            return ret;
        }
        InstrOfferingConfig config = subpart.getInstrOfferingConfig();
        SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
        for (SchedulingSubpart s : config.getSchedulingSubparts()) {
            if (cmp.compare(s, subpart) >= 0) continue;
            return ret;
        }
        InstructionalOffering offering = config.getInstructionalOffering();
        ret.addAll(Exam.findAll(2, config.getUniqueId()));
        ret.addAll(Exam.findAll(0, offering.getUniqueId()));
        for (CourseOffering co : offering.getCourseOfferings()) {
            ret.addAll(Exam.findAll(1, co.getUniqueId()));
        }
        return ret;
    }

    @Override
    protected PdfPCell pdfBuildNote(PreferenceGroup prefGroup, boolean isEditable, UserContext user) {
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_) {
            String note;
            Class_ c = (Class_)prefGroup;
            String offeringNote = c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getNotes();
            String classNote = c.getNotes();
            String string = offeringNote == null || offeringNote.isEmpty() ? classNote : (note = offeringNote + (classNote == null || classNote.isEmpty() ? "" : "\n" + classNote));
            if (note != null && !note.isEmpty()) {
                if (note.length() <= 30 || user == null || CommonValues.NoteAsFullText.eq(user.getProperty(UserProperty.ManagerNoteDisplay))) {
                    this.addText(cell, note, false, false, 0, color, true);
                } else {
                    if (classNote != null && !classNote.isEmpty()) {
                        note = classNote;
                    }
                    this.addText(cell, note.length() <= 30 ? note : note.substring(0, 30) + "...", false, false, 0, color, true);
                }
            }
        }
        return cell;
    }
}

