/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.criteria.BrokenTimePatterns;
import org.cpsolver.coursett.criteria.TooBigRooms;
import org.cpsolver.coursett.criteria.UselessHalfHours;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.dom4j.Element;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.solver.ui.TimetableInfo;

public class AssignmentPreferenceInfo
implements TimetableInfo,
Serializable {
    private static final long serialVersionUID = 4L;
    public static int sVersion = 4;
    private double iNormalizedTimePreference = 0.0;
    private double iBestNormalizedTimePreference = 0.0;
    private int iTimePreference = 0;
    private Map<Long, Integer> iRoomPreference = new HashMap<Long, Integer>();
    private int iBestRoomPreference = 0;
    private int iNrStudentConflicts = 0;
    private int iNrHardStudentConflicts = 0;
    private int iNrDistanceStudentConflicts = 0;
    private int iNrCommitedStudentConflicts = 0;
    private int iNrTimeLocations = 0;
    private int iNrRoomLocations = 0;
    private int iNrSameRoomPlacementsNoConf = 0;
    private int iNrSameTimePlacementsNoConf = 0;
    private int iNrPlacementsNoConf = 0;
    private int iBtbInstructorPreference = 0;
    private boolean iIsInitial = false;
    private String iInitialAssignment = null;
    private boolean iHasInitialSameTime = false;
    private boolean iHasInitialSameRoom = false;
    private double iPerturbationPenalty = 0.0;
    private int iTooBigRoomPreference = 0;
    private long iMinRoomSize = 0L;
    private int iUselessHalfHours = 0;
    private double iDeptBalancPenalty = 0.0;
    private double iSpreadPenalty = 0.0;
    private int iMaxDeptBalancPenalty = 0;
    private double iMaxSpreadPenalty = 0.0;
    private int iGroupConstraintPref = 0;
    private int iDatePatternPref = 0;
    private Integer iStudentGroupPercent = null;
    private String iStudentGroupComment = null;

    public AssignmentPreferenceInfo() {
    }

    public AssignmentPreferenceInfo(Solver solver, Placement placement) {
        this(solver, placement, false, false);
    }

    public AssignmentPreferenceInfo(Solver solver, Placement placement, boolean includeConflictInfo) {
        this(solver, placement, includeConflictInfo, false);
    }

    public AssignmentPreferenceInfo(Solver solver, Placement placement, boolean includeConflictInfo, boolean ofTheSameProblem) {
        Assignment assignment = solver.currentSolution().getAssignment();
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Lecture lecture = (Lecture)placement.variable();
        this.setBestNormalizedTimePreference(lecture.getBestTimePreference());
        this.setNormalizedTimePreference(placement.getTimeLocation().getNormalizedPreference());
        this.setBestRoomPreference(lecture.getBestRoomPreference());
        if (ofTheSameProblem) {
            this.setNrStudentConflicts(lecture.countStudentConflictsOfTheSameProblem(assignment, placement));
            this.setNrHardStudentConflicts(lecture.countHardStudentConflictsOfTheSameProblem(assignment, placement));
            this.setNrCommitedStudentConflicts(lecture.countCommittedStudentConflictsOfTheSameProblem(assignment, placement));
            this.setNrDistanceStudentConflicts(lecture.countDistanceStudentConflictsOfTheSameProblem(assignment, placement));
        } else {
            this.setNrStudentConflicts(lecture.countStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement));
            this.setNrHardStudentConflicts(lecture.countHardStudentConflicts(assignment, placement));
            this.setNrCommitedStudentConflicts(lecture.getCommitedConflicts(placement) + lecture.countCommittedStudentConflicts(assignment, placement));
            this.setNrDistanceStudentConflicts(lecture.countDistanceStudentConflicts(assignment, placement));
        }
        this.setNrRoomLocations(lecture.nrRoomLocations());
        this.setNrTimeLocations(lecture.nrTimeLocations());
        if (lecture.nrTimeLocations() == 1 && placement.getTimeLocation().getPreference() == 0) {
            this.setTimePreference(PreferenceLevel.sIntLevelRequired);
        } else {
            this.setTimePreference(placement.getTimeLocation().getPreference());
        }
        if (placement.isMultiRoom()) {
            for (RoomLocation r : placement.getRoomLocations()) {
                if (lecture.nrRoomLocations() == lecture.getNrRooms() && r.getPreference() == 0) {
                    this.setRoomPreference(r.getId(), PreferenceLevel.sIntLevelRequired);
                    continue;
                }
                this.setRoomPreference(r.getId(), r.getPreference());
            }
        } else if (lecture.nrRoomLocations() == 1 && placement.getRoomLocation().getPreference() == 0) {
            this.setRoomPreference(placement.getRoomLocation().getId(), PreferenceLevel.sIntLevelRequired);
        } else {
            this.setRoomPreference(placement.getRoomLocation().getId(), placement.getRoomLocation().getPreference());
        }
        if (includeConflictInfo) {
            int nrSameRoomPlacementsNoConf = 0;
            int nrSameTimePlacementsNoConf = 0;
            int nrPlacementsNoConf = 0;
            for (Placement p : lecture.values(assignment)) {
                if (p.isHard(assignment) || p.equals((Object)placement) || !lecture.getModel().conflictValues(assignment, (Value)p).isEmpty()) continue;
                if (p.getTimeLocation().equals((Object)placement.getTimeLocation())) {
                    ++nrSameTimePlacementsNoConf;
                }
                if (p.sameRooms(placement)) {
                    ++nrSameRoomPlacementsNoConf;
                }
                ++nrPlacementsNoConf;
            }
            this.setNrPlacementsNoConf(nrPlacementsNoConf);
            this.setNrSameRoomPlacementsNoConf(nrSameRoomPlacementsNoConf);
            this.setNrSameTimePlacementsNoConf(nrSameTimePlacementsNoConf);
        }
        int btbInstructorPref = 0;
        for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
            btbInstructorPref += ic.getPreferenceCombination(assignment, placement);
        }
        this.setBtbInstructorPreference(btbInstructorPref);
        if (lecture.getInitialAssignment() != null) {
            this.setInitialAssignment(((Placement)lecture.getInitialAssignment()).getName());
            this.setIsInitial(placement.equals((Object)lecture.getInitialAssignment()));
            this.setHasInitialSameTime(placement.getTimeLocation().equals((Object)((Placement)lecture.getInitialAssignment()).getTimeLocation()));
            this.setHasInitialSameRoom(placement.sameRooms((Placement)lecture.getInitialAssignment()));
        }
        this.iTooBigRoomPreference = ((TooBigRooms)model.getCriterion(TooBigRooms.class)).getPreference(placement);
        this.iMinRoomSize = lecture.minRoomSize();
        this.iUselessHalfHours = ((Lecture)placement.variable()).getModel() == null ? 0 : (int)Math.round(((Lecture)placement.variable()).getModel().getCriterion(UselessHalfHours.class).getValue(assignment, (Value)placement, null) + ((Lecture)placement.variable()).getModel().getCriterion(BrokenTimePatterns.class).getValue(assignment, (Value)placement, null));
        DepartmentSpreadConstraint deptConstraint = null;
        HashMap<Variable, Placement> assignments = new HashMap<Variable, Placement>();
        if (placement != null) {
            assignments.put(placement.variable(), placement);
        }
        for (Constraint c : lecture.constraints()) {
            if (c instanceof DepartmentSpreadConstraint) {
                deptConstraint = (DepartmentSpreadConstraint)c;
            }
            if (c instanceof GroupConstraint) {
                this.iGroupConstraintPref += ((GroupConstraint)c).getCurrentPreference(assignment, placement);
            }
            if (!(c instanceof FlexibleConstraint)) continue;
            this.iGroupConstraintPref = (int)((double)this.iGroupConstraintPref + ((FlexibleConstraint)c).getCurrentPreference(assignment, null, assignments));
        }
        if (deptConstraint != null) {
            this.iDeptBalancPenalty = (double)deptConstraint.getPenalty(assignment, placement) / 12.0;
            this.iMaxDeptBalancPenalty = deptConstraint.getMaxPenalty(assignment, placement);
        }
        this.iSpreadPenalty = (double)placement.getSpreadPenalty(assignment) / 12.0;
        this.iMaxSpreadPenalty = (double)placement.getMaxSpreadPenalty(assignment) / 12.0;
        if (solver != null && solver.getPerturbationsCounter() != null) {
            this.setPerturbationPenalty(solver.getPerturbationsCounter().getPerturbationPenalty(assignment, lecture.getModel(), (Value)placement, new Vector(0)));
        }
        this.setDatePatternPref(placement.getTimeLocation().getDatePatternPreference());
        if (!model.getStudentGroups().isEmpty()) {
            int nrGroups = 0;
            double value = 0.0;
            int allAssigned = 0;
            int grandTotal = 0;
            for (StudentGroup group : model.getStudentGroups()) {
                int total = 0;
                int assigned = 0;
                for (Student student : group.getStudents()) {
                    if (lecture.getConfiguration() == null || !student.hasOffering(lecture.getConfiguration().getOfferingId())) continue;
                    ++total;
                    if (!lecture.students().contains(student)) continue;
                    ++assigned;
                }
                if (total <= true || assigned <= 0) continue;
                allAssigned += assigned;
                grandTotal += total;
                int limit = Math.max(lecture.students().size(), lecture.classLimit(assignment));
                if (total > limit) {
                    total = limit;
                }
                ++nrGroups;
                value += (double)assigned / (double)total;
            }
            if (nrGroups > 0) {
                this.iStudentGroupPercent = (int)Math.round(100.0 * value / (double)nrGroups);
                this.iStudentGroupComment = nrGroups == 1 ? allAssigned + " of " + grandTotal : nrGroups + " groups";
            }
        }
    }

    public double getNormalizedTimePreference() {
        return this.iNormalizedTimePreference;
    }

    public void setNormalizedTimePreference(double normalizedTimePreference) {
        this.iNormalizedTimePreference = normalizedTimePreference;
    }

    public double getBestNormalizedTimePreference() {
        return this.iBestNormalizedTimePreference;
    }

    public void setBestNormalizedTimePreference(double bestNormalizedTimePreference) {
        this.iBestNormalizedTimePreference = bestNormalizedTimePreference;
    }

    public int getTimePreference() {
        return this.iTimePreference;
    }

    public void setTimePreference(int timePreference) {
        this.iTimePreference = timePreference;
    }

    public int getRoomPreference(Long roomId) {
        Integer pref = this.iRoomPreference.get(roomId);
        return pref == null ? 0 : pref;
    }

    public int sumRoomPreference() {
        int ret = 0;
        Iterator<Integer> i = this.iRoomPreference.values().iterator();
        while (i.hasNext()) {
            ret += i.next().intValue();
        }
        return ret;
    }

    public int combineRoomPreference() {
        PreferenceCombination p = PreferenceCombination.getDefault();
        Iterator<Integer> i = this.iRoomPreference.values().iterator();
        while (i.hasNext()) {
            p.addPreferenceInt(i.next().intValue());
        }
        return p.getPreferenceInt();
    }

    public Map<Long, Integer> getRoomPreference() {
        return this.iRoomPreference;
    }

    public void setRoomPreference(Long roomId, int roomPreference) {
        this.iRoomPreference.put(roomId, roomPreference);
    }

    public int getBestRoomPreference() {
        return this.iBestRoomPreference;
    }

    public void setBestRoomPreference(int bestRoomPreference) {
        this.iBestRoomPreference = bestRoomPreference;
    }

    public int getNrStudentConflicts() {
        return this.iNrStudentConflicts;
    }

    public void setNrStudentConflicts(int nrStudentConflicts) {
        this.iNrStudentConflicts = nrStudentConflicts;
    }

    public int getNrHardStudentConflicts() {
        return this.iNrHardStudentConflicts;
    }

    public void setNrHardStudentConflicts(int nrHardStudentConflicts) {
        this.iNrHardStudentConflicts = nrHardStudentConflicts;
    }

    public int getNrDistanceStudentConflicts() {
        return this.iNrDistanceStudentConflicts;
    }

    public void setNrDistanceStudentConflicts(int nrDistanceStudentConflicts) {
        this.iNrDistanceStudentConflicts = nrDistanceStudentConflicts;
    }

    public int getNrCommitedStudentConflicts() {
        return this.iNrCommitedStudentConflicts;
    }

    public void setNrCommitedStudentConflicts(int nrCommitedStudentConflicts) {
        this.iNrCommitedStudentConflicts = nrCommitedStudentConflicts;
    }

    public int getNrTimeLocations() {
        return this.iNrTimeLocations;
    }

    public void setNrTimeLocations(int nrTimeLocations) {
        this.iNrTimeLocations = nrTimeLocations;
    }

    public int getNrRoomLocations() {
        return this.iNrRoomLocations;
    }

    public void setNrRoomLocations(int nrRoomLocations) {
        this.iNrRoomLocations = nrRoomLocations;
    }

    public int getNrSameRoomPlacementsNoConf() {
        return this.iNrSameRoomPlacementsNoConf;
    }

    public void setNrSameRoomPlacementsNoConf(int nrSameRoomPlacementsNoConf) {
        this.iNrSameRoomPlacementsNoConf = nrSameRoomPlacementsNoConf;
    }

    public int getNrSameTimePlacementsNoConf() {
        return this.iNrSameTimePlacementsNoConf;
    }

    public void setNrSameTimePlacementsNoConf(int nrSameTimePlacementsNoConf) {
        this.iNrSameTimePlacementsNoConf = nrSameTimePlacementsNoConf;
    }

    public int getNrPlacementsNoConf() {
        return this.iNrPlacementsNoConf;
    }

    public void setNrPlacementsNoConf(int nrPlacementsNoConf) {
        this.iNrPlacementsNoConf = nrPlacementsNoConf;
    }

    public int getBtbInstructorPreference() {
        return this.iBtbInstructorPreference;
    }

    public void setBtbInstructorPreference(int btbInstructorPreference) {
        this.iBtbInstructorPreference = btbInstructorPreference;
    }

    public boolean getIsInitial() {
        return this.iIsInitial;
    }

    public void setIsInitial(boolean isInitial) {
        this.iIsInitial = isInitial;
    }

    public String getInitialAssignment() {
        return this.iInitialAssignment;
    }

    public void setInitialAssignment(String initialAssignment) {
        this.iInitialAssignment = initialAssignment;
    }

    public boolean getHasInitialSameTime() {
        return this.iHasInitialSameTime;
    }

    public void setHasInitialSameTime(boolean hasInitialSameTime) {
        this.iHasInitialSameTime = hasInitialSameTime;
    }

    public boolean getHasInitialSameRoom() {
        return this.iHasInitialSameRoom;
    }

    public void setHasInitialSameRoom(boolean hasInitialSameRoom) {
        this.iHasInitialSameRoom = hasInitialSameRoom;
    }

    public double getPerturbationPenalty() {
        return this.iPerturbationPenalty;
    }

    public void setPerturbationPenalty(double perturbationPenalty) {
        this.iPerturbationPenalty = perturbationPenalty;
    }

    public int getTooBigRoomPreference() {
        return this.iTooBigRoomPreference;
    }

    public void setTooBigRoomPreference(int tooBigRoomPreference) {
        this.iTooBigRoomPreference = tooBigRoomPreference;
    }

    public long getMinRoomSize() {
        return this.iMinRoomSize;
    }

    public void setMinRoomSize(long minRoomSize) {
        this.iMinRoomSize = minRoomSize;
    }

    public int getUselessHalfHours() {
        return this.iUselessHalfHours;
    }

    public void setUselessHalfHours(int uselessHalfHours) {
        this.iUselessHalfHours = uselessHalfHours;
    }

    public double getDeptBalancPenalty() {
        return this.iDeptBalancPenalty;
    }

    public void setDeptBalancPenalty(double deptBalancPenalty) {
        this.iDeptBalancPenalty = deptBalancPenalty;
    }

    public int getMaxDeptBalancPenalty() {
        return this.iMaxDeptBalancPenalty;
    }

    public void setMaxDeptBalancPenalty(int deptBalancPenalty) {
        this.iMaxDeptBalancPenalty = deptBalancPenalty;
    }

    public int getGroupConstraintPref() {
        return this.iGroupConstraintPref;
    }

    public void setGroupConstraintPref(int groupConstraintPref) {
        this.iGroupConstraintPref = groupConstraintPref;
    }

    public double getSpreadPenalty() {
        return this.iSpreadPenalty;
    }

    public void setSpreadPenalty(double spreadPenalty) {
        this.iSpreadPenalty = spreadPenalty;
    }

    public double getMaxSpreadPenalty() {
        return this.iMaxSpreadPenalty;
    }

    public void setMaxSpreadPenalty(double spreadPenalty) {
        this.iMaxSpreadPenalty = spreadPenalty;
    }

    public int getDatePatternPref() {
        return this.iDatePatternPref;
    }

    public void setDatePatternPref(int datePatternPref) {
        this.iDatePatternPref = datePatternPref;
    }

    public Integer getStudentGroupPercent() {
        return this.iStudentGroupPercent;
    }

    public void setStudentGroupPercent(Integer percent) {
        this.iStudentGroupPercent = percent;
    }

    public String getStudentGroupComment() {
        return this.iStudentGroupComment;
    }

    public void setStudentGroupComment(String comment) {
        this.iStudentGroupComment = comment;
    }

    @Override
    public void load(Element root) {
        int version = Integer.parseInt(root.attributeValue("version"));
        if (version == sVersion) {
            this.iNormalizedTimePreference = Double.parseDouble(root.elementText("normTimePref"));
            this.iBestNormalizedTimePreference = Double.parseDouble(root.elementText("bestNormTimePref"));
            this.iTimePreference = Integer.parseInt(root.elementText("timePref"));
            Iterator i = root.elementIterator("roomPref");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                this.iRoomPreference.put(Long.valueOf(e.attributeValue("id")), Integer.valueOf(e.getText()));
            }
            this.iBestRoomPreference = Integer.parseInt(root.elementText("bestRoomPref"));
            this.iNrStudentConflicts = Integer.parseInt(root.elementText("nrStudentConf"));
            this.iNrHardStudentConflicts = Integer.parseInt(root.elementText("nrHardStudentConf"));
            this.iNrDistanceStudentConflicts = Integer.parseInt(root.elementText("nrDistanceStudentConf"));
            this.iNrCommitedStudentConflicts = Integer.parseInt(root.elementText("nrCommitedStudentConf"));
            this.iNrTimeLocations = Integer.parseInt(root.elementText("nrTimeLoc"));
            this.iNrRoomLocations = Integer.parseInt(root.elementText("nrRoomLoc"));
            this.iNrSameRoomPlacementsNoConf = Integer.parseInt(root.elementText("nrSameRoomPlacNoConf"));
            this.iNrSameTimePlacementsNoConf = Integer.parseInt(root.elementText("nrSameTimePlacNoConf"));
            this.iNrPlacementsNoConf = Integer.parseInt(root.elementText("nrPlacNoConf"));
            this.iBtbInstructorPreference = Integer.parseInt(root.elementText("btbInstrPref"));
            this.iIsInitial = Boolean.valueOf(root.elementText("isInitial"));
            this.iInitialAssignment = root.elementText("iniAssign");
            this.iHasInitialSameTime = Boolean.valueOf(root.elementText("hasIniSameTime"));
            this.iHasInitialSameRoom = Boolean.valueOf(root.elementText("hasIniSameRoom"));
            this.iPerturbationPenalty = Double.parseDouble(root.elementText("pertPenalty"));
            this.iTooBigRoomPreference = Integer.parseInt(root.elementText("tooBig"));
            this.iMinRoomSize = Long.parseLong(root.elementText("minSize"));
            this.iUselessHalfHours = Integer.parseInt(root.elementText("uselessHalfHours"));
            this.iDeptBalancPenalty = Double.parseDouble(root.elementText("deptBalanc"));
            this.iGroupConstraintPref = Integer.parseInt(root.elementText("groupConstr"));
            if (root.elementText("spread") != null) {
                this.iSpreadPenalty = Double.parseDouble(root.elementText("spread"));
            }
            this.iMaxSpreadPenalty = root.elementText("maxSpread") != null ? Double.parseDouble(root.elementText("maxSpread")) : this.iSpreadPenalty;
            this.iMaxDeptBalancPenalty = root.elementText("maxDeptBalanc") != null ? Integer.parseInt(root.elementText("maxDeptBalanc")) : (int)this.iDeptBalancPenalty;
            if (root.elementText("datePref") != null) {
                this.iDatePatternPref = Integer.parseInt(root.elementText("datePref"));
            }
            if (root.elementText("studentGroupPercent") != null) {
                this.iStudentGroupPercent = Integer.valueOf(root.elementText("studentGroupPercent"));
            }
            this.iStudentGroupComment = root.elementText("studentGroupComment");
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        root.addElement("normTimePref").setText(String.valueOf(this.iNormalizedTimePreference));
        root.addElement("bestNormTimePref").setText(String.valueOf(this.iBestNormalizedTimePreference));
        root.addElement("timePref").setText(String.valueOf(this.iTimePreference));
        for (Map.Entry<Long, Integer> entry : this.iRoomPreference.entrySet()) {
            root.addElement("roomPref").addAttribute("id", ((Object)entry.getKey()).toString()).setText(((Object)entry.getValue()).toString());
        }
        root.addElement("bestRoomPref").setText(String.valueOf(this.iBestRoomPreference));
        root.addElement("nrStudentConf").setText(String.valueOf(this.iNrStudentConflicts));
        root.addElement("nrHardStudentConf").setText(String.valueOf(this.iNrHardStudentConflicts));
        root.addElement("nrCommitedStudentConf").setText(String.valueOf(this.iNrCommitedStudentConflicts));
        root.addElement("nrDistanceStudentConf").setText(String.valueOf(this.iNrDistanceStudentConflicts));
        root.addElement("nrTimeLoc").setText(String.valueOf(this.iNrTimeLocations));
        root.addElement("nrRoomLoc").setText(String.valueOf(this.iNrRoomLocations));
        root.addElement("nrSameRoomPlacNoConf").setText(String.valueOf(this.iNrSameRoomPlacementsNoConf));
        root.addElement("nrSameTimePlacNoConf").setText(String.valueOf(this.iNrSameTimePlacementsNoConf));
        root.addElement("nrPlacNoConf").setText(String.valueOf(this.iNrPlacementsNoConf));
        root.addElement("btbInstrPref").setText(String.valueOf(this.iBtbInstructorPreference));
        root.addElement("isInitial").setText(String.valueOf(this.iIsInitial));
        if (this.iInitialAssignment != null) {
            root.addElement("iniAssign").setText(this.iInitialAssignment);
        }
        root.addElement("hasIniSameTime").setText(String.valueOf(this.iHasInitialSameTime));
        root.addElement("hasIniSameRoom").setText(String.valueOf(this.iHasInitialSameRoom));
        root.addElement("pertPenalty").setText(String.valueOf(this.iPerturbationPenalty));
        root.addElement("tooBig").setText(String.valueOf(this.iTooBigRoomPreference));
        root.addElement("minSize").setText(String.valueOf(this.iMinRoomSize));
        root.addElement("uselessHalfHours").setText(String.valueOf(this.iUselessHalfHours));
        root.addElement("deptBalanc").setText(String.valueOf(this.iDeptBalancPenalty));
        root.addElement("maxDeptBalanc").setText(String.valueOf(this.iMaxDeptBalancPenalty));
        root.addElement("groupConstr").setText(String.valueOf(this.iGroupConstraintPref));
        root.addElement("spread").setText(String.valueOf(this.iSpreadPenalty));
        root.addElement("maxSpread").setText(String.valueOf(this.iMaxSpreadPenalty));
        root.addElement("datePref").setText(String.valueOf(this.iDatePatternPref));
        if (this.iStudentGroupPercent != null) {
            root.addElement("studentGroupPercent").setText(String.valueOf(this.iStudentGroupPercent));
        }
        if (this.iStudentGroupComment != null) {
            root.addElement("studentGroupComment").setText(this.iStudentGroupComment);
        }
    }

    @Override
    public boolean saveToFile() {
        return false;
    }

    public String toString() {
        return "AssignmentPreferneceInfo{\n  normTimePref=" + this.iNormalizedTimePreference + "\n  bestNormTimePref = " + this.iBestNormalizedTimePreference + "\n  timePref = " + this.iTimePreference + "\n  roomPreference = " + this.iRoomPreference + "\n  bestRoomPref = " + this.iBestRoomPreference + "\n  nrStudentConf = " + this.iNrStudentConflicts + "\n  nrHardStudentConf = " + this.iNrHardStudentConflicts + "\n  nrCommitedStudentConf = " + this.iNrCommitedStudentConflicts + "\n  nrDistanceStudentConf = " + this.iNrDistanceStudentConflicts + "\n  nrTimeLoc = " + this.iNrTimeLocations + "\n  nrRoomLoc = " + this.iNrRoomLocations + "\n  nrSameRoomPlacNoConf = " + this.iNrSameRoomPlacementsNoConf + "\n  nrSameTimePlacNoConf = " + this.iNrSameTimePlacementsNoConf + "\n  nrPlacNoConf = " + this.iNrPlacementsNoConf + "\n  btbInstrPref = " + this.iBtbInstructorPreference + "\n  isInitial = " + this.iIsInitial + "\n  iniAssign = " + this.iInitialAssignment + "\n  hasIniSameTime = " + this.iHasInitialSameTime + "\n  hasIniSameRoom = " + this.iHasInitialSameRoom + "\n  pertPenalty = " + this.iPerturbationPenalty + "\n  tooBig = " + this.iTooBigRoomPreference + "\n  minSize = " + this.iMinRoomSize + "\n  uselessHalfHours = " + this.iUselessHalfHours + "\n  deptBalanc = " + this.iDeptBalancPenalty + "\n  maxDeptBalanc = " + this.iMaxDeptBalancPenalty + "\n  groupConstr = " + this.iGroupConstraintPref + "\n  spread = " + this.iSpreadPenalty + "\n  maxSpread = " + this.iMaxSpreadPenalty + "\n  datePatterPref = " + this.iDatePatternPref + "\n  studentGroupPercent = " + this.iStudentGroupPercent + "\n  studentGroupComment = " + this.iStudentGroupComment + "\n}";
    }
}

