/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.criteria.StudentOverlapConflict;
import org.cpsolver.coursett.criteria.placement.DeltaTimePreference;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SelectedAssignmentBackend;
import org.unitime.timetable.server.solver.SuggestionsContext;
import org.unitime.timetable.server.solver.SuggestionsFilterBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=SuggestionsInterface.ComputeSuggestionsRequest.class)
public class ComputeSuggestionsBackend
implements GwtRpcImplementation<SuggestionsInterface.ComputeSuggestionsRequest, SuggestionsInterface.Suggestions> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static CPSolverMessages MSG = Localization.create(CPSolverMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public SuggestionsInterface.Suggestions execute(SuggestionsInterface.ComputeSuggestionsRequest request, SessionContext context) {
        SolverProxy solver;
        context.checkPermission(Right.Suggestions);
        SuggestionsContext cx = new SuggestionsContext();
        String instructorFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (instructorFormat != null) {
            cx.setInstructorNameFormat(instructorFormat);
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) == null) {
            throw new GwtRpcException(MESSAGES.warnSolverNotLoaded());
        }
        if (solver.isWorking()) {
            throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
        }
        SuggestionsInterface.Suggestions response = solver.computeSuggestions(cx, request);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public static SuggestionsInterface.Suggestions computeSuggestions(SuggestionsContext context, TimetableSolver solver, SuggestionsInterface.ComputeSuggestionsRequest request) {
        Lecture lect;
        SuggestionsInterface.Suggestions suggestions = new SuggestionsInterface.Suggestions(request);
        Solution solution = solver.currentSolution();
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        context.setBaseStudentConflicts(solution);
        ArrayList unAssignedVariables = new ArrayList();
        HashMap<Lecture, Placement> initialAssignments = new HashMap<Lecture, Placement>();
        for (Lecture lec : assignment.assignedVariables()) {
            initialAssignments.put(lec, (Placement)assignment.getValue((Variable)lec));
        }
        HashMap<Lecture, Placement> conflictsToResolve = new HashMap<Lecture, Placement>();
        ArrayList<Long> resolvedLectures = new ArrayList<Long>();
        ArrayList<Placement> hints = new ArrayList<Placement>();
        HashMap<Long, String> descriptions = new HashMap<Long, String>();
        boolean canAssign = true;
        if (request.hasAssignments()) {
            for (SuggestionsInterface.SelectedAssignment selectedAssignment : request.getAssignments()) {
                Placement placement = SelectedAssignmentBackend.getPlacement(model, selectedAssignment, false);
                if (placement == null || ((Lecture)placement.variable()).getClassId().equals(request.getClassId()) && (request.isPlacements() || placement.equals((Object)assignment.getValue(placement.variable())))) continue;
                if (!placement.isValid()) {
                    String reason = TimetableSolver.getNotValidReason(placement, (Assignment<Lecture, Placement>)assignment, solver.getProperties().getPropertyBoolean("General.UseAmPm", true));
                    throw new GwtRpcException(reason == null ? MSG.reasonNotKnown() : reason);
                }
                lect = (Lecture)placement.variable();
                hints.add(placement);
                SelectedAssignmentBackend.fillDescriptions((Assignment<Lecture, Placement>)assignment, placement, descriptions);
                Set conflicts = model.conflictValues(assignment, (Value)placement);
                for (Placement conflictPlacement : conflicts) {
                    conflictsToResolve.put((Lecture)conflictPlacement.variable(), conflictPlacement);
                    assignment.unassign(0L, conflictPlacement.variable());
                }
                if (!conflicts.contains(placement)) {
                    resolvedLectures.add(lect.getClassId());
                    conflictsToResolve.remove(lect);
                    assignment.assign(0L, (Value)placement);
                    continue;
                }
                canAssign = false;
            }
        }
        Lecture lecture = null;
        for (Lecture lecture2 : model.variables()) {
            if (!lecture2.getClassId().equals(request.getClassId())) continue;
            lecture = lecture2;
        }
        if (lecture == null) {
            for (Lecture lecture3 : model.constantVariables()) {
                if (!lecture3.getClassId().equals(request.getClassId())) continue;
                lecture = lecture3;
            }
        }
        if (canAssign) {
            if (request.isPlacements()) {
                resolvedLectures.remove(request.getClassId());
                ComputeSuggestionsBackend.placements(context, solver, suggestions, new Query(request.getFilter()), System.currentTimeMillis(), lecture, resolvedLectures, conflictsToResolve, initialAssignments);
            } else {
                void var15_21;
                Object var15_19 = null;
                if (!resolvedLectures.contains(request.getClassId())) {
                    ArrayList<Lecture> arrayList = new ArrayList<Lecture>(1);
                    arrayList.add(lecture);
                }
                ComputeSuggestionsBackend.backtrack(context, solver, suggestions, new Query(request.getFilter()), System.currentTimeMillis(), (List<Lecture>)var15_21, resolvedLectures, conflictsToResolve, initialAssignments, request.getDepth());
            }
        }
        for (Placement placement : hints) {
            lect = (Lecture)placement.variable();
            if (assignment.getValue((Variable)lect) == null) continue;
            assignment.unassign(0L, (Variable)lect);
        }
        for (Lecture lecture4 : unAssignedVariables) {
            if (assignment.getValue((Variable)lecture4) == null) continue;
            assignment.unassign(0L, (Variable)lecture4);
        }
        for (Placement placement : initialAssignments.values()) {
            if (placement.equals((Object)assignment.getValue((Variable)(lect = (Lecture)placement.variable())))) continue;
            assignment.assign(0L, (Value)placement);
        }
        Map<String, String> map = context.courseObjectives();
        for (Criterion c : model.getCriteria()) {
            if (c instanceof StudentOverlapConflict || c instanceof DeltaTimePreference) continue;
            String name = c.getName();
            String translatedName = map == null || map.isEmpty() ? null : map.get(c.getName());
            double value = c.getValue(assignment);
            for (SuggestionsInterface.Suggestion suggestion : suggestions.getSuggestions()) {
                if (translatedName != null) {
                    suggestion.setBaseCriterion(translatedName, value);
                    continue;
                }
                suggestion.setBaseCriterion(name, value);
            }
        }
        double d = model.getTotalValue(assignment);
        int unassigned = model.nrUnassignedVariables(assignment);
        for (SuggestionsInterface.Suggestion suggestion : suggestions.getSuggestions()) {
            suggestion.setBaseValue(d);
            suggestion.setBaseUnassignedVariables(unassigned);
        }
        return suggestions;
    }

    protected static boolean isBetter(SuggestionsInterface.Suggestion suggestion, TimetableSolver solver) {
        return suggestion.getValue() < solver.currentSolution().getModel().getTotalValue(solver.currentSolution().getAssignment());
    }

    private static void backtrack(SuggestionsContext context, TimetableSolver solver, SuggestionsInterface.Suggestions suggestions, Query query, long startTime, List<Lecture> initialLectures, List<Long> resolvedLectures, Map<Lecture, Placement> conflictsToResolve, Map<Lecture, Placement> initialAssignments, int depth) {
        suggestions.setNrCombinationsConsidered(1 + suggestions.getNrCombinationsConsidered());
        int nrUnassigned = conflictsToResolve.size();
        if ((initialLectures == null || initialLectures.isEmpty()) && nrUnassigned == 0) {
            if (suggestions.size() == suggestions.getLimit() && ComputeSuggestionsBackend.isBetter(suggestions.last(), solver)) {
                return;
            }
            suggestions.addSuggestion(SelectedAssignmentBackend.createSuggestion(context, solver, initialAssignments, resolvedLectures, conflictsToResolve.values()));
            return;
        }
        if (depth <= 0) {
            return;
        }
        if (suggestions.getTimeLimit() > 0 && System.currentTimeMillis() - startTime > (long)suggestions.getTimeLimit()) {
            suggestions.setTimeoutReached(true);
            return;
        }
        if (suggestions.size() == suggestions.getLimit() && suggestions.last().getValue() < ComputeSuggestionsBackend.getBound(query, suggestions, solver, conflictsToResolve)) {
            return;
        }
        Assignment assignment = solver.currentSolution().getAssignment();
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        for (Lecture lecture : new ArrayList<Lecture>(initialLectures != null && !initialAssignments.isEmpty() ? initialLectures : conflictsToResolve.keySet())) {
            if (suggestions.isTimeoutReached()) break;
            if (resolvedLectures.contains(lecture.getClassId())) continue;
            resolvedLectures.add(lecture.getClassId());
            for (PlacementValue placementValue : ComputeSuggestionsBackend.values(query, suggestions, solver, lecture)) {
                Placement c;
                Iterator i;
                Set conflicts;
                Placement ini;
                Placement current;
                if (suggestions.isTimeoutReached()) break;
                Placement placement = placementValue.getPlacement();
                if (placement.equals((Object)(current = (Placement)assignment.getValue((Variable)lecture))) || !suggestions.isAllowBreakHard() && placement.isHard(assignment) || suggestions.isSameTime() && current != null && !placement.getTimeLocation().equals((Object)current.getTimeLocation()) || suggestions.isSameRoom() && current != null && !placement.sameRooms(current) || suggestions.isSameTime() && current == null && (ini = initialAssignments.get(lecture)) != null && !placement.sameTime(ini) || suggestions.isSameRoom() && current == null && (ini = initialAssignments.get(lecture)) != null && !placement.sameRooms(ini) || (conflicts = model.conflictValues(assignment, (Value)placement)) != null && nrUnassigned + conflicts.size() > depth || ComputeSuggestionsBackend.containsCommited(model, conflicts) || conflicts.contains(placement)) continue;
                boolean containException = false;
                if (conflicts != null) {
                    i = conflicts.iterator();
                    while (!containException && i.hasNext()) {
                        c = (Placement)i.next();
                        if (!resolvedLectures.contains(((Lecture)c.variable()).getClassId())) continue;
                        containException = true;
                    }
                }
                if (containException) continue;
                if (conflicts != null) {
                    i = conflicts.iterator();
                    while (!containException && i.hasNext()) {
                        c = (Placement)i.next();
                        assignment.unassign(0L, c.variable());
                    }
                }
                assignment.assign(0L, (Value)placement);
                i = conflicts.iterator();
                while (!containException && i.hasNext()) {
                    c = (Placement)i.next();
                    conflictsToResolve.put((Lecture)c.variable(), c);
                }
                Placement resolvedConf = conflictsToResolve.remove(lecture);
                ComputeSuggestionsBackend.backtrack(context, solver, suggestions, query, startTime, null, resolvedLectures, conflictsToResolve, initialAssignments, depth - 1);
                if (current == null) {
                    assignment.unassign(0L, (Variable)lecture);
                } else {
                    assignment.assign(0L, (Value)current);
                }
                if (conflicts != null) {
                    for (Placement p : conflicts) {
                        assignment.assign(0L, (Value)p);
                        conflictsToResolve.remove(p.variable());
                    }
                }
                if (resolvedConf == null) continue;
                conflictsToResolve.put(lecture, resolvedConf);
            }
            resolvedLectures.remove(lecture.getClassId());
        }
    }

    private static void placements(SuggestionsContext context, TimetableSolver solver, SuggestionsInterface.Suggestions suggestions, Query query, long startTime, Lecture lecture, List<Long> resolvedLectures, Map<Lecture, Placement> conflictsToResolve, Map<Lecture, Placement> initialAssignments) {
        int nrUnassigned = conflictsToResolve.size();
        if (conflictsToResolve.containsKey(lecture)) {
            --nrUnassigned;
        }
        Assignment assignment = solver.currentSolution().getAssignment();
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        for (PlacementValue placementValue : ComputeSuggestionsBackend.values(query, suggestions, solver, lecture)) {
            Placement c;
            Iterator i;
            Set conflicts;
            Placement ini;
            Placement current;
            if (suggestions.isTimeoutReached()) break;
            suggestions.setNrCombinationsConsidered(1 + suggestions.getNrCombinationsConsidered());
            Placement placement = placementValue.getPlacement();
            if (placement.equals((Object)(current = initialAssignments.get(lecture))) || !suggestions.isAllowBreakHard() && placement.isHard(assignment) || suggestions.isSameTime() && current != null && !placement.getTimeLocation().equals((Object)current.getTimeLocation()) || suggestions.isSameRoom() && current != null && !placement.sameRooms(current) || suggestions.isSameTime() && current == null && (ini = initialAssignments.get(lecture)) != null && !placement.sameTime(ini) || suggestions.isSameRoom() && current == null && (ini = initialAssignments.get(lecture)) != null && !placement.sameRooms(ini) || (conflicts = model.conflictValues(assignment, (Value)placement)) != null && nrUnassigned + conflicts.size() > suggestions.getDepth() || ComputeSuggestionsBackend.containsCommited(model, conflicts) || conflicts.contains(placement)) continue;
            boolean containException = false;
            if (conflicts != null) {
                i = conflicts.iterator();
                while (!containException && i.hasNext()) {
                    c = (Placement)i.next();
                    if (!resolvedLectures.contains(((Lecture)c.variable()).getClassId())) continue;
                    containException = true;
                }
            }
            if (containException) continue;
            if (conflicts != null) {
                i = conflicts.iterator();
                while (!containException && i.hasNext()) {
                    c = (Placement)i.next();
                    assignment.unassign(0L, c.variable());
                }
            }
            assignment.assign(0L, (Value)placement);
            i = conflicts.iterator();
            while (!containException && i.hasNext()) {
                c = (Placement)i.next();
                conflictsToResolve.put((Lecture)c.variable(), c);
            }
            Placement resolvedConf = conflictsToResolve.remove(lecture);
            if (suggestions.size() < suggestions.getLimit() || !ComputeSuggestionsBackend.isBetter(suggestions.last(), solver)) {
                SuggestionsInterface.Suggestion suggestion = SelectedAssignmentBackend.createSuggestion(context, solver, initialAssignments, resolvedLectures, conflictsToResolve.values());
                if (!suggestion.hasDifferentAssignments()) {
                    suggestion.addDifferentAssignment(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, lecture, current, placement));
                }
                suggestions.addSuggestion(suggestion);
            }
            if (suggestions.getTimeLimit() > 0 && System.currentTimeMillis() - startTime > (long)suggestions.getTimeLimit()) {
                suggestions.setTimeoutReached(true);
            }
            if (current == null) {
                assignment.unassign(0L, (Variable)lecture);
            } else {
                assignment.assign(0L, (Value)current);
            }
            if (conflicts != null) {
                for (Placement p : conflicts) {
                    assignment.assign(0L, (Value)p);
                    conflictsToResolve.remove(p.variable());
                }
            }
            if (resolvedConf == null) continue;
            conflictsToResolve.put(lecture, resolvedConf);
        }
    }

    protected static double getBound(Query query, SuggestionsInterface.Suggestions suggestions, TimetableSolver solver, Map<Lecture, Placement> conflictsToResolve) {
        double value = solver.currentSolution().getModel().getTotalValue(solver.currentSolution().getAssignment());
        for (Lecture lect : conflictsToResolve.keySet()) {
            TreeSet<PlacementValue> values = ComputeSuggestionsBackend.values(query, suggestions, solver, lect);
            if (values.isEmpty()) continue;
            PlacementValue val = values.first();
            value += val.getValue();
        }
        return value;
    }

    protected static boolean match(Query query, SuggestionsInterface.Suggestions suggestions, Placement placement) {
        if (query != null) {
            return query.match(new PlacementMatcher(placement));
        }
        return true;
    }

    protected static TreeSet<PlacementValue> values(Query query, SuggestionsInterface.Suggestions suggestions, TimetableSolver solver, Lecture lecture) {
        TreeSet<PlacementValue> vals = new TreeSet<PlacementValue>();
        Assignment assignment = solver.currentSolution().getAssignment();
        if (lecture.getClassId().equals(suggestions.getClassId())) {
            for (Placement p : lecture.allowBreakHard() || !suggestions.isAllowBreakHard() ? lecture.values(assignment) : lecture.computeValues(assignment, true)) {
                if (!ComputeSuggestionsBackend.match(query, suggestions, p)) continue;
                vals.add(new PlacementValue((Assignment<Lecture, Placement>)assignment, p));
            }
        } else if (lecture.allowBreakHard() || !suggestions.isAllowBreakHard()) {
            for (Placement x : lecture.values(assignment)) {
                vals.add(new PlacementValue((Assignment<Lecture, Placement>)assignment, x));
            }
        } else {
            for (Placement x : lecture.computeValues(assignment, true)) {
                vals.add(new PlacementValue((Assignment<Lecture, Placement>)assignment, x));
            }
        }
        return vals;
    }

    protected static boolean containsCommited(TimetableModel model, Collection values) {
        if (model.hasConstantVariables()) {
            for (Placement placement : values) {
                Lecture lecture = (Lecture)placement.variable();
                if (!lecture.isCommitted()) continue;
                return true;
            }
        }
        return false;
    }

    public static class PlacementValue
    implements Comparable<PlacementValue> {
        private Placement iPlacement;
        private double iValue;

        public PlacementValue(Assignment<Lecture, Placement> assignment, Placement placement) {
            this.iPlacement = placement;
            this.iValue = placement.toDouble(assignment);
        }

        public Placement getPlacement() {
            return this.iPlacement;
        }

        public double getValue() {
            return this.iValue;
        }

        @Override
        public int compareTo(PlacementValue p) {
            int cmp = Double.compare(this.getValue(), p.getValue());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.getPlacement().getId(), p.getPlacement().getId());
        }
    }

    public static class PlacementMatcher
    implements Query.TermMatcher {
        private Placement iPlacement = null;

        public PlacementMatcher(Placement placement) {
            this.iPlacement = placement;
        }

        @Override
        public boolean match(String attr, String term) {
            if ("time".equals(attr)) {
                return term.equalsIgnoreCase(SuggestionsFilterBackend.getDaysName(this.iPlacement.getTimeLocation().getDayCode()) + " " + this.iPlacement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
            }
            if ("date".equals(attr)) {
                return term.equalsIgnoreCase(this.iPlacement.getTimeLocation().getDatePatternName());
            }
            if ("room".equals(attr)) {
                if (this.iPlacement.getNrRooms() == 0) {
                    return false;
                }
                if (this.iPlacement.getNrRooms() == 1) {
                    return term.equalsIgnoreCase(this.iPlacement.getRoomLocation().getName());
                }
                for (RoomLocation r : this.iPlacement.getRoomLocations()) {
                    if (!term.equalsIgnoreCase(r.getName())) continue;
                    return true;
                }
                return false;
            }
            if ("day".equals(attr)) {
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if (!term.equalsIgnoreCase(Constants.DAY_NAMES_FULL[i]) && !term.equalsIgnoreCase(Constants.DAY_NAME[i]) && !term.equalsIgnoreCase(Constants.DAY_NAMES_SHORT[i])) continue;
                    return (this.iPlacement.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) != 0;
                }
                return false;
            }
            if ("after".equals(attr)) {
                Integer after = TimeSelector.TimeUtils.parseTime2(CONSTANTS, term, null);
                return after != null && after <= this.iPlacement.getTimeLocation().getStartSlot();
            }
            if ("before".equals(attr)) {
                Integer before = TimeSelector.TimeUtils.parseTime2(CONSTANTS, term, null);
                return before != null && before >= this.iPlacement.getTimeLocation().getStartSlot() + this.iPlacement.getTimeLocation().getLength();
            }
            if ("size".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Size prefix = Size.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Size.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Size.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Size.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Size.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Size.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.iPlacement.getNrRooms() == 0) {
                    return false;
                }
                if (this.iPlacement.getNrRooms() == 1) {
                    return min <= this.iPlacement.getRoomLocation().getRoomSize() && this.iPlacement.getRoomLocation().getRoomSize() <= max;
                }
                for (RoomLocation r : this.iPlacement.getRoomLocations()) {
                    if (min > r.getRoomSize() || r.getRoomSize() > max) continue;
                    return true;
                }
                return false;
            }
            if ("flag".equals(attr) || "depth".equals(attr) || "timeout".equals(attr) || "results".equals(attr) || "mode".equals(attr)) {
                return true;
            }
            if (attr == null || attr.isEmpty()) {
                return this.iPlacement.getName(CONSTANTS.useAmPm()).toUpperCase().indexOf(term) >= 0;
            }
            return this.iPlacement.getName(CONSTANTS.useAmPm()).toUpperCase().indexOf(attr + ":" + term) >= 0;
        }
    }

    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }
}

