/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.AttachmentTypeDAO;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.EventServiceProviderDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.NonUniversityLocationPictureDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.RoomPictureDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.server.rooms.RoomSharingBackend;
import org.unitime.timetable.util.LocationPermIdGenerator;

@GwtRpcImplements(value=RoomInterface.RoomUpdateRpcRequest.class)
public class RoomUpdateBackend
implements GwtRpcImplementation<RoomInterface.RoomUpdateRpcRequest, RoomInterface.RoomDetailInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(RoomUpdateBackend.class);

    @Override
    public RoomInterface.RoomDetailInterface execute(RoomInterface.RoomUpdateRpcRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        Location location = null;
        RoomInterface.RoomException exception = null;
        try {
            switch (request.getOperation()) {
                case DELETE: {
                    List<Location> futureLocations = request.hasFutureFlags() ? Location.getFutureLocations(request.getLocationId()) : null;
                    this.delete(request.getLocationId(), context, false);
                    if (futureLocations == null) break;
                    for (Location location2 : futureLocations) {
                        if (request.getFutureFlag(location2.getUniqueId()) == null) continue;
                        this.delete(location2.getUniqueId(), new EventAction.EventContext(context, context.getUser(), location2.getSession().getUniqueId()), true);
                    }
                    break;
                }
                case UPDATE: {
                    List<Location> futureLocations = request.hasFutureFlags() ? Location.getFutureLocations(request.getRoom().getUniqueId()) : null;
                    List<ExamType> examTypes = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
                    location = this.update(request.getRoom(), context, false, request.getFutureFlag(0L, RoomInterface.FutureOperation.getFlagAllEnabled()), examTypes);
                    if (futureLocations == null) break;
                    for (Location location3 : futureLocations) {
                        Integer flags = request.getFutureFlag(location3.getUniqueId());
                        if (flags == null) continue;
                        request.getRoom().setUniqueId(location3.getUniqueId());
                        this.update(request.getRoom(), new EventAction.EventContext(context, context.getUser(), location3.getSession().getUniqueId()), true, flags, examTypes);
                    }
                    break;
                }
                case CREATE: {
                    location = this.create(request.getRoom(), context, null, null, request.getFutureFlag(0L, RoomInterface.FutureOperation.getFlagAllEnabled()));
                    if (location == null || !request.hasFutureFlags()) break;
                    List list = LocationDAO.getInstance().getSession().createQuery("select f.uniqueId from Session f, Session s where s.uniqueId = :sessionId and s.sessionBeginDateTime < f.sessionBeginDateTime and s.academicInitiative = f.academicInitiative order by f.sessionBeginDateTime").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).list();
                    for (Long id : list) {
                        Integer flags = request.getFutureFlag(-id.longValue());
                        if (flags == null) continue;
                        this.create(request.getRoom(), new EventAction.EventContext(context, context.getUser(), id), id, location.getPermanentId(), flags);
                    }
                    break;
                }
            }
        }
        catch (RoomInterface.RoomException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            exception = e;
        }
        if (location != null) {
            List<ExamType> types = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
            RoomInterface.RoomDetailInterface detail = new RoomDetailsBackend().load(location, null, true, context, !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent), types, context.hasPermission(Right.InstructionalOfferings) || context.hasPermission(Right.Classes), context.hasPermission(Right.Examinations), context.hasPermission(Right.Events) || context.hasPermission(location, Right.RoomEditChangeEventProperties), true);
            RoomSharingBackend roomSharingBackend = new RoomSharingBackend();
            if (detail.isCanSeeEventAvailability()) {
                detail.setEventAvailabilityModel(roomSharingBackend.loadEventAvailability(location, context));
            }
            if (detail.isCanSeeAvailability()) {
                detail.setRoomSharingModel(roomSharingBackend.loadRoomSharing(location, true, context));
            }
            if (detail.isCanSeePeriodPreferences()) {
                PeriodPreferencesBackend periodPreferencesBackend = new PeriodPreferencesBackend();
                for (ExamType type : types) {
                    detail.setPeriodPreferenceModel(periodPreferencesBackend.loadPeriodPreferences(location, type, context));
                }
            }
            context.setAttribute(SessionAttribute.RoomPictures, null);
            if (exception != null) {
                throw exception.withRoom(detail);
            }
            return detail;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    protected Long delete(Long locationId, SessionContext context, boolean future) {
        if (locationId == null) {
            return null;
        }
        Transaction tx = null;
        Long permId = null;
        String roomName = null;
        String sessionLabel = null;
        org.hibernate.Session hibSession = LocationDAO.getInstance().getSession();
        try {
            Event event;
            tx = hibSession.beginTransaction();
            Location location = (Location)LocationDAO.getInstance().get(locationId, hibSession);
            if (location == null) {
                Long l = null;
                return l;
            }
            roomName = location.getLabel();
            sessionLabel = location.getSession().getLabel();
            if (future) {
                if (location instanceof Room) {
                    if (!context.hasPermission((Room)location, Right.RoomDelete)) {
                        Long l = null;
                        return l;
                    }
                } else if (!context.hasPermission((NonUniversityLocation)location, Right.NonUniversityLocationDelete)) {
                    Long l = null;
                    return l;
                }
            } else if (location instanceof Room) {
                context.checkPermission((Room)location, Right.RoomDelete);
            } else {
                context.checkPermission((NonUniversityLocation)location, Right.NonUniversityLocationDelete);
            }
            permId = location.getPermanentId();
            ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.DELETE, null, location.getControllingDepartment());
            HashMap<Event, ArrayList<Meeting>> deletedMeetings = new HashMap<Event, ArrayList<Meeting>>();
            for (Meeting l : hibSession.createQuery("select m from Meeting m, Location l where l.uniqueId = :locId and m.locationPermanentId = l.permanentId and m.meetingDate >= l.session.eventBeginDate and m.meetingDate <= l.session.eventEndDate").setLong("locId", location.getUniqueId().longValue()).list()) {
                event = l.getEvent();
                event.getMeetings().remove(l);
                ArrayList<Meeting> deleted = (ArrayList<Meeting>)deletedMeetings.get(event);
                if (deleted == null) {
                    deleted = new ArrayList<Meeting>();
                    deletedMeetings.put(event, deleted);
                }
                deleted.add(l);
            }
            for (Map.Entry entry : deletedMeetings.entrySet()) {
                event = (Event)entry.getKey();
                List meetings = (List)entry.getValue();
                if (event.getMeetings().isEmpty()) {
                    hibSession.delete((Object)event);
                    continue;
                }
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(4);
                note.setTimeStamp(new Date());
                note.setUser(context.getUser().getTrueName());
                note.setUserId(context.getUser().getTrueExternalUserId());
                note.setTextNote(MESSAGES.eventNoteRoomDeleted(location.getLabel()));
                note.setMeetingCollection(meetings);
                event.getNotes().add(note);
                hibSession.saveOrUpdate((Object)event);
            }
            List roomPrefs = hibSession.createCriteria(RoomPref.class).add((Criterion)Restrictions.eq((String)"room.uniqueId", (Object)location.getUniqueId())).list();
            for (RoomDept rd : location.getRoomDepts()) {
                Department d = rd.getDepartment();
                d.getRoomDepts().remove(rd);
                hibSession.delete((Object)rd);
                hibSession.saveOrUpdate((Object)d);
            }
            for (RoomPref rp : roomPrefs) {
                rp.getOwner().getPreferences().remove(rp);
                hibSession.delete((Object)rp);
                hibSession.saveOrUpdate((Object)rp.getOwner());
            }
            Iterator<Assignment> iterator = location.getAssignments().iterator();
            while (iterator.hasNext()) {
                Assignment a = iterator.next();
                a.getRooms().remove(location);
                hibSession.saveOrUpdate((Object)a);
                iterator.remove();
            }
            hibSession.delete((Object)location);
            tx.commit();
            tx = null;
            Long l = permId;
            return l;
        }
        catch (Throwable t) {
            if (future) {
                throw new RoomInterface.RoomException(MESSAGES.failedDeleteLocation(roomName, sessionLabel, t.getMessage()), t);
            }
            throw new GwtRpcException(t.getMessage(), t);
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Location update(RoomInterface.RoomDetailInterface room, SessionContext context, boolean future, int flags, List<ExamType> examTypes) {
        Transaction tx = null;
        String roomName = null;
        String sessionLabel = null;
        org.hibernate.Session hibSession = LocationDAO.getInstance().getSession();
        try {
            RoomType type;
            tx = hibSession.beginTransaction();
            Location location = (Location)LocationDAO.getInstance().get(room.getUniqueId(), hibSession);
            if (location == null) {
                Location location2 = null;
                return location2;
            }
            sessionLabel = location.getSession().getLabel();
            boolean canEdit = context.hasPermission(location, location instanceof Room ? Right.RoomEdit : Right.NonUniversityLocationEdit);
            if (canEdit && context.hasPermission(location, Right.RoomEditChangeRoomProperties) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                if (location instanceof Room) {
                    Building building = this.lookupBuilding(hibSession, room.getBuilding(), future, location.getSession().getUniqueId());
                    if (future && room.getBuilding() != null && building == null) {
                        throw new RoomInterface.RoomException(MESSAGES.errorBuildingNotExist(room.getBuilding().getAbbreviation()));
                    }
                    Room other = Room.findByBldgIdRoomNbr(building != null ? building.getUniqueId() : ((Room)location).getBuilding().getUniqueId(), room.getName(), location.getSession().getUniqueId());
                    if (other != null && !location.getUniqueId().equals(other.getUniqueId())) {
                        throw new RoomInterface.RoomException(MESSAGES.errorRoomAlreadyExists(roomName));
                    }
                    if (building != null) {
                        ((Room)location).setBuilding(building);
                        ((Room)location).setBuildingAbbv(building.getAbbreviation());
                    }
                    ((Room)location).setRoomNumber(room.getName());
                    if (room.getParent() == null) {
                        if (((Room)location).getParentRoom() != null) {
                            ((Room)location).getParentRoom().getPartitions().remove((Room)location);
                        }
                        ((Room)location).setParentRoom(null);
                    } else {
                        Room parent = (Room)RoomDAO.getInstance().get(room.getParent().getUniqueId());
                        if (parent != null) {
                            if (!future) {
                                if (((Room)location).getParentRoom() != null) {
                                    ((Room)location).getParentRoom().getPartitions().remove((Room)location);
                                }
                                ((Room)location).setParentRoom(parent);
                                parent.getPartitions().add((Room)location);
                            } else {
                                List<Location> futureParents = parent.getFutureLocations();
                                if (futureParents != null) {
                                    for (Location location2 : futureParents) {
                                        if (!location2.getSession().equals(location.getSession())) continue;
                                        if (((Room)location).getParentRoom() != null) {
                                            ((Room)location).getParentRoom().getPartitions().remove((Room)location);
                                        }
                                        ((Room)location).setParentRoom((Room)location2);
                                        ((Room)location2).getPartitions().add((Room)location);
                                    }
                                }
                            }
                        } else {
                            if (((Room)location).getParentRoom() != null) {
                                ((Room)location).getParentRoom().getPartitions().remove((Room)location);
                            }
                            ((Room)location).setParentRoom(null);
                        }
                    }
                } else {
                    if (!room.getName().equals(location.getLabel())) {
                        String nonUniversityLocationRegex = ApplicationProperty.NonUniversityLocationPattern.value();
                        String nonUniversityLocationInfo = ApplicationProperty.NonUniversityLocationPatternInfo.value();
                        if (nonUniversityLocationRegex != null && nonUniversityLocationRegex.trim().length() > 0) {
                            try {
                                Pattern pattern = Pattern.compile(nonUniversityLocationRegex);
                                Iterator<EventInterface.EventServiceProviderInterface> matcher = pattern.matcher(room.getName());
                                if (!((Matcher)((Object)matcher)).find()) {
                                    throw new RoomInterface.RoomException(nonUniversityLocationInfo == null || nonUniversityLocationInfo.isEmpty() ? MESSAGES.errorLocationNameDoesNotMeetRequiredPattern(room.getName(), nonUniversityLocationRegex) : nonUniversityLocationInfo);
                                }
                            }
                            catch (RoomInterface.RoomException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new RoomInterface.RoomException(MESSAGES.errorLocationNameDoesNotMeetRequiredPatternWithReason(room.getName(), nonUniversityLocationRegex, e.getMessage()), e);
                            }
                        }
                    }
                    ((NonUniversityLocation)location).setName(room.getName());
                }
                location.setIgnoreTooFar(room.isIgnoreTooFar());
                location.setIgnoreRoomCheck(room.isIgnoreRoomCheck());
                location.setCoordinateX(room.getX());
                location.setCoordinateY(room.getY());
                location.setArea(room.getArea());
                location.setDisplayName(room.getDisplayName());
            }
            if (canEdit && context.hasPermission(location, Right.RoomEditChangeCapacity) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                location.setCapacity(room.getCapacity());
            }
            if (canEdit && context.hasPermission(location, Right.RoomEditChangeExternalId) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                location.setExternalUniqueId(room.hasExternalId() ? room.getExternalId() : null);
            }
            if (canEdit && context.hasPermission(location, Right.RoomEditChangeType) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags) && (type = this.lookupRoomType(hibSession, room.getRoomType())) != null && (type.isRoom().booleanValue() && location instanceof Room || !type.isRoom().booleanValue() || !(location instanceof NonUniversityLocation))) {
                location.setRoomType(type);
            }
            String oldNote = location.getNote();
            if (context.hasPermission(location, Right.RoomEditChangeEventProperties) && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                Department eventDepartment = this.lookuDepartment(hibSession, room.getEventDepartment(), future, location.getSession().getUniqueId());
                if (!future || room.getEventDepartment() == null || eventDepartment != null) {
                    location.setEventDepartment(eventDepartment);
                }
                location.setBreakTime(room.getBreakTime());
                if (!future) {
                    location.setEventStatus(room.getEventStatus());
                }
                location.setNote(room.getEventNote() == null ? "" : (room.getEventNote().length() > 2048 ? room.getEventNote().substring(0, 2048) : room.getEventNote()));
                HashSet<EventServiceProvider> services = new HashSet<EventServiceProvider>(location.getAllowedServices());
                if (room.hasServices()) {
                    for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : room.getServices()) {
                        EventServiceProvider eventServiceProvider = this.lookupService(hibSession, eventServiceProviderInterface, future, location.getSession().getUniqueId());
                        if (eventServiceProvider == null || services.remove(eventServiceProvider)) continue;
                        location.getAllowedServices().add(eventServiceProvider);
                    }
                }
                for (EventServiceProvider eventServiceProvider : services) {
                    EventServiceProvider eventServiceProvider2;
                    if (future && ((eventServiceProvider2 = eventServiceProvider.findInSession(hibSession, room.getSessionId())) == null || eventServiceProvider2.isAllRooms().booleanValue() || !eventServiceProvider2.isVisible().booleanValue())) continue;
                    location.getAllowedServices().remove(eventServiceProvider);
                }
            }
            if (canEdit && context.hasPermission(location, Right.RoomEditChangeExaminationStatus) && RoomInterface.FutureOperation.EXAM_PROPERTIES.in(flags)) {
                location.setExamCapacity(room.getExamCapacity());
                boolean examTypesChanged = false;
                List<ExamType> types = null;
                if (future) {
                    types = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
                    Iterator<ExamType> i = types.iterator();
                    while (i.hasNext()) {
                        if (examTypes.contains(i.next())) continue;
                        i.remove();
                    }
                } else {
                    types = examTypes;
                }
                for (ExamType examType : types) {
                    if (room.getExamType(examType.getUniqueId(), examType.getReference()) != null == location.getExamTypes().contains(examType)) continue;
                    examTypesChanged = true;
                    break;
                }
                if (examTypesChanged) {
                    ArrayList<ExamType> readOnlyTypes = new ArrayList<ExamType>();
                    for (ExamType examType : location.getExamTypes()) {
                        if (types.contains(examType)) continue;
                        readOnlyTypes.add(examType);
                    }
                    if (!location.getExamTypes().isEmpty()) {
                        location.getExamTypes().clear();
                        hibSession.update((Object)location);
                        hibSession.flush();
                    }
                    for (ExamType examType : types) {
                        if (room.getExamType(examType.getUniqueId(), examType.getReference()) == null) continue;
                        location.getExamTypes().add(examType);
                    }
                    for (ExamType examType : readOnlyTypes) {
                        location.getExamTypes().add(examType);
                    }
                }
            }
            if (context.hasPermission(Right.EditRoomDepartmentsExams) && RoomInterface.FutureOperation.EXAM_PREFS.in(flags)) {
                for (ExamType type4 : location.getExamTypes()) {
                    RoomInterface.PeriodPreferenceModel model = room.getPeriodPreferenceModel(type4.getUniqueId());
                    if (model == null || !examTypes.contains(type4)) continue;
                    location.clearExamPreferences(type4.getUniqueId());
                    for (ExamPeriod examPeriod : hibSession.createQuery("from ExamPeriod ep where ep.session.uniqueId=:sessionId and ep.examType.uniqueId=:typeId").setLong("sessionId", location.getSession().getUniqueId().longValue()).setLong("typeId", type4.getUniqueId().longValue()).setCacheable(true).list()) {
                        RoomInterface.PreferenceInterface pref = model.getPreference(examPeriod.getDateOffset(), examPeriod.getStartSlot());
                        if (pref == null || PreferenceLevel.sNeutral.equals(pref.getCode())) continue;
                        location.addExamPreference(examPeriod, PreferenceLevel.getPreferenceLevel(pref.getCode()));
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditAvailability) && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                if (room.hasRoomSharingModel()) {
                    HashMap<Long, Character> dept2char = new HashMap<Long, Character>();
                    dept2char.put(-1L, Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                    dept2char.put(-2L, Character.valueOf(RoomSharingModel.sNotAvailablePrefChar));
                    Object managerIds = "";
                    char pref = '0';
                    HashSet<Department> hashSet = new HashSet<Department>();
                    HashMap<Long, Department> hashMap = new HashMap<Long, Department>();
                    for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                        if (option.getId() < 0L) continue;
                        Department d2 = this.lookuDepartment(hibSession, option.getId(), future, location.getSession().getUniqueId());
                        if (d2 != null) {
                            hashMap.put(option.getId(), d2);
                            managerIds = managerIds + (((String)managerIds).isEmpty() ? "" : ",") + d2.getUniqueId();
                            char c = pref;
                            pref = (char)(pref + 1);
                            dept2char.put(option.getId(), Character.valueOf(c));
                            hashSet.add(d2);
                            continue;
                        }
                        dept2char.put(option.getId(), Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                    }
                    Object pattern = "";
                    for (int d3 = 0; d3 < 7; ++d3) {
                        for (int s = 0; s < 288; ++s) {
                            RoomInterface.RoomSharingOption option = room.getRoomSharingModel().getOption(d3, s);
                            pattern = (String)pattern + dept2char.get(option.getId());
                        }
                    }
                    location.setManagerIds((String)managerIds);
                    location.setPattern((String)pattern);
                    Iterator<RoomDept> i = location.getRoomDepts().iterator();
                    while (i.hasNext()) {
                        RoomDept rd = i.next();
                        if (hashSet.remove(rd.getDepartment())) continue;
                        rd.getDepartment().getRoomDepts().remove(rd);
                        i.remove();
                        hibSession.delete((Object)rd);
                    }
                    for (Department d4 : hashSet) {
                        RoomDept rd = new RoomDept();
                        rd.setControl(false);
                        rd.setDepartment(d4);
                        rd.getDepartment().getRoomDepts().add(rd);
                        rd.setRoom(location);
                        location.getRoomDepts().add(rd);
                        hibSession.saveOrUpdate((Object)rd);
                    }
                    if (room.getRoomSharingModel().isNoteEditable()) {
                        if (room.getRoomSharingModel().hasNote()) {
                            location.setShareNote(room.getRoomSharingModel().getNote().length() > 2048 ? room.getRoomSharingModel().getNote().substring(0, 2048) : room.getRoomSharingModel().getNote());
                        } else {
                            location.setShareNote(null);
                        }
                    }
                } else if (room.hasDepartments()) {
                    HashMap<Long, RoomDept> rds = new HashMap<Long, RoomDept>();
                    for (RoomDept rd : location.getRoomDepts()) {
                        rds.put(rd.getDepartment().getUniqueId(), rd);
                    }
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        Department department2 = this.lookuDepartment(hibSession, department, future, location.getSession().getUniqueId());
                        if (department2 == null || rds.remove(department2.getUniqueId()) != null) continue;
                        RoomDept roomDept = new RoomDept();
                        roomDept.setControl(false);
                        roomDept.setDepartment(department2);
                        roomDept.getDepartment().getRoomDepts().add(roomDept);
                        roomDept.setRoom(location);
                        location.getRoomDepts().add(roomDept);
                        hibSession.saveOrUpdate((Object)roomDept);
                    }
                    for (RoomDept rd : rds.values()) {
                        rd.getDepartment().getRoomDepts().remove(rd);
                        location.getRoomDepts().remove(rd);
                        hibSession.delete((Object)rd);
                    }
                    location.setShareNote(room.getRoomSharingNote());
                }
            }
            if (context.hasPermission(location, Right.RoomEditPreference) && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                HashMap<Long, Object> dept2pref = null;
                if (room.hasRoomSharingModel()) {
                    dept2pref = new HashMap<Long, Object>();
                    for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                        Department department;
                        if (option.getId() < 0L || !option.isEditable() || !option.hasPreference() || (department = this.lookuDepartment(hibSession, option.getId(), future, location.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(department.getUniqueId(), PreferenceLevelDAO.getInstance().get(option.getPreference()));
                    }
                } else if (room.hasDepartments()) {
                    dept2pref = new HashMap();
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        Department department3;
                        if (department.getPreference() == null || (department3 = this.lookuDepartment(hibSession, department, future, location.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(department3.getUniqueId(), this.lookupPreferenceLevel(hibSession, department.getPreference()));
                    }
                }
                if (dept2pref != null) {
                    for (RoomDept rd : location.getRoomDepts()) {
                        void var17_106;
                        PreferenceLevel preferenceLevel = (PreferenceLevel)dept2pref.get(rd.getDepartment().getUniqueId());
                        Object var17_104 = null;
                        for (RoomPref x : rd.getDepartment().getRoomPreferences()) {
                            if (!x.getRoom().equals(location)) continue;
                            RoomPref roomPref = x;
                            break;
                        }
                        if (var17_106 == null && preferenceLevel != null && !preferenceLevel.getPrefProlog().equals(PreferenceLevel.sNeutral)) {
                            RoomPref roomPref = new RoomPref();
                            roomPref.setRoom(location);
                            roomPref.setPrefLevel(preferenceLevel);
                            roomPref.setOwner(rd.getDepartment());
                            rd.getDepartment().getPreferences().add(roomPref);
                            rd.setPreference(preferenceLevel);
                            hibSession.saveOrUpdate((Object)roomPref);
                            hibSession.saveOrUpdate((Object)rd.getDepartment());
                            continue;
                        }
                        if (var17_106 != null && (preferenceLevel == null || preferenceLevel.getPrefProlog().equals(PreferenceLevel.sNeutral))) {
                            rd.getDepartment().getPreferences().remove(var17_106);
                            rd.setPreference(null);
                            hibSession.delete((Object)var17_106);
                            hibSession.saveOrUpdate((Object)rd.getDepartment());
                            continue;
                        }
                        if (var17_106 == null || var17_106.getPrefLevel().equals(preferenceLevel)) continue;
                        var17_106.setPrefLevel(preferenceLevel);
                        rd.setPreference(preferenceLevel);
                        hibSession.saveOrUpdate((Object)var17_106);
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditFeatures) && RoomInterface.FutureOperation.FEATURES.in(flags)) {
                boolean editGlobalFeatures = context.hasPermission(location, Right.RoomEditGlobalFeatures);
                boolean deptIndependent = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                HashSet<RoomFeature> features = new HashSet<RoomFeature>(location.getFeatures());
                for (RoomInterface.FeatureInterface featureInterface : room.getFeatures()) {
                    RoomFeature feature = this.lookupFeature(hibSession, featureInterface, future, location.getSession().getUniqueId());
                    if (feature == null || features.remove(feature) || feature instanceof GlobalRoomFeature && !editGlobalFeatures || feature instanceof DepartmentRoomFeature && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)feature).getDepartment())) continue;
                    location.getFeatures().add(feature);
                    feature.getRooms().add(location);
                    hibSession.saveOrUpdate((Object)feature);
                }
                for (RoomFeature roomFeature : features) {
                    if (roomFeature instanceof GlobalRoomFeature && !editGlobalFeatures || roomFeature instanceof DepartmentRoomFeature && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)roomFeature).getDepartment())) continue;
                    if (future) {
                        RoomInterface.FeatureInterface f = new RoomInterface.FeatureInterface(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel());
                        if (roomFeature instanceof DepartmentRoomFeature) {
                            f.setDepartment(new RoomInterface.DepartmentInterface());
                        }
                        if (this.lookupFeature(hibSession, f, future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    }
                    location.getFeatures().remove(roomFeature);
                    roomFeature.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)roomFeature);
                }
            }
            if (context.hasPermission(location, Right.RoomEditGroups) && RoomInterface.FutureOperation.GROUPS.in(flags)) {
                boolean editGlobalGroups = context.hasPermission(location, Right.RoomEditGlobalGroups);
                boolean deptIndependent = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                HashSet<RoomGroup> groups = new HashSet<RoomGroup>(location.getRoomGroups());
                for (RoomInterface.GroupInterface groupInterface : room.getGroups()) {
                    RoomGroup group = this.lookupGroup(hibSession, groupInterface, future, location.getSession().getUniqueId());
                    if (group == null || groups.remove(group) || group.isGlobal().booleanValue() && !editGlobalGroups || !group.isGlobal().booleanValue() && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(group.getDepartment())) continue;
                    location.getRoomGroups().add(group);
                    group.getRooms().add(location);
                    hibSession.saveOrUpdate((Object)group);
                }
                for (RoomGroup roomGroup : groups) {
                    if (roomGroup.isGlobal().booleanValue() && !editGlobalGroups || !roomGroup.isGlobal().booleanValue() && !deptIndependent && !context.getUser().getCurrentAuthority().hasQualifier(roomGroup.getDepartment())) continue;
                    if (future) {
                        RoomInterface.GroupInterface g = new RoomInterface.GroupInterface(roomGroup.getUniqueId(), roomGroup.getAbbv(), roomGroup.getName());
                        if (!roomGroup.isGlobal().booleanValue()) {
                            g.setDepartment(new RoomInterface.DepartmentInterface());
                        }
                        if (this.lookupGroup(hibSession, g, future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    }
                    location.getRoomGroups().remove(roomGroup);
                    roomGroup.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)roomGroup);
                }
            }
            if (context.hasPermission(location, Right.RoomEditChangeControll) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                Department d5 = this.lookuDepartment(hibSession, room.getControlDepartment(), future, location.getSession().getUniqueId());
                if (!future || room.getControlDepartment() == null || d5 != null) {
                    for (RoomDept rd : location.getRoomDepts()) {
                        rd.setControl(rd.getDepartment().equals(d5));
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditEventAvailability) && room.hasEventAvailabilityModel() && RoomInterface.FutureOperation.EVENT_AVAILABILITY.in(flags)) {
                String availability = "";
                for (int d6 = 0; d6 < 7; ++d6) {
                    for (int s = 0; s < 288; ++s) {
                        RoomInterface.RoomSharingOption roomSharingOption = room.getEventAvailabilityModel().getOption(d6, s);
                        availability = availability + (roomSharingOption.getId() == -1L ? (char)'0' : '1');
                    }
                }
                location.setEventAvailability(availability);
            }
            hibSession.saveOrUpdate((Object)location);
            for (RoomDept rd : location.getRoomDepts()) {
                hibSession.saveOrUpdate((Object)rd);
            }
            if (context.hasPermission(location, Right.RoomEditChangeEventProperties) && !(oldNote == null ? "" : oldNote).equals(location.getNote() == null ? "" : location.getNote()) && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                ChangeLog.addChange(hibSession, context, location, location.getNote() == null || location.getNote().isEmpty() ? "-" : location.getNote(), ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.NOTE, null, location.getControllingDepartment());
            }
            ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            if (context.hasPermission(location, Right.RoomEditChangePicture) && RoomInterface.FutureOperation.PICTURES.in(flags)) {
                Map temp = (Map)context.getAttribute(SessionAttribute.RoomPictures);
                HashMap<Long, LocationPicture> pictures = new HashMap<Long, LocationPicture>();
                if (future) {
                    HashSet<? extends LocationPicture> otherPictures = new HashSet<LocationPicture>(location.getPictures());
                    block39: for (RoomInterface.RoomPictureInterface roomPictureInterface : room.getPictures()) {
                        LocationPicture original;
                        LocationPicture p2;
                        Iterator i = otherPictures.iterator();
                        while (i.hasNext()) {
                            p2 = (LocationPicture)i.next();
                            if (!this.samePicture(roomPictureInterface, p2)) continue;
                            if (!this.sameType(roomPictureInterface, p2)) {
                                p2.setType(roomPictureInterface.getPictureType() == null ? null : (AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                                hibSession.saveOrUpdate((Object)p2);
                            }
                            i.remove();
                            continue block39;
                        }
                        if (location instanceof Room) {
                            original = (RoomPicture)RoomPictureDAO.getInstance().get(roomPictureInterface.getUniqueId());
                            if (original == null) continue;
                            p2 = ((RoomPicture)original).clonePicture();
                            p2.setLocation(location);
                            ((Room)location).getPictures().add((RoomPicture)p2);
                            hibSession.saveOrUpdate((Object)p2);
                            continue;
                        }
                        original = (NonUniversityLocationPicture)NonUniversityLocationPictureDAO.getInstance().get(roomPictureInterface.getUniqueId());
                        if (original == null) continue;
                        p2 = ((NonUniversityLocationPicture)original).clonePicture();
                        p2.setLocation(location);
                        ((NonUniversityLocation)location).getPictures().add((NonUniversityLocationPicture)p2);
                        hibSession.saveOrUpdate((Object)p2);
                    }
                    for (LocationPicture locationPicture : otherPictures) {
                        location.getPictures().remove(locationPicture);
                        hibSession.delete((Object)locationPicture);
                    }
                } else {
                    for (LocationPicture locationPicture : location.getPictures()) {
                        pictures.put(locationPicture.getUniqueId(), locationPicture);
                    }
                    for (RoomInterface.RoomPictureInterface roomPictureInterface : room.getPictures()) {
                        LocationPicture locationPicture = (LocationPicture)pictures.remove(roomPictureInterface.getUniqueId());
                        if (locationPicture == null && temp != null) {
                            LocationPicture locationPicture2 = (LocationPicture)temp.get(roomPictureInterface.getUniqueId());
                            if (locationPicture2 == null) continue;
                            if (location instanceof Room) {
                                ((RoomPicture)locationPicture2).setLocation((Room)location);
                                ((Room)location).getPictures().add((RoomPicture)locationPicture2);
                            } else {
                                ((NonUniversityLocationPicture)locationPicture2).setLocation((NonUniversityLocation)location);
                                ((NonUniversityLocation)location).getPictures().add((NonUniversityLocationPicture)locationPicture2);
                            }
                            if (roomPictureInterface.getPictureType() != null) {
                                locationPicture2.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                            }
                            hibSession.saveOrUpdate((Object)locationPicture2);
                            roomPictureInterface.setUniqueId(locationPicture2.getUniqueId());
                            continue;
                        }
                        if (locationPicture == null) continue;
                        if (roomPictureInterface.getPictureType() != null) {
                            locationPicture.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                        }
                        hibSession.saveOrUpdate((Object)locationPicture);
                    }
                    for (LocationPicture locationPicture : pictures.values()) {
                        location.getPictures().remove(locationPicture);
                        hibSession.delete((Object)locationPicture);
                    }
                }
            }
            hibSession.flush();
            tx.commit();
            tx = null;
            Location location3 = location;
            return location3;
        }
        catch (Throwable t) {
            if (future) {
                throw new RoomInterface.RoomException(MESSAGES.failedUpdateLocation(roomName, sessionLabel, t.getMessage()), t);
            }
            throw new GwtRpcException(t.getMessage(), t);
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Location create(RoomInterface.RoomDetailInterface room, SessionContext context, Long sessionId, Long permId, int flags) {
        Transaction tx = null;
        String roomName = room.getLabel();
        String sessionLabel = null;
        boolean future = sessionId != null;
        org.hibernate.Session hibSession = LocationDAO.getInstance().getSession();
        try {
            Department dept;
            tx = hibSession.beginTransaction();
            Session session = (Session)SessionDAO.getInstance().get(sessionId == null ? context.getUser().getCurrentAcademicSessionId() : sessionId, hibSession);
            if (session == null) {
                Location location = null;
                return location;
            }
            sessionLabel = session.getLabel();
            if (future) {
                if (room.getRoomType().isRoom()) {
                    if (!context.hasPermission(Right.AddRoom)) {
                        Location location = null;
                        return location;
                    }
                } else if (!context.hasPermission(Right.AddNonUnivLocation)) {
                    Location location = null;
                    return location;
                }
            } else if (room.getRoomType().isRoom()) {
                context.checkPermission(Right.AddRoom);
            } else {
                context.checkPermission(Right.AddNonUnivLocation);
            }
            if (room.getRoomType().isRoom()) {
                // empty if block
            }
            Location location = null;
            if (room.getRoomType().isRoom()) {
                Room room2;
                Room r = new Room();
                Building building = this.lookupBuilding(hibSession, room.getBuilding(), future, session.getUniqueId());
                if (building == null) {
                    throw new RoomInterface.RoomException(MESSAGES.errorBuildingNotExist(room.getBuilding().getAbbreviation()));
                }
                Room other = Room.findByBldgIdRoomNbr(building.getUniqueId(), room.getName(), session.getUniqueId());
                if (other != null) {
                    throw new RoomInterface.RoomException(MESSAGES.errorRoomAlreadyExists(roomName));
                }
                r.setBuilding(building);
                r.setBuildingAbbv(building.getAbbreviation());
                r.setRoomNumber(room.getName());
                r.setPictures(new HashSet<RoomPicture>());
                r.setPartitions(new HashSet<Room>());
                if (room.getParent() != null && (room2 = (Room)RoomDAO.getInstance().get(room.getParent().getUniqueId())) != null) {
                    if (!future) {
                        r.setParentRoom(room2);
                        room2.getPartitions().add(r);
                    } else {
                        List<Location> list = room2.getFutureLocations();
                        if (list != null) {
                            for (Location futureParent : list) {
                                if (!futureParent.getSession().equals(session)) continue;
                                r.setParentRoom((Room)futureParent);
                                ((Room)futureParent).getPartitions().add(r);
                            }
                        }
                    }
                }
                location = r;
            } else {
                String nonUniversityLocationRegex = ApplicationProperty.NonUniversityLocationPattern.value();
                String string = ApplicationProperty.NonUniversityLocationPatternInfo.value();
                if (nonUniversityLocationRegex != null && nonUniversityLocationRegex.trim().length() > 0) {
                    try {
                        Pattern pattern = Pattern.compile(nonUniversityLocationRegex);
                        Matcher matcher = pattern.matcher(room.getName());
                        if (!matcher.find()) {
                            throw new RoomInterface.RoomException(string == null || string.isEmpty() ? MESSAGES.errorLocationNameDoesNotMeetRequiredPattern(room.getName(), nonUniversityLocationRegex) : string);
                        }
                    }
                    catch (RoomInterface.RoomException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RoomInterface.RoomException(MESSAGES.errorLocationNameDoesNotMeetRequiredPatternWithReason(room.getName(), nonUniversityLocationRegex, e.getMessage()), e);
                    }
                }
                NonUniversityLocation r = new NonUniversityLocation();
                r.setPictures(new HashSet<NonUniversityLocationPicture>());
                r.setName(room.getName());
                location = r;
            }
            location.setSession(session);
            location.setIgnoreTooFar(room.isIgnoreTooFar());
            location.setIgnoreRoomCheck(room.isIgnoreRoomCheck());
            location.setCoordinateX(room.getX());
            location.setCoordinateY(room.getY());
            location.setArea(room.getArea());
            location.setDisplayName(room.getDisplayName());
            location.setCapacity(room.getCapacity());
            location.setRoomDepts(new HashSet<RoomDept>());
            location.setExamPreferences(new HashSet<ExamLocationPref>());
            location.setExamTypes(new HashSet<ExamType>());
            location.setRoomDepts(new HashSet<RoomDept>());
            location.setRoomGroups(new HashSet<RoomGroup>());
            location.setFeatures(new HashSet<RoomFeature>());
            location.setRoomType(this.lookupRoomType(hibSession, room.getRoomType()));
            if (permId == null) {
                LocationPermIdGenerator.setPermanentId(location);
            } else {
                location.setPermanentId(permId);
            }
            if (room.hasRoomSharingModel() && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                void var14_26;
                HashMap<Long, Character> dept2char = new HashMap<Long, Character>();
                dept2char.put(-1L, Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                dept2char.put(-2L, Character.valueOf(RoomSharingModel.sNotAvailablePrefChar));
                String string = "";
                char pref = '0';
                HashSet<Department> hashSet = new HashSet<Department>();
                HashMap<Long, Department> hashMap = new HashMap<Long, Department>();
                for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                    if (option.getId() < 0L) continue;
                    Department d2 = this.lookuDepartment(hibSession, option.getId(), future, session.getUniqueId());
                    if (d2 != null) {
                        hashMap.put(option.getId(), d2);
                        String string2 = (String)var14_26 + (var14_26.isEmpty() ? "" : ",") + d2.getUniqueId();
                        char c = pref;
                        pref = (char)(pref + 1);
                        dept2char.put(option.getId(), Character.valueOf(c));
                        hashSet.add(d2);
                        continue;
                    }
                    dept2char.put(option.getId(), Character.valueOf(RoomSharingModel.sFreeForAllPrefChar));
                }
                String pattern = "";
                for (int d3 = 0; d3 < 7; ++d3) {
                    for (int s = 0; s < 288; ++s) {
                        RoomInterface.RoomSharingOption option = room.getRoomSharingModel().getOption(d3, s);
                        pattern = pattern + dept2char.get(option.getId());
                    }
                }
                location.setManagerIds((String)var14_26);
                location.setPattern(pattern);
                Department control = this.lookuDepartment(hibSession, room.getControlDepartment(), future, session.getUniqueId());
                for (Department d4 : hashSet) {
                    RoomDept rd2 = new RoomDept();
                    rd2.setControl(d4.equals(control));
                    rd2.setDepartment(d4);
                    rd2.getDepartment().getRoomDepts().add(rd2);
                    rd2.setRoom(location);
                    location.getRoomDepts().add(rd2);
                }
                if (room.getRoomSharingModel().isNoteEditable()) {
                    if (room.getRoomSharingModel().hasNote()) {
                        location.setShareNote(room.getRoomSharingModel().getNote().length() > 2048 ? room.getRoomSharingModel().getNote().substring(0, 2048) : room.getRoomSharingModel().getNote());
                    } else {
                        location.setShareNote(null);
                    }
                }
            } else if (room.hasDepartments()) {
                Department control = room.getControlDepartment() == null ? null : this.lookuDepartment(hibSession, room.getControlDepartment(), future, session.getUniqueId());
                for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                    Department department2 = this.lookuDepartment(hibSession, department, future, location.getSession().getUniqueId());
                    if (department2 == null) continue;
                    RoomDept roomDept = new RoomDept();
                    roomDept.setControl(department2.equals(control));
                    roomDept.setDepartment(department2);
                    roomDept.getDepartment().getRoomDepts().add(roomDept);
                    roomDept.setRoom(location);
                    location.getRoomDepts().add(roomDept);
                }
                location.setShareNote(room.getRoomSharingNote());
            } else if (room.getControlDepartment() != null && (dept = this.lookuDepartment(hibSession, room.getControlDepartment(), future, session.getUniqueId())) != null) {
                RoomDept roomDept = new RoomDept();
                roomDept.setControl(true);
                roomDept.setDepartment(dept);
                roomDept.getDepartment().getRoomDepts().add(roomDept);
                roomDept.setRoom(location);
                location.getRoomDepts().add(roomDept);
            }
            hibSession.save((Object)location);
            if (context.hasPermission(location, Right.RoomEditChangeExternalId) && RoomInterface.FutureOperation.ROOM_PROPERTIES.in(flags)) {
                location.setExternalUniqueId(room.hasExternalId() ? room.getExternalId() : null);
            }
            if (context.hasPermission(location, Right.RoomEditChangeEventProperties) && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                Department eventDepartment = this.lookuDepartment(hibSession, room.getEventDepartment(), future, session.getUniqueId());
                if (!future || room.getEventDepartment() == null || eventDepartment != null) {
                    location.setEventDepartment(eventDepartment);
                }
                location.setBreakTime(room.getBreakTime());
                if (!future) {
                    location.setEventStatus(room.getEventStatus());
                }
                location.setNote(room.getEventNote() == null ? "" : (room.getEventNote().length() > 2048 ? room.getEventNote().substring(0, 2048) : room.getEventNote()));
                location.setAllowedServices(new HashSet<EventServiceProvider>());
                if (room.hasServices()) {
                    for (EventInterface.EventServiceProviderInterface service : room.getServices()) {
                        EventServiceProvider eventServiceProvider = this.lookupService(hibSession, service, future, location.getSession().getUniqueId());
                        if (eventServiceProvider == null) continue;
                        location.getAllowedServices().add(eventServiceProvider);
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditChangeExaminationStatus) && RoomInterface.FutureOperation.EXAM_PROPERTIES.in(flags)) {
                location.setExamCapacity(room.getExamCapacity());
                List<ExamType> types = ExamType.findAll(hibSession);
                Iterator<ExamType> iterator = types.iterator();
                while (iterator.hasNext()) {
                    ExamType type = iterator.next();
                    if (room.getExamType(type.getUniqueId(), type.getReference()) == null) continue;
                    location.getExamTypes().add(type);
                }
            }
            if (context.hasPermission(Right.EditRoomDepartmentsExams) && RoomInterface.FutureOperation.EXAM_PREFS.in(flags)) {
                for (ExamType examType : location.getExamTypes()) {
                    RoomInterface.PeriodPreferenceModel model = room.getPeriodPreferenceModel(examType.getUniqueId());
                    if (model == null) continue;
                    location.clearExamPreferences(examType.getUniqueId());
                    for (ExamPeriod examPeriod : hibSession.createQuery("from ExamPeriod ep where ep.session.uniqueId=:sessionId and ep.examType.uniqueId=:typeId").setLong("sessionId", session.getUniqueId().longValue()).setLong("typeId", examType.getUniqueId().longValue()).setCacheable(true).list()) {
                        RoomInterface.PreferenceInterface pref = model.getPreference(examPeriod.getDateOffset(), examPeriod.getStartSlot());
                        if (pref == null || PreferenceLevel.sNeutral.equals(pref.getCode())) continue;
                        location.addExamPreference(examPeriod, PreferenceLevel.getPreferenceLevel(pref.getCode()));
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditPreference) && RoomInterface.FutureOperation.ROOM_SHARING.in(flags)) {
                HashMap<Long, Object> dept2pref = null;
                if (room.hasRoomSharingModel()) {
                    dept2pref = new HashMap<Long, Object>();
                    for (RoomInterface.RoomSharingOption option : room.getRoomSharingModel().getOptions()) {
                        Department department;
                        if (option.getId() < 0L || !option.isEditable() || !option.hasPreference() || (department = this.lookuDepartment(hibSession, option.getId(), future, location.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(department.getUniqueId(), PreferenceLevelDAO.getInstance().get(option.getPreference()));
                    }
                } else if (room.hasDepartments()) {
                    dept2pref = new HashMap();
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        Department department3;
                        if (department.getPreference() == null || (department3 = this.lookuDepartment(hibSession, department, future, location.getSession().getUniqueId())) == null) continue;
                        dept2pref.put(department3.getUniqueId(), this.lookupPreferenceLevel(hibSession, department.getPreference()));
                    }
                }
                if (dept2pref != null) {
                    for (RoomDept rd4 : location.getRoomDepts()) {
                        PreferenceLevel preferenceLevel = (PreferenceLevel)dept2pref.get(rd4.getDepartment().getUniqueId());
                        if (preferenceLevel == null || preferenceLevel.getPrefProlog().equals(PreferenceLevel.sNeutral)) continue;
                        RoomPref roomPref = new RoomPref();
                        roomPref.setRoom(location);
                        roomPref.setPrefLevel(preferenceLevel);
                        roomPref.setOwner(rd4.getDepartment());
                        rd4.getDepartment().getPreferences().add(roomPref);
                        rd4.setPreference(preferenceLevel);
                        hibSession.saveOrUpdate((Object)roomPref);
                        hibSession.saveOrUpdate((Object)rd4.getDepartment());
                    }
                }
            }
            if (context.hasPermission(location, Right.RoomEditFeatures) && RoomInterface.FutureOperation.FEATURES.in(flags)) {
                boolean editGlobalFeatures = context.hasPermission(location, Right.RoomEditGlobalFeatures);
                boolean bl = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                HashSet<RoomFeature> features = new HashSet<RoomFeature>(location.getFeatures());
                for (RoomInterface.FeatureInterface featureInterface : room.getFeatures()) {
                    RoomFeature feature = this.lookupFeature(hibSession, featureInterface, future, location.getSession().getUniqueId());
                    if (feature == null || features.remove(feature) || feature instanceof GlobalRoomFeature && !editGlobalFeatures || feature instanceof DepartmentRoomFeature && !bl && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)feature).getDepartment())) continue;
                    location.getFeatures().add(feature);
                    feature.getRooms().add(location);
                    hibSession.saveOrUpdate((Object)feature);
                }
                for (RoomFeature roomFeature : features) {
                    if (roomFeature instanceof GlobalRoomFeature && !editGlobalFeatures || roomFeature instanceof DepartmentRoomFeature && !bl && !context.getUser().getCurrentAuthority().hasQualifier(((DepartmentRoomFeature)roomFeature).getDepartment()) || future && this.lookupFeature(hibSession, new RoomInterface.FeatureInterface(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel()), future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    location.getFeatures().remove(roomFeature);
                    roomFeature.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)roomFeature);
                }
            }
            if (context.hasPermission(location, Right.RoomEditGroups) && RoomInterface.FutureOperation.GROUPS.in(flags)) {
                boolean editGlobalGroups = context.hasPermission(location, Right.RoomEditGlobalGroups);
                boolean bl = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
                HashSet<RoomGroup> groups = new HashSet<RoomGroup>(location.getRoomGroups());
                for (RoomInterface.GroupInterface groupInterface : room.getGroups()) {
                    RoomGroup group = this.lookupGroup(hibSession, groupInterface, future, location.getSession().getUniqueId());
                    if (group == null || groups.remove(group) || group.isGlobal().booleanValue() && !editGlobalGroups || !group.isGlobal().booleanValue() && !bl && !context.getUser().getCurrentAuthority().hasQualifier(group.getDepartment())) continue;
                    location.getRoomGroups().add(group);
                    group.getRooms().add(location);
                    hibSession.saveOrUpdate((Object)group);
                }
                for (RoomGroup roomGroup : groups) {
                    if (roomGroup.isGlobal().booleanValue() && !editGlobalGroups || !roomGroup.isGlobal().booleanValue() && !bl && !context.getUser().getCurrentAuthority().hasQualifier(roomGroup.getDepartment()) || future && this.lookupGroup(hibSession, new RoomInterface.GroupInterface(roomGroup.getUniqueId(), roomGroup.getAbbv(), roomGroup.getName()), future, context.getUser().getCurrentAcademicSessionId()) == null) continue;
                    location.getRoomGroups().remove(roomGroup);
                    roomGroup.getRooms().remove(location);
                    hibSession.saveOrUpdate((Object)roomGroup);
                }
            }
            if (context.hasPermission(location, Right.RoomEditEventAvailability) && room.hasEventAvailabilityModel() && RoomInterface.FutureOperation.EVENT_AVAILABILITY.in(flags)) {
                void var14_45;
                String availability = "";
                boolean bl = false;
                while (var14_45 < 7) {
                    for (int s = 0; s < 288; ++s) {
                        RoomInterface.RoomSharingOption roomSharingOption = room.getEventAvailabilityModel().getOption((int)var14_45, s);
                        availability = availability + (roomSharingOption.getId() == -1L ? (char)'0' : '1');
                    }
                    ++var14_45;
                }
                location.setEventAvailability(availability);
            }
            hibSession.saveOrUpdate((Object)location);
            for (RoomDept roomDept : location.getRoomDepts()) {
                hibSession.saveOrUpdate((Object)roomDept);
            }
            if (context.hasPermission(location, Right.RoomEditChangeEventProperties) && location.getNote() != null && !location.getNote().isEmpty() && RoomInterface.FutureOperation.EVENT_PROPERTIES.in(flags)) {
                ChangeLog.addChange(hibSession, context, location, location.getNote() == null || location.getNote().isEmpty() ? "-" : location.getNote(), ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.NOTE, null, location.getControllingDepartment());
            }
            ChangeLog.addChange(hibSession, context, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.CREATE, null, location.getControllingDepartment());
            if (context.hasPermission(location, Right.RoomEditChangePicture) && RoomInterface.FutureOperation.PICTURES.in(flags)) {
                Map temp = (Map)context.getAttribute(SessionAttribute.RoomPictures);
                HashMap<Long, LocationPicture> hashMap = new HashMap<Long, LocationPicture>();
                if (future) {
                    HashSet<? extends LocationPicture> otherPictures = new HashSet<LocationPicture>(location.getPictures());
                    block31: for (RoomInterface.RoomPictureInterface roomPictureInterface : room.getPictures()) {
                        LocationPicture original;
                        LocationPicture p2;
                        Iterator i = otherPictures.iterator();
                        while (i.hasNext()) {
                            p2 = (LocationPicture)i.next();
                            if (!this.samePicture(roomPictureInterface, p2)) continue;
                            if (!this.sameType(roomPictureInterface, p2)) {
                                p2.setType(roomPictureInterface.getPictureType() == null ? null : (AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                                hibSession.saveOrUpdate((Object)p2);
                            }
                            i.remove();
                            continue block31;
                        }
                        if (location instanceof Room) {
                            original = (RoomPicture)RoomPictureDAO.getInstance().get(roomPictureInterface.getUniqueId());
                            if (original == null) continue;
                            p2 = ((RoomPicture)original).clonePicture();
                            p2.setLocation(location);
                            ((Room)location).getPictures().add((RoomPicture)p2);
                            hibSession.saveOrUpdate((Object)p2);
                            continue;
                        }
                        original = (NonUniversityLocationPicture)NonUniversityLocationPictureDAO.getInstance().get(roomPictureInterface.getUniqueId());
                        if (original == null) continue;
                        p2 = ((NonUniversityLocationPicture)original).clonePicture();
                        p2.setLocation(location);
                        ((NonUniversityLocation)location).getPictures().add((NonUniversityLocationPicture)p2);
                        hibSession.saveOrUpdate((Object)p2);
                    }
                    for (LocationPicture locationPicture : otherPictures) {
                        location.getPictures().remove(locationPicture);
                        hibSession.delete((Object)locationPicture);
                    }
                } else {
                    for (LocationPicture locationPicture : location.getPictures()) {
                        hashMap.put(locationPicture.getUniqueId(), locationPicture);
                    }
                    for (RoomInterface.RoomPictureInterface roomPictureInterface : room.getPictures()) {
                        LocationPicture locationPicture = (LocationPicture)hashMap.remove(roomPictureInterface.getUniqueId());
                        if (locationPicture == null && temp != null) {
                            LocationPicture locationPicture2 = (LocationPicture)temp.get(roomPictureInterface.getUniqueId());
                            if (locationPicture2 == null) continue;
                            if (location instanceof Room) {
                                ((RoomPicture)locationPicture2).setLocation((Room)location);
                                ((Room)location).getPictures().add((RoomPicture)locationPicture2);
                                if (roomPictureInterface.getPictureType() != null) {
                                    locationPicture2.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                                }
                                hibSession.saveOrUpdate((Object)locationPicture2);
                                roomPictureInterface.setUniqueId(locationPicture2.getUniqueId());
                                continue;
                            }
                            NonUniversityLocationPicture np = new NonUniversityLocationPicture();
                            np.setDataFile(locationPicture2.getDataFile());
                            np.setFileName(locationPicture2.getFileName());
                            np.setContentType(locationPicture2.getContentType());
                            np.setTimeStamp(locationPicture2.getTimeStamp());
                            np.setLocation((NonUniversityLocation)location);
                            ((NonUniversityLocation)location).getPictures().add(np);
                            if (roomPictureInterface.getPictureType() != null) {
                                np.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                            }
                            hibSession.saveOrUpdate((Object)np);
                            roomPictureInterface.setUniqueId(np.getUniqueId());
                            continue;
                        }
                        if (locationPicture == null) continue;
                        if (roomPictureInterface.getPictureType() != null) {
                            locationPicture.setType((AttachmentType)AttachmentTypeDAO.getInstance().get(roomPictureInterface.getPictureType().getId(), hibSession));
                        }
                        hibSession.saveOrUpdate((Object)locationPicture);
                    }
                    for (LocationPicture locationPicture : hashMap.values()) {
                        location.getPictures().remove(locationPicture);
                        hibSession.delete((Object)locationPicture);
                    }
                }
            }
            hibSession.flush();
            tx.commit();
            tx = null;
            Location location2 = location;
            return location2;
        }
        catch (Throwable t) {
            if (future) {
                throw new RoomInterface.RoomException(MESSAGES.failedCreateLocation(roomName, sessionLabel, t.getMessage()), t);
            }
            throw new GwtRpcException(t.getMessage(), t);
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    protected boolean samePicture(RoomInterface.RoomPictureInterface p1, LocationPicture p2) {
        return p1.getName().equals(p2.getFileName()) && Math.abs(p1.getTimeStamp() - p2.getTimeStamp().getTime()) < 1000L && p1.getType().equals(p2.getContentType());
    }

    protected boolean sameType(RoomInterface.RoomPictureInterface p1, LocationPicture p2) {
        if (p1.getPictureType() == null) {
            return p2.getType() == null;
        }
        return p2.getType() != null && p1.getPictureType().getId().equals(p2.getType().getUniqueId());
    }

    protected RoomType lookupRoomType(org.hibernate.Session hibSession, RoomInterface.RoomTypeInterface original) {
        if (original == null) {
            return null;
        }
        if (original.getId() != null) {
            return (RoomType)RoomTypeDAO.getInstance().get(original.getId(), hibSession);
        }
        return (RoomType)hibSession.createQuery("select t from RoomType t where t.reference = :reference").setString("reference", original.getReference()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    protected PreferenceLevel lookupPreferenceLevel(org.hibernate.Session hibSession, RoomInterface.PreferenceInterface original) {
        if (original == null) {
            return null;
        }
        if (original.getId() != null) {
            return (PreferenceLevel)PreferenceLevelDAO.getInstance().get(original.getId(), hibSession);
        }
        return PreferenceLevel.getPreferenceLevel(original.getCode());
    }

    protected Building lookupBuilding(org.hibernate.Session hibSession, RoomInterface.BuildingInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future || original.getId() == null) {
            return (Building)hibSession.createQuery("select b from Building b where b.abbreviation = :abbreviation and b.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("abbreviation", original.getAbbreviation()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (Building)BuildingDAO.getInstance().get(original.getId(), hibSession);
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, RoomInterface.DepartmentInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future || original.getId() == null) {
            return Department.findByDeptCode(original.getDeptCode(), sessionId, hibSession);
        }
        return (Department)DepartmentDAO.getInstance().get(original.getId(), hibSession);
    }

    protected EventServiceProvider lookupService(org.hibernate.Session hibSession, EventInterface.EventServiceProviderInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        EventServiceProvider service = (EventServiceProvider)EventServiceProviderDAO.getInstance().get(original.getId());
        if (future && service != null) {
            return service.findInSession(sessionId);
        }
        return service;
    }

    protected RoomFeature lookupFeature(org.hibernate.Session hibSession, RoomInterface.FeatureInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (original.getId() == null) {
            if (original.isDepartmental()) {
                return (DepartmentRoomFeature)hibSession.createQuery("select f from DepartmentRoomFeature f where f.department.session.uniqueId = :sessionId and f.abbv = :abbv and f.department.deptCode = :deptCode").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setString("deptCode", original.getDepartment().getDeptCode()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (GlobalRoomFeature)hibSession.createQuery("select f from GlobalRoomFeature f where f.session.uniqueId = :sessionId and f.abbv = :abbv").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        if (future) {
            if (original.isDepartmental()) {
                return (DepartmentRoomFeature)hibSession.createQuery("select f from DepartmentRoomFeature f, DepartmentRoomFeature o where o.uniqueId = :originalId and f.department.session.uniqueId = :sessionId and f.abbv = o.abbv and f.department.deptCode = o.department.deptCode").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (GlobalRoomFeature)hibSession.createQuery("select f from GlobalRoomFeature f, GlobalRoomFeature o where o.uniqueId = :originalId and f.session.uniqueId = :sessionId and f.abbv = o.abbv").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (RoomFeature)RoomFeatureDAO.getInstance().get(original.getId(), hibSession);
    }

    protected RoomGroup lookupGroup(org.hibernate.Session hibSession, RoomInterface.GroupInterface original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (original.getId() == null) {
            if (original.isDepartmental()) {
                return (RoomGroup)hibSession.createQuery("select g from RoomGroup g where g.department.session.uniqueId = :sessionId and g.abbv = :abbv and g.department.deptCode = :deptCode and g.global = false").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setString("deptCode", original.getDepartment().getDeptCode()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (RoomGroup)hibSession.createQuery("select g from RoomGroup g where g.session.uniqueId = :sessionId and g.abbv = :abbv and g.global = true").setLong("sessionId", sessionId.longValue()).setString("abbv", original.getAbbreviation()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        if (future) {
            if (original.isDepartmental()) {
                return (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.department.session.uniqueId = :sessionId and g.abbv = o.abbv and g.department.deptCode = o.department.deptCode and g.global = false").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
            }
            return (RoomGroup)hibSession.createQuery("select g from RoomGroup g, RoomGroup o where o.uniqueId = :originalId and g.session.uniqueId = :sessionId and g.abbv = o.abbv and g.global = true").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (RoomGroup)RoomGroupDAO.getInstance().get(original.getId(), hibSession);
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, Department original, boolean future, Long sessionId) {
        if (original == null) {
            return null;
        }
        if (future) {
            return (Department)hibSession.createQuery("select d from Department d, Department o where d.deptCode = o.deptCode and d.session.uniqueId = :sessionId and o.uniqueId = :originalId").setLong("sessionId", sessionId.longValue()).setLong("originalId", original.getUniqueId().longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return original;
    }

    protected Department lookuDepartment(org.hibernate.Session hibSession, Long originalId, boolean future, Long sessionId) {
        if (originalId == null) {
            return null;
        }
        if (future) {
            return (Department)hibSession.createQuery("select distinct d from Department d, Department o where d.deptCode = o.deptCode and d.session.uniqueId = :sessionId and o.uniqueId = :originalId").setLong("sessionId", sessionId.longValue()).setLong("originalId", originalId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (Department)DepartmentDAO.getInstance().get(originalId, hibSession);
    }
}

