/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.util.Collections;
import java.util.HashMap;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.RoomFilterBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;

@GwtRpcImplements(value=RoomInterface.SearchRoomGroupsRequest.class)
public class RoomGroupsBackend
implements GwtRpcImplementation<RoomInterface.SearchRoomGroupsRequest, GwtRpcResponseList<RoomInterface.GroupInterface>> {
    @Override
    public GwtRpcResponseList<RoomInterface.GroupInterface> execute(RoomInterface.SearchRoomGroupsRequest request, SessionContext context) {
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        if (context.isAuthenticated()) {
            request.getFilter().setOption("user", context.getUser().getExternalUserId());
        }
        context.checkPermission(Right.RoomGroups);
        GwtRpcResponseList<RoomInterface.GroupInterface> list = new GwtRpcResponseList<RoomInterface.GroupInterface>();
        EventInterface.FilterRpcResponse filterResponse = new EventInterface.FilterRpcResponse();
        new RoomFilterBackend().enumarate(request.getFilter(), filterResponse, new EventAction.EventContext(context, context.getUser().getCurrentAcademicSessionId()));
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> locations = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        if (filterResponse.hasResults()) {
            for (EventInterface.FilterRpcResponse.Entity entity : filterResponse.getResults()) {
                locations.put(entity.getUniqueId(), entity);
            }
        }
        boolean filterDepartments = context.getUser() != null && !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        for (RoomGroup g : RoomGroup.getAllRoomGroupsForSession(context.getUser().getCurrentAcademicSessionId())) {
            RoomInterface.GroupInterface group = new RoomInterface.GroupInterface(g.getUniqueId(), g.getAbbv(), g.getName());
            group.setDescription(g.getDescription());
            group.setDefault(g.isDefaultGroup());
            if (g.getDepartment() != null) {
                if (filterDepartments && !context.getUser().getCurrentAuthority().hasQualifier(g.getDepartment())) continue;
                group.setDepartment(RoomDetailsBackend.wrap(g.getDepartment(), null, null));
                group.setCanEdit(context.hasPermission(g, Right.DepartmenalRoomGroupEdit));
                group.setCanDelete(context.hasPermission(g, Right.DepartmenalRoomGroupDelete));
                group.setSessionId(g.getDepartment().getSession().getUniqueId());
                group.setSessionName(g.getDepartment().getSession().getLabel());
            } else {
                group.setCanEdit(context.hasPermission(g, Right.GlobalRoomGroupEdit));
                group.setCanDelete(context.hasPermission(g, Right.GlobalRoomGroupDelete));
                group.setSessionId(g.getSession().getUniqueId());
                group.setSessionName(g.getSession().getLabel());
            }
            for (Location location : g.getRooms()) {
                EventInterface.FilterRpcResponse.Entity e = (EventInterface.FilterRpcResponse.Entity)locations.get(location.getUniqueId());
                if (e == null) continue;
                group.addRoom(e);
            }
            if (group.hasRooms()) {
                Collections.sort(group.getRooms());
            }
            list.add(group);
        }
        return list;
    }
}

