/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;

@SerializeWith(value=XAreaClassificationMajorSerializer.class)
public class XAreaClassificationMajor
implements Serializable,
Externalizable,
Comparable<XAreaClassificationMajor> {
    private static final long serialVersionUID = 1L;
    private String iAreaCode;
    private String iClassificationCode;
    private String iMajorCode;
    private String iConcentrationCode;
    private String iDegreeCode;
    private String iProgramCode;
    private String iCampusCode;
    private String iAreaLabel;
    private String iClassificationLabel;
    private String iMajorLabel;
    private String iConcentrationLabel;
    private String iDegreeLabel;
    private String iProgramLabel;
    private String iCampusLabel;
    private double iWeight = 1.0;

    public XAreaClassificationMajor() {
    }

    public XAreaClassificationMajor(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XAreaClassificationMajor(String area, String classification, String major) {
        this.iAreaCode = area;
        this.iClassificationCode = classification;
        this.iMajorCode = major;
    }

    public XAreaClassificationMajor(StudentAreaClassificationMinor acm) {
        this.iAreaCode = acm.getAcademicArea().getAcademicAreaAbbreviation();
        this.iAreaLabel = acm.getAcademicArea().getTitle();
        this.iClassificationCode = acm.getAcademicClassification().getCode();
        this.iClassificationLabel = acm.getAcademicClassification().getName();
        this.iMajorCode = acm.getMinor().getCode();
        this.iMajorLabel = acm.getMinor().getName();
    }

    public XAreaClassificationMajor(StudentAreaClassificationMajor acm) {
        this.iAreaCode = acm.getAcademicArea().getAcademicAreaAbbreviation();
        this.iAreaLabel = acm.getAcademicArea().getTitle();
        this.iClassificationCode = acm.getAcademicClassification().getCode();
        this.iClassificationLabel = acm.getAcademicClassification().getName();
        this.iMajorCode = acm.getMajor().getCode();
        this.iMajorLabel = acm.getMajor().getName();
        if (acm.getConcentration() != null) {
            this.iConcentrationCode = acm.getConcentration().getCode();
            this.iConcentrationLabel = acm.getConcentration().getName();
        }
        if (acm.getDegree() != null) {
            this.iDegreeCode = acm.getDegree().getReference();
            this.iDegreeLabel = acm.getDegree().getLabel();
        }
        if (acm.getProgram() != null) {
            this.iProgramCode = acm.getProgram().getReference();
            this.iProgramLabel = acm.getProgram().getLabel();
        }
        if (acm.getCampus() != null) {
            this.iCampusCode = acm.getCampus().getReference();
            this.iCampusLabel = acm.getCampus().getLabel();
        }
        if (acm.getWeight() != null) {
            this.iWeight = acm.getWeight();
        }
    }

    public XAreaClassificationMajor(AreaClassificationMajor acm) {
        this.iAreaCode = acm.getArea();
        this.iAreaLabel = acm.getAreaName();
        this.iClassificationCode = acm.getClassification();
        this.iClassificationLabel = acm.getClassificationName();
        this.iMajorCode = acm.getMajor();
        this.iMajorLabel = acm.getMajorName();
        this.iConcentrationCode = acm.getConcentration();
        this.iConcentrationLabel = acm.getConcentrationName();
        this.iDegreeCode = acm.getDegree();
        this.iDegreeLabel = acm.getDegreeName();
        this.iProgramCode = acm.getProgram();
        this.iProgramLabel = acm.getProgramName();
        this.iWeight = acm.getWeight();
    }

    public String getArea() {
        return this.iAreaCode;
    }

    public String getAreaLabel() {
        return this.iAreaLabel;
    }

    public String getClassification() {
        return this.iClassificationCode;
    }

    public String getClassificationLabel() {
        return this.iClassificationLabel;
    }

    public String getMajor() {
        return this.iMajorCode;
    }

    public String getMajorLabel() {
        return this.iMajorLabel;
    }

    public String getConcentration() {
        return this.iConcentrationCode;
    }

    public String getConcentrationNotNull() {
        return this.iConcentrationCode == null ? "" : this.iConcentrationCode;
    }

    public String getConcentrationLabel() {
        return this.iConcentrationLabel;
    }

    public String getDegree() {
        return this.iDegreeCode;
    }

    public String getDegreeNotNull() {
        return this.iDegreeCode == null ? "" : this.iDegreeCode;
    }

    public String getDegreeLabel() {
        return this.iDegreeLabel;
    }

    public String getProgram() {
        return this.iProgramCode;
    }

    public String getProgramNotNull() {
        return this.iProgramCode == null ? "" : this.iProgramCode;
    }

    public String getProgramLabel() {
        return this.iProgramLabel;
    }

    public String getCampus() {
        return this.iCampusCode;
    }

    public String getCampusNotNull() {
        return this.iCampusCode == null ? "" : this.iCampusCode;
    }

    public String getCampusLabel() {
        return this.iCampusLabel;
    }

    public double getWeight() {
        return this.iWeight;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XAreaClassificationMajor)) {
            return false;
        }
        XAreaClassificationMajor acm = (XAreaClassificationMajor)o;
        return ToolBox.equals((Object)acm.getArea(), (Object)this.getArea()) && ToolBox.equals((Object)acm.getClassification(), (Object)this.getClassification()) && ToolBox.equals((Object)acm.getMajor(), (Object)this.getMajor()) && ToolBox.equals((Object)acm.getConcentration(), (Object)this.getConcentration()) && ToolBox.equals((Object)acm.getDegree(), (Object)this.getDegree()) && ToolBox.equals((Object)acm.getProgram(), (Object)this.getProgram()) && ToolBox.equals((Object)acm.getCampus(), (Object)this.getCampus());
    }

    public String toString() {
        return this.getArea() + "/" + this.getMajor() + (this.getConcentration() == null ? "" : "-" + this.getConcentration()) + " " + this.getClassification();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iAreaCode = (String)in.readObject();
        this.iAreaLabel = (String)in.readObject();
        this.iClassificationCode = (String)in.readObject();
        this.iClassificationLabel = (String)in.readObject();
        this.iMajorCode = (String)in.readObject();
        this.iMajorLabel = (String)in.readObject();
        this.iConcentrationCode = (String)in.readObject();
        this.iConcentrationLabel = (String)in.readObject();
        this.iDegreeCode = (String)in.readObject();
        this.iDegreeLabel = (String)in.readObject();
        this.iProgramCode = (String)in.readObject();
        this.iProgramLabel = (String)in.readObject();
        this.iCampusCode = (String)in.readObject();
        this.iCampusLabel = (String)in.readObject();
        this.iWeight = in.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.iAreaCode);
        out.writeObject(this.iAreaLabel);
        out.writeObject(this.iClassificationCode);
        out.writeObject(this.iClassificationLabel);
        out.writeObject(this.iMajorCode);
        out.writeObject(this.iMajorLabel);
        out.writeObject(this.iConcentrationCode);
        out.writeObject(this.iConcentrationLabel);
        out.writeObject(this.iDegreeCode);
        out.writeObject(this.iDegreeLabel);
        out.writeObject(this.iProgramCode);
        out.writeObject(this.iProgramLabel);
        out.writeObject(this.iCampusCode);
        out.writeObject(this.iCampusLabel);
        out.writeDouble(this.iWeight);
    }

    @Override
    public int compareTo(XAreaClassificationMajor acm) {
        if (this.getWeight() != acm.getWeight()) {
            return this.getWeight() > acm.getWeight() ? -1 : 1;
        }
        if (!this.getArea().equals(acm.getArea())) {
            return this.getArea().compareTo(acm.getArea());
        }
        if (!this.getClassification().equals(acm.getClassification())) {
            return this.getClassification().compareTo(acm.getClassification());
        }
        if (!this.getDegreeNotNull().equals(acm.getDegreeNotNull())) {
            return this.getDegreeNotNull().compareTo(acm.getDegreeNotNull());
        }
        if (!this.getProgramNotNull().equals(acm.getProgramNotNull())) {
            return this.getProgramNotNull().compareTo(acm.getProgramNotNull());
        }
        if (!this.getMajor().equals(acm.getMajor())) {
            return this.getMajor().compareTo(acm.getMajor());
        }
        if (!this.getCampusNotNull().equals(acm.getCampusNotNull())) {
            return this.getCampusNotNull().compareTo(acm.getCampusNotNull());
        }
        return this.getConcentrationNotNull().compareTo(acm.getConcentrationNotNull());
    }

    public static class XAreaClassificationMajorSerializer
    implements Externalizer<XAreaClassificationMajor> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XAreaClassificationMajor object) throws IOException {
            object.writeExternal(output);
        }

        public XAreaClassificationMajor readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XAreaClassificationMajor(input);
        }
    }
}

