/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.springframework.web.util.HtmlUtils;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;

public class SolverGroupEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 150007237399797836L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp;
    private Long iUniqueId;
    private String iName;
    private String iAbbv;
    private boolean iDepartmentsEditable;
    private List<Long> iDepartmentIds;
    private List<String> iDepartmentNames;
    private List<Boolean> iAssignedDepartments;
    private List<Long> iManagerIds;
    private List<String> iManagerNames;
    private List<Boolean> iAssignedManagers;

    public SolverGroupEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        SolverGroup g;
        Long sessionId = action.getSessionContext().getUser().getCurrentAcademicSessionId();
        if (this.iName == null || this.iName.trim().length() == 0) {
            action.addFieldError("form.name", MSG.errorRequiredField(MSG.fieldName()));
        } else {
            try {
                g = SolverGroup.findBySessionIdName(sessionId, this.iName);
                if (g != null && !g.getUniqueId().equals(this.iUniqueId)) {
                    action.addFieldError("form.name", MSG.errorAlreadyExists(this.iName));
                }
            }
            catch (Exception e) {
                action.addFieldError("form.name", e.getMessage());
            }
        }
        if (this.iAbbv == null || this.iAbbv.trim().length() == 0) {
            action.addFieldError("form.abbv", MSG.errorRequiredField(MSG.fieldAbbreviation()));
        } else {
            try {
                g = SolverGroup.findBySessionIdAbbv(sessionId, this.iAbbv);
                if (g != null && !g.getUniqueId().equals(this.iUniqueId)) {
                    action.addFieldError("form.abbv", MSG.errorAlreadyExists(this.iAbbv));
                }
            }
            catch (Exception e) {
                action.addFieldError("form.abbv", e.getMessage());
            }
        }
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iUniqueId = null;
        this.iName = null;
        this.iAbbv = null;
        this.iAssignedDepartments = new ArrayList<Boolean>();
        this.iAssignedManagers = new ArrayList<Boolean>();
        this.iManagerIds = new ArrayList<Long>();
        this.iManagerNames = new ArrayList<String>();
        this.iDepartmentIds = new ArrayList<Long>();
        this.iDepartmentNames = new ArrayList<String>();
        this.iDepartmentsEditable = false;
    }

    public void load(SolverGroup group, Session session, final String nameFormat) throws Exception {
        TreeSet<Department> departments = Department.findAllBeingUsed(session.getUniqueId());
        ArrayList managers = new ArrayList(TimetableManagerDAO.getInstance().findAll());
        Collections.sort(managers, new Comparator<TimetableManager>(){

            @Override
            public int compare(TimetableManager m1, TimetableManager m2) {
                int cmp = m1.getName(nameFormat).compareToIgnoreCase(m2.getName(nameFormat));
                if (cmp != 0) {
                    return cmp;
                }
                return m1.compareTo(m2);
            }
        });
        this.iDepartmentIds.clear();
        this.iDepartmentNames.clear();
        this.iManagerIds.clear();
        this.iManagerNames.clear();
        this.iAssignedDepartments.clear();
        this.iAssignedManagers.clear();
        this.iDepartmentsEditable = true;
        if (group == null) {
            this.iUniqueId = -1L;
            this.iName = null;
            this.iAbbv = null;
            this.iOp = "Save";
            for (Department d : departments) {
                if (d.getSolverGroup() != null) continue;
                this.iAssignedDepartments.add(Boolean.FALSE);
                this.iDepartmentIds.add(d.getUniqueId());
                this.iDepartmentNames.add(d.getLabel());
            }
            for (TimetableManager m : managers) {
                boolean hasSession = false;
                for (Department department : m.getDepartments()) {
                    if (!department.getSession().equals(session)) continue;
                    hasSession = true;
                    break;
                }
                if (!hasSession) continue;
                this.iAssignedManagers.add(Boolean.FALSE);
                this.iManagerIds.add(m.getUniqueId());
                String deptStr = "";
                for (Department d3 : new TreeSet(m.departmentsForSession(session.getUniqueId()))) {
                    deptStr = deptStr + (deptStr.isEmpty() ? "" : ", ") + "<span title='" + HtmlUtils.htmlEscape((String)d3.getLabel()) + "'>" + d3.getDeptCode() + "</span>";
                }
                this.iManagerNames.add(m.getName(nameFormat) + (deptStr.isEmpty() ? "" : " (" + deptStr + ")"));
            }
        } else {
            this.iUniqueId = group.getUniqueId();
            this.iName = group.getName();
            this.iAbbv = group.getAbbv();
            this.iOp = "Update";
            Iterator i = departments.iterator();
            while (i.hasNext()) {
                Department d = (Department)i.next();
                if (group.equals(d.getSolverGroup())) {
                    this.iAssignedDepartments.add(Boolean.TRUE);
                    this.iDepartmentIds.add(d.getUniqueId());
                    this.iDepartmentNames.add(d.getLabel());
                    continue;
                }
                if (d.getSolverGroup() == null) {
                    this.iAssignedDepartments.add(Boolean.FALSE);
                    this.iDepartmentIds.add(d.getUniqueId());
                    this.iDepartmentNames.add(d.getLabel());
                    continue;
                }
                i.remove();
            }
            for (TimetableManager m : managers) {
                String deptStr = "";
                for (Department department : new TreeSet(m.departmentsForSession(session.getUniqueId()))) {
                    deptStr = deptStr + (deptStr.isEmpty() ? "" : ", ") + "<span title='" + HtmlUtils.htmlEscape((String)department.getLabel()) + "'>" + department.getDeptCode() + "</span>";
                }
                boolean hasSession = group.getTimetableManagers().contains(m);
                if (!hasSession) {
                    for (Department d : m.getDepartments()) {
                        if (!d.getSession().equals(session)) continue;
                        hasSession = true;
                        break;
                    }
                }
                if (!hasSession) continue;
                this.iManagerIds.add(m.getUniqueId());
                this.iManagerNames.add(m.getName(nameFormat) + (deptStr.isEmpty() ? "" : " (" + deptStr + ")"));
                if (group.getTimetableManagers().contains(m)) {
                    this.iAssignedManagers.add(Boolean.TRUE);
                    continue;
                }
                this.iAssignedManagers.add(Boolean.FALSE);
            }
            if (!group.getSolutions().isEmpty()) {
                this.iDepartmentsEditable = false;
            }
        }
    }

    public SolverGroup saveOrUpdate(org.hibernate.Session hibSession, SessionContext context) throws Exception {
        SolverGroup group = null;
        if (this.iUniqueId >= 0L) {
            group = (SolverGroup)SolverGroupDAO.getInstance().get(this.iUniqueId);
        }
        if (group == null) {
            group = this.create(hibSession, context.getUser().getCurrentAcademicSessionId());
            ChangeLog.addChange(hibSession, context, group, ChangeLog.Source.SOLVER_GROUP_EDIT, ChangeLog.Operation.CREATE, null, null);
        } else {
            this.update(group, hibSession);
            ChangeLog.addChange(hibSession, context, group, ChangeLog.Source.SOLVER_GROUP_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        return group;
    }

    public SolverGroup create(org.hibernate.Session hibSession, Long sessionId) throws Exception {
        SolverGroup group = new SolverGroup();
        group.setName(this.iName);
        group.setAbbv(this.iAbbv);
        Session session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
        group.setSession(session);
        HashSet<Department> newDepartments = new HashSet<Department>();
        for (int i = 0; i < this.iAssignedDepartments.size(); ++i) {
            if (!this.iAssignedDepartments.get(i).booleanValue()) continue;
            Long deptId = this.iDepartmentIds.get(i);
            Department dept = (Department)DepartmentDAO.getInstance().get(deptId, hibSession);
            if (dept == null) continue;
            newDepartments.add(dept);
        }
        group.setDepartments(newDepartments);
        HashSet<TimetableManager> newManagers = new HashSet<TimetableManager>();
        for (int i = 0; i < this.iAssignedManagers.size(); ++i) {
            if (!this.iAssignedManagers.get(i).booleanValue()) continue;
            Long mgrId = this.iManagerIds.get(i);
            TimetableManager mgr = (TimetableManager)TimetableManagerDAO.getInstance().get(mgrId, hibSession);
            if (mgr == null) continue;
            newManagers.add(mgr);
        }
        group.setTimetableManagers(newManagers);
        group.setSolutions(new HashSet<Solution>());
        hibSession.save((Object)group);
        for (Department d : newDepartments) {
            d.setSolverGroup(group);
            hibSession.saveOrUpdate((Object)d);
        }
        for (TimetableManager mgr : newManagers) {
            mgr.getSolverGroups().add(group);
            hibSession.saveOrUpdate((Object)mgr);
        }
        this.iUniqueId = group.getUniqueId();
        return group;
    }

    public void update(SolverGroup group, org.hibernate.Session hibSession) throws Exception {
        group.setName(this.iName);
        group.setAbbv(this.iAbbv);
        if (this.iDepartmentsEditable) {
            HashSet<Department> oldDepartments = new HashSet<Department>(group.getDepartments());
            for (int i = 0; i < this.iAssignedDepartments.size(); ++i) {
                if (!this.iAssignedDepartments.get(i).booleanValue()) continue;
                Long deptId = this.iDepartmentIds.get(i);
                Department dept = (Department)DepartmentDAO.getInstance().get(deptId, hibSession);
                if (dept == null || oldDepartments.remove(dept)) continue;
                group.getDepartments().add(dept);
                dept.setSolverGroup(group);
                hibSession.saveOrUpdate((Object)dept);
            }
            for (Department dept : oldDepartments) {
                group.getDepartments().remove(dept);
                dept.setSolverGroup(null);
                hibSession.saveOrUpdate((Object)dept);
            }
        }
        HashSet<TimetableManager> oldManagers = new HashSet<TimetableManager>(group.getTimetableManagers());
        for (int i = 0; i < this.iAssignedManagers.size(); ++i) {
            if (!this.iAssignedManagers.get(i).booleanValue()) continue;
            Long mgrId = this.iManagerIds.get(i);
            TimetableManager mgr = (TimetableManager)TimetableManagerDAO.getInstance().get(mgrId, hibSession);
            if (mgr == null || oldManagers.remove(mgr)) continue;
            group.getTimetableManagers().add(mgr);
        }
        for (TimetableManager mgr : oldManagers) {
            group.getTimetableManagers().remove(mgr);
            mgr.getSolverGroups().remove(group);
            hibSession.saveOrUpdate((Object)mgr);
        }
        hibSession.saveOrUpdate((Object)group);
        hibSession.flush();
        hibSession.refresh((Object)group);
        Iterator<Comparable> i = group.getDepartments().iterator();
        while (i.hasNext()) {
            hibSession.refresh((Object)i.next());
        }
        i = group.getTimetableManagers().iterator();
        while (i.hasNext()) {
            hibSession.refresh((Object)i.next());
        }
    }

    public void delete(org.hibernate.Session hibSession, SessionContext context) throws Exception {
        if (this.iUniqueId < 0L) {
            return;
        }
        if (!this.iDepartmentsEditable) {
            return;
        }
        SolverGroup group = (SolverGroup)new SolverGroupDAO().get(this.iUniqueId);
        if (group == null) {
            return;
        }
        for (Department dept : group.getDepartments()) {
            dept.setSolverGroup(null);
            hibSession.saveOrUpdate((Object)dept);
        }
        for (TimetableManager mgr : group.getTimetableManagers()) {
            mgr.getSolverGroups().remove(group);
            hibSession.saveOrUpdate((Object)mgr);
        }
        ChangeLog.addChange(hibSession, context, group, ChangeLog.Source.SOLVER_GROUP_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)group);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public boolean getDepartmentsEditable() {
        return this.iDepartmentsEditable;
    }

    public void setDepartmentsEditable(boolean departmentsEditable) {
        this.iDepartmentsEditable = departmentsEditable;
    }

    public List<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(List<Long> departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public Long getDepartmentIds(int idx) {
        return this.iDepartmentIds.get(idx);
    }

    public void setDepartmentIds(int idx, Long departmentId) {
        this.iDepartmentIds.set(idx, departmentId);
    }

    public List<String> getDepartmentNames() {
        return this.iDepartmentNames;
    }

    public void setDepartmentNames(List<String> departmentNames) {
        this.iDepartmentNames = departmentNames;
    }

    public String getDepartmentNames(int idx) {
        return this.iDepartmentNames.get(idx);
    }

    public void setDepartmentNames(int idx, String departmentName) {
        this.iDepartmentNames.set(idx, departmentName);
    }

    public List<Boolean> getAssignedDepartments() {
        return this.iAssignedDepartments;
    }

    public void setAssignedDepartments(List<Boolean> assignedDepartments) {
        this.iAssignedDepartments = assignedDepartments;
    }

    public Boolean getAssignedDepartments(int idx) {
        return this.iAssignedDepartments.get(idx);
    }

    public void setAssignedDepartments(int idx, Boolean assignedDepartment) {
        this.iAssignedDepartments.set(idx, assignedDepartment);
    }

    public List<Long> getManagerIds() {
        return this.iManagerIds;
    }

    public void setManagerIds(List<Long> managerIds) {
        this.iManagerIds = managerIds;
    }

    public Long getManagerIds(int idx) {
        return this.iManagerIds.get(idx);
    }

    public void setManagerIds(int idx, Long managerId) {
        this.iManagerIds.set(idx, managerId);
    }

    public List<String> getManagerNames() {
        return this.iManagerNames;
    }

    public void setManagerNames(List<String> managerNames) {
        this.iManagerNames = managerNames;
    }

    public String getManagerNames(int idx) {
        return this.iManagerNames.get(idx);
    }

    public void setManagerNames(int idx, String managerName) {
        this.iManagerNames.set(idx, managerName);
    }

    public List<Boolean> getAssignedManagers() {
        return this.iAssignedManagers;
    }

    public void setAssignedManagers(List<Boolean> assignedManagers) {
        this.iAssignedManagers = assignedManagers;
    }

    public Boolean getAssignedManagers(int idx) {
        return this.iAssignedManagers.get(idx);
    }

    public void setAssignedManagers(int idx, Boolean assignedManagers) {
        this.iAssignedManagers.set(idx, assignedManagers);
    }
}

