/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.util.ArrayList;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.ui.UnassignedClassRow;
import org.unitime.timetable.solver.ui.UnassignedClassesModel;

public class SolverUnassignedClassesModel
extends UnassignedClassesModel {
    private static final long serialVersionUID = -6094708695678612559L;

    public SolverUnassignedClassesModel(TimetableSolver solver, String ... prefix) {
        for (Lecture lecture : solver.currentSolution().getModel().unassignedVariables(solver.currentSolution().getAssignment())) {
            String name = lecture.getName();
            if (prefix != null && prefix.length > 0) {
                boolean hasPrefix = false;
                for (String p : prefix) {
                    if (p != null && !name.startsWith(p)) continue;
                    hasPrefix = true;
                    break;
                }
                if (!hasPrefix) continue;
            }
            ArrayList<String> instructors = new ArrayList<String>();
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                instructors.add(ic.getName());
            }
            int nrStudents = lecture.students().size();
            String initial = "";
            if (lecture.getInitialAssignment() != null) {
                initial = ((Placement)lecture.getInitialAssignment()).getName();
            }
            this.rows().add(new UnassignedClassRow(lecture.getClassId(), name, instructors, nrStudents, initial, lecture.getOrd()));
        }
    }
}

