/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.convention.annotation.Action;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;

@Action(value="examEditAjax")
public class ExamEditAjax
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -4965013857791832650L;
    protected static ExaminationMessages EXMSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        this.response.addHeader("Content-Type", "text/xml; charset=UTF-8");
        this.request.setCharacterEncoding("UTF-8");
        PrintWriter out = this.response.getWriter();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        out.print("<results>");
        this.coumputeSuggestionList(this.request, out);
        out.print("</results>");
        return null;
    }

    protected void print(PrintWriter out, String id, String value) throws IOException {
        out.print("<result id=\"" + id + "\" value=\"" + value + "\" />");
    }

    protected void print(PrintWriter out, String id, String value, String extra) throws IOException {
        out.print("<result id=\"" + id + "\" value=\"" + value + "\" extra=\"" + extra + "\" />");
    }

    protected void coumputeSuggestionList(HttpServletRequest request, PrintWriter out) throws Exception {
        if ("subjectArea".equals(request.getParameter("type"))) {
            this.coumputeCourseNumbers(request.getParameter("id"), out);
        } else if ("courseNbr".equals(request.getParameter("type"))) {
            this.coumputeSubparts(request.getParameter("id"), out);
        } else if ("itype".equals(request.getParameter("type"))) {
            this.coumputeClasses(request.getParameter("id"), request.getParameter("courseId"), out);
        }
    }

    protected void coumputeCourseNumbers(String subjectAreaId, PrintWriter out) throws Exception {
        if (subjectAreaId == null || subjectAreaId.length() == 0 || subjectAreaId.equals("-")) {
            this.print(out, "-1", EXMSG.examOwnerNotApplicable());
            return;
        }
        List courseNumbers = new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ").setFetchSize(200).setCacheable(true).setLong("subjectAreaId", Long.parseLong(subjectAreaId)).list();
        if (courseNumbers.isEmpty()) {
            this.print(out, "-1", EXMSG.examOwnerNotApplicable());
        }
        if (courseNumbers.size() > 1) {
            this.print(out, "-1", "-");
        }
        for (Object[] o : courseNumbers) {
            this.print(out, o[0].toString(), o[1].toString() + " - " + (o[2] == null ? "" : o[2].toString().replaceAll(">", "&gt;").replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;")));
        }
    }

    protected void coumputeSubparts(String courseOfferingId, PrintWriter out) throws Exception {
        if (courseOfferingId == null || courseOfferingId.length() == 0 || courseOfferingId.equals("-")) {
            this.print(out, "0", EXMSG.examOwnerNotApplicable());
            return;
        }
        CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(Long.parseLong(courseOfferingId));
        if (course == null) {
            this.print(out, "0", EXMSG.examOwnerNotApplicable());
            return;
        }
        if (course.isIsControl().booleanValue()) {
            this.print(out, String.valueOf(-9223372036854775807L), EXMSG.examTypeOffering());
        }
        this.print(out, String.valueOf(Long.MIN_VALUE), EXMSG.examTypeCourse());
        if (!course.isIsControl().booleanValue()) {
            return;
        }
        TreeSet configs = new TreeSet(new InstrOfferingConfigComparator(null));
        configs.addAll(new InstrOfferingConfigDAO().getSession().createQuery("select distinct c from InstrOfferingConfig c inner join c.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", course.getUniqueId().longValue()).list());
        TreeSet subparts = new TreeSet(new SchedulingSubpartComparator(null));
        subparts.addAll(new SchedulingSubpartDAO().getSession().createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId").setFetchSize(200).setCacheable(true).setLong("courseOfferingId", course.getUniqueId().longValue()).list());
        if (!configs.isEmpty()) {
            this.print(out, String.valueOf(-9223372036854775806L), EXMSG.sctOwnerTypeConfigurations());
            for (InstrOfferingConfig c : configs) {
                this.print(out, String.valueOf(-c.getUniqueId().longValue()), c.getName() + (c.getInstructionalMethod() == null ? "" : " (" + c.getInstructionalMethod().getLabel() + ")"));
            }
        }
        if (!configs.isEmpty() && !subparts.isEmpty()) {
            this.print(out, String.valueOf(-9223372036854775806L), EXMSG.sctOwnerTypeSubparts());
        }
        for (SchedulingSubpart s : subparts) {
            String id = s.getUniqueId().toString();
            String name = s.getItype().getAbbv();
            String sufix = s.getSchedulingSubpartSuffix();
            while (s.getParentSubpart() != null) {
                name = "_" + name;
                s = s.getParentSubpart();
            }
            if (s.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                name = name + " [" + s.getInstrOfferingConfig().getName() + "]";
            }
            this.print(out, id, name + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")"));
        }
    }

    protected void coumputeClasses(String schedulingSubpartId, String courseId, PrintWriter out) throws Exception {
        SchedulingSubpart subpart;
        if (schedulingSubpartId == null || schedulingSubpartId.length() == 0 || schedulingSubpartId.equals("-")) {
            this.print(out, "-1", EXMSG.examOwnerNotApplicable());
            return;
        }
        SchedulingSubpart schedulingSubpart = subpart = Long.parseLong(schedulingSubpartId) > 0L ? (SchedulingSubpart)new SchedulingSubpartDAO().get(Long.valueOf(schedulingSubpartId)) : null;
        if (subpart == null) {
            this.print(out, "-1", EXMSG.examOwnerNotApplicable());
            return;
        }
        CourseOffering co = null;
        if (courseId != null && !courseId.isEmpty()) {
            co = (CourseOffering)CourseOfferingDAO.getInstance().get(Long.valueOf(courseId));
        }
        TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
        classes.addAll(new Class_DAO().getSession().createQuery("select distinct c from Class_ c where c.schedulingSubpart.uniqueId=:schedulingSubpartId").setFetchSize(200).setCacheable(true).setLong("schedulingSubpartId", Long.parseLong(schedulingSubpartId)).list());
        if (classes.size() > 1) {
            this.print(out, "-1", "-");
        }
        for (Class_ c : classes) {
            String extId = c.getClassSuffix(co);
            this.print(out, c.getUniqueId().toString(), c.getSectionNumberString() + (extId == null || extId.isEmpty() || extId.equalsIgnoreCase(c.getSectionNumberString()) ? "" : " - " + extId));
        }
    }
}

