/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CreateBaseModelFromXml
extends Task {
    private Hashtable<String, String> iParent = new Hashtable();
    private Hashtable<String, String[]> iIds = new Hashtable();
    private Hashtable<String, TreeSet<String>> iClassProperties = new Hashtable();
    private SAXReader iSAXReader = null;
    private String iSource = null;
    private String iConfig = "hibernate.cfg.xml";
    private EntityResolver iEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
            }
            if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
            }
            return null;
        }
    };

    public CreateBaseModelFromXml() throws DocumentException {
        this.iSAXReader = new SAXReader();
        this.iSAXReader.setEntityResolver(this.iEntityResolver);
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public void setConfig(String config) {
        this.iConfig = config;
    }

    protected Document read(String resource) throws IOException, DocumentException {
        if (this.iSource == null) {
            return this.iSAXReader.read(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource));
        }
        return this.iSAXReader.read(new File(this.iSource + File.separator + resource));
    }

    public void convert() throws IOException, DocumentException {
        Element classEl;
        Iterator j;
        String pkg;
        Element resRoot;
        Document resDoc;
        String resource;
        Element m;
        this.info("Config: " + (this.iSource == null ? ((Object)((Object)this)).getClass().getClassLoader().getResource(this.iConfig) : this.iSource + File.separator + this.iConfig));
        File workDir = null;
        if (this.iSource == null) {
            workDir = new File(((Object)((Object)this)).getClass().getClassLoader().getResource(this.iConfig).getFile());
            while (workDir.getParentFile() != null && !"WebContent".equals(workDir.getName())) {
                workDir = workDir.getParentFile();
            }
            workDir = new File(workDir.getParentFile(), "JavaSource");
            workDir.mkdirs();
        } else {
            workDir = new File(this.iSource);
        }
        this.info("Working directory: " + workDir);
        this.info("Reading hibernate.cfg.xml ...");
        Document document = this.read(this.iConfig);
        Element root = document.getRootElement();
        Element sessionFactoryElement = root.element("session-factory");
        Iterator i = sessionFactoryElement.elementIterator("mapping");
        while (i.hasNext()) {
            m = (Element)i.next();
            resource = m.attributeValue("resource");
            if (resource == null) continue;
            this.info("Pre-processing " + resource + " ...");
            resDoc = this.read(resource);
            resRoot = resDoc.getRootElement();
            pkg = resRoot.attributeValue("package");
            j = resRoot.elementIterator("class");
            while (j.hasNext()) {
                classEl = (Element)j.next();
                this.preprocess(classEl, null, pkg);
            }
        }
        i = sessionFactoryElement.elementIterator("mapping");
        while (i.hasNext()) {
            m = (Element)i.next();
            resource = m.attributeValue("resource");
            if (resource == null) continue;
            this.info("Processing " + resource + " ...");
            resDoc = this.read(resource);
            resRoot = resDoc.getRootElement();
            pkg = resRoot.attributeValue("package");
            j = resRoot.elementIterator("class");
            while (j.hasNext()) {
                classEl = (Element)j.next();
                this.importClass(classEl, pkg, workDir, null, null, null, null);
            }
        }
        this.info("All done.");
    }

    private void preprocess(Element classEl, String ext, String pkg) throws IOException {
        Element idEl;
        String className = this.fixType(classEl.attributeValue("name"), pkg);
        if (className.indexOf(46) >= 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        if (ext != null) {
            this.iParent.put(className, ext);
        }
        if ((idEl = classEl.element("id")) != null) {
            String type = this.fixType(idEl.attributeValue("type"), pkg);
            String name = this.fixName(idEl.attributeValue("name"));
            this.iIds.put(className, new String[]{type, name});
        }
        Iterator i = classEl.elementIterator("union-subclass");
        while (i.hasNext()) {
            this.preprocess((Element)i.next(), className, pkg);
        }
        i = classEl.elementIterator("subclass");
        while (i.hasNext()) {
            this.preprocess((Element)i.next(), className, pkg);
        }
    }

    private String fixType(String type, String pkg) {
        if (type == null) {
            return null;
        }
        if (type.startsWith("java.lang.")) {
            return type.substring("java.lang.".length());
        }
        if ("byte[]".equals(type)) {
            return type;
        }
        if (type.indexOf(46) < 0) {
            type = type.substring(0, 1).toUpperCase() + type.substring(1);
        }
        if ("Boolean".equals(type)) {
            return type;
        }
        if ("Long".equals(type)) {
            return type;
        }
        if ("Integer".equals(type)) {
            return type;
        }
        if ("String".equals(type)) {
            return type;
        }
        if ("Float".equals(type)) {
            return type;
        }
        if ("Double".equals(type)) {
            return type;
        }
        if (type.equals("java.sql.Date")) {
            return "java.util.Date";
        }
        if (type.equalsIgnoreCase("java.sql.TimeStamp")) {
            return "java.util.Date";
        }
        if (type.endsWith(".XmlBlobType")) {
            return "org.dom4j.Document";
        }
        if (type.endsWith(".XmlClobType")) {
            return "org.dom4j.Document";
        }
        if (type.startsWith("java.")) {
            return type;
        }
        if (type.indexOf(46) < 0) {
            type = pkg + "." + type;
        }
        return type;
    }

    private String fixName(String name) {
        if (name == null) {
            return null;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private File fileFromPackage(File outputFolder, String pkg) {
        File ret = new File(outputFolder, pkg.replace('.', File.separatorChar));
        ret.mkdirs();
        return ret;
    }

    private void license(PrintWriter pw) {
        pw.println("/*");
        pw.println(" * Licensed to The Apereo Foundation under one or more contributor license");
        pw.println(" * agreements. See the NOTICE file distributed with this work for");
        pw.println(" * additional information regarding copyright ownership.");
        pw.println(" *");
        pw.println(" * The Apereo Foundation licenses this file to you under the Apache License,");
        pw.println(" * Version 2.0 (the \"License\"); you may not use this file except in");
        pw.println(" * compliance with the License. You may obtain a copy of the License at:");
        pw.println(" *");
        pw.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        pw.println(" *");
        pw.println(" * Unless required by applicable law or agreed to in writing, software");
        pw.println(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
        pw.println(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        pw.println(" *");
        pw.println(" * See the License for the specific language governing permissions and");
        pw.println(" * limitations under the License.");
        pw.println(" * ");
        pw.println("*/");
    }

    /*
     * WARNING - void declaration
     */
    private void importClass(Element classEl, String pkg, File outputFolder, String ext, String idClass, String idName, String idType) throws IOException {
        Object x;
        String formula;
        String attribute;
        Object name;
        String type;
        Element el;
        String className = this.fixType(classEl.attributeValue("name"), pkg);
        String table = classEl.attributeValue("table");
        StringWriter attributes = new StringWriter();
        PrintWriter pwa = new PrintWriter(attributes);
        StringWriter props = new StringWriter();
        PrintWriter pwp = new PrintWriter(props);
        StringWriter body = new StringWriter();
        PrintWriter pwb = new PrintWriter(body);
        TreeSet<String> imports = new TreeSet<String>();
        if (className.indexOf(46) >= 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        this.info("  " + className + " ...");
        Vector<String[]> manyToOnes = new Vector<String[]>();
        TreeSet<String> properties = new TreeSet<String>();
        Vector<String[]> compositeId = new Vector<String[]>();
        boolean hasProperty = false;
        Iterator i = classEl.elementIterator("id");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = this.fixType(el.attributeValue("type"), pkg);
            if (type.indexOf(46) >= 0) {
                imports.add(type);
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            name = this.fixName(el.attributeValue("name"));
            String string = el.attributeValue("column").toLowerCase();
            String attribute2 = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
            if ("default".equals(attribute2)) {
                attribute2 = "defaultValue";
            }
            idName = name;
            idType = type;
            pwa.println("\tprivate " + type + " i" + (String)name + ";");
            pwp.println("\tpublic static String PROP_" + string.toUpperCase() + " = \"" + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + "\";");
            properties.add((String)name);
            pwb.println();
            pwb.println("\tpublic " + type + " get" + (String)name + "() { return i" + (String)name + "; }");
            pwb.println("\tpublic void set" + (String)name + "(" + type + " " + attribute2 + ") { i" + (String)name + " = " + attribute2 + "; }");
            hasProperty = true;
        }
        i = classEl.elementIterator("composite-id");
        while (i.hasNext()) {
            Element cidEl = (Element)i.next();
            Iterator j = cidEl.elementIterator("key-many-to-one");
            while (j.hasNext()) {
                void var25_30;
                String name2;
                Element el2 = (Element)j.next();
                String string = this.fixType(el2.attributeValue("class"), pkg);
                if (string.indexOf(46) >= 0) {
                    imports.add(string);
                    String string2 = string.substring(string.lastIndexOf(46) + 1);
                }
                if ("default".equals(attribute = (name2 = this.fixName(el2.attributeValue("name"))).substring(0, 1).toLowerCase() + name2.substring(1))) {
                    attribute = "defaultValue";
                }
                pwa.println("\tprivate " + (String)var25_30 + " i" + name2 + ";");
                properties.add(name2);
                compositeId.add(new String[]{var25_30, name2});
                pwb.println();
                pwb.println("\tpublic " + (String)var25_30 + " get" + name2 + "() { return i" + name2 + "; }");
                pwb.println("\tpublic void set" + name2 + "(" + (String)var25_30 + " " + attribute + ") { i" + name2 + " = " + attribute + "; }");
                hasProperty = true;
            }
            j = cidEl.elementIterator("key-property");
            while (j.hasNext()) {
                void var25_33;
                String name2;
                Element el2 = (Element)j.next();
                String string = this.fixType(el2.attributeValue("type"), pkg);
                if (string.indexOf(46) >= 0) {
                    imports.add(string);
                    String string3 = string.substring(string.lastIndexOf(46) + 1);
                }
                if ("default".equals(attribute = (name2 = this.fixName(el2.attributeValue("name"))).substring(0, 1).toLowerCase() + name2.substring(1))) {
                    attribute = "defaultValue";
                }
                compositeId.add(new String[]{var25_33, name2});
                pwa.println("\tprivate " + (String)var25_33 + " i" + name2 + ";");
                properties.add(name2);
                pwb.println();
                pwb.println("\tpublic " + (String)var25_33 + " get" + name2 + "() { return i" + name2 + "; }");
                pwb.println("\tpublic void set" + name2 + "(" + (String)var25_33 + " " + attribute + ") { i" + name2 + " = " + attribute + "; }");
                hasProperty = true;
            }
        }
        i = classEl.elementIterator("property");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = this.fixType(el.attributeValue("type"), pkg);
            if (type.indexOf(46) >= 0) {
                imports.add(type);
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            name = this.fixName(el.attributeValue("name"));
            String string = el.attributeValue("column");
            formula = el.attributeValue("formula");
            attribute = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
            if ("default".equals(attribute)) {
                attribute = "defaultValue";
            }
            if (string != null) {
                pwa.println("\tprivate " + type + " i" + (String)name + ";");
                properties.add((String)name);
                pwb.println();
                pwp.println("\tpublic static String PROP_" + string.toUpperCase() + " = \"" + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + "\";");
                if (type.equals("Boolean")) {
                    pwb.println("\tpublic " + type + " is" + (String)name + "() { return i" + (String)name + "; }");
                }
                pwb.println("\tpublic " + type + " get" + (String)name + "() { return i" + (String)name + "; }");
                pwb.println("\tpublic void set" + (String)name + "(" + type + " " + attribute + ") { i" + (String)name + " = " + attribute + "; }");
            } else if (formula != null) {
                pwa.println("\tprivate " + type + " i" + (String)name + ";");
                pwb.println();
                if (type.equals("Boolean")) {
                    pwb.println("\tpublic " + type + " is" + (String)name + "() { return i" + (String)name + "; }");
                }
                pwb.println("\tpublic " + type + " get" + (String)name + "() { return i" + (String)name + "; }");
                pwb.println("\tpublic void set" + (String)name + "(" + type + " " + attribute + ") { i" + (String)name + " = " + attribute + "; }");
            } else {
                System.err.println("Unknown " + el.getName() + ": " + el.asXML());
            }
            hasProperty = true;
        }
        if (hasProperty) {
            pwa.println();
        }
        i = classEl.elementIterator("many-to-one");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = this.fixType(el.attributeValue("class"), pkg);
            if (type.indexOf(46) >= 0) {
                imports.add(type);
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            name = this.fixName(el.attributeValue("name"));
            String string = el.attributeValue("column");
            formula = el.attributeValue("formula");
            if (string != null) {
                pwa.println("\tprivate " + type + " i" + (String)name + ";");
                properties.add((String)name);
                pwb.println();
                manyToOnes.add(new String[]{type, name});
                pwb.println("\tpublic " + type + " get" + (String)name + "() { return i" + (String)name + "; }");
                pwb.println("\tpublic void set" + (String)name + "(" + type + " " + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + ") { i" + (String)name + " = " + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + "; }");
                continue;
            }
            if (formula != null) {
                pwa.println("\tprivate " + type + " i" + (String)name + ";");
                pwb.println();
                pwb.println("\tpublic " + type + " get" + (String)name + "() { return i" + (String)name + "; }");
                pwb.println("\tpublic void set" + (String)name + "(" + type + " " + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + ") { i" + (String)name + " = " + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + "; }");
                continue;
            }
            System.err.println("Unknown " + el.getName() + ": " + el.asXML());
        }
        i = classEl.elementIterator("set");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = null;
            name = this.fixName(el.attributeValue("name"));
            pwb.println();
            if (el.element("many-to-many") != null) {
                type = this.fixType(el.element("many-to-many").attributeValue("class"), pkg);
                if (type.indexOf(46) >= 0) {
                    imports.add(type);
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
            } else if (el.element("one-to-many") != null) {
                type = this.fixType(el.element("one-to-many").attributeValue("class"), pkg);
                if (type.indexOf(46) >= 0) {
                    imports.add(type);
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
            } else if (el.element("element") != null) {
                type = this.fixType(el.element("element").attributeValue("type"), pkg);
                if (type.indexOf(46) >= 0) {
                    imports.add(type);
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
            } else {
                System.err.println("Unknown type of set");
            }
            if (type.indexOf(46) >= 0) {
                imports.add(type);
            }
            imports.add("java.util.Set");
            imports.add("java.util.HashSet");
            pwa.println("\tprivate Set<" + type + "> i" + (String)name + ";");
            pwb.println("\tpublic Set<" + type + "> get" + (String)name + "() { return i" + (String)name + "; }");
            pwb.println("\tpublic void set" + (String)name + "(Set<" + type + "> " + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + ") { i" + (String)name + " = " + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + "; }");
            pwb.println("\tpublic void addTo" + ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1) + "(" + type + " " + type.substring(0, 1).toLowerCase() + type.substring(1) + ") {");
            pwb.println("\t\tif (i" + (String)name + " == null) i" + (String)name + " = new HashSet<" + type + ">();");
            pwb.println("\t\ti" + (String)name + ".add(" + type.substring(0, 1).toLowerCase() + type.substring(1) + ");");
            pwb.println("\t}");
        }
        pwa.flush();
        pwa.close();
        pwb.flush();
        pwb.close();
        pwp.flush();
        pwp.close();
        imports.add("java.io.Serializable");
        boolean abs = "true".equals(classEl.attributeValue("abstract", "false"));
        ext = this.fixType(ext, pkg);
        if (ext != null && ext.indexOf(46) >= 0) {
            imports.add(ext);
            ext = ext.substring(ext.lastIndexOf(46) + 1);
        }
        if (idName != null || !compositeId.isEmpty()) {
            imports.add(this.fixType(classEl.attributeValue("name"), pkg));
        }
        PrintWriter pw = new PrintWriter(new FileWriter(new File(this.fileFromPackage(outputFolder, pkg + ".base"), "Base" + className + ".java")));
        this.license(pw);
        pw.println("package " + pkg + ".base;");
        pw.println();
        String last = null;
        for (String string : imports) {
            String top = string.substring(0, string.indexOf(46));
            if (last != null && !last.equals(top)) {
                pw.println();
            }
            pw.println("import " + string + ";");
            last = top;
        }
        pw.println();
        pw.println("/**");
        pw.println(" * Do not change this class. It has been automatically generated using ant create-model.");
        pw.println(" * @see org.unitime.commons.ant.CreateBaseModelFromXml");
        pw.println(" */");
        pw.println("public abstract class Base" + className + (ext == null ? "" : " extends " + ext) + " implements Serializable {");
        pw.println("\tprivate static final long serialVersionUID = 1L;");
        pw.println();
        pw.print(attributes.getBuffer());
        pw.println();
        pw.print(props.getBuffer());
        pw.println();
        pw.println("\tpublic Base" + className + "() {");
        pw.println("\t\tinitialize();");
        pw.println("\t}");
        if (idName != null) {
            x = idName.substring(0, 1).toLowerCase() + idName.substring(1);
            pw.println();
            pw.println("\tpublic Base" + className + "(" + idType + " " + (String)x + ") {");
            pw.println("\t\tset" + idName + "(" + (String)x + ");");
            pw.println("\t\tinitialize();");
            pw.println("\t}");
        }
        pw.println();
        pw.println("\tprotected void initialize() {}");
        pw.print(body.getBuffer());
        this.iClassProperties.put(className, properties);
        if (ext != null && this.iClassProperties.containsKey(ext)) {
            properties.addAll((Collection)this.iClassProperties.get(ext));
        }
        if (idName != null) {
            if (idClass == null) {
                idClass = className;
            }
            pw.println();
            pw.println("\tpublic boolean equals(Object o) {");
            pw.println("\t\tif (o == null || !(o instanceof " + className + ")) return false;");
            pw.println("\t\tif (get" + idName + "() == null || ((" + className + ")o).get" + idName + "() == null) return false;");
            pw.println("\t\treturn get" + idName + "().equals(((" + className + ")o).get" + idName + "());");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic int hashCode() {");
            pw.println("\t\tif (get" + idName + "() == null) return super.hashCode();");
            pw.println("\t\treturn get" + idName + "().hashCode();");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic String toString() {");
            if (properties.contains("Name")) {
                pw.println("\t\treturn \"" + className + "[\"+get" + idName + "()+\" \"+getName()+\"]\";");
            } else if (properties.contains("Label")) {
                pw.println("\t\treturn \"" + className + "[\"+get" + idName + "()+\" \"+getLabel()+\"]\";");
            } else {
                pw.println("\t\treturn \"" + className + "[\"+get" + idName + "()+\"]\";");
            }
            pw.println("\t}");
        } else if (!compositeId.isEmpty()) {
            void var25_42;
            x = className.substring(0, 1).toLowerCase() + className.substring(1);
            pw.println();
            pw.println("\tpublic boolean equals(Object o) {");
            pw.println("\t\tif (o == null || !(o instanceof " + className + ")) return false;");
            pw.println("\t\t" + className + " " + (String)x + " = (" + className + ")o;");
            for (String[] typeName : compositeId) {
                String name3 = typeName[1];
                pw.println("\t\tif (get" + (String)name3 + "() == null || " + (String)x + ".get" + (String)name3 + "() == null || !get" + (String)name3 + "().equals(" + (String)x + ".get" + (String)name3 + "())) return false;");
            }
            pw.println("\t\treturn true;");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic int hashCode() {");
            String string = "";
            String isNull = "";
            for (String[] stringArray : compositeId) {
                void var25_44;
                String name4 = stringArray[1];
                if (!var25_42.isEmpty()) {
                    String string4 = (String)var25_42 + " ^ ";
                    isNull = isNull + " || ";
                }
                String string5 = (String)var25_44 + "get" + name4 + "().hashCode()";
                isNull = isNull + "get" + name4 + "() == null";
            }
            pw.println("\t\tif (" + isNull + ") return super.hashCode();");
            pw.println("\t\treturn " + (String)var25_42 + ";");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic String toString() {");
            String names = "";
            for (String[] typeName : compositeId) {
                String name5 = typeName[1];
                if (!names.isEmpty()) {
                    names = names + " + \", \" + ";
                }
                names = names + "get" + name5 + "()";
            }
            pw.println("\t\treturn \"" + className + "[\" + " + names + " + \"]\";");
            pw.println("\t}");
        }
        pw.println();
        pw.println("\tpublic String toDebugString() {");
        pw.println("\t\treturn \"" + className + "[\" +");
        for (String string : properties) {
            pw.println("\t\t\t\"\\n\t" + string + ": \" + get" + string + "() +");
        }
        pw.println("\t\t\t\"]\";");
        pw.println("\t}");
        pw.println("}");
        pw.flush();
        pw.close();
        Iterator i2 = classEl.elementIterator("union-subclass");
        while (i2.hasNext()) {
            this.importClass((Element)i2.next(), pkg, outputFolder, className, idClass, idName, idType);
        }
        Iterator i3 = classEl.elementIterator("subclass");
        while (i3.hasNext()) {
            this.importClass((Element)i3.next(), pkg, outputFolder, className, idClass, idName, idType);
        }
        File mainFile = new File(this.fileFromPackage(outputFolder, pkg), className + ".java");
        if (!mainFile.exists()) {
            pw = new PrintWriter(new FileWriter(mainFile));
            this.license(pw);
            pw.println("package " + pkg + ";");
            pw.println();
            pw.println("import " + pkg + ".base.Base" + className + ";");
            pw.println();
            pw.println("public" + (abs ? " abstract" : "") + " class " + className + " extends Base" + className + " {");
            pw.println();
            pw.println("\tpublic " + className + "() {");
            pw.println("\t\tsuper();");
            pw.println("\t}");
            pw.println();
            pw.println("}");
            pw.flush();
            pw.close();
        }
        pw = new PrintWriter(new FileWriter(new File(this.fileFromPackage(outputFolder, pkg + ".base"), "Base" + className + "DAO.java")));
        this.license(pw);
        pw.println("package " + pkg + ".base;");
        pw.println();
        if (idType == null) {
            pw.println("import java.io.Serializable;");
        }
        if (!manyToOnes.isEmpty()) {
            pw.println("import java.util.List;");
        }
        if (idType == null || !manyToOnes.isEmpty()) {
            pw.println();
        }
        pw.println("import " + pkg + "." + className + ";");
        pw.println("import " + pkg + ".dao._RootDAO;");
        pw.println("import " + pkg + ".dao." + className + "DAO;");
        pw.println();
        pw.println("/**");
        pw.println(" * Do not change this class. It has been automatically generated using ant create-model.");
        pw.println(" * @see org.unitime.commons.ant.CreateBaseModelFromXml");
        pw.println(" */");
        pw.println("public abstract class Base" + className + "DAO extends _RootDAO<" + className + "," + (idType == null ? "Serializable" : idType) + "> {");
        pw.println();
        pw.println("\tprivate static " + className + "DAO sInstance;");
        pw.println();
        pw.println("\tpublic static " + className + "DAO getInstance() {");
        pw.println("\t\tif (sInstance == null) sInstance = new " + className + "DAO();");
        pw.println("\t\treturn sInstance;");
        pw.println("\t}");
        pw.println();
        pw.println("\tpublic Class<" + className + "> getReferenceClass() {");
        pw.println("\t\treturn " + className + ".class;");
        pw.println("\t}");
        for (String[] attr : manyToOnes) {
            String type3 = attr[0];
            String string = attr[1];
            String x2 = string.substring(0, 1).toLowerCase() + string.substring(1);
            String[] id = this.iIds.get(type3);
            String iType = "Long";
            String iName = "UniqueId";
            if (id != null) {
                iType = id[0];
                iName = id[1];
            }
            pw.println();
            pw.println("\t@SuppressWarnings(\"unchecked\")");
            pw.println("\tpublic List<" + className + "> findBy" + string + "(org.hibernate.Session hibSession, " + iType + " " + x2 + "Id) {");
            pw.println("\t\treturn hibSession.createQuery(\"from " + className + " x where x." + x2 + "." + iName.substring(0, 1).toLowerCase() + iName.substring(1) + " = :" + x2 + "Id\").set" + iType + "(\"" + x2 + "Id\", " + x2 + "Id).list();");
            pw.println("\t}");
        }
        pw.println("}");
        pw.flush();
        pw.close();
        File file = new File(this.fileFromPackage(outputFolder, pkg + ".dao"), className + "DAO.java");
        if (!file.exists()) {
            pw = new PrintWriter(new FileWriter(file));
            this.license(pw);
            pw.println("package " + pkg + ".dao;");
            pw.println();
            pw.println("import " + pkg + ".base.Base" + className + "DAO;");
            pw.println();
            pw.println("public" + (abs ? " abstract" : "") + " class " + className + "DAO extends Base" + className + "DAO {");
            pw.println();
            pw.println("\tpublic " + className + "DAO() {}");
            pw.println();
            pw.println("}");
            pw.flush();
            pw.close();
        }
    }

    public void execute() throws BuildException {
        try {
            this.convert();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void info(String message) {
        try {
            this.log(message);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public void warn(String message) {
        try {
            this.log(message, 1);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) {
        try {
            new CreateBaseModelFromXml().convert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

