/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDistributionPref;
import org.unitime.timetable.model.base.BaseInstructorCoursePref;
import org.unitime.timetable.model.base.BasePreferenceLevel;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class InstructorListBuilder {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String htmlTableForInstructor(SessionContext context, String deptId, int order, String backId) {
        int i;
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(context.getUser());
        boolean gridAsText = RequiredTimeTable.getTimeGridAsText(context.getUser());
        String timeGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        List<DepartmentalInstructor> list = null;
        list = deptId.equals(Constants.ALL_OPTION_VALUE) ? DepartmentalInstructor.findInstructorsForSession(context.getUser().getCurrentAcademicSessionId()) : DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
        if (list == null || list.size() == 0) {
            return null;
        }
        boolean hasCoursePrefs = false;
        boolean hasTeachPref = false;
        boolean hasMaxLoad = false;
        boolean hasUnavailableDates = false;
        TreeSet<InstructorAttributeType> attributeTypes = new TreeSet<InstructorAttributeType>(new Comparator<InstructorAttributeType>(){

            @Override
            public int compare(InstructorAttributeType o1, InstructorAttributeType o2) {
                return o1.getReference().compareTo(o2.getReference());
            }
        });
        for (DepartmentalInstructor di : list) {
            if (!di.getPreferences(InstructorCoursePref.class).isEmpty()) {
                hasCoursePrefs = true;
            }
            if (di.getMaxLoad() != null && di.getMaxLoad().floatValue() > 0.0f) {
                hasMaxLoad = true;
            }
            if (di.hasUnavailabilities()) {
                hasUnavailableDates = true;
            }
            if (di.getTeachingPreference() != null && !PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) {
                hasTeachPref = true;
            }
            for (InstructorAttribute at : di.getAttributes()) {
                if (at.getType() == null) continue;
                attributeTypes.add(at.getType());
            }
        }
        String[] fixedHeaders1 = new String[]{MSG.columnExternalId(), MSG.columnInstructorName(), MSG.columnInstructorPosition(), MSG.columnInstructorNote(), MSG.columnPreferences() + "<BR>" + MSG.columnTimePref(), "<BR>" + MSG.columnRoomPref(), "<BR>" + MSG.columnDistributionPref()};
        String[] fixedHeaders2 = new String[]{MSG.columnInstructorClassAssignments(), MSG.columnInstructorExamAssignments(), MSG.columnInstructorIgnoreTooFar()};
        String[] headers = new String[fixedHeaders1.length + (hasCoursePrefs ? 1 : 0) + (hasTeachPref ? 1 : 0) + (hasMaxLoad ? 1 : 0) + (hasUnavailableDates ? 1 : 0) + attributeTypes.size() + fixedHeaders2.length];
        String[] aligns = new String[headers.length];
        boolean[] asc = new boolean[headers.length];
        int idx = 0;
        Object stringArray = fixedHeaders1;
        int n = ((String[])stringArray).length;
        for (i = 0; i < n; ++i) {
            String string;
            headers[idx] = string = stringArray[i];
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasCoursePrefs) {
            headers[idx] = "<BR>" + MSG.columnCoursePref();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasTeachPref) {
            headers[idx] = MSG.columnTeachingPreference();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasUnavailableDates) {
            headers[idx] = MSG.columnUnavailableDates();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasMaxLoad) {
            headers[idx] = MSG.columnMaxTeachingLoad();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        for (InstructorAttributeType at : attributeTypes) {
            headers[idx] = at.getReference();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        stringArray = fixedHeaders2;
        int at = ((Object)stringArray).length;
        for (i = 0; i < at; ++i) {
            Object object;
            headers[idx] = object = stringArray[i];
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        WebTable webTable = new WebTable(headers.length, "", "instructorSearch.action?order=%%&deptId=" + deptId, headers, aligns, asc);
        webTable.setRowStyle("white-space:nowrap;");
        webTable.enableHR("#9CB0CE");
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        String instructorSortOrder = UserProperty.SortNames.get(context.getUser());
        for (DepartmentalInstructor di : list) {
            String[] line = new String[headers.length];
            Comparable[] cmp = new Comparable[headers.length];
            idx = 0;
            if (di.getExternalUniqueId() != null && di.getExternalUniqueId().trim().length() > 0) {
                line[idx] = di.getExternalUniqueId();
                cmp[idx] = di.getExternalUniqueId();
            } else {
                line[idx] = "<center><img src='images/error.png' border='0' alt='" + MSG.altNotAvailableExternalId() + "' title='" + MSG.titleInstructorExternalIdNotSupplied() + "'></center>";
                cmp[idx] = "";
            }
            line[++idx] = Constants.toInitialCase(di.getName(instructorNameFormat), "-".toCharArray());
            cmp[idx] = CommonValues.SortAsDisplayed.eq(instructorSortOrder) ? line[idx].toLowerCase() : di.nameLastNameFirst().toLowerCase();
            ++idx;
            if (di.getPositionType() != null) {
                line[idx] = di.getPositionType().getLabel();
                cmp[idx] = di.getPositionType().getSortOrder();
            } else {
                line[idx] = MSG.instructorPositionNotSpecified();
                cmp[idx] = Integer.valueOf(Integer.MAX_VALUE);
            }
            ++idx;
            if (di.getNote() != null) {
                line[idx] = di.getNote();
                cmp[idx] = di.getNote();
            } else {
                line[idx] = "";
                cmp[idx] = "";
            }
            ++idx;
            StringBuffer timePref = new StringBuffer();
            if (di.getTimePreferences() != null) {
                try {
                    for (TimePref tp : di.getTimePreferences()) {
                        RequiredTimeTable rtt = tp.getRequiredTimeTable();
                        if (gridAsText) {
                            timePref.append("<span onmouseover=\"showGwtInstructorAvailabilityHint(this, '" + di.getUniqueId() + "');\" onmouseout=\"hideGwtInstructorAvailabilityHint();\">" + rtt.getModel().toString().replaceAll(", ", "<br>") + "</span>");
                            continue;
                        }
                        rtt.getModel().setDefaultSelection(timeGridSize);
                        timePref.append("<img border='0' onmouseover=\"showGwtInstructorAvailabilityHint(this, '" + di.getUniqueId() + "');\" onmouseout=\"hideGwtInstructorAvailabilityHint();\" src='pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&p=" + rtt.getModel().getPreferences() + "' title='" + rtt.getModel().toString() + "' >&nbsp;");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            line[idx] = timePref.toString();
            line[++idx] = "";
            String x = di.getEffectivePrefHtmlForPrefType(RoomPref.class);
            if (x != null && !x.trim().isEmpty()) {
                int n2 = idx;
                line[n2] = line[n2] + x;
            }
            if ((x = di.getEffectivePrefHtmlForPrefType(BuildingPref.class)) != null && !x.trim().isEmpty()) {
                if (!line[idx].isEmpty()) {
                    int n3 = idx;
                    line[n3] = line[n3] + "<br>";
                }
                int n4 = idx;
                line[n4] = line[n4] + x;
            }
            if ((x = di.getEffectivePrefHtmlForPrefType(RoomFeaturePref.class)) != null && !x.trim().isEmpty()) {
                if (!line[idx].isEmpty()) {
                    int n5 = idx;
                    line[n5] = line[n5] + "<br>";
                }
                int n6 = idx;
                line[n6] = line[n6] + x;
            }
            if ((x = di.getEffectivePrefHtmlForPrefType(RoomGroupPref.class)) != null && !x.trim().isEmpty()) {
                if (!line[idx].isEmpty()) {
                    int n7 = idx;
                    line[n7] = line[n7] + "<br>";
                }
                int n8 = idx;
                line[n8] = line[n8] + x;
            }
            line[++idx] = di.getEffectivePrefHtmlForPrefType(DistributionPref.class);
            ++idx;
            if (hasCoursePrefs) {
                line[idx] = di.getEffectivePrefHtmlForPrefType(InstructorCoursePref.class);
                ++idx;
            }
            if (hasTeachPref) {
                Object pref = di.getTeachingPreference();
                if (pref == null) {
                    pref = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited);
                }
                line[idx] = "<span style='font-weight:bold; color:" + PreferenceLevel.prolog2color(((BasePreferenceLevel)pref).getPrefProlog()) + ";' title='" + ((BasePreferenceLevel)pref).getPrefName() + "'>" + ((BasePreferenceLevel)pref).getPrefName() + "</span>";
                cmp[idx] = ((BasePreferenceLevel)pref).getPrefId();
                ++idx;
            }
            if (hasUnavailableDates) {
                line[idx] = di.hasUnavailabilities() ? di.getUnavailableDaysText("<br>") : "";
                cmp[idx] = line[idx];
                ++idx;
            }
            if (hasMaxLoad) {
                if (di.getMaxLoad() == null) {
                    line[idx] = "";
                    cmp[idx] = Float.valueOf(0.0f);
                } else {
                    line[idx] = Formats.getNumberFormat("0.##").format(di.getMaxLoad());
                    cmp[idx] = di.getMaxLoad();
                }
                ++idx;
            }
            for (InstructorAttributeType at2 : attributeTypes) {
                line[idx] = "";
                for (InstructorAttribute a : di.getAttributes(at2)) {
                    if (!line[idx].isEmpty()) {
                        int n9 = idx;
                        line[n9] = line[n9] + "<br>";
                    }
                    int n10 = idx;
                    line[n10] = line[n10] + "<span title='" + a.getName() + "'>" + a.getCode() + "</span>";
                }
                cmp[idx] = line[idx];
                ++idx;
            }
            TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
            classes.addAll(di.getClasses());
            line[idx] = "";
            Iterator i2 = classes.iterator();
            while (i2.hasNext()) {
                String className;
                ClassInstructor ci = (ClassInstructor)i2.next();
                Class_ c = ci.getClassInstructing();
                String title = className = c.getClassLabel();
                if (c.isCancelled().booleanValue()) {
                    title = MSG.classNoteCancelled(c.getClassLabel());
                }
                title = title + " (" + ci.getPercentShare() + "%" + (ci.isLead() != false ? ", " + MSG.titleCheckConflicts() : "") + ")";
                if (!c.isDisplayInstructor().booleanValue()) {
                    title = title + " - " + MSG.titleDoNotDisplayInstructor();
                }
                if (c.isCancelled().booleanValue()) {
                    int n11 = idx;
                    line[n11] = line[n11] + "<span style='color: gray; text-decoration: line-through;" + (ci.isLead() != false ? "font-weight:bold;" : "") + (c.isDisplayInstructor() != false ? "" : "font-style:italic;") + "' title='" + title + "'>";
                } else if (ci.isLead().booleanValue()) {
                    int n12 = idx;
                    line[n12] = line[n12] + "<span style='font-weight:bold;" + (c.isDisplayInstructor() != false ? "" : "font-style:italic;") + "' title='" + title + "'>";
                } else {
                    int n13 = idx;
                    line[n13] = line[n13] + "<span title='" + title + "'>";
                }
                int n14 = idx;
                line[n14] = line[n14] + className;
                int n15 = idx;
                line[n15] = line[n15] + "</span>";
                if (!i2.hasNext()) continue;
                int n16 = idx;
                line[n16] = line[n16] + "<br>";
            }
            TreeSet<Exam> exams = new TreeSet<Exam>(di.getExams());
            line[++idx] = "";
            Iterator<Exam> i22 = exams.iterator();
            while (i22.hasNext()) {
                Exam exam = i22.next();
                if (!context.hasPermission(exam, Right.ExaminationView)) continue;
                String examName = exam.getLabel();
                if (exam.getExamType().getType() == 1) {
                    int n17 = idx;
                    line[n17] = line[n17] + "<span title='" + examName + " " + MSG.titleMidtermExamination() + "'>" + examName + "</span>";
                } else {
                    int n18 = idx;
                    line[n18] = line[n18] + "<span style='font-weight:bold;' title='" + examName + " " + MSG.titleFinalExamination() + "'>" + examName + "</span>";
                }
                if (!i22.hasNext()) continue;
                int n19 = idx;
                line[n19] = line[n19] + "<br>";
            }
            ++idx;
            if (di.isIgnoreToFar() != null && di.isIgnoreToFar().booleanValue()) {
                line[idx] = "<img border='0' title='" + MSG.titleIgnoreTooFarDistances() + "' alt='true' align='absmiddle' src='images/accept.png'>";
                cmp[idx] = Boolean.valueOf(true);
            } else {
                line[idx] = "";
                cmp[idx] = Boolean.valueOf(false);
            }
            ++idx;
            boolean back = di.getUniqueId().toString().equals(backId);
            if (back) {
                line[0] = "<A name=\"back\"></A>" + line[0];
            }
            webTable.addLine("onClick=\"document.location='instructorDetail.action?instructorId=" + di.getUniqueId() + "&deptId=" + deptId + "';\"", line, cmp);
        }
        String string = webTable.printTable(order);
        return string;
    }

    public PdfWebTable pdfTableForInstructor(SessionContext context, String deptId, boolean canHaveImages) {
        int i;
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(context.getUser());
        boolean gridAsText = RequiredTimeTable.getTimeGridAsText(context.getUser());
        String timeGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
        List<DepartmentalInstructor> list = null;
        list = deptId.equals(Constants.ALL_OPTION_VALUE) ? DepartmentalInstructor.findInstructorsForSession(context.getUser().getCurrentAcademicSessionId()) : DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
        if (list == null || list.size() == 0) {
            return null;
        }
        boolean hasCoursePrefs = false;
        boolean hasTeachPref = false;
        boolean hasMaxLoad = false;
        boolean hasUnavailableDates = false;
        TreeSet<InstructorAttributeType> attributeTypes = new TreeSet<InstructorAttributeType>(new Comparator<InstructorAttributeType>(){

            @Override
            public int compare(InstructorAttributeType o1, InstructorAttributeType o2) {
                return o1.getReference().compareTo(o2.getReference());
            }
        });
        for (DepartmentalInstructor di : list) {
            if (!di.getPreferences(InstructorCoursePref.class).isEmpty()) {
                hasCoursePrefs = true;
            }
            if (di.getMaxLoad() != null && di.getMaxLoad().floatValue() > 0.0f) {
                hasMaxLoad = true;
            }
            if (di.hasUnavailabilities()) {
                hasUnavailableDates = true;
            }
            if (di.getTeachingPreference() != null && !PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) {
                hasTeachPref = true;
            }
            for (InstructorAttribute at : di.getAttributes()) {
                if (at.getType() == null) continue;
                attributeTypes.add(at.getType());
            }
        }
        String[] fixedHeaders1 = new String[]{MSG.columnExternalId(), MSG.columnInstructorName(), MSG.columnInstructorPosition(), MSG.columnInstructorNote(), MSG.columnPreferences() + "\n" + MSG.columnTimePref(), "\n" + MSG.columnRoomPref(), "\n" + MSG.columnDistributionPref()};
        String[] fixedHeaders2 = new String[]{MSG.columnInstructorClassAssignmentsPDF(), MSG.columnInstructorExamAssignmentsPDF(), MSG.columnInstructorIgnoreTooFarPDF()};
        String[] headers = new String[fixedHeaders1.length + (hasCoursePrefs ? 1 : 0) + (hasTeachPref ? 1 : 0) + (hasMaxLoad ? 1 : 0) + (hasUnavailableDates ? 1 : 0) + attributeTypes.size() + fixedHeaders2.length];
        String[] aligns = new String[headers.length];
        boolean[] asc = new boolean[headers.length];
        int idx = 0;
        Object stringArray = fixedHeaders1;
        int n = ((String[])stringArray).length;
        for (i = 0; i < n; ++i) {
            String string;
            headers[idx] = string = stringArray[i];
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasCoursePrefs) {
            headers[idx] = "\n" + MSG.columnCoursePref();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasTeachPref) {
            headers[idx] = MSG.columnTeachingPreferencePDF();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasUnavailableDates) {
            headers[idx] = MSG.columnUnavailableDatesPDF();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        if (hasMaxLoad) {
            headers[idx] = MSG.columnMaxTeachingLoadPDF();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        for (InstructorAttributeType at : attributeTypes) {
            headers[idx] = at.getReference();
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        stringArray = fixedHeaders2;
        int at = ((Object)stringArray).length;
        for (i = 0; i < at; ++i) {
            Object object;
            headers[idx] = object = stringArray[i];
            aligns[idx] = "left";
            asc[idx] = true;
            ++idx;
        }
        PdfWebTable webTable = new PdfWebTable(headers.length, MSG.sectionTitleInstructorList(), null, headers, aligns, asc);
        String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
        String instructorSortOrder = UserProperty.SortNames.get(context.getUser());
        for (DepartmentalInstructor di : list) {
            String[] line = new String[headers.length];
            Comparable[] cmp = new Comparable[headers.length];
            idx = 0;
            if (di.getExternalUniqueId() != null && di.getExternalUniqueId().trim().length() > 0) {
                line[idx] = di.getExternalUniqueId();
                cmp[idx] = di.getExternalUniqueId();
            } else {
                line[idx] = "@@ITALIC " + MSG.instructorExternalIdNotSpecified();
                cmp[idx] = "";
            }
            line[++idx] = Constants.toInitialCase(di.getName(instructorNameFormat), "-".toCharArray());
            cmp[idx] = CommonValues.SortAsDisplayed.eq(instructorSortOrder) ? line[idx].toLowerCase() : di.nameLastNameFirst().toLowerCase();
            ++idx;
            if (di.getPositionType() != null) {
                line[idx] = di.getPositionType().getLabel();
                cmp[idx] = di.getPositionType().getSortOrder();
            } else {
                line[idx] = "@@ITALIC " + MSG.instructorPositionNotSpecified();
                cmp[idx] = Integer.valueOf(Integer.MAX_VALUE);
            }
            ++idx;
            if (di.getNote() != null) {
                line[idx] = di.getNote();
                cmp[idx] = di.getNote();
            } else {
                line[idx] = "";
                cmp[idx] = "";
            }
            ++idx;
            StringBuffer timePref = new StringBuffer();
            if (di.getTimePreferences() != null) {
                Iterator i2 = di.getTimePreferences().iterator();
                while (i2.hasNext()) {
                    TimePref tp = (TimePref)i2.next();
                    RequiredTimeTable rtt = tp.getRequiredTimeTable();
                    if (gridAsText || !canHaveImages) {
                        timePref.append(rtt.getModel().toString().replaceAll(", ", "\n"));
                        continue;
                    }
                    rtt.getModel().setDefaultSelection(timeGridSize);
                    BufferedImage image = rtt.createBufferedImage(timeVertical);
                    if (image != null) {
                        webTable.addImage(tp.getUniqueId().toString(), image);
                        timePref.append("@@IMAGE " + tp.getUniqueId().toString() + " ");
                    } else {
                        timePref.append(rtt.getModel().toString().replaceAll(", ", "\n"));
                    }
                    if (!i2.hasNext()) continue;
                    timePref.append("\n");
                }
            }
            line[idx] = timePref.toString();
            line[++idx] = "";
            for (RoomPref rp : di.effectivePreferences(RoomPref.class)) {
                if (!line[idx].isEmpty()) {
                    int n2 = idx;
                    line[n2] = line[n2] + "\n";
                }
                int n3 = idx;
                line[n3] = line[n3] + "@@COLOR " + PreferenceLevel.prolog2color(rp.getPrefLevel().getPrefProlog()) + " " + rp.getPrefLevel().getAbbreviation() + " " + rp.getRoom().getLabel();
            }
            for (BuildingPref bp : di.effectivePreferences(BuildingPref.class)) {
                if (!line[idx].isEmpty()) {
                    int n4 = idx;
                    line[n4] = line[n4] + "\n";
                }
                int n5 = idx;
                line[n5] = line[n5] + "@@COLOR " + PreferenceLevel.prolog2color(bp.getPrefLevel().getPrefProlog()) + " " + bp.getPrefLevel().getAbbreviation() + " " + bp.getBuilding().getAbbreviation();
            }
            for (RoomFeaturePref rfp : di.effectivePreferences(RoomFeaturePref.class)) {
                if (!line[idx].isEmpty()) {
                    int n6 = idx;
                    line[n6] = line[n6] + "\n";
                }
                int n7 = idx;
                line[n7] = line[n7] + "@@COLOR " + PreferenceLevel.prolog2color(rfp.getPrefLevel().getPrefProlog()) + " " + rfp.getPrefLevel().getAbbreviation() + " " + rfp.getRoomFeature().getLabel();
            }
            for (RoomGroupPref rgp : di.effectivePreferences(RoomGroupPref.class)) {
                if (!line[idx].isEmpty()) {
                    int n8 = idx;
                    line[n8] = line[n8] + "\n";
                }
                int n9 = idx;
                line[n9] = line[n9] + "@@COLOR " + PreferenceLevel.prolog2color(rgp.getPrefLevel().getPrefProlog()) + " " + rgp.getPrefLevel().getAbbreviation() + " " + rgp.getRoomGroup().getName();
            }
            line[++idx] = "";
            for (Preference dp : di.effectivePreferences(DistributionPref.class)) {
                if (!line[idx].isEmpty()) {
                    int n10 = idx;
                    line[n10] = line[n10] + "\n";
                }
                int n11 = idx;
                line[n11] = line[n11] + "@@COLOR " + PreferenceLevel.prolog2color(dp.getPrefLevel().getPrefProlog()) + " " + dp.getPrefLevel().getAbbreviation() + " " + ((BaseDistributionPref)dp).getDistributionType().getAbbreviation();
            }
            ++idx;
            if (hasCoursePrefs) {
                line[idx] = "";
                for (Preference dp : di.effectivePreferences(InstructorCoursePref.class)) {
                    if (!line[idx].isEmpty()) {
                        int n12 = idx;
                        line[n12] = line[n12] + "\n";
                    }
                    int n13 = idx;
                    line[n13] = line[n13] + "@@COLOR " + PreferenceLevel.prolog2color(dp.getPrefLevel().getPrefProlog()) + " " + dp.getPrefLevel().getAbbreviation() + " " + ((BaseInstructorCoursePref)dp).getCourse().getCourseName();
                }
                ++idx;
            }
            if (hasTeachPref) {
                Object pref = di.getTeachingPreference();
                if (pref == null) {
                    pref = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited);
                }
                line[idx] = "@@COLOR " + PreferenceLevel.prolog2color(((BasePreferenceLevel)pref).getPrefProlog()) + " " + ((BasePreferenceLevel)pref).getPrefName();
                cmp[idx] = ((BasePreferenceLevel)pref).getPrefId();
                ++idx;
            }
            if (hasUnavailableDates) {
                line[idx] = di.hasUnavailabilities() ? di.getUnavailableDaysText("\n") : "";
                cmp[idx] = line[idx];
                ++idx;
            }
            if (hasMaxLoad) {
                if (di.getMaxLoad() == null) {
                    line[idx] = "";
                    cmp[idx] = Float.valueOf(0.0f);
                } else {
                    line[idx] = Formats.getNumberFormat("0.##").format(di.getMaxLoad());
                    cmp[idx] = di.getMaxLoad();
                }
                ++idx;
            }
            for (InstructorAttributeType at2 : attributeTypes) {
                line[idx] = "";
                for (InstructorAttribute a : di.getAttributes(at2)) {
                    if (!line[idx].isEmpty()) {
                        int n14 = idx;
                        line[n14] = line[n14] + "\n";
                    }
                    int n15 = idx;
                    line[n15] = line[n15] + a.getCode();
                }
                cmp[idx] = line[idx];
                ++idx;
            }
            TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
            classes.addAll(di.getClasses());
            line[idx] = "";
            Iterator i3 = classes.iterator();
            while (i3.hasNext()) {
                ClassInstructor ci = (ClassInstructor)i3.next();
                Class_ c = ci.getClassInstructing();
                String className = c.getClassLabel();
                if (ci.isLead().booleanValue()) {
                    int n16 = idx;
                    line[n16] = line[n16] + "@@BOLD ";
                }
                if (!c.isDisplayInstructor().booleanValue()) {
                    int n17 = idx;
                    line[n17] = line[n17] + "@@ITALIC ";
                }
                int n18 = idx;
                line[n18] = line[n18] + className;
                if (!c.isDisplayInstructor().booleanValue()) {
                    int n19 = idx;
                    line[n19] = line[n19] + "@@END_ITALIC ";
                }
                if (ci.isLead().booleanValue()) {
                    int n20 = idx;
                    line[n20] = line[n20] + "@@END_BOLD ";
                }
                if (!i3.hasNext()) continue;
                int n21 = idx;
                line[n21] = line[n21] + "\n";
            }
            TreeSet<Exam> exams = new TreeSet<Exam>(di.getExams());
            line[++idx] = "";
            Iterator<Exam> i2 = exams.iterator();
            while (i2.hasNext()) {
                Exam exam = i2.next();
                if (!context.hasPermission(exam, Right.ExaminationView)) continue;
                String examName = exam.getLabel();
                if (exam.getExamType().getType() == 1) {
                    int n22 = idx;
                    line[n22] = line[n22] + examName;
                } else {
                    int n23 = idx;
                    line[n23] = line[n23] + "@@BOLD " + examName + "@@END_BOLD ";
                }
                if (!i2.hasNext()) continue;
                int n24 = idx;
                line[n24] = line[n24] + "\n";
            }
            ++idx;
            if (di.isIgnoreToFar() != null && di.isIgnoreToFar().booleanValue()) {
                line[idx] = "@@ITALIC " + MSG.yes();
                cmp[idx] = Boolean.valueOf(true);
            } else {
                line[idx] = "@@ITALIC " + MSG.no();
                cmp[idx] = Boolean.valueOf(false);
            }
            ++idx;
            webTable.addLine(null, line, cmp);
        }
        return webTable;
    }
}

