/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.departments;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.DepartmentInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ReferenceList;

@GwtRpcImplements(value=DepartmentInterface.GetDepartmentsRequest.class)
public class GetDepartmentsDataBackend
implements GwtRpcImplementation<DepartmentInterface.GetDepartmentsRequest, DepartmentInterface.DepartmentsDataResponse> {
    @Override
    public DepartmentInterface.DepartmentsDataResponse execute(DepartmentInterface.GetDepartmentsRequest request, SessionContext context) {
        context.checkPermission(Right.Departments);
        DepartmentInterface.DepartmentsDataResponse response = new DepartmentInterface.DepartmentsDataResponse();
        response.setCanAdd(context.hasPermission(Right.DepartmentAdd));
        response.setCanExportPdf(context.hasPermission(Right.Departments));
        response.setFundingDeptEnabled(ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue());
        for (Department dept : Department.findAll(context.getUser().getCurrentAcademicSessionId())) {
            DepartmentInterface d = new DepartmentInterface();
            DependentDepartmentData dependentDeptData = new DependentDepartmentData(dept);
            d.setSessionId(dept.getSessionId());
            d.setAcademicSessionName(context.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
            d.setDeptCode(dept.getDeptCode());
            d.setUniqueId(dept.getUniqueId());
            d.setAbbreviation(dept.getAbbreviation());
            d.setName(dept.getName());
            d.setExternalManager((boolean)dept.isExternalManager());
            d.setExternalMgrAbbv(dept.getExternalMgrAbbv());
            d.setExternalMgrLabel(dept.getExternalMgrLabel());
            d.setTimetableManagersCount(dept.getTimetableManagers().size());
            d.setSubjectAreaCount(dept.getSubjectAreas().size());
            d.setRoomDeptCount(dept.getRoomDepts().size());
            d.setDistributionPrefPriority((int)dept.getDistributionPrefPriority());
            d.setStatusTypeStr(dept.effectiveStatusType().getLabel());
            d.setStatusTypeCode(dept.effectiveStatusType().getReference());
            d.setAllowReqTime(dept.getAllowReqTime());
            d.setAllowReqRoom(dept.getAllowReqRoom());
            d.setAllowReqDistribution(dept.getAllowReqDistribution());
            d.setExternalFundingDept(dept.getExternalFundingDept());
            d.setDependentStatusesStr(dependentDeptData.getDependentDepartmentStatusStr());
            d.setInheritInstructorPreferences(dept.isInheritInstructorPreferences());
            d.setAllowEvents(dept.isAllowEvents());
            d.setAllowStudentScheduling(dept.isAllowStudentScheduling());
            d.setLastChangeStr(this.lastChangeStr(dept, context));
            d.setDependentDepartments(dependentDeptData.getDependentDepartments());
            d.setDependentStatuses(dependentDeptData.getDependentStatuses());
            d.setExternalId(dept.getExternalUniqueId());
            response.addDepartment(d);
        }
        return response;
    }

    public String lastChangeStr(Department dept, SessionContext context) {
        String lastChangeStr = null;
        if (context.hasPermission(Right.HasRole) && CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges))) {
            List<ChangeLog> changes = ChangeLog.findLastNChanges(dept.getSession().getUniqueId(), null, null, dept.getUniqueId(), 1);
            ChangeLog lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
            lastChangeStr = lastChange == null ? "" : ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName();
        }
        return lastChangeStr;
    }

    public HashMap<String, String> getStatusOptions() {
        ReferenceList ref = new ReferenceList();
        ref.addAll(DepartmentStatusType.findAllForDepartment());
        HashMap<String, String> map = new HashMap<String, String>();
        for (RefTableEntry r : ref) {
            map.put(r.getReference(), r.getLabel());
        }
        return map;
    }

    public HashMap<Long, String> getAllDependentDepartmentOptions(SessionContext context) {
        TreeSet<Department> departments = Department.findAllNonExternal(context.getUser().getCurrentAcademicSessionId());
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (Department d : departments) {
            String deptCode = d.getDepartment().getDeptCode();
            String deptName = d.getDepartment().getName();
            String displayName = deptCode + " : " + deptName;
            map.put(d.getDepartment().getUniqueId(), displayName);
        }
        return map;
    }

    protected class DependentDepartmentData {
        private ArrayList<String> dependentStatuses = new ArrayList();
        private ArrayList<String> dependentDepartments = new ArrayList();
        private ArrayList<String> dependentDepartmentStatusStr = new ArrayList();

        protected DependentDepartmentData(Department dept) {
            if (dept.isExternalManager().booleanValue() && dept.getExternalStatusTypes() != null && !dept.getExternalStatusTypes().isEmpty()) {
                TreeSet<ExternalDepartmentStatusType> set = new TreeSet<ExternalDepartmentStatusType>(new Comparator<ExternalDepartmentStatusType>(){

                    @Override
                    public int compare(ExternalDepartmentStatusType e1, ExternalDepartmentStatusType e2) {
                        return e1.getDepartment().compareTo(e2.getDepartment());
                    }
                });
                set.addAll(dept.getExternalStatusTypes());
                for (ExternalDepartmentStatusType t : set) {
                    this.dependentStatuses.add(t.getStatusType().getReference());
                    this.dependentDepartmentStatusStr.add(t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel());
                    this.dependentDepartments.add(t.getDepartment().getUniqueId().toString());
                }
            }
        }

        protected ArrayList<String> getDependentStatuses() {
            return this.dependentStatuses;
        }

        protected ArrayList<String> getDependentDepartments() {
            return this.dependentDepartments;
        }

        protected ArrayList<String> getDependentDepartmentStatusStr() {
            return this.dependentDepartmentStatusStr;
        }
    }
}

