/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.enrollment;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.StudentClassEnrollmentDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.enrollment.EnrollmentsViolatingCourseStructureAuditReport;
import org.unitime.timetable.reports.enrollment.MissingCourseEnrollmentsAuditReport;
import org.unitime.timetable.reports.enrollment.MultipleConfigEnrollmentsAuditReport;
import org.unitime.timetable.reports.enrollment.MultipleCourseEnrollmentsAuditReport;

public abstract class PdfEnrollmentAuditReport
extends AbstractReport {
    protected static ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    public static Hashtable<String, Class> sRegisteredReports = new Hashtable();
    public static String sAllRegisteredReports = "";
    protected static int studentIdLength = 10;
    protected static int studentNameLength = 23;
    protected static int offeringNameLength = 45;
    protected static int classNameLength = 14;
    protected static int itypeLength = 7;
    protected static int multipleClassesLength = 30;
    private Session iSession = null;
    private boolean iShowId;
    private boolean iShowName;
    private TreeSet<SubjectArea> iSubjectAreas;

    public PdfEnrollmentAuditReport(int mode, File file, String title, String title2, String subject, String session) throws IOException, DocumentException {
        super(mode, file, title, title2, subject, session);
    }

    public PdfEnrollmentAuditReport(int mode, String title, File file, Session session, TreeSet<SubjectArea> subjectAreas, String subTitle) throws DocumentException, IOException {
        super(mode, file, title, subTitle, title + " -- " + session.getLabel(), session.getLabel());
        this.iSession = session;
        this.iSubjectAreas = subjectAreas;
    }

    public PdfEnrollmentAuditReport(int mode, String title, File file, Session session) throws DocumentException, IOException {
        super(mode, file, title, "", title + " -- " + session.getLabel(), session.getLabel());
        this.iSession = session;
        this.iSubjectAreas = null;
    }

    public abstract void printReport() throws DocumentException;

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean isShowId() {
        return this.iShowId;
    }

    public void setShowId(boolean showId) {
        this.iShowId = showId;
    }

    public boolean isShowName() {
        return this.iShowName;
    }

    public void setShowName(boolean showName) {
        this.iShowName = showName;
    }

    public TreeSet<SubjectArea> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(TreeSet<SubjectArea> subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    protected abstract String createQueryString(TreeSet<SubjectArea> var1);

    protected List getAuditResults(TreeSet<SubjectArea> subjectAreas) {
        String query = this.createQueryString(subjectAreas);
        return StudentClassEnrollmentDAO.getInstance().getQuery(query).setLong("sessId", this.getSession().getUniqueId().longValue()).list();
    }

    protected AbstractReport.Line buildBaseAuditLine(EnrollmentAuditResult result) {
        return new AbstractReport.Line(this.isShowId() ? this.lpad(result.getStudentId(), ' ', studentIdLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.isShowName() ? this.rpad(result.getStudentName(), ' ', studentNameLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.rpad(result.getOffering(), ' ', offeringNameLength));
    }

    protected AbstractReport.Line[] getBaseHeader() {
        return new AbstractReport.Line[]{new AbstractReport.Line(this.isShowId() ? this.rpad("", ' ', studentIdLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.isShowName() ? this.rpad("", ' ', studentNameLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.rpad("", ' ', offeringNameLength)), new AbstractReport.Line(this.isShowId() ? this.rpad(MSG.lrStudentID(), ' ', studentIdLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.isShowName() ? this.rpad(MSG.lrStudentName(), ' ', studentNameLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.rpad(MSG.lrOffering(), ' ', offeringNameLength)), new AbstractReport.Line(this.isShowId() ? this.rpad("", '-', studentIdLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.isShowName() ? this.rpad("", '-', studentNameLength) : new AbstractReport.Cell(new AbstractReport.Cell[0]), this.rpad("", '-', offeringNameLength))};
    }

    static {
        sRegisteredReports.put("struct", EnrollmentsViolatingCourseStructureAuditReport.class);
        sRegisteredReports.put("missing", MissingCourseEnrollmentsAuditReport.class);
        sRegisteredReports.put("many-subp", MultipleCourseEnrollmentsAuditReport.class);
        sRegisteredReports.put("many-conf", MultipleConfigEnrollmentsAuditReport.class);
        for (String report : sRegisteredReports.keySet()) {
            sAllRegisteredReports = sAllRegisteredReports + (sAllRegisteredReports.length() > 0 ? "," : "") + report;
        }
    }

    protected abstract class EnrollmentAuditResult {
        private String studentId;
        private String studentLastName;
        private String studentFirstName;
        private String studentMiddleName;
        private String subjectArea;
        private String courseNbr;
        private String title;

        public EnrollmentAuditResult(Object[] result) {
            if (result[0] != null) {
                this.studentId = result[0].toString().trim();
            }
            if (result[1] != null) {
                this.studentLastName = result[1].toString();
            }
            if (result[2] != null) {
                this.studentFirstName = result[2].toString();
            }
            if (result[3] != null) {
                this.studentMiddleName = result[3].toString();
            }
            if (result[4] != null) {
                this.subjectArea = result[4].toString();
            }
            if (result[5] != null) {
                this.courseNbr = result[5].toString();
            }
            if (result[6] != null) {
                this.title = result[6].toString();
            }
        }

        public String getStudentName() {
            String name;
            StringBuilder sb = new StringBuilder();
            if (this.studentLastName != null && this.studentLastName.length() > 0) {
                sb.append(this.studentLastName);
                if (this.studentFirstName != null && this.studentFirstName.length() > 0) {
                    sb.append(", ").append(this.studentFirstName.charAt(0));
                    if (this.studentMiddleName != null && this.studentMiddleName.length() > 0) {
                        sb.append(" ").append(this.studentMiddleName.charAt(0));
                    }
                }
            }
            if ((name = sb.toString()).length() > studentNameLength) {
                name = name.substring(0, studentNameLength);
            }
            return name;
        }

        public String getStudentId() {
            return this.studentId;
        }

        public String getOffering() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.subjectArea).append(" ").append(this.courseNbr).append(" - ").append(this.title);
            String title = sb.toString();
            if (title.length() > offeringNameLength) {
                title = title.substring(0, offeringNameLength);
            }
            return title;
        }

        protected String createClassString(String itypeStr, String nbrStr, String suffixStr) {
            StringBuilder sb = new StringBuilder();
            sb.append(itypeStr);
            if (nbrStr.length() != 0) {
                sb.append(" ").append(nbrStr);
                if (!suffixStr.trim().equals("-")) {
                    sb.append("(").append(suffixStr).append(")");
                }
            }
            return sb.toString();
        }
    }
}

