/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.duration.DurationModel;

public class MinutesPerWeek
implements DurationModel {
    public MinutesPerWeek(String paramter) {
    }

    @Override
    public boolean isValidCombination(int minsPerWeek, DatePattern datePattern, TimePattern timePattern) {
        if (datePattern == null) {
            return false;
        }
        return minsPerWeek == timePattern.getNrMeetings() * timePattern.getMinPerMtg();
    }

    @Override
    public boolean isValidSelection(int minsPerWeek, DatePattern datePattern, TimePattern timePattern, int dayCode) {
        if (!this.isValidCombination(minsPerWeek, datePattern, timePattern)) {
            return false;
        }
        if (datePattern.isPatternSet()) {
            for (DatePattern child : datePattern.findChildren()) {
                if (!this.hasDates(child, dayCode)) continue;
                return true;
            }
            return false;
        }
        return this.hasDates(datePattern, dayCode);
    }

    @Override
    public Set<Integer> getDayCodes(int minsPerWeek, DatePattern datePattern, TimePattern timePattern) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (TimePatternDays days : timePattern.getDays()) {
            if (!this.isValidSelection(minsPerWeek, datePattern, timePattern, days.getDayCode())) continue;
            ret.add(days.getDayCode());
        }
        return ret;
    }

    protected boolean hasDates(DatePattern datePattern, int dayCode) {
        if (datePattern == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(datePattern.getStartDate());
        cal.setLenient(true);
        String pattern = datePattern.getPattern();
        for (int idx = 0; idx < pattern.length(); ++idx) {
            if (pattern.charAt(idx) == '1') {
                boolean offered = false;
                switch (cal.get(7)) {
                    case 2: {
                        offered = (dayCode & Constants.DAY_CODES[0]) != 0;
                        break;
                    }
                    case 3: {
                        offered = (dayCode & Constants.DAY_CODES[1]) != 0;
                        break;
                    }
                    case 4: {
                        offered = (dayCode & Constants.DAY_CODES[2]) != 0;
                        break;
                    }
                    case 5: {
                        offered = (dayCode & Constants.DAY_CODES[3]) != 0;
                        break;
                    }
                    case 6: {
                        offered = (dayCode & Constants.DAY_CODES[4]) != 0;
                        break;
                    }
                    case 7: {
                        offered = (dayCode & Constants.DAY_CODES[5]) != 0;
                        break;
                    }
                    case 1: {
                        boolean bl = offered = (dayCode & Constants.DAY_CODES[6]) != 0;
                    }
                }
                if (offered) {
                    return true;
                }
            }
            cal.add(6, 1);
        }
        return false;
    }

    @Override
    public List<Date> getDates(int minsPerWeek, DatePattern datePattern, int dayCode, int minutesPerMeeting) {
        ArrayList<Date> ret = new ArrayList<Date>();
        if (datePattern == null) {
            return ret;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(datePattern.getStartDate());
        cal.setLenient(true);
        EventDateMapping.Class2EventDateMap class2eventDates = EventDateMapping.getMapping(datePattern.getSession().getUniqueId());
        String pattern = datePattern.getPattern();
        for (int idx = 0; idx < pattern.length(); ++idx) {
            if (pattern.charAt(idx) == '1') {
                boolean offered = false;
                switch (cal.get(7)) {
                    case 2: {
                        offered = (dayCode & Constants.DAY_CODES[0]) != 0;
                        break;
                    }
                    case 3: {
                        offered = (dayCode & Constants.DAY_CODES[1]) != 0;
                        break;
                    }
                    case 4: {
                        offered = (dayCode & Constants.DAY_CODES[2]) != 0;
                        break;
                    }
                    case 5: {
                        offered = (dayCode & Constants.DAY_CODES[3]) != 0;
                        break;
                    }
                    case 6: {
                        offered = (dayCode & Constants.DAY_CODES[4]) != 0;
                        break;
                    }
                    case 7: {
                        offered = (dayCode & Constants.DAY_CODES[5]) != 0;
                        break;
                    }
                    case 1: {
                        boolean bl = offered = (dayCode & Constants.DAY_CODES[6]) != 0;
                    }
                }
                if (offered) {
                    ret.add(class2eventDates.getEventDate(cal.getTime()));
                }
            }
            cal.add(6, 1);
        }
        return ret;
    }

    @Override
    public String getParamterFormat() {
        return null;
    }

    @Override
    public int getExactTimeMinutesPerMeeting(int minsPerWeek, DatePattern datePattern, int dayCode) {
        return minsPerWeek / DayCode.nrDays(dayCode);
    }

    @Override
    public Integer getArrangedHours(int minsPerWeek, DatePattern datePattern) {
        return minsPerWeek <= 0 ? null : Integer.valueOf(Math.round((float)minsPerWeek / 50.0f));
    }
}

