/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.RollForwardSessionAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.RollForwardSessionForm;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Campus;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.CurriculumOverrideReservation;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Degree;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomDepartment;
import org.unitime.timetable.model.ExternalRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Program;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SessionConfig;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.StandardEventNote;
import org.unitime.timetable.model.StandardEventNoteDepartment;
import org.unitime.timetable.model.StandardEventNoteSession;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.base.BaseExternalRoom;
import org.unitime.timetable.model.base.BaseNonUniversityLocation;
import org.unitime.timetable.model.base.BaseRoom;
import org.unitime.timetable.model.base.BaseRoomFeature;
import org.unitime.timetable.model.base.BaseRoomGroup;
import org.unitime.timetable.model.base.BaseStandardEventNoteDepartment;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.CampusDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseCatalogDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DegreeDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.ExamStatusDAO;
import org.unitime.timetable.model.dao.ExternalBuildingDAO;
import org.unitime.timetable.model.dao.ExternalRoomDAO;
import org.unitime.timetable.model.dao.ExternalRoomDepartmentDAO;
import org.unitime.timetable.model.dao.ExternalRoomFeatureDAO;
import org.unitime.timetable.model.dao.GlobalRoomFeatureDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.LastLikeCourseDemandDAO;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.model.dao.NonUniversityLocationDAO;
import org.unitime.timetable.model.dao.OfferingCoordinatorDAO;
import org.unitime.timetable.model.dao.PeriodicTaskDAO;
import org.unitime.timetable.model.dao.PosMajorDAO;
import org.unitime.timetable.model.dao.PosMinorDAO;
import org.unitime.timetable.model.dao.ProgramDAO;
import org.unitime.timetable.model.dao.ReservationDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.SessionConfigDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao.TeachingRequestDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.model.dao.TravelTimeDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.SaveTaskBackend;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.InstructionalOfferingRollForward;
import org.unitime.timetable.util.LocationPermIdGenerator;

public class SessionRollForward {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected Log iLog;
    private HashMap roomList;
    private HashMap sessionHasCourseCatalogList;
    private HashMap sessionHasExternalBuildingList;
    private HashMap sessionHasExternalRoomList;
    private HashMap sessionHasExternalRoomDeptList;
    private HashMap sessionHasExternalRoomFeatureList;
    private boolean subpartTimeRollForward;
    private boolean subpartLocationRollForward;
    private boolean classPrefsPushUp;
    private boolean classRollForward;
    private DistributionMode rollForwardDistributions = DistributionMode.MIXED;
    private CancelledClassAction cancelledClassAction = CancelledClassAction.REOPEN;
    private boolean resetClassSuffix;
    private boolean waitListsAndProhibitedOverrides;
    public static String ROLL_PREFS_ACTION = "rollUnchanged";
    public static String DO_NOT_ROLL_ACTION = "doNotRoll";
    public static String PUSH_UP_ACTION = "pushUp";
    public static String EXAMS_NO_PREF = "doNotRoll";
    public static String EXAMS_ROOM_PREFS = "rollRoomPrefs";
    public static String EXAMS_ALL_PREF = "rollAllPrefs";

    public SessionRollForward(Log log) {
        this.iLog = log;
        this.resetClassSuffix = ApplicationProperty.RollForwardResetClassSuffix.isTrue();
    }

    public void setSubpartLocationPrefRollForwardParameters(String subpartLocationPrefsAction) {
        this.subpartLocationRollForward = subpartLocationPrefsAction == null || subpartLocationPrefsAction.equalsIgnoreCase(ROLL_PREFS_ACTION) ? true : !subpartLocationPrefsAction.equalsIgnoreCase(DO_NOT_ROLL_ACTION);
    }

    public void setSubpartTimePrefRollForwardParameters(String subpartTimePrefsAction) {
        this.subpartTimeRollForward = subpartTimePrefsAction == null || subpartTimePrefsAction.equalsIgnoreCase(ROLL_PREFS_ACTION) ? true : !subpartTimePrefsAction.equalsIgnoreCase(DO_NOT_ROLL_ACTION);
    }

    public void setClassPrefRollForwardParameter(String classPrefsAction) {
        if (classPrefsAction == null || classPrefsAction.equalsIgnoreCase(DO_NOT_ROLL_ACTION)) {
            this.classPrefsPushUp = false;
            this.classRollForward = false;
        } else if (classPrefsAction.equalsIgnoreCase(PUSH_UP_ACTION)) {
            this.classPrefsPushUp = true;
            this.classRollForward = false;
        } else if (classPrefsAction.equalsIgnoreCase(ROLL_PREFS_ACTION)) {
            this.classRollForward = true;
            this.classPrefsPushUp = false;
        } else {
            this.classPrefsPushUp = false;
            this.classRollForward = false;
        }
    }

    public void setRollForwardDistributions(String rollForwardDistributions) {
        this.rollForwardDistributions = rollForwardDistributions == null ? DistributionMode.MIXED : DistributionMode.valueOf(rollForwardDistributions);
    }

    public void setCancelledClassActionRollForwardParameter(String cancelledClassAction) {
        this.cancelledClassAction = cancelledClassAction == null ? CancelledClassAction.REOPEN : CancelledClassAction.valueOf(cancelledClassAction);
    }

    public void setWaitListsAndProhibitedOverrides(Boolean waitListsAndProhibitedOverrides) {
        this.waitListsAndProhibitedOverrides = waitListsAndProhibitedOverrides == null ? false : waitListsAndProhibitedOverrides;
    }

    public boolean isWaitListsAndProhibitedOverrides() {
        return this.waitListsAndProhibitedOverrides;
    }

    public void rollBuildingAndRoomDataForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollRoomDataForwardFrom());
        this.rollRoomFeaturesForward(errors, fromSession, toSession);
        this.rollRoomGroupsForward(errors, fromSession, toSession);
        this.rollBuildingsForward(errors, fromSession, toSession);
        this.rollLocationsForward(errors, fromSession, toSession);
        this.rollTravelTimesForward(errors, fromSession, toSession);
        this.rollRoomPartitionsForward(errors, fromSession, toSession);
        new SessionDAO().getSession().clear();
    }

    private void rollRoomGroupsForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        RoomGroup fromRoomGroup2 = null;
        RoomGroup toRoomGroup = null;
        RoomGroupDAO rgDao = new RoomGroupDAO();
        List<RoomGroup> fromRoomGroups = RoomGroup.getAllRoomGroupsForSession(fromSession);
        try {
            if (fromRoomGroups != null && !fromRoomGroups.isEmpty()) {
                for (RoomGroup fromRoomGroup2 : fromRoomGroups) {
                    if (fromRoomGroup2 == null) continue;
                    toRoomGroup = (RoomGroup)fromRoomGroup2.clone();
                    toRoomGroup.setSession(toSession);
                    if (fromRoomGroup2.getDepartment() != null) {
                        toRoomGroup.setDepartment(fromRoomGroup2.getDepartment().findSameDepartmentInSession(toSession));
                    }
                    rgDao.saveOrUpdate(toRoomGroup);
                }
            }
        }
        catch (Exception e) {
            String type = MSG.rollForwardRoomsGroups();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    private void rollRoomFeaturesForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        DepartmentRoomFeature fromRoomFeature2 = null;
        DepartmentRoomFeature toRoomFeature = null;
        RoomFeatureDAO rfDao = new RoomFeatureDAO();
        Collection fromRoomFeatures = DepartmentRoomFeature.getAllRoomFeaturesForSession(fromSession);
        try {
            if (fromRoomFeatures != null && !fromRoomFeatures.isEmpty()) {
                for (DepartmentRoomFeature fromRoomFeature2 : fromRoomFeatures) {
                    if (fromRoomFeature2 == null) continue;
                    toRoomFeature = (DepartmentRoomFeature)fromRoomFeature2.clone();
                    toRoomFeature.setDepartment(fromRoomFeature2.getDepartment().findSameDepartmentInSession(toSession));
                    rfDao.saveOrUpdate(toRoomFeature);
                }
            }
            HashSet<String> globalFeatures = new HashSet<String>();
            for (GlobalRoomFeature fromRoomFeatureGlobal : GlobalRoomFeature.getAllGlobalRoomFeatures(fromSession)) {
                GlobalRoomFeature toRoomFeatureGlobal = (GlobalRoomFeature)fromRoomFeatureGlobal.clone();
                toRoomFeatureGlobal.setSession(toSession);
                rfDao.saveOrUpdate(toRoomFeatureGlobal);
                globalFeatures.add(fromRoomFeatureGlobal.getLabel());
            }
            if (this.sessionHasExternalRoomFeatureList(toSession)) {
                GlobalRoomFeatureDAO grfDao = new GlobalRoomFeatureDAO();
                GlobalRoomFeature grf = null;
                List newGlobalFeatures = grfDao.getQuery("select distinct erf.value, erf.name from ExternalRoomFeature erf where erf.room.building.session.uniqueId=:sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list();
                if (newGlobalFeatures != null) {
                    String newLabel = null;
                    String newSisReference = null;
                    for (Object[] o : newGlobalFeatures) {
                        newLabel = (String)o[0];
                        if (globalFeatures.contains(newLabel)) continue;
                        newSisReference = (String)o[1];
                        grf = new GlobalRoomFeature();
                        grf.setLabel(newLabel);
                        grf.setSisReference(newSisReference);
                        grf.setSisValue(null);
                        grf.setSession(toSession);
                        grfDao.saveOrUpdate(grf);
                    }
                }
            }
        }
        catch (Exception e) {
            String type = MSG.rollForwardRoomsFeatures();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    private void rollRoomFeaturesForLocationForward(Location fromLocation, Location toLocation, Session toSession, HashMap roomFeatureCache) {
        if (fromLocation.getFeatures() != null && !fromLocation.getFeatures().isEmpty()) {
            ExternalRoom er;
            Room toRoom;
            RoomFeature fromFeature2 = null;
            GlobalRoomFeature toGlobalFeature = null;
            RoomFeature toFeature = null;
            boolean rollGlobalFeaturesFromFromLocation = true;
            if (toLocation instanceof Room && (toRoom = (Room)toLocation).getExternalUniqueId() != null && (er = ExternalRoom.findExternalRoomForSession(toRoom.getExternalUniqueId(), toSession)) != null) {
                rollGlobalFeaturesFromFromLocation = false;
                if (er.getRoomFeatures() != null) {
                    ExternalRoomFeature erf2 = null;
                    for (ExternalRoomFeature erf2 : er.getRoomFeatures()) {
                        toGlobalFeature = GlobalRoomFeature.findGlobalRoomFeatureForLabel(toSession, erf2.getValue());
                        toLocation.addTofeatures(toGlobalFeature);
                    }
                }
            }
            for (RoomFeature fromFeature2 : fromLocation.getFeatures()) {
                if (fromFeature2 instanceof GlobalRoomFeature && !rollGlobalFeaturesFromFromLocation || (toFeature = (RoomFeature)roomFeatureCache.get(fromFeature2)) != null || (toFeature = fromFeature2.findSameFeatureInSession(toSession)) == null) continue;
                roomFeatureCache.put(fromFeature2, toFeature);
                toLocation.addTofeatures(toFeature);
                if (toFeature.getRooms() == null) {
                    toFeature.setRooms(new HashSet<Location>());
                }
                toFeature.getRooms().add(toLocation);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rollRoomForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession, Location location) {
        Room fromRoom = null;
        Room toRoom = null;
        RoomDAO rDao = new RoomDAO();
        DepartmentDAO dDao = new DepartmentDAO();
        Building toBuilding = null;
        RoomDept fromRoomDept2 = null;
        Department toDept = null;
        Department fromDept = null;
        HashMap roomFeatureCache = new HashMap();
        HashMap roomGroupCache = new HashMap();
        try {
            Iterator<RoomDept> rdIt;
            boolean foundDept;
            Iterator<ExternalRoomDepartment> erdIt;
            ExternalRoomDepartment toExternalRoomDept;
            Iterator<EventServiceProvider> toExternalRoom;
            fromRoom = (Room)location;
            if (fromRoom.getExternalUniqueId() != null && this.sessionHasExternalRoomList(toSession)) {
                ExternalRoom toExternalRoom2 = ExternalRoom.findExternalRoomForSession(fromRoom.getExternalUniqueId(), toSession);
                if (toExternalRoom2 == null) return;
                toRoom = new Room();
                toRoom.setCapacity(toExternalRoom2.getCapacity());
                toRoom.setExamCapacity(toExternalRoom2.getExamCapacity());
                toRoom.setClassification(toExternalRoom2.getClassification());
                toRoom.setCoordinateX(toExternalRoom2.getCoordinateX());
                toRoom.setCoordinateY(toExternalRoom2.getCoordinateY());
                toRoom.setArea(toExternalRoom2.getArea());
                toRoom.setDisplayName(toExternalRoom2.getDisplayName());
                toRoom.setExternalUniqueId(toExternalRoom2.getExternalUniqueId());
                toRoom.setIgnoreRoomCheck(fromRoom.isIgnoreRoomCheck());
                toRoom.setIgnoreTooFar(fromRoom.isIgnoreTooFar());
                toRoom.setPattern(fromRoom.getPattern());
                toRoom.setRoomNumber(toExternalRoom2.getRoomNumber());
                toRoom.setRoomType(toExternalRoom2.getRoomType());
                toRoom.setExamTypes(new HashSet<ExamType>(fromRoom.getExamTypes()));
                toRoom.setEventStatus(null);
                toRoom.setBreakTime(fromRoom.getBreakTime());
                toRoom.setNote(fromRoom.getNote());
                toRoom.setEventAvailability(fromRoom.getEventAvailability());
                LocationPermIdGenerator.setPermanentId(toRoom);
            } else {
                toRoom = (Room)fromRoom.clone();
            }
            toRoom.setSession(toSession);
            if (fromRoom.getEventDepartment() != null) {
                toRoom.setEventDepartment(fromRoom.getEventDepartment().findSameDepartmentInSession(toSession));
            }
            if ((toBuilding = fromRoom.getBuilding().findSameBuildingInSession(toSession)) == null) return;
            toRoom.setBuilding(toBuilding);
            if (fromRoom.getManagerIds() != null && fromRoom.getManagerIds().length() != 0) {
                String toManagerStr = "";
                StringTokenizer stk = new StringTokenizer(fromRoom.getManagerIds(), ",");
                while (stk.hasMoreTokens()) {
                    Long fromDeptId = Long.valueOf(stk.nextToken());
                    if (fromDeptId == null || (fromDept = (Department)dDao.get(fromDeptId)) == null || (toDept = fromDept.findSameDepartmentInSession(toSession)) == null) continue;
                    if (toManagerStr.length() != 0) {
                        toManagerStr = toManagerStr + ",";
                    }
                    toManagerStr = toManagerStr + toDept.getUniqueId().toString();
                }
                toRoom.setManagerIds(toManagerStr);
            } else {
                toRoom.setPattern(null);
            }
            this.rollRoomFeaturesForLocationForward(fromRoom, toRoom, toSession, roomFeatureCache);
            this.rollRoomGroupsForLocationForward(fromRoom, toRoom, toSession, roomGroupCache);
            rDao.saveOrUpdate(toRoom);
            boolean rollForwardExistingRoomDepts = true;
            if (fromRoom.getExternalUniqueId() != null && this.sessionHasExternalRoomDeptList(toSession) && ((BaseExternalRoom)((Object)(toExternalRoom = ExternalRoom.findExternalRoomForSession(fromRoom.getExternalUniqueId(), toSession)))).getRoomDepartments() != null && !((BaseExternalRoom)((Object)toExternalRoom)).getRoomDepartments().isEmpty()) {
                toExternalRoomDept = null;
                fromRoomDept2 = null;
                erdIt = ((BaseExternalRoom)((Object)toExternalRoom)).getRoomDepartments().iterator();
                while (erdIt.hasNext() && rollForwardExistingRoomDepts) {
                    foundDept = false;
                    toExternalRoomDept = erdIt.next();
                    rdIt = fromRoom.getRoomDepts().iterator();
                    while (rdIt.hasNext() && !foundDept) {
                        fromRoomDept2 = rdIt.next();
                        if (!fromRoomDept2.getDepartment().getDeptCode().equals(toExternalRoomDept.getDepartmentCode())) continue;
                        foundDept = true;
                    }
                    if (foundDept) continue;
                    rollForwardExistingRoomDepts = false;
                }
            }
            if (rollForwardExistingRoomDepts) {
                if (fromRoom.getRoomDepts() != null && !fromRoom.getRoomDepts().isEmpty()) {
                    for (RoomDept fromRoomDept2 : fromRoom.getRoomDepts()) {
                        this.rollForwardRoomDept(fromRoomDept2, toRoom, toSession, fromRoom);
                    }
                }
            } else {
                toRoom.setPattern(null);
                toRoom.setManagerIds(null);
                toExternalRoom = ExternalRoom.findExternalRoomForSession(fromRoom.getExternalUniqueId(), toSession);
                toExternalRoomDept = null;
                fromRoomDept2 = null;
                erdIt = ((BaseExternalRoom)((Object)toExternalRoom)).getRoomDepartments().iterator();
                while (erdIt.hasNext()) {
                    foundDept = false;
                    toExternalRoomDept = erdIt.next();
                    rdIt = fromRoom.getRoomDepts().iterator();
                    while (rdIt.hasNext() && !foundDept) {
                        fromRoomDept2 = rdIt.next();
                        if (!fromRoomDept2.getDepartment().getDeptCode().equals(toExternalRoomDept.getDepartmentCode())) continue;
                        foundDept = true;
                    }
                    if (foundDept) {
                        this.rollForwardRoomDept(fromRoomDept2, toRoom, toSession, fromRoom);
                        continue;
                    }
                    toRoom.addExternalRoomDept(toExternalRoomDept, ((BaseExternalRoom)((Object)toExternalRoom)).getRoomDepartments());
                }
            }
            rDao.saveOrUpdate(toRoom);
            for (RoomPicture fromPicture : fromRoom.getPictures()) {
                RoomPicture toPicture = fromPicture.clonePicture();
                toPicture.setLocation(toRoom);
                toRoom.addTopictures(toPicture);
                rDao.getSession().saveOrUpdate((Object)toPicture);
            }
            for (EventServiceProvider fromProvider : fromRoom.getAllowedServices()) {
                EventServiceProvider toProvider = fromProvider.findInSession(toSession.getUniqueId());
                if (toProvider == null) continue;
                toRoom.addToallowedServices(toProvider);
            }
            rDao.getSession().flush();
            return;
        }
        catch (Exception e) {
            String type = MSG.rollForwardRooms();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    private void rollForwardRoomDept(RoomDept fromRoomDept, Location toLocation, Session toSession, Location fromLocation) {
        Department toDept = fromRoomDept.getDepartment().findSameDepartmentInSession(toSession);
        RoomDept toRoomDept = null;
        RoomDeptDAO rdDao = new RoomDeptDAO();
        if (toDept != null) {
            toRoomDept = new RoomDept();
            toRoomDept.setRoom(toLocation);
            toRoomDept.setControl(fromRoomDept.isControl());
            toRoomDept.setDepartment(toDept);
            toLocation.addToroomDepts(toRoomDept);
            toDept.addToroomDepts(toRoomDept);
            rdDao.saveOrUpdate(toRoomDept);
            PreferenceLevel fromRoomPrefLevel = fromLocation.getRoomPreferenceLevel(fromRoomDept.getDepartment());
            if (!fromRoomPrefLevel.getPrefProlog().equals(PreferenceLevel.sNeutral)) {
                RoomPref toRoomPref = new RoomPref();
                toRoomPref.setOwner(toDept);
                toRoomPref.setPrefLevel(fromRoomPrefLevel);
                toRoomPref.setRoom(toLocation);
                toDept.addTopreferences(toRoomPref);
                rdDao.getSession().saveOrUpdate((Object)toDept);
            }
        }
    }

    private void rollRoomGroupsForLocationForward(Location fromLocation, Location toLocation, Session toSession, HashMap roomGroupCache) {
        if (fromLocation.getRoomGroups() != null && !fromLocation.getRoomGroups().isEmpty()) {
            RoomGroup fromRoomGroup2 = null;
            RoomGroup toRoomGroup = null;
            for (RoomGroup fromRoomGroup2 : fromLocation.getRoomGroups()) {
                toRoomGroup = (RoomGroup)roomGroupCache.get(fromRoomGroup2);
                if (toRoomGroup == null) {
                    toRoomGroup = fromRoomGroup2.findSameRoomGroupInSession(toSession);
                }
                if (toRoomGroup == null) continue;
                roomGroupCache.put(fromRoomGroup2, toRoomGroup);
                if (toLocation.getRoomGroups() == null) {
                    toLocation.setRoomGroups(new HashSet<RoomGroup>());
                }
                toLocation.getRoomGroups().add(toRoomGroup);
                if (toRoomGroup.getRooms() == null) {
                    toRoomGroup.setRooms(new HashSet<Location>());
                }
                toRoomGroup.getRooms().add(toLocation);
            }
        }
    }

    private void rollNonUniversityLocationsForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession, Location location) {
        NonUniversityLocation fromNonUniversityLocation = null;
        NonUniversityLocation toNonUniversityLocation = null;
        NonUniversityLocationDAO nulDao = new NonUniversityLocationDAO();
        DepartmentDAO dDao = new DepartmentDAO();
        RoomDept fromRoomDept2 = null;
        Department toDept = null;
        Department fromDept = null;
        HashMap roomFeatureCache = new HashMap();
        HashMap roomGroupCache = new HashMap();
        try {
            fromNonUniversityLocation = (NonUniversityLocation)location;
            toNonUniversityLocation = (NonUniversityLocation)fromNonUniversityLocation.clone();
            toNonUniversityLocation.setSession(toSession);
            if (fromNonUniversityLocation.getEventDepartment() != null) {
                toNonUniversityLocation.setEventDepartment(fromNonUniversityLocation.getEventDepartment().findSameDepartmentInSession(toSession));
            }
            if (fromNonUniversityLocation.getManagerIds() != null && fromNonUniversityLocation.getManagerIds().length() != 0) {
                Object toManagerStr = "";
                StringTokenizer stk = new StringTokenizer(fromNonUniversityLocation.getManagerIds(), ",");
                while (stk.hasMoreTokens()) {
                    Long fromDeptId = Long.valueOf(stk.nextToken());
                    if (fromDeptId == null || (fromDept = (Department)dDao.get(fromDeptId)) == null || (toDept = fromDept.findSameDepartmentInSession(toSession)) == null) continue;
                    if (((String)toManagerStr).length() != 0) {
                        toManagerStr = toManagerStr + ",";
                    }
                    toManagerStr = toManagerStr + toDept.getUniqueId().toString();
                }
                toNonUniversityLocation.setManagerIds((String)toManagerStr);
            } else {
                toNonUniversityLocation.setPattern(null);
            }
            this.rollRoomFeaturesForLocationForward(fromNonUniversityLocation, toNonUniversityLocation, toSession, roomFeatureCache);
            this.rollRoomGroupsForLocationForward(fromNonUniversityLocation, toNonUniversityLocation, toSession, roomGroupCache);
            nulDao.saveOrUpdate(toNonUniversityLocation);
            for (NonUniversityLocationPicture fromPicture : fromNonUniversityLocation.getPictures()) {
                NonUniversityLocationPicture toPicture = fromPicture.clonePicture();
                toPicture.setLocation(toNonUniversityLocation);
                toNonUniversityLocation.addTopictures(toPicture);
                nulDao.getSession().saveOrUpdate((Object)toPicture);
            }
            for (EventServiceProvider fromProvider : fromNonUniversityLocation.getAllowedServices()) {
                EventServiceProvider toProvider = fromProvider.findInSession(toSession.getUniqueId());
                if (toProvider == null) continue;
                toNonUniversityLocation.addToallowedServices(toProvider);
            }
            if (fromNonUniversityLocation.getRoomDepts() != null && !fromNonUniversityLocation.getRoomDepts().isEmpty()) {
                for (RoomDept fromRoomDept2 : fromNonUniversityLocation.getRoomDepts()) {
                    this.rollForwardRoomDept(fromRoomDept2, toNonUniversityLocation, toSession, fromNonUniversityLocation);
                }
                nulDao.saveOrUpdate(toNonUniversityLocation);
                nulDao.getSession().flush();
                nulDao.getSession().evict((Object)toNonUniversityLocation);
                nulDao.getSession().evict((Object)fromNonUniversityLocation);
            }
        }
        catch (Exception e) {
            String type = MSG.rollForwardNonUniversityLocations();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    private void rollLocationsForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        if (fromSession.getRooms() != null && !fromSession.getRooms().isEmpty()) {
            Location location2 = null;
            for (Location location2 : fromSession.getRooms()) {
                if (location2 instanceof Room) {
                    this.rollRoomForward(errors, fromSession, toSession, location2);
                    continue;
                }
                if (!(location2 instanceof NonUniversityLocation)) continue;
                this.rollNonUniversityLocationsForward(errors, fromSession, toSession, location2);
            }
        }
        if (this.sessionHasExternalRoomList(toSession)) {
            Room.addNewExternalRoomsToSession(toSession);
        }
    }

    private void rollTravelTimesForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        TravelTimeDAO dao = new TravelTimeDAO();
        dao.getSession().createQuery("delete from TravelTime where session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).executeUpdate();
        for (TravelTime travel : dao.getSession().createQuery("from TravelTime where session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            Location to;
            Location from = this.findLocation(travel.getLocation1Id(), toSession.getUniqueId());
            if (from == null || (to = this.findLocation(travel.getLocation2Id(), toSession.getUniqueId())) == null) continue;
            TravelTime time = new TravelTime();
            time.setSession(toSession);
            time.setLocation1Id(Math.min(from.getUniqueId(), to.getUniqueId()));
            time.setLocation2Id(Math.max(from.getUniqueId(), to.getUniqueId()));
            time.setDistance(travel.getDistance());
            dao.saveOrUpdate(time);
        }
    }

    private void rollRoomPartitionsForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        RoomDAO dao = new RoomDAO();
        for (Room original : dao.getSession().createQuery("from Room where session.uniqueId = :sessionId and parentRoom is not null").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            Room parent;
            Room room = this.findRoom(original.getUniqueId(), toSession.getUniqueId());
            if (room == null || (parent = this.findRoom(original.getParentRoom().getUniqueId(), toSession.getUniqueId())) == null) continue;
            room.setParentRoom(parent);
            dao.update(room);
        }
    }

    private Location findLocation(Long locationId, Long sessionId) {
        TravelTimeDAO dao = new TravelTimeDAO();
        Room room = (Room)dao.getSession().createQuery("select r2 from Room r1, Room r2 where r1.uniqueId = :locationId and r2.building.session.uniqueId=:sessionId and ((r1.externalUniqueId is not null and r1.externalUniqueId <> '' and r1.externalUniqueId = r2.externalUniqueId) or ((r1.externalUniqueId is null or r1.externalUniqueId = '') and r1.building.abbreviation = r2.building.abbreviation and r1.roomNumber = r2.roomNumber))").setLong("sessionId", sessionId.longValue()).setLong("locationId", locationId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
        if (room != null) {
            return room;
        }
        return (NonUniversityLocation)dao.getSession().createQuery("select r2 from NonUniversityLocation r1, NonUniversityLocation r2 where r1.uniqueId = :locationId and r2.session.uniqueId=:sessionId and r1.name = r2.name").setLong("sessionId", sessionId.longValue()).setLong("locationId", locationId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    private Room findRoom(Long locationId, Long sessionId) {
        return (Room)RoomDAO.getInstance().getSession().createQuery("select r2 from Room r1, Room r2 where r1.uniqueId = :locationId and r2.building.session.uniqueId=:sessionId and ((r1.externalUniqueId is not null and r1.externalUniqueId <> '' and r1.externalUniqueId = r2.externalUniqueId) or ((r1.externalUniqueId is null or r1.externalUniqueId = '') and r1.building.abbreviation = r2.building.abbreviation and r1.roomNumber = r2.roomNumber))").setLong("sessionId", sessionId.longValue()).setLong("locationId", locationId.longValue()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    private void rollBuildingsForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        if (fromSession.getBuildings() != null && !fromSession.getBuildings().isEmpty()) {
            try {
                Building fromBldg2 = null;
                Building toBldg = null;
                BuildingDAO bDao = new BuildingDAO();
                ExternalBuilding toExternalBuilding = null;
                for (Building fromBldg2 : fromSession.getBuildings()) {
                    if (fromBldg2.getExternalUniqueId() != null && this.sessionHasExternalBuildingList(toSession)) {
                        toExternalBuilding = ExternalBuilding.findExternalBuildingForSession(fromBldg2.getExternalUniqueId(), toSession);
                        if (toExternalBuilding == null) continue;
                        toBldg = new Building();
                        toBldg.setAbbreviation(toExternalBuilding.getAbbreviation());
                        toBldg.setCoordinateX(toExternalBuilding.getCoordinateX());
                        toBldg.setCoordinateY(toExternalBuilding.getCoordinateY());
                        toBldg.setExternalUniqueId(toExternalBuilding.getExternalUniqueId());
                        toBldg.setName(toExternalBuilding.getDisplayName());
                    } else {
                        toBldg = (Building)fromBldg2.clone();
                    }
                    if (toSession.getBuildings() == null) {
                        toSession.setBuildings(new HashSet<Building>());
                    }
                    toBldg.setSession(toSession);
                    toSession.getBuildings().add(toBldg);
                    bDao.saveOrUpdate(toBldg);
                    bDao.getSession().flush();
                }
            }
            catch (Exception e) {
                String type = MSG.rollForwardBuildings();
                String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
                this.iLog.error((Object)msg, (Throwable)e);
                errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
            }
        }
    }

    public void rollManagersForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollManagersForwardFrom());
        Department fromDepartment2 = null;
        Department toDepartment = null;
        TimetableManagerDAO tmDao = new TimetableManagerDAO();
        try {
            for (Department fromDepartment2 : fromSession.getDepartments()) {
                if (fromDepartment2 == null || fromDepartment2.getTimetableManagers() == null || (toDepartment = fromDepartment2.findSameDepartmentInSession(toSession)) == null) continue;
                if (toDepartment.getTimetableManagers() == null) {
                    toDepartment.setTimetableManagers(new HashSet<TimetableManager>());
                }
                TimetableManager tm2 = null;
                for (TimetableManager tm2 : fromDepartment2.getTimetableManagers()) {
                    if (tm2 == null) continue;
                    toDepartment.getTimetableManagers().add(tm2);
                    tm2.getDepartments().add(toDepartment);
                    tmDao.saveOrUpdate(tm2);
                    tmDao.getSession().flush();
                    if (!tm2.getSolverGroups(toSession).isEmpty()) continue;
                    for (SolverGroup fromSg : tm2.getSolverGroups(fromSession)) {
                        SolverGroup toSg = SolverGroup.findBySessionIdAbbv(toSession.getUniqueId(), fromSg.getAbbv());
                        if (toSg == null || tm2.getSolverGroups().contains(toSg)) continue;
                        toSg.getTimetableManagers().add(tm2);
                        tm2.getSolverGroups().add(toSg);
                    }
                }
            }
            tmDao.getSession().flush();
            tmDao.getSession().clear();
        }
        catch (Exception e) {
            String type = MSG.rollForwardTimetableManagers();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    public void rollDepartmentsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollDeptsFowardFrom());
        Department fromDepartment2 = null;
        Department toDepartment = null;
        DepartmentDAO dDao = new DepartmentDAO();
        SolverGroup sg = null;
        try {
            for (Department fromDepartment2 : fromSession.getDepartments()) {
                if (fromDepartment2 == null) continue;
                toDepartment = (Department)fromDepartment2.clone();
                toDepartment.setStatusType(null);
                toDepartment.setSession(toSession);
                toSession.addTodepartments(toDepartment);
                dDao.saveOrUpdate(toDepartment);
                if (fromDepartment2.getSolverGroup() != null) {
                    sg = SolverGroup.findBySessionIdName(toSession.getUniqueId(), fromDepartment2.getSolverGroup().getName());
                    if (sg == null) {
                        sg = (SolverGroup)fromDepartment2.getSolverGroup().clone();
                        sg.setSession(toSession);
                    }
                    if (sg != null) {
                        if (null == sg.getDepartments()) {
                            sg.setDepartments(new HashSet<Department>());
                        }
                        sg.getDepartments().add(toDepartment);
                        toDepartment.setSolverGroup(sg);
                        SolverGroupDAO sgDao = new SolverGroupDAO();
                        sgDao.saveOrUpdate(sg);
                    }
                }
                dDao.saveOrUpdate(toDepartment);
                DistributionTypeDAO dtDao = new DistributionTypeDAO();
                List l = dtDao.getQuery("select dt from DistributionType dt inner join dt.departments as d where d.uniqueId = " + fromDepartment2.getUniqueId().toString()).list();
                if (l != null && !l.isEmpty()) {
                    DistributionType distributionType2 = null;
                    for (DistributionType distributionType2 : l) {
                        distributionType2.getDepartments().add(toDepartment);
                        dtDao.saveOrUpdate(distributionType2);
                    }
                }
                dDao.getSession().flush();
                dDao.getSession().evict((Object)toDepartment);
                dDao.getSession().evict((Object)fromDepartment2);
            }
            dDao.getSession().flush();
            dDao.getSession().clear();
        }
        catch (Exception e) {
            String type = MSG.rollForwardDepartments();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    private void rollDatePatternOntoDepartments(DatePattern fromDatePattern, DatePattern toDatePattern) {
        if (fromDatePattern.getDepartments() != null && !fromDatePattern.getDepartments().isEmpty()) {
            for (Department fromDept : fromDatePattern.getDepartments()) {
                Department toDepartment = Department.findByDeptCode(fromDept.getDeptCode(), toDatePattern.getSession().getSessionId());
                if (toDepartment == null) continue;
                if (null == toDepartment.getDatePatterns()) {
                    toDepartment.setDatePatterns(new HashSet<DatePattern>());
                }
                toDepartment.getDatePatterns().add(toDatePattern);
                if (null == toDatePattern.getDepartments()) {
                    toDatePattern.setDepartments(new HashSet<Department>());
                }
                toDatePattern.addTodepartments(toDepartment);
            }
        }
    }

    public void rollDatePatternsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollDatePatternsForwardFrom());
        List<DatePattern> fromDatePatterns = DatePattern.findAll(fromSession, true, null, null);
        DatePattern fromDatePattern2 = null;
        DatePattern toDatePattern = null;
        DatePatternDAO dpDao = new DatePatternDAO();
        HashMap<DatePattern, DatePattern> fromToDatePatternMap = new HashMap<DatePattern, DatePattern>();
        try {
            DatePattern defDp;
            for (DatePattern fromDatePattern2 : fromDatePatterns) {
                if (fromDatePattern2 == null) continue;
                toDatePattern = (DatePattern)fromDatePattern2.clone();
                toDatePattern.setSession(toSession);
                this.rollDatePatternOntoDepartments(fromDatePattern2, toDatePattern);
                dpDao.saveOrUpdate(toDatePattern);
                dpDao.getSession().flush();
                fromToDatePatternMap.put(fromDatePattern2, toDatePattern);
            }
            for (DatePattern fromDp : fromToDatePatternMap.keySet()) {
                DatePattern toDp = (DatePattern)fromToDatePatternMap.get(fromDp);
                if (fromDp.getParents() == null || fromDp.getParents().isEmpty()) continue;
                for (DatePattern fromParent : fromDp.getParents()) {
                    toDp.addToparents((DatePattern)fromToDatePatternMap.get(fromParent));
                }
                dpDao.saveOrUpdate(toDp);
            }
            if (fromSession.getDefaultDatePattern() != null && (defDp = DatePattern.findByName(toSession, fromSession.getDefaultDatePattern().getName())) != null) {
                toSession.setDefaultDatePattern(defDp);
                SessionDAO sDao = new SessionDAO();
                sDao.saveOrUpdate(toSession);
            }
            dpDao.getSession().flush();
            dpDao.getSession().clear();
        }
        catch (Exception e) {
            String type = MSG.rollForwardDatePatterns();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    public void rollSubjectAreasForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollSubjectAreasForwardFrom());
        SubjectArea toSubjectArea = null;
        SubjectArea fromSubjectArea2 = null;
        SubjectAreaDAO sDao = new SubjectAreaDAO();
        Department toDepartment = null;
        try {
            if (this.sessionHasCourseCatalog(toSession)) {
                CourseCatalogDAO ccDao = new CourseCatalogDAO();
                List subjects = ccDao.getQuery("select distinct cc.subject, cc.previousSubject from CourseCatalog cc where cc.session.uniqueId=:sessionId and cc.previousSubject != null").setLong("sessionId", toSession.getUniqueId().longValue()).list();
                if (subjects != null) {
                    String toSubject = null;
                    String fromSubject = null;
                    Object[] subjectInfo2 = null;
                    for (Object[] subjectInfo2 : subjects) {
                        if (subjectInfo2 == null || subjectInfo2.length != 2) continue;
                        toSubject = (String)subjectInfo2[0];
                        fromSubject = (String)subjectInfo2[1];
                        fromSubjectArea2 = SubjectArea.findByAbbv(fromSession.getUniqueId(), fromSubject);
                        if (fromSubjectArea2 == null) continue;
                        toSubjectArea = (SubjectArea)fromSubjectArea2.clone();
                        toSubjectArea.setDepartment(null);
                        if (!toSubject.equals(fromSubject)) {
                            toSubjectArea.setSubjectAreaAbbreviation(toSubject);
                        }
                        if (fromSubjectArea2.getFundingDept() != null) {
                            Department toFundingDept = fromSubjectArea2.getFundingDept().findSameDepartmentInSession(toSession);
                            toSubjectArea.setFundingDept(toFundingDept);
                        }
                        toSubjectArea.setSession(toSession);
                        toSession.addTosubjectAreas(toSubjectArea);
                        if (fromSubjectArea2.getDepartment() == null || (toDepartment = fromSubjectArea2.getDepartment().findSameDepartmentInSession(toSession)) == null) continue;
                        toSubjectArea.setDepartment(toDepartment);
                        toDepartment.addTosubjectAreas(toSubjectArea);
                        sDao.saveOrUpdate(toSubjectArea);
                        sDao.getSession().flush();
                        sDao.getSession().evict((Object)toSubjectArea);
                        sDao.getSession().evict((Object)fromSubjectArea2);
                    }
                }
                List newSubjects = ccDao.getQuery("select distinct subject from CourseCatalog cc where cc.session.uniqueId=:sessionId and cc.previousSubject = null and cc.subject not in (select sa.subjectAreaAbbreviation from SubjectArea sa where sa.session.uniqueId=:sessionId)").setLong("sessionId", toSession.getUniqueId().longValue()).list();
                toDepartment = Department.findByDeptCode("TEMP", toSession.getUniqueId());
                if (toDepartment == null) {
                    toDepartment = new Department();
                    toDepartment.setAbbreviation("TEMP");
                    toDepartment.setAllowReqRoom(false);
                    toDepartment.setAllowReqTime(false);
                    toDepartment.setAllowReqDistribution(false);
                    toDepartment.setDeptCode("TEMP");
                    toDepartment.setExternalManager(false);
                    toDepartment.setExternalUniqueId(null);
                    toDepartment.setName("Temp Department For New Subjects");
                    toDepartment.setSession(toSession);
                    toDepartment.setDistributionPrefPriority(0);
                    toDepartment.setInheritInstructorPreferences(true);
                    toDepartment.setAllowEvents(false);
                    toDepartment.setAllowStudentScheduling(true);
                    toSession.addTodepartments(toDepartment);
                    DepartmentDAO.getInstance().saveOrUpdate(toDepartment);
                }
                String toSubject2 = null;
                for (String toSubject2 : newSubjects) {
                    if (toSubject2 == null) continue;
                    toSubjectArea = new SubjectArea();
                    toSubjectArea.setDepartment(toDepartment);
                    toSubjectArea.setTitle("New Subject");
                    toSubjectArea.setSession(toSession);
                    toSubjectArea.setSubjectAreaAbbreviation(toSubject2);
                    toDepartment.addTosubjectAreas(toSubjectArea);
                    toSession.addTosubjectAreas(toSubjectArea);
                    sDao.saveOrUpdate(toSubjectArea);
                    sDao.getSession().flush();
                    sDao.getSession().evict((Object)toSubjectArea);
                    sDao.getSession().evict((Object)fromSubjectArea2);
                }
            } else if (fromSession.getSubjectAreas() != null && !fromSession.getSubjectAreas().isEmpty()) {
                for (SubjectArea fromSubjectArea2 : fromSession.getSubjectAreas()) {
                    if (fromSubjectArea2 == null) continue;
                    toSubjectArea = (SubjectArea)fromSubjectArea2.clone();
                    if (fromSubjectArea2.getFundingDept() != null) {
                        Department toFundingDept = fromSubjectArea2.getFundingDept().findSameDepartmentInSession(toSession);
                        toSubjectArea.setFundingDept(toFundingDept);
                    }
                    toSubjectArea.setDepartment(null);
                    toSubjectArea.setSession(toSession);
                    toSession.addTosubjectAreas(toSubjectArea);
                    if (fromSubjectArea2.getDepartment() == null || (toDepartment = fromSubjectArea2.getDepartment().findSameDepartmentInSession(toSession)) == null) continue;
                    toSubjectArea.setDepartment(toDepartment);
                    toDepartment.addTosubjectAreas(toSubjectArea);
                    sDao.saveOrUpdate(toSubjectArea);
                    sDao.getSession().flush();
                    sDao.getSession().evict((Object)toSubjectArea);
                    sDao.getSession().evict((Object)fromSubjectArea2);
                }
            }
            sDao.getSession().flush();
            sDao.getSession().clear();
        }
        catch (Exception e) {
            String type = MSG.rollForwardSubjectAreas();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    private Department findManagingDepartmentForPrefGroup(PreferenceGroup prefGroup) {
        Class_ toClass_;
        Department toDepartment = null;
        if (prefGroup instanceof DepartmentalInstructor) {
            DepartmentalInstructor toInstructor = (DepartmentalInstructor)prefGroup;
            toDepartment = toInstructor.getDepartment();
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart toSchedSubpart = (SchedulingSubpart)prefGroup;
            if (toSchedSubpart.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering() != null) {
                toDepartment = toSchedSubpart.getManagingDept();
            }
        } else if (prefGroup instanceof Class_ && (toDepartment = (toClass_ = (Class_)prefGroup).getManagingDept()) == null) {
            toDepartment = toClass_.getSchedulingSubpart().getControllingDept();
        }
        return toDepartment;
    }

    private Department findToManagingDepartmentForPrefGroup(PreferenceGroup toPrefGroup, PreferenceGroup fromPrefGroup, Session toSession) {
        Department fromDepartment;
        Department toDepartment = this.findManagingDepartmentForPrefGroup(toPrefGroup);
        if (toDepartment == null && (fromDepartment = this.findManagingDepartmentForPrefGroup(fromPrefGroup)) != null) {
            toDepartment = Department.findByDeptCode(fromDepartment.getDeptCode(), toSession.getUniqueId());
            return toDepartment;
        }
        return toDepartment;
    }

    private void createToBuildingPref(BuildingPref fromBuildingPref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession, Set locations, boolean isExamPref) throws Exception {
        if (fromPrefGroup instanceof Class_ && !this.isClassRollForward()) {
            return;
        }
        BuildingPref toBuildingPref = null;
        Building toBuilding = fromBuildingPref.getBuilding().findSameBuildingInSession(toSession);
        if (toBuilding != null) {
            boolean deptHasRoomInBuilding = false;
            if (!isExamPref) {
                Location loc = null;
                Room r = null;
                Iterator rIt = locations.iterator();
                while (rIt.hasNext() && !deptHasRoomInBuilding) {
                    loc = (Location)rIt.next();
                    if (!(loc instanceof Room) || (r = (Room)loc).getBuilding() == null || !r.getBuilding().getUniqueId().equals(toBuilding.getUniqueId())) continue;
                    deptHasRoomInBuilding = true;
                }
            }
            if (isExamPref || deptHasRoomInBuilding) {
                toBuildingPref = new BuildingPref();
                toBuildingPref.setBuilding(toBuilding);
                toBuildingPref.setPrefLevel(fromBuildingPref.getPrefLevel());
                toBuildingPref.setDistanceFrom(fromBuildingPref.getDistanceFrom());
                toBuildingPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toBuildingPref);
            }
        }
    }

    protected void rollForwardBuildingPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) throws Exception {
        Set locations = null;
        boolean isExamPref = false;
        if (fromPrefGroup instanceof Exam) {
            isExamPref = true;
        }
        if (!(fromPrefGroup.getBuildingPreferences() == null || fromPrefGroup.getBuildingPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !this.isClassRollForward() || fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartLocationRollForward())) {
            locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, toSession);
            if (!isExamPref && locations == null) {
                return;
            }
            Iterator it = fromPrefGroup.getBuildingPreferences().iterator();
            while (it.hasNext()) {
                this.createToBuildingPref((BuildingPref)it.next(), fromPrefGroup, toPrefGroup, toSession, locations, isExamPref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && this.isClassPrefsPushUp() && (toPrefGroup.getBuildingPreferences() == null || toPrefGroup.getBuildingPreferences().isEmpty())) {
            SchedulingSubpart ss = (SchedulingSubpart)fromPrefGroup;
            if (locations == null) {
                locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, toSession);
            }
            if (locations != null && locations.size() > 0 && ss.getClasses() != null && !ss.getClasses().isEmpty()) {
                HashMap<String, BuildingPref> prefMap = new HashMap<String, BuildingPref>();
                HashMap<String, Integer> prefCount = new HashMap<String, Integer>();
                int clsCnt = 0;
                for (Class_ c : ss.getClasses()) {
                    if (CancelledClassAction.SKIP == this.getCancelledClassAction() && c.isCancelled().booleanValue()) continue;
                    ++clsCnt;
                    if (c.getBuildingPreferences() == null || c.getBuildingPreferences().isEmpty()) continue;
                    for (BuildingPref rfp : c.getBuildingPreferences()) {
                        String key = rfp.getPrefLevel().getPrefName() + rfp.getBuilding().getUniqueId().toString();
                        prefMap.put(key, rfp);
                        int cnt = 0;
                        if (prefCount.containsKey(key)) {
                            cnt = (Integer)prefCount.get(key);
                        }
                        prefCount.put(key, ++cnt);
                    }
                }
                for (String pref : prefCount.keySet()) {
                    if ((Integer)prefCount.get(pref) != clsCnt) continue;
                    this.createToBuildingPref((BuildingPref)prefMap.get(pref), fromPrefGroup, toPrefGroup, toSession, locations, isExamPref);
                }
            }
        }
    }

    private void createToRoomPref(RoomPref fromRoomPref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession, Set locations) {
        if (fromPrefGroup instanceof Class_ && !this.isClassRollForward()) {
            return;
        }
        RoomPref toRoomPref = new RoomPref();
        if (fromRoomPref.getRoom() instanceof Room) {
            Room fromRoom = (Room)fromRoomPref.getRoom();
            Location loc = null;
            BaseRoom toRoom = null;
            Iterator rmIt = locations.iterator();
            while (!(!rmIt.hasNext() || (loc = (Location)rmIt.next()) instanceof Room && ((toRoom = (Room)loc).getBuilding().getExternalUniqueId() != null && fromRoom.getBuilding().getExternalUniqueId() != null && toRoom.getBuilding().getExternalUniqueId().equals(fromRoom.getBuilding().getExternalUniqueId()) || (toRoom.getBuilding().getExternalUniqueId() == null || fromRoom.getBuilding().getExternalUniqueId() == null) && toRoom.getBuilding().getAbbreviation().equals(fromRoom.getBuilding().getAbbreviation())) && toRoom.getRoomNumber().equals(fromRoom.getRoomNumber()))) {
            }
            if (toRoom != null && (toRoom.getBuilding().getExternalUniqueId() != null && fromRoom.getBuilding().getExternalUniqueId() != null && toRoom.getBuilding().getExternalUniqueId().equals(fromRoom.getBuilding().getExternalUniqueId()) || (toRoom.getBuilding().getExternalUniqueId() == null || fromRoom.getBuilding().getExternalUniqueId() == null) && toRoom.getBuilding().getAbbreviation().equals(fromRoom.getBuilding().getAbbreviation())) && toRoom.getRoomNumber().equals(fromRoom.getRoomNumber())) {
                toRoomPref.setRoom(toRoom);
                toRoomPref.setPrefLevel(fromRoomPref.getPrefLevel());
                toRoomPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toRoomPref);
            }
        } else if (fromRoomPref.getRoom() instanceof NonUniversityLocation) {
            NonUniversityLocation fromNonUniversityLocation = (NonUniversityLocation)fromRoomPref.getRoom();
            Location loc = null;
            BaseNonUniversityLocation toNonUniversityLocation = null;
            Iterator rmIt = locations.iterator();
            while (!(!rmIt.hasNext() || (loc = (Location)rmIt.next()) instanceof NonUniversityLocation && (toNonUniversityLocation = (NonUniversityLocation)loc).getName().equals(fromNonUniversityLocation.getName()))) {
            }
            if (toNonUniversityLocation != null && toNonUniversityLocation.getName().equals(fromNonUniversityLocation.getName())) {
                toRoomPref.setRoom(toNonUniversityLocation);
                toRoomPref.setPrefLevel(fromRoomPref.getPrefLevel());
                toRoomPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toRoomPref);
            }
        }
    }

    private Set getLocationsFor(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        if (fromPrefGroup instanceof Exam) {
            Exam exam = (Exam)fromPrefGroup;
            if (!this.getRoomList().containsKey(exam.getExamType())) {
                this.getRoomList().put(exam.getExamType(), Location.findAllExamLocations(toSession.getUniqueId(), exam.getExamType()));
            }
            return (Set)this.getRoomList().get(exam.getExamType());
        }
        Department toDepartment = this.findToManagingDepartmentForPrefGroup(toPrefGroup, fromPrefGroup, toSession);
        if (toDepartment == null) {
            return null;
        }
        if (!this.getRoomList().containsKey(toDepartment)) {
            this.getRoomList().put(toDepartment, SessionRollForward.buildRoomListForDepartment(toDepartment, toSession));
        }
        return (Set)this.getRoomList().get(toDepartment);
    }

    protected void rollForwardRoomPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        Set locations = null;
        if (!(fromPrefGroup.getRoomPreferences() == null || fromPrefGroup.getRoomPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !this.isClassRollForward() || fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartLocationRollForward() || (locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, toSession)) == null || locations.size() <= 0)) {
            Iterator it = fromPrefGroup.getRoomPreferences().iterator();
            while (it.hasNext()) {
                this.createToRoomPref((RoomPref)it.next(), fromPrefGroup, toPrefGroup, toSession, locations);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && this.isClassPrefsPushUp() && (toPrefGroup.getRoomPreferences() == null || toPrefGroup.getRoomPreferences().isEmpty())) {
            SchedulingSubpart ss = (SchedulingSubpart)fromPrefGroup;
            if (locations == null) {
                locations = this.getLocationsFor(fromPrefGroup, toPrefGroup, toSession);
            }
            if (locations != null && locations.size() > 0 && ss.getClasses() != null && !ss.getClasses().isEmpty()) {
                HashMap<String, RoomPref> prefMap = new HashMap<String, RoomPref>();
                HashMap<String, Integer> prefCount = new HashMap<String, Integer>();
                int clsCnt = 0;
                for (Class_ c : ss.getClasses()) {
                    if (CancelledClassAction.SKIP == this.getCancelledClassAction() && c.isCancelled().booleanValue()) continue;
                    ++clsCnt;
                    if (c.getRoomPreferences() == null || c.getRoomPreferences().isEmpty()) continue;
                    for (RoomPref rfp : c.getRoomPreferences()) {
                        String key = rfp.getPrefLevel().getPrefName() + rfp.getRoom().getUniqueId().toString();
                        prefMap.put(key, rfp);
                        int cnt = 0;
                        if (prefCount.containsKey(key)) {
                            cnt = (Integer)prefCount.get(key);
                        }
                        prefCount.put(key, ++cnt);
                    }
                }
                for (String pref : prefCount.keySet()) {
                    if ((Integer)prefCount.get(pref) != clsCnt) continue;
                    this.createToRoomPref((RoomPref)prefMap.get(pref), fromPrefGroup, toPrefGroup, toSession, locations);
                }
            }
        }
    }

    protected void rollForwardPeriodPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        for (ExamPeriodPref fromPref : fromPrefGroup.getExamPeriodPreferences()) {
            ExamPeriod toPeriod = fromPref.getExamPeriod().findSameExamPeriodInSession(toSession);
            if (toPeriod == null) continue;
            ExamPeriodPref toPref = new ExamPeriodPref();
            toPref.setExamPeriod(toPeriod);
            toPref.setOwner(toPrefGroup);
            toPref.setPrefLevel(fromPref.getPrefLevel());
            toPrefGroup.addTopreferences(toPref);
        }
    }

    private void createToRoomFeaturePref(RoomFeaturePref fromRoomFeaturePref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        if (fromPrefGroup instanceof Class_ && !this.isClassRollForward()) {
            return;
        }
        RoomFeaturePref toRoomFeaturePref = new RoomFeaturePref();
        if (fromRoomFeaturePref.getRoomFeature() instanceof GlobalRoomFeature) {
            GlobalRoomFeature grf = GlobalRoomFeature.findGlobalRoomFeatureForLabel(toSession, fromRoomFeaturePref.getRoomFeature().getLabel());
            if (grf != null) {
                toRoomFeaturePref.setRoomFeature(grf);
                toRoomFeaturePref.setPrefLevel(fromRoomFeaturePref.getPrefLevel());
                toRoomFeaturePref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toRoomFeaturePref);
            }
        } else {
            Department toDepartment = this.findToManagingDepartmentForPrefGroup(toPrefGroup, fromPrefGroup, toSession);
            if (toDepartment == null) {
                return;
            }
            List<DepartmentRoomFeature> l = DepartmentRoomFeature.getAllDepartmentRoomFeatures(toDepartment);
            DepartmentRoomFeature fromDepartmentRoomFeature = (DepartmentRoomFeature)fromRoomFeaturePref.getRoomFeature();
            if (l != null && l.size() > 0) {
                BaseRoomFeature toDepartmentRoomFeature = null;
                Iterator rfIt = l.iterator();
                while (rfIt.hasNext() && !(toDepartmentRoomFeature = (DepartmentRoomFeature)rfIt.next()).getLabel().equals(fromDepartmentRoomFeature.getLabel())) {
                }
                if (toDepartmentRoomFeature.getLabel().equals(fromDepartmentRoomFeature.getLabel())) {
                    toRoomFeaturePref.setRoomFeature((RoomFeature)toDepartmentRoomFeature);
                    toRoomFeaturePref.setPrefLevel(fromRoomFeaturePref.getPrefLevel());
                    toRoomFeaturePref.setOwner(toPrefGroup);
                    toPrefGroup.addTopreferences(toRoomFeaturePref);
                }
            }
        }
    }

    protected void rollForwardRoomFeaturePrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        SchedulingSubpart ss;
        if (!(fromPrefGroup.getRoomFeaturePreferences() == null || fromPrefGroup.getRoomFeaturePreferences().isEmpty() || fromPrefGroup instanceof Class_ && !this.isClassRollForward() || fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartLocationRollForward())) {
            Iterator it = fromPrefGroup.getRoomFeaturePreferences().iterator();
            while (it.hasNext()) {
                this.createToRoomFeaturePref((RoomFeaturePref)it.next(), fromPrefGroup, toPrefGroup, toSession);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && this.isClassPrefsPushUp() && (toPrefGroup.getRoomFeaturePreferences() == null || toPrefGroup.getRoomFeaturePreferences().isEmpty()) && (ss = (SchedulingSubpart)fromPrefGroup).getClasses() != null && !ss.getClasses().isEmpty()) {
            HashMap<String, RoomFeaturePref> prefMap = new HashMap<String, RoomFeaturePref>();
            HashMap<String, Integer> prefCount = new HashMap<String, Integer>();
            int clsCnt = 0;
            for (Class_ c : ss.getClasses()) {
                if (CancelledClassAction.SKIP == this.getCancelledClassAction() && c.isCancelled().booleanValue()) continue;
                ++clsCnt;
                if (c.getRoomFeaturePreferences() == null || c.getRoomFeaturePreferences().isEmpty()) continue;
                for (RoomFeaturePref rfp : c.getRoomFeaturePreferences()) {
                    String key = rfp.getPrefLevel().getPrefName() + rfp.getRoomFeature().getUniqueId().toString();
                    prefMap.put(key, rfp);
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put(key, ++cnt);
                }
            }
            for (String pref : prefCount.keySet()) {
                if ((Integer)prefCount.get(pref) != clsCnt) continue;
                this.createToRoomFeaturePref((RoomFeaturePref)prefMap.get(pref), fromPrefGroup, toPrefGroup, toSession);
            }
        }
    }

    private void createToRoomGroupPref(RoomGroupPref fromRoomGroupPref, PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        if (fromPrefGroup instanceof Class_ && !this.isClassRollForward()) {
            return;
        }
        RoomGroupPref toRoomGroupPref = new RoomGroupPref();
        RoomGroup toDefaultRoomGroup = RoomGroup.getGlobalDefaultRoomGroup(toSession);
        if (fromRoomGroupPref.getRoomGroup().isDefaultGroup().booleanValue() && toDefaultRoomGroup != null) {
            toRoomGroupPref.setRoomGroup(toDefaultRoomGroup);
            toRoomGroupPref.setPrefLevel(fromRoomGroupPref.getPrefLevel());
            toRoomGroupPref.setOwner(toPrefGroup);
            toPrefGroup.addTopreferences(toRoomGroupPref);
        } else if (fromRoomGroupPref.getRoomGroup().isGlobal().booleanValue()) {
            RoomGroup toRoomGroup = RoomGroup.findGlobalRoomGroupForName(toSession, fromRoomGroupPref.getRoomGroup().getName());
            if (toRoomGroup != null) {
                toRoomGroupPref.setRoomGroup(toRoomGroup);
                toRoomGroupPref.setPrefLevel(fromRoomGroupPref.getPrefLevel());
                toRoomGroupPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toRoomGroupPref);
            }
        } else {
            Department toDepartment = this.findToManagingDepartmentForPrefGroup(toPrefGroup, fromPrefGroup, toSession);
            if (toDepartment == null) {
                return;
            }
            List<RoomGroup> l = RoomGroup.getAllDepartmentRoomGroups(toDepartment);
            if (l != null && l.size() > 0) {
                BaseRoomGroup toRoomGroup = null;
                Iterator itRg = l.iterator();
                while (itRg.hasNext() && !(toRoomGroup = (RoomGroup)itRg.next()).getName().equals(fromRoomGroupPref.getRoomGroup().getName())) {
                }
                if (toRoomGroup.getName().equals(fromRoomGroupPref.getRoomGroup().getName())) {
                    toRoomGroupPref.setRoomGroup((RoomGroup)toRoomGroup);
                    toRoomGroupPref.setPrefLevel(fromRoomGroupPref.getPrefLevel());
                    toRoomGroupPref.setOwner(toPrefGroup);
                    toPrefGroup.addTopreferences(toRoomGroupPref);
                }
            }
        }
    }

    protected void rollForwardRoomGroupPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        SchedulingSubpart ss;
        if (!(fromPrefGroup.getRoomGroupPreferences() == null || fromPrefGroup.getRoomGroupPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !this.isClassRollForward() || fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartLocationRollForward())) {
            Iterator it = fromPrefGroup.getRoomGroupPreferences().iterator();
            while (it.hasNext()) {
                this.createToRoomGroupPref((RoomGroupPref)it.next(), fromPrefGroup, toPrefGroup, toSession);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && this.isClassPrefsPushUp() && (toPrefGroup.getRoomGroupPreferences() == null || toPrefGroup.getRoomGroupPreferences().isEmpty()) && (ss = (SchedulingSubpart)fromPrefGroup).getClasses() != null && !ss.getClasses().isEmpty()) {
            HashMap<String, RoomGroupPref> prefMap = new HashMap<String, RoomGroupPref>();
            HashMap<String, Integer> prefCount = new HashMap<String, Integer>();
            int clsCnt = 0;
            for (Class_ c : ss.getClasses()) {
                if (CancelledClassAction.SKIP == this.getCancelledClassAction() && c.isCancelled().booleanValue()) continue;
                ++clsCnt;
                if (c.getRoomGroupPreferences() == null || c.getRoomGroupPreferences().isEmpty()) continue;
                for (RoomGroupPref rfp : c.getRoomGroupPreferences()) {
                    String key = rfp.getPrefLevel().getPrefName() + rfp.getRoomGroup().getUniqueId().toString();
                    prefMap.put(key, rfp);
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put(key, ++cnt);
                }
            }
            for (String pref : prefCount.keySet()) {
                if ((Integer)prefCount.get(pref) != clsCnt) continue;
                this.createToRoomGroupPref((RoomGroupPref)prefMap.get(pref), fromPrefGroup, toPrefGroup, toSession);
            }
        }
    }

    protected void rollForwardTimePrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        SchedulingSubpart ss;
        TimePref toTimePref;
        TimePref fromTimePref2;
        if (!(fromPrefGroup.getTimePreferences() == null || fromPrefGroup.getTimePreferences().isEmpty() || fromPrefGroup instanceof Class_ && !this.isClassRollForward() || fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartTimeRollForward())) {
            fromTimePref2 = null;
            toTimePref = null;
            for (TimePref fromTimePref2 : fromPrefGroup.getTimePreferences()) {
                if (fromTimePref2.getTimePattern() == null) {
                    toTimePref = (TimePref)fromTimePref2.clone();
                } else {
                    toTimePref = TimePattern.getMatchingTimePreference(toSession.getUniqueId(), fromTimePref2);
                    if (toTimePref == null) {
                        this.iLog.warn((Object)("To Time Pattern not found:  " + fromTimePref2.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    }
                }
                if (toTimePref == null) continue;
                toTimePref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toTimePref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartTimeRollForward()) {
            fromTimePref2 = null;
            toTimePref = null;
            for (TimePref fromTimePref2 : fromPrefGroup.getTimePreferences()) {
                if (fromTimePref2.getTimePattern() == null) {
                    toTimePref = (TimePref)fromTimePref2.clone();
                } else {
                    toTimePref = TimePattern.getMatchingTimePreference(toSession.getUniqueId(), fromTimePref2);
                    if (toTimePref == null) {
                        this.iLog.warn((Object)("To Time Pattern not found:  " + fromTimePref2.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    }
                }
                if (toTimePref == null) continue;
                toTimePref.setPreference(null);
                toTimePref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toTimePref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && this.isClassPrefsPushUp() && ((ss = (SchedulingSubpart)fromPrefGroup).getTimePreferences() == null || ss.getTimePreferences().isEmpty()) && ss.getClasses() != null && !ss.getClasses().isEmpty()) {
            TimePref toTimePref2;
            HashMap<String, TimePref> prefMap = new HashMap<String, TimePref>();
            HashMap<String, Integer> prefCount = new HashMap<String, Integer>();
            HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
            int clsCnt = 0;
            for (Class_ c : ss.getClasses()) {
                if (CancelledClassAction.SKIP == this.getCancelledClassAction() && c.isCancelled().booleanValue()) continue;
                ++clsCnt;
                if (c.getTimePreferences() == null || c.getTimePreferences().isEmpty()) continue;
                for (TimePref tp : c.getTimePreferences()) {
                    String key = tp.getPrefLevel().getPrefName() + tp.getTimePattern().getUniqueId().toString() + tp.getPreference();
                    prefMap.put(key, tp);
                    timePatterns.add(tp.getTimePattern());
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put(key, ++cnt);
                }
            }
            for (String pref : prefCount.keySet()) {
                if ((Integer)prefCount.get(pref) != clsCnt) continue;
                TimePref fromTimePref3 = (TimePref)prefMap.get(pref);
                toTimePref2 = null;
                if (fromTimePref3.getTimePattern() == null) {
                    toTimePref2 = (TimePref)fromTimePref3.clone();
                } else {
                    if (fromTimePref3.getTimePattern().isExactTime()) continue;
                    toTimePref2 = TimePattern.getMatchingTimePreference(toSession.getUniqueId(), fromTimePref3);
                    if (toTimePref2 == null) {
                        this.iLog.warn((Object)("To Time Pattern not found:  " + fromTimePref3.getTimePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    }
                }
                if (toTimePref2 != null) {
                    toTimePref2.setOwner(toPrefGroup);
                    toPrefGroup.addTopreferences(toTimePref2);
                    if (toTimePref2.getPreference().contains("R") || toTimePref2.getPreference().contains("P")) {
                        toTimePref2.setPreference(null);
                    }
                }
                timePatterns.remove(fromTimePref3.getTimePattern());
            }
            for (TimePattern fromTp : timePatterns) {
                if (fromTp.isExactTime()) continue;
                TimePattern toTp = TimePattern.getMatchingTimePattern(toSession.getUniqueId(), fromTp);
                toTimePref2 = null;
                if (toTp != null) {
                    toTimePref2 = new TimePref();
                    toTimePref2.setOwner(toPrefGroup);
                    toTimePref2.setTimePattern(toTp);
                    toTimePref2.setPrefLevel(PreferenceLevel.getPreferenceLevel("R"));
                    toPrefGroup.addTopreferences(toTimePref2);
                    continue;
                }
                this.iLog.warn((Object)("To Time Pattern not found:  " + fromTp.getName() + " for " + fromPrefGroup.htmlLabel()));
            }
        }
    }

    protected void rollForwardDatePatternPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession, org.hibernate.Session hibSession) {
        SchedulingSubpart ss;
        if (!(fromPrefGroup.getDatePatternPreferences() == null || fromPrefGroup.getDatePatternPreferences().isEmpty() || fromPrefGroup instanceof Class_ && !this.isClassRollForward() || fromPrefGroup instanceof SchedulingSubpart && !this.isSubpartTimeRollForward())) {
            DatePatternPref fromDatePatternPref22 = null;
            DatePatternPref toDatePatternPref = null;
            for (DatePatternPref fromDatePatternPref22 : fromPrefGroup.getDatePatternPreferences()) {
                DatePattern toDatePattern = DatePattern.findByName(toSession, fromDatePatternPref22.getDatePattern().getName());
                if (toDatePattern == null) {
                    this.iLog.warn((Object)("To Date Pattern not found:  " + fromDatePatternPref22.getDatePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    continue;
                }
                toDatePatternPref = (DatePatternPref)fromDatePatternPref22.clone();
                toDatePatternPref.setDatePattern(toDatePattern);
                toDatePatternPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toDatePatternPref);
            }
        }
        if (fromPrefGroup instanceof SchedulingSubpart && this.isClassPrefsPushUp() && (toPrefGroup.getDatePatternPreferences() == null || toPrefGroup.getDatePatternPreferences().isEmpty()) && (ss = (SchedulingSubpart)fromPrefGroup).getClasses() != null && !ss.getClasses().isEmpty()) {
            HashMap<String, DatePatternPref> prefMap = new HashMap<String, DatePatternPref>();
            HashMap<String, Integer> prefCount = new HashMap<String, Integer>();
            int clsCnt = 0;
            BaseDatePattern firstDp = null;
            int dpCount = 0;
            for (Class_ class_ : ss.getClasses()) {
                if (CancelledClassAction.SKIP == this.getCancelledClassAction() && class_.isCancelled().booleanValue()) continue;
                ++clsCnt;
                DatePattern dp = class_.effectiveDatePattern();
                if (dp != null) {
                    if (firstDp == null) {
                        firstDp = dp;
                        ++dpCount;
                    } else if (firstDp.equals(dp)) {
                        ++dpCount;
                    }
                }
                if (class_.getDatePatternPreferences() == null || class_.getDatePatternPreferences().isEmpty()) continue;
                for (DatePatternPref dfp : class_.getDatePatternPreferences()) {
                    String key = dfp.getPrefLevel().getPrefName() + dfp.getDatePattern().getUniqueId().toString();
                    prefMap.put(key, dfp);
                    int cnt = 0;
                    if (prefCount.containsKey(key)) {
                        cnt = (Integer)prefCount.get(key);
                    }
                    prefCount.put(key, ++cnt);
                }
            }
            if (firstDp != null && dpCount == clsCnt && !firstDp.equals(ss.effectiveDatePattern())) {
                DatePattern toDatePattern = DatePattern.findByName(toSession, firstDp.getName());
                if (toDatePattern == null) {
                    this.iLog.warn((Object)("To Date Pattern not found:  " + firstDp.getName() + " for " + fromPrefGroup.htmlLabel()));
                } else {
                    ((SchedulingSubpart)toPrefGroup).setDatePattern(toDatePattern);
                    for (Class_ c : ((SchedulingSubpart)toPrefGroup).getClasses()) {
                        c.setDatePattern(null);
                        hibSession.update((Object)c);
                    }
                }
            }
            for (String string : prefCount.keySet()) {
                if ((Integer)prefCount.get(string) != clsCnt) continue;
                DatePatternPref fromDatePatternPref = (DatePatternPref)prefMap.get(string);
                DatePattern toDatePattern = DatePattern.findByName(toSession, fromDatePatternPref.getDatePattern().getName());
                if (toDatePattern == null) {
                    this.iLog.warn((Object)("To Date Pattern not found:  " + fromDatePatternPref.getDatePattern().getName() + " for " + fromPrefGroup.htmlLabel()));
                    continue;
                }
                DatePatternPref toDatePatternPref = (DatePatternPref)fromDatePatternPref.clone();
                toDatePatternPref.setDatePattern(toDatePattern);
                toDatePatternPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toDatePatternPref);
            }
        }
    }

    protected void rollForwardDistributionPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession, org.hibernate.Session hibSession) {
        if (fromPrefGroup.getDistributionObjects() != null && !fromPrefGroup.getDistributionObjects().isEmpty()) {
            DistributionObject fromDistObj2 = null;
            DistributionObject toDistObj = null;
            DistributionPref fromDistributionPref = null;
            DistributionPref toDistributionPref = null;
            for (DistributionObject fromDistObj2 : fromPrefGroup.getDistributionObjects()) {
                toDistObj = new DistributionObject();
                fromDistributionPref = fromDistObj2.getDistributionPref();
                if (!this.isRollForwardDistributions(fromDistributionPref)) continue;
                toDistributionPref = DistributionPref.findByIdRolledForwardFrom(fromDistributionPref.getUniqueId(), toSession.getUniqueId());
                if (toDistributionPref == null) {
                    toDistributionPref = new DistributionPref();
                    toDistributionPref.setDistributionType(fromDistributionPref.getDistributionType());
                    toDistributionPref.setGrouping(fromDistributionPref.getGrouping());
                    toDistributionPref.setPrefLevel(fromDistributionPref.getPrefLevel());
                    toDistributionPref.setUniqueIdRolledForwardFrom(fromDistributionPref.getUniqueId());
                    Department toDept = Department.findByDeptCode(((Department)fromDistributionPref.getOwner()).getDeptCode(), toSession.getUniqueId());
                    if (toDept == null) continue;
                    toDistributionPref.setOwner(toDept);
                    toDept.addTopreferences(toDistributionPref);
                }
                toDistObj.setDistributionPref(toDistributionPref);
                toDistObj.setPrefGroup(toPrefGroup);
                toDistObj.setSequenceNumber(fromDistObj2.getSequenceNumber());
                toPrefGroup.addTodistributionObjects(toDistObj);
                hibSession.saveOrUpdate((Object)toDistributionPref);
            }
        }
    }

    protected void rollForwardInstructorCoursePrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        Set preferences = fromPrefGroup.getPreferences(InstructorCoursePref.class);
        if (toPrefGroup.getPreferences() != null) {
            Iterator<Preference> i = toPrefGroup.getPreferences().iterator();
            while (i.hasNext()) {
                Preference p = i.next();
                if (!(p instanceof InstructorCoursePref)) continue;
                i.remove();
            }
        }
        if (preferences != null && !preferences.isEmpty()) {
            for (InstructorCoursePref fromCoursePref : preferences) {
                CourseOffering course = CourseOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromCoursePref.getCourse().getUniqueId());
                if (course == null) continue;
                InstructorCoursePref toCoursePref = (InstructorCoursePref)fromCoursePref.clone();
                toCoursePref.setCourse(course);
                toCoursePref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toCoursePref);
            }
        }
    }

    private void rollGlobalInstructorAttributesForward(RollForwardSessionAction.RollForwardErrors errors, Session fromSession, Session toSession) {
        HashMap<Long, InstructorAttribute> attributes = new HashMap<Long, InstructorAttribute>();
        for (InstructorAttribute oldAttribute : InstructorAttribute.getAllGlobalAttributes(toSession.getUniqueId())) {
            InstructorAttributeDAO.getInstance().delete(oldAttribute);
        }
        List<InstructorAttribute> globalAttributes = InstructorAttribute.getAllGlobalAttributes(fromSession.getUniqueId());
        for (InstructorAttribute fromAttribute : globalAttributes) {
            InstructorAttribute toAttribute = new InstructorAttribute();
            toAttribute.setSession(toSession);
            toAttribute.setCode(fromAttribute.getCode());
            toAttribute.setName(fromAttribute.getName());
            toAttribute.setType(fromAttribute.getType());
            toAttribute.setInstructors(new HashSet<DepartmentalInstructor>());
            toAttribute.setChildAttributes(new HashSet<InstructorAttribute>());
            attributes.put(fromAttribute.getUniqueId(), toAttribute);
            InstructorAttributeDAO.getInstance().saveOrUpdate(toAttribute);
        }
        for (InstructorAttribute fromChildAttribute : globalAttributes) {
            if (fromChildAttribute.getParentAttribute() == null) continue;
            InstructorAttribute toChildAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getUniqueId());
            InstructorAttribute toParentAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getParentAttribute().getUniqueId());
            if (toParentAttribute == null) continue;
            toChildAttribute.setParentAttribute(toParentAttribute);
            toParentAttribute.getChildAttributes().add(toChildAttribute);
            InstructorAttributeDAO.getInstance().saveOrUpdate(toChildAttribute);
        }
    }

    private void rollDepartmentalInstructorAttributesForward(RollForwardSessionAction.RollForwardErrors errors, Department fromDepartment, Department toDepartment) {
        HashMap<Long, InstructorAttribute> attributes = new HashMap<Long, InstructorAttribute>();
        for (InstructorAttribute oldAttribute : InstructorAttribute.getAllDepartmentalAttributes(toDepartment.getUniqueId())) {
            InstructorAttributeDAO.getInstance().delete(oldAttribute);
        }
        List<InstructorAttribute> departmentalAttributes = InstructorAttribute.getAllDepartmentalAttributes(fromDepartment.getUniqueId());
        for (InstructorAttribute fromAttribute : departmentalAttributes) {
            InstructorAttribute toAttribute = new InstructorAttribute();
            toAttribute.setSession(toDepartment.getSession());
            toAttribute.setDepartment(toDepartment);
            toAttribute.setCode(fromAttribute.getCode());
            toAttribute.setName(fromAttribute.getName());
            toAttribute.setType(fromAttribute.getType());
            toAttribute.setInstructors(new HashSet<DepartmentalInstructor>());
            toAttribute.setChildAttributes(new HashSet<InstructorAttribute>());
            attributes.put(fromAttribute.getUniqueId(), toAttribute);
            InstructorAttributeDAO.getInstance().save(toAttribute);
        }
        for (InstructorAttribute fromChildAttribute : departmentalAttributes) {
            if (fromChildAttribute.getParentAttribute() == null) continue;
            InstructorAttribute toChildAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getUniqueId());
            InstructorAttribute toParentAttribute = (InstructorAttribute)attributes.get(fromChildAttribute.getParentAttribute().getUniqueId());
            if (toParentAttribute == null) continue;
            toChildAttribute.setParentAttribute(toParentAttribute);
            toParentAttribute.getChildAttributes().add(toChildAttribute);
            InstructorAttributeDAO.getInstance().saveOrUpdate(toChildAttribute);
        }
    }

    protected void rollForwardInstructorAttributePrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        Set preferences = fromPrefGroup.getPreferences(InstructorAttributePref.class);
        if (preferences != null && !preferences.isEmpty()) {
            for (InstructorAttributePref fromAttributePref : preferences) {
                InstructorAttribute attribute = fromAttributePref.getAttribute().findSameAttributeInSession(toSession);
                if (attribute == null) continue;
                InstructorAttributePref toAttributePref = (InstructorAttributePref)fromAttributePref.clone();
                toAttributePref.setAttribute(attribute);
                toAttributePref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toAttributePref);
            }
        }
    }

    protected void rollForwardInstructorPrefs(PreferenceGroup fromPrefGroup, PreferenceGroup toPrefGroup, Session toSession) {
        Set preferences = fromPrefGroup.getPreferences(InstructorPref.class);
        if (preferences != null && !preferences.isEmpty()) {
            for (InstructorPref fromInstrPref : preferences) {
                DepartmentalInstructor instructor = fromInstrPref.getInstructor().findThisInstructorInSession(toSession.getUniqueId());
                if (instructor == null) continue;
                InstructorPref toInstrPref = (InstructorPref)fromInstrPref.clone();
                toInstrPref.setInstructor(instructor);
                toInstrPref.setOwner(toPrefGroup);
                toPrefGroup.addTopreferences(toInstrPref);
            }
        }
    }

    private void rollForwardExamPeriods(Session toSession, Session fromSession) {
        ExamPeriod fromExamPeriod2 = null;
        ExamPeriod toExamPeriod = null;
        ExamPeriodDAO examPeriodDao = new ExamPeriodDAO();
        TreeSet<ExamPeriod> examPeriods = ExamPeriod.findAll(fromSession.getUniqueId(), (Long)null);
        for (ExamPeriod fromExamPeriod2 : examPeriods) {
            toExamPeriod = (ExamPeriod)fromExamPeriod2.clone();
            toExamPeriod.setSession(toSession);
            if (toExamPeriod.getEventStartOffset() == null) {
                toExamPeriod.setEventStartOffset(0);
            }
            if (toExamPeriod.getEventStopOffset() == null) {
                toExamPeriod.setEventStopOffset(0);
            }
            examPeriodDao.save(toExamPeriod);
        }
    }

    private void rollForwardExamLocationPrefs(Session toSession, Session fromSession) throws Exception {
        List rooms = new RoomDAO().getQuery("select distinct r from Room r inner join r.examPreferences as ep where r.session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list();
        Room fromRoom2 = null;
        Room toRoom = null;
        ExamLocationPref fromPref2 = null;
        ExamPeriod toPeriod = null;
        for (Room fromRoom2 : rooms) {
            toRoom = fromRoom2.findSameRoomInSession(toSession);
            if (toRoom == null) continue;
            for (ExamLocationPref fromPref2 : fromRoom2.getExamPreferences()) {
                toPeriod = fromPref2.getExamPeriod().findSameExamPeriodInSession(toSession);
                if (toPeriod == null) continue;
                toRoom.addExamPreference(toPeriod, fromPref2.getPrefLevel());
            }
        }
        List nonUniversityLocations = new NonUniversityLocationDAO().getQuery("select distinct nul from NonUniversityLocation nul inner join nul.examPreferences as ep where nul.session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list();
        NonUniversityLocation fromNonUniversityLocation2 = null;
        NonUniversityLocation toNonUniversityLocation = null;
        for (NonUniversityLocation fromNonUniversityLocation2 : nonUniversityLocations) {
            toNonUniversityLocation = fromNonUniversityLocation2.findSameNonUniversityLocationInSession(toSession);
            if (toNonUniversityLocation == null) continue;
            for (ExamLocationPref fromPref2 : fromNonUniversityLocation2.getExamPreferences()) {
                toPeriod = fromPref2.getExamPeriod().findSameExamPeriodInSession(toSession);
                if (toPeriod == null) continue;
                toNonUniversityLocation.addExamPreference(toPeriod, fromPref2.getPrefLevel());
            }
        }
    }

    private void rollForwardExaminationManagers(Session toSession, Session fromSession) throws Exception {
        ExamStatusDAO dao = ExamStatusDAO.getInstance();
        HashSet managers = new HashSet(dao.getSession().createQuery("select distinct m from TimetableManager m inner join m.departments d inner join m.managerRoles mr where d.session.uniqueId = :sessionId and mr.role.enabled = true and :prmExMgr in elements(mr.role.rights) and :prmAdmin not in elements(mr.role.rights) order by m.lastName, m.firstName").setLong("sessionId", toSession.getUniqueId().longValue()).setString("prmExMgr", Right.ExaminationSolver.name()).setString("prmAdmin", Right.StatusIndependent.name()).list());
        List statuses = dao.getSession().createQuery("from ExamStatus s where s.session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list();
        for (ExamStatus fromStatus : statuses) {
            ExamStatus toStatus = ExamStatus.findStatus(toSession.getUniqueId(), fromStatus.getType().getUniqueId());
            if (toStatus == null) {
                toStatus = new ExamStatus();
                toStatus.setSession(toSession);
                toStatus.setType(fromStatus.getType());
                toStatus.setManagers(new HashSet<TimetableManager>());
            } else {
                toStatus.getManagers().clear();
            }
            for (TimetableManager m : fromStatus.getManagers()) {
                if (!managers.contains(m)) continue;
                toStatus.getManagers().add(m);
            }
            dao.saveOrUpdate(toStatus);
        }
    }

    private void rollForwardExam(Exam fromExam, Session toSession, String prefOption) throws Exception {
        Exam toExam = new Exam();
        toExam.setExamType(fromExam.getExamType());
        toExam.setLength(fromExam.getLength());
        toExam.setMaxNbrRooms(fromExam.getMaxNbrRooms());
        toExam.setNote(fromExam.getNote());
        toExam.setSeatingType(fromExam.getSeatingType());
        toExam.setSession(toSession);
        toExam.setUniqueIdRolledForwardFrom(fromExam.getUniqueId());
        if (fromExam.getAveragePeriod() != null && fromExam.getAssignedPeriod() != null) {
            toExam.setAvgPeriod((fromExam.getAvgPeriod() + fromExam.getAssignedPeriod().getIndex()) / 2);
        } else if (fromExam.getAveragePeriod() != null) {
            toExam.setAvgPeriod(fromExam.getAvgPeriod());
        } else if (fromExam.getAssignedPeriod() != null) {
            toExam.setAvgPeriod(fromExam.getAssignedPeriod().getIndex());
        }
        for (ExamOwner fromOwner : fromExam.getOwners()) {
            ExamOwner toOwner = new ExamOwner();
            if (fromOwner.getOwnerType().equals(3)) {
                Class_ fromClass = (Class_)fromOwner.getOwnerObject();
                Class_ toClass = Class_.findByIdRolledForwardFrom(toSession.getUniqueId(), fromClass.getUniqueId());
                if (toClass != null) {
                    toOwner.setOwner(toClass);
                }
            } else if (fromOwner.getOwnerType().equals(2)) {
                InstrOfferingConfig fromIoc = (InstrOfferingConfig)fromOwner.getOwnerObject();
                InstrOfferingConfig toIoc = InstrOfferingConfig.findByIdRolledForwardFrom(toSession.getUniqueId(), fromIoc.getUniqueId());
                if (toIoc != null) {
                    toOwner.setOwner(toIoc);
                }
            } else if (fromOwner.getOwnerType().equals(0)) {
                InstructionalOffering fromIo = (InstructionalOffering)fromOwner.getOwnerObject();
                InstructionalOffering toIo = InstructionalOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromIo.getUniqueId());
                if (toIo != null) {
                    toOwner.setOwner(toIo);
                }
            } else if (fromOwner.getOwnerType().equals(1)) {
                CourseOffering fromCo = (CourseOffering)fromOwner.getOwnerObject();
                CourseOffering toCo = CourseOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromCo.getUniqueId());
                if (toCo != null) {
                    toOwner.setOwner(toCo);
                }
            }
            if (toOwner.getOwnerType() == null) continue;
            toOwner.setExam(toExam);
            toExam.addToowners(toOwner);
        }
        if (toExam.getOwners() != null || toExam.getOwners().size() > 0) {
            ExamDAO eDao = new ExamDAO();
            eDao.save(toExam);
            if (EXAMS_ROOM_PREFS.equals(prefOption) || EXAMS_ALL_PREF.equals(prefOption)) {
                this.rollForwardBuildingPrefs(fromExam, toExam, toSession);
                this.rollForwardRoomGroupPrefs(fromExam, toExam, toSession);
                this.rollForwardRoomFeaturePrefs(fromExam, toExam, toSession);
            }
            if (EXAMS_ALL_PREF.equals(prefOption)) {
                this.rollForwardRoomPrefs(fromExam, toExam, toSession);
                this.rollForwardPeriodPrefs(fromExam, toExam, toSession);
            }
            eDao.update(toExam);
            eDao.getSession().flush();
            eDao.getSession().evict((Object)toExam);
            eDao.getSession().evict((Object)fromExam);
        }
    }

    private List findExamToRollForward(Session toSession, int examType) {
        ExamDAO eDao = new ExamDAO();
        return eDao.getQuery("select distinct e from ExamOwner as eo inner join eo.exam as e where e.examType.type = :examType  and ((eo.ownerType=:ownerTypeClass and eo.ownerId in (select c.uniqueIdRolledForwardFrom from Class_ as c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :toSessionId))  or (eo.ownerType=:ownerTypeCourse and eo.ownerId in (select co.uniqueIdRolledForwardFrom from CourseOffering as co where co.subjectArea.session.uniqueId = :toSessionId))  or (eo.ownerType=:ownerTypeOffering and eo.ownerId in (select io.uniqueIdRolledForwardFrom from InstructionalOffering as io where io.session.uniqueId = :toSessionId))  or (eo.ownerType=:ownerTypeConfig and eo.ownerId in (select ioc.uniqueIdRolledForwardFrom from InstrOfferingConfig as ioc where ioc.instructionalOffering.session.uniqueId = :toSessionId)))").setLong("toSessionId", toSession.getUniqueId().longValue()).setInteger("examType", examType).setInteger("ownerTypeClass", 3).setInteger("ownerTypeCourse", 1).setInteger("ownerTypeOffering", 0).setInteger("ownerTypeConfig", 2).list();
    }

    public void rollMidtermExamsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        try {
            List exams = this.findExamToRollForward(toSession, 1);
            Iterator examIt = exams.iterator();
            while (examIt.hasNext()) {
                this.rollForwardExam((Exam)examIt.next(), toSession, rollForwardSessionForm.getMidtermExamsPrefsAction());
            }
        }
        catch (Exception e) {
            String type = MSG.rollForwardMidtermExams();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForwardTo(type, toSession.getLabel(), msg));
        }
    }

    public void rollFinalExamsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        try {
            List exams = this.findExamToRollForward(toSession, 0);
            Iterator examIt = exams.iterator();
            while (examIt.hasNext()) {
                this.rollForwardExam((Exam)examIt.next(), toSession, rollForwardSessionForm.getFinalExamsPrefsAction());
            }
        }
        catch (Exception e) {
            String type = MSG.rollForwardFinalExams();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForwardTo(type, toSession.getLabel(), msg));
        }
    }

    public void rollExamConfigurationDataForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollExamConfigurationForwardFrom());
        try {
            this.rollForwardExamPeriods(toSession, fromSession);
            this.rollForwardExamLocationPrefs(toSession, fromSession);
            this.rollForwardExaminationManagers(toSession, fromSession);
        }
        catch (Exception e) {
            String type = MSG.rollForwardExamConfiguration();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    protected void rollInstructorDistributionPrefs(DepartmentalInstructor fromInstructor, DepartmentalInstructor toInstructor) {
        if (fromInstructor.getDistributionPreferences() != null && fromInstructor.getDistributionPreferences().size() > 0) {
            DistributionPref fromDistributionPref2 = null;
            DistributionPref toDistributionPref = null;
            for (DistributionPref fromDistributionPref2 : fromInstructor.getDistributionPreferences()) {
                toDistributionPref = new DistributionPref();
                if (fromDistributionPref2.getDistributionType() != null) {
                    toDistributionPref.setDistributionType(fromDistributionPref2.getDistributionType());
                }
                if (fromDistributionPref2.getGrouping() != null) {
                    toDistributionPref.setGrouping(fromDistributionPref2.getGrouping());
                }
                toDistributionPref.setPrefLevel(fromDistributionPref2.getPrefLevel());
                toDistributionPref.setOwner(toInstructor);
                toInstructor.addTopreferences(toDistributionPref);
            }
        }
    }

    public void rollInstructorDataForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollInstructorDataForwardFrom());
        DepartmentalInstructor toInstructor = null;
        DepartmentalInstructorDAO iDao = new DepartmentalInstructorDAO();
        Department toDepartment = null;
        ArrayList<String> deptsToRollDataFor = new ArrayList<String>();
        for (String dept : rollForwardSessionForm.getRollForwardDepartmentIds()) {
            deptsToRollDataFor.add(dept);
        }
        try {
            if (fromSession.getDepartments() != null) {
                String existingQuery = "select di.department.deptCode || di.externalUniqueId from DepartmentalInstructor di where di.department.session.uniqueId = :sessionId and di.externalUniqueId is not null";
                ArrayList existingInstructors = (ArrayList)iDao.getSession().createQuery(existingQuery).setLong("sessionId", toSession.getUniqueId().longValue()).list();
                String existingNoExtIdQuery = "select di.department.deptCode || di.lastName || ',' || di.firstName || ',' || di.middleName from DepartmentalInstructor di where di.department.session.uniqueId = :sessionId and di.externalUniqueId is null";
                ArrayList existingNoExtIdInstructors = (ArrayList)iDao.getSession().createQuery(existingNoExtIdQuery).setLong("sessionId", toSession.getUniqueId().longValue()).list();
                for (Department fromDepartment : fromSession.getDepartments()) {
                    if (fromDepartment == null || fromDepartment.getInstructors() == null || fromDepartment.getInstructors().isEmpty() || (toDepartment = fromDepartment.findSameDepartmentInSession(toSession)) == null || !deptsToRollDataFor.contains(toDepartment.getUniqueId().toString())) continue;
                    this.rollDepartmentalInstructorAttributesForward(errors, fromDepartment, toDepartment);
                    for (DepartmentalInstructor fromInstructor : fromDepartment.getInstructors()) {
                        if (fromInstructor.getExternalUniqueId() != null && !fromInstructor.getExternalUniqueId().isEmpty() && existingInstructors.contains(toDepartment.getDeptCode() + fromInstructor.getExternalUniqueId())) {
                            this.iLog.info((Object)(fromInstructor.toString() + ": already exists in term, not rolling forward"));
                            continue;
                        }
                        if ((fromInstructor.getExternalUniqueId() == null || fromInstructor.getExternalUniqueId().isEmpty()) && existingNoExtIdInstructors.contains(toDepartment.getDeptCode() + fromInstructor.getLastName() + "," + fromInstructor.getFirstName() + "," + fromInstructor.getMiddleName())) {
                            this.iLog.info((Object)(fromInstructor.toString() + ": already exists in term, not rolling forward"));
                            continue;
                        }
                        toInstructor = (DepartmentalInstructor)fromInstructor.clone();
                        toInstructor.setDepartment(toDepartment);
                        toInstructor.setAttributes(new HashSet<InstructorAttribute>());
                        for (InstructorAttribute fromAttribute : fromInstructor.getAttributes()) {
                            InstructorAttribute toAttribute = fromAttribute.findSameAttributeInSession(toSession);
                            if (toAttribute == null) continue;
                            toAttribute.addToinstructors(toInstructor);
                            toInstructor.addToattributes(toAttribute);
                        }
                        this.rollForwardBuildingPrefs(fromInstructor, toInstructor, toSession);
                        this.rollForwardRoomPrefs(fromInstructor, toInstructor, toSession);
                        this.rollForwardRoomFeaturePrefs(fromInstructor, toInstructor, toSession);
                        this.rollForwardRoomGroupPrefs(fromInstructor, toInstructor, toSession);
                        this.rollForwardTimePrefs(fromInstructor, toInstructor, toSession);
                        this.rollInstructorDistributionPrefs(fromInstructor, toInstructor);
                        iDao.saveOrUpdate(toInstructor);
                        iDao.getSession().flush();
                        iDao.getSession().evict((Object)toInstructor);
                        iDao.getSession().evict((Object)fromInstructor);
                    }
                }
                iDao.getSession().flush();
                iDao.getSession().clear();
            }
        }
        catch (Exception e) {
            String type = MSG.rollForwardInstructors();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    public void rollCourseOfferingsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollCourseOfferingsForwardFrom());
        ArrayList subjects = new ArrayList();
        SubjectAreaDAO saDao = new SubjectAreaDAO();
        for (int i = 0; i < rollForwardSessionForm.getRollForwardSubjectAreaIds().length; ++i) {
            subjects.add(saDao.get(Long.parseLong(rollForwardSessionForm.getRollForwardSubjectAreaIds()[i])));
        }
        if (toSession.getSubjectAreas() != null) {
            SubjectArea subjectArea2 = null;
            InstructionalOfferingRollForward instrOffrRollFwd = new InstructionalOfferingRollForward(this.iLog);
            instrOffrRollFwd.setClassPrefRollForwardParameter(rollForwardSessionForm.getClassPrefsAction());
            instrOffrRollFwd.setSubpartLocationPrefRollForwardParameters(rollForwardSessionForm.getSubpartLocationPrefsAction());
            instrOffrRollFwd.setSubpartTimePrefRollForwardParameters(rollForwardSessionForm.getSubpartTimePrefsAction());
            instrOffrRollFwd.setRollForwardDistributions(rollForwardSessionForm.getRollForwardDistributions());
            instrOffrRollFwd.setCancelledClassActionRollForwardParameter(rollForwardSessionForm.getCancelledClassAction());
            instrOffrRollFwd.setWaitListsAndProhibitedOverrides(rollForwardSessionForm.getRollForwardWaitListsProhibitedOverrides());
            for (SubjectArea subjectArea2 : subjects) {
                instrOffrRollFwd.rollForwardInstructionalOfferingsForASubjectArea(subjectArea2.getSubjectAreaAbbreviation(), fromSession, toSession);
            }
        }
    }

    public void addNewCourseOfferings(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        ArrayList subjects = new ArrayList();
        SubjectAreaDAO saDao = new SubjectAreaDAO();
        for (int i = 0; i < rollForwardSessionForm.getAddNewCourseOfferingsSubjectIds().length; ++i) {
            subjects.add(saDao.get(Long.parseLong(rollForwardSessionForm.getAddNewCourseOfferingsSubjectIds()[i])));
        }
        if (toSession.getSubjectAreas() != null) {
            SubjectArea subjectArea2 = null;
            InstructionalOfferingRollForward instrOffrRollFwd = new InstructionalOfferingRollForward(this.iLog);
            for (SubjectArea subjectArea2 : subjects) {
                instrOffrRollFwd.addNewInstructionalOfferingsForASubjectArea(subjectArea2.getSubjectAreaAbbreviation(), toSession);
            }
        }
    }

    private static String buildRoomQueryForDepartment(Department dept, Session sess, String locType) {
        StringBuffer sb = new StringBuffer();
        sb.append("select l from " + locType + " as l inner join l.roomDepts as rd where l.session.uniqueId = ");
        sb.append(sess.getUniqueId().toString());
        sb.append(" and rd.department.uniqueId = ");
        sb.append(dept.getUniqueId().toString());
        return sb.toString();
    }

    private static Set buildRoomListForDepartment(Department department, Session session) {
        TreeSet<Location> ts = new TreeSet<Location>();
        Iterator it = RoomDAO.getInstance().getQuery(SessionRollForward.buildRoomQueryForDepartment(department, session, "Room")).iterate();
        Room r = null;
        while (it.hasNext()) {
            r = (Room)it.next();
            RoomDept rd2 = null;
            for (RoomDept rd2 : r.getRoomDepts()) {
                rd2.getDepartment();
            }
            ts.add(r);
        }
        it = NonUniversityLocationDAO.getInstance().getQuery(SessionRollForward.buildRoomQueryForDepartment(department, session, "NonUniversityLocation")).iterate();
        NonUniversityLocation l = null;
        while (it.hasNext()) {
            l = (NonUniversityLocation)it.next();
            RoomDept rd3 = null;
            for (RoomDept rd3 : l.getRoomDepts()) {
                rd3.getDepartment();
            }
            ts.add(l);
        }
        return ts;
    }

    public HashMap getRoomList() {
        if (this.roomList == null) {
            this.roomList = new HashMap();
        }
        return this.roomList;
    }

    public boolean sessionHasCourseCatalog(Session session) {
        if (session == null) {
            return false;
        }
        if (!this.getSessionHasCourseCatalogList().containsKey(session)) {
            CourseCatalogDAO ccDao = new CourseCatalogDAO();
            List l = ccDao.getQuery("select count(cc) from CourseCatalog cc where cc.session.uniqueId =" + session.getUniqueId().toString()).list();
            int cnt = 0;
            if (l != null && !l.isEmpty()) {
                cnt = ((Long)l.get(0)).intValue();
            }
            this.getSessionHasCourseCatalogList().put(session, cnt != 0);
        }
        return (Boolean)this.getSessionHasCourseCatalogList().get(session);
    }

    public HashMap getSessionHasCourseCatalogList() {
        if (this.sessionHasCourseCatalogList == null) {
            this.sessionHasCourseCatalogList = new HashMap();
        }
        return this.sessionHasCourseCatalogList;
    }

    public boolean sessionHasExternalBuildingList(Session session) {
        if (!this.getSessionHasExternalBuildingList().containsKey(session)) {
            ExternalBuildingDAO ebDao = new ExternalBuildingDAO();
            List l = ebDao.getQuery("select count(eb) from ExternalBuilding eb where eb.session.uniqueId =" + session.getUniqueId().toString()).list();
            int cnt = 0;
            if (l != null && !l.isEmpty()) {
                cnt = ((Long)l.get(0)).intValue();
            }
            this.getSessionHasExternalBuildingList().put(session, cnt != 0);
        }
        return (Boolean)this.getSessionHasExternalBuildingList().get(session);
    }

    public HashMap getSessionHasExternalBuildingList() {
        if (this.sessionHasExternalBuildingList == null) {
            this.sessionHasExternalBuildingList = new HashMap();
        }
        return this.sessionHasExternalBuildingList;
    }

    public boolean sessionHasExternalRoomList(Session session) {
        if (!this.getSessionHasExternalRoomList().containsKey(session)) {
            ExternalRoomDAO erDao = new ExternalRoomDAO();
            List l = erDao.getQuery("select count(er) from ExternalRoom er where er.building.session.uniqueId =" + session.getUniqueId().toString()).list();
            int cnt = 0;
            if (l != null && !l.isEmpty()) {
                cnt = ((Long)l.get(0)).intValue();
            }
            this.getSessionHasExternalRoomList().put(session, cnt != 0);
        }
        return (Boolean)this.getSessionHasExternalRoomList().get(session);
    }

    public HashMap getSessionHasExternalRoomList() {
        if (this.sessionHasExternalRoomList == null) {
            this.sessionHasExternalRoomList = new HashMap();
        }
        return this.sessionHasExternalRoomList;
    }

    public boolean sessionHasExternalRoomDeptList(Session session) {
        if (!this.getSessionHasExternalRoomDeptList().containsKey(session)) {
            ExternalRoomDepartmentDAO erdDao = new ExternalRoomDepartmentDAO();
            List l = erdDao.getQuery("select count(erd) from ExternalRoomDepartment erd where erd.room.building.session.uniqueId =" + session.getUniqueId().toString()).list();
            int cnt = 0;
            if (l != null && !l.isEmpty()) {
                cnt = ((Long)l.get(0)).intValue();
            }
            this.getSessionHasExternalRoomDeptList().put(session, cnt != 0);
        }
        return (Boolean)this.getSessionHasExternalRoomDeptList().get(session);
    }

    public HashMap getSessionHasExternalRoomDeptList() {
        if (this.sessionHasExternalRoomDeptList == null) {
            this.sessionHasExternalRoomDeptList = new HashMap();
        }
        return this.sessionHasExternalRoomDeptList;
    }

    public boolean sessionHasExternalRoomFeatureList(Session session) {
        if (!this.getSessionHasExternalRoomFeatureList().containsKey(session)) {
            ExternalRoomFeatureDAO erfDao = new ExternalRoomFeatureDAO();
            List l = erfDao.getQuery("select count(erf) from ExternalRoomFeature erf where erf.room.building.session.uniqueId =" + session.getUniqueId().toString()).list();
            int cnt = 0;
            if (l != null && !l.isEmpty()) {
                cnt = ((Long)l.get(0)).intValue();
            }
            this.getSessionHasExternalRoomFeatureList().put(session, cnt != 0);
        }
        return (Boolean)this.getSessionHasExternalRoomFeatureList().get(session);
    }

    public HashMap getSessionHasExternalRoomFeatureList() {
        if (this.sessionHasExternalRoomFeatureList == null) {
            this.sessionHasExternalRoomFeatureList = new HashMap();
        }
        return this.sessionHasExternalRoomFeatureList;
    }

    private void rollTimePatternOntoDepartments(TimePattern fromTimePattern, TimePattern toTimePattern) {
        if (fromTimePattern.getDepartments() != null && !fromTimePattern.getDepartments().isEmpty()) {
            for (Department fromDept : fromTimePattern.getDepartments()) {
                Department toDepartment = Department.findByDeptCode(fromDept.getDeptCode(), toTimePattern.getSession().getSessionId());
                if (toDepartment == null) continue;
                if (null == toDepartment.getTimePatterns()) {
                    toDepartment.setTimePatterns(new HashSet<TimePattern>());
                }
                toDepartment.getTimePatterns().add(toTimePattern);
                if (null == toTimePattern.getDepartments()) {
                    toTimePattern.setDepartments(new HashSet<Department>());
                }
                toTimePattern.addTodepartments(toDepartment);
            }
        }
    }

    public void rollTimePatternsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollTimePatternsForwardFrom());
        List<TimePattern> fromDatePatterns = TimePattern.findAll(fromSession, null);
        TimePattern fromTimePattern2 = null;
        TimePattern toTimePattern = null;
        TimePatternDAO tpDao = new TimePatternDAO();
        try {
            for (TimePattern fromTimePattern2 : fromDatePatterns) {
                if (fromTimePattern2 == null) continue;
                toTimePattern = (TimePattern)fromTimePattern2.clone();
                toTimePattern.setSession(toSession);
                this.rollTimePatternOntoDepartments(fromTimePattern2, toTimePattern);
                tpDao.saveOrUpdate(toTimePattern);
                tpDao.getSession().flush();
            }
            tpDao.getSession().flush();
            tpDao.getSession().clear();
        }
        catch (Exception e) {
            String type = MSG.rollForwardTimePatterns();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    public void rollClassInstructorsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        ArrayList subjects = new ArrayList();
        SubjectAreaDAO saDao = new SubjectAreaDAO();
        for (int i = 0; i < rollForwardSessionForm.getRollForwardClassInstrSubjectIds().length; ++i) {
            subjects.add(saDao.get(Long.parseLong(rollForwardSessionForm.getRollForwardClassInstrSubjectIds()[i])));
        }
        if (toSession.getSubjectAreas() != null) {
            SubjectArea subjectArea2 = null;
            for (SubjectArea subjectArea2 : subjects) {
                this.rollForwardClassInstructorsForASubjectArea(subjectArea2.getSubjectAreaAbbreviation(), toSession);
            }
        }
    }

    private void rollForwardClassInstructorsForASubjectArea(String subjectAreaAbbreviation, Session toSession) {
        this.iLog.info((Object)("Rolling forward class instructors for:  " + subjectAreaAbbreviation));
        Class_DAO clsDao = new Class_DAO();
        org.hibernate.Session hibSession = clsDao.getSession();
        hibSession.clear();
        List classes = Class_.findAllForControllingSubjectArea(subjectAreaAbbreviation, toSession.getUniqueId(), hibSession);
        if (classes != null && !classes.isEmpty()) {
            Class_ toClass2 = null;
            Class_ fromClass = null;
            for (Class_ toClass2 : classes) {
                if (toClass2.getUniqueIdRolledForwardFrom() != null && (fromClass = (Class_)clsDao.get(toClass2.getUniqueIdRolledForwardFrom(), hibSession)) != null) {
                    if (fromClass.getClassInstructors() != null && !fromClass.getClassInstructors().isEmpty()) {
                        ClassInstructor fromClassInstr2 = null;
                        ClassInstructor toClassInstr = null;
                        DepartmentalInstructor toDeptInstr = null;
                        for (ClassInstructor fromClassInstr2 : fromClass.getClassInstructors()) {
                            if (fromClassInstr2.getTeachingRequest() != null || (toDeptInstr = fromClassInstr2.getInstructor().findThisInstructorInSession(toSession.getUniqueId(), hibSession)) == null) continue;
                            toClassInstr = new ClassInstructor();
                            toClassInstr.setClassInstructing(toClass2);
                            toClassInstr.setInstructor(toDeptInstr);
                            toClassInstr.setLead(fromClassInstr2.isLead());
                            toClassInstr.setPercentShare(fromClassInstr2.getPercentShare());
                            toClassInstr.setResponsibility(fromClassInstr2.getResponsibility());
                            toClassInstr.setUniqueId(null);
                            toClass2.addToclassInstructors(toClassInstr);
                            toDeptInstr.addToclasses(toClassInstr);
                            hibSession.evict((Object)fromClassInstr2);
                        }
                        hibSession.evict((Object)fromClass);
                        Transaction t = hibSession.beginTransaction();
                        hibSession.update((Object)toClass2);
                        t.commit();
                    } else {
                        hibSession.evict((Object)fromClass);
                    }
                }
                hibSession.evict((Object)toClass2);
            }
        }
    }

    public void rollOfferingCoordinatorsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        ArrayList subjects = new ArrayList();
        SubjectAreaDAO saDao = new SubjectAreaDAO();
        for (int i = 0; i < rollForwardSessionForm.getRollForwardOfferingCoordinatorsSubjectIds().length; ++i) {
            subjects.add(saDao.get(Long.parseLong(rollForwardSessionForm.getRollForwardOfferingCoordinatorsSubjectIds()[i])));
        }
        if (toSession.getSubjectAreas() != null) {
            SubjectArea subjectArea2 = null;
            for (SubjectArea subjectArea2 : subjects) {
                this.rollForwardOfferingCoordinatorsForASubjectArea(subjectArea2, toSession);
            }
        }
    }

    private void rollForwardOfferingCoordinatorsForASubjectArea(SubjectArea subjectArea, Session toSession) {
        this.iLog.info((Object)("Rolling forward offering coordinators for:  " + subjectArea.getSubjectAreaAbbreviation()));
        for (InstructionalOffering toInstructionalOffering : OfferingCoordinatorDAO.getInstance().getQuery("select co.instructionalOffering from CourseOffering co where co.isControl = true and co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.uniqueIdRolledForwardFrom is not null").setLong("subjectAreaId", subjectArea.getUniqueId().longValue()).list()) {
            InstructionalOffering fromInstructionalOffering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(toInstructionalOffering.getUniqueIdRolledForwardFrom());
            if (fromInstructionalOffering == null) continue;
            for (OfferingCoordinator fromOfferingCoordinator : fromInstructionalOffering.getOfferingCoordinators()) {
                DepartmentalInstructor toInstructor;
                if (fromOfferingCoordinator.getTeachingRequest() != null || (toInstructor = fromOfferingCoordinator.getInstructor().findThisInstructorInSession(toSession.getUniqueId())) == null) continue;
                OfferingCoordinator toOfferingCoordinator = new OfferingCoordinator();
                toOfferingCoordinator.setInstructor(toInstructor);
                toOfferingCoordinator.setOffering(toInstructionalOffering);
                toOfferingCoordinator.setResponsibility(fromOfferingCoordinator.getResponsibility());
                toOfferingCoordinator.setPercentShare(fromOfferingCoordinator.getPercentShare());
                toInstructionalOffering.addToofferingCoordinators(toOfferingCoordinator);
                OfferingCoordinatorDAO.getInstance().saveOrUpdate(toOfferingCoordinator);
            }
        }
    }

    public void rollStudentsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        String[] query = null;
        if (rollForwardSessionForm.getRollForwardStudentsMode().equals(StudentEnrollmentMode.LAST_LIKE.name())) {
            query = new String[]{"select distinct d.student, co, d.priority from LastLikeCourseDemand d, CourseOffering co, CourseOffering last where co.subjectArea.session.uniqueId=:toSessionId and co.uniqueIdRolledForwardFrom=last.uniqueId and ((d.coursePermId is null and d.subjectArea.uniqueId = last.subjectArea.uniqueId and d.courseNbr=last.courseNbr) or (d.coursePermId is not null and d.coursePermId=last.permId))"};
        } else if (rollForwardSessionForm.getRollForwardStudentsMode().equals(StudentEnrollmentMode.STUDENT_CLASS_ENROLLMENTS.name())) {
            query = new String[]{"select distinct e.student, co, e.courseRequest.courseDemand.priority from StudentClassEnrollment e, CourseOffering co where co.subjectArea.session.uniqueId=:toSessionId and co.uniqueIdRolledForwardFrom=e.courseOffering.uniqueId", "select distinct e.student, co, -1 from StudentClassEnrollment e, CourseOffering co where co.subjectArea.session.uniqueId=:toSessionId and co.uniqueIdRolledForwardFrom=e.courseOffering.uniqueId and e.courseRequest is null"};
        } else if (rollForwardSessionForm.getRollForwardStudentsMode().equals(StudentEnrollmentMode.STUDENT_COURSE_REQUESTS.name())) {
            query = new String[]{"select r.courseDemand.student, co, r.courseDemand.priority from CourseRequest r, CourseOffering co where co.subjectArea.session.uniqueId=:toSessionId and co.uniqueIdRolledForwardFrom=r.courseOffering.uniqueId and r.order=0 and r.courseDemand.alternative=false"};
        } else if (rollForwardSessionForm.getRollForwardStudentsMode().equals(StudentEnrollmentMode.POINT_IN_TIME_CLASS_ENROLLMENTS.name())) {
            query = new String[]{"select distinct psce.pitStudent.student, co, -1 from PitStudentClassEnrollment psce, CourseOffering co where co.subjectArea.session.uniqueId=:toSessionId and co.uniqueIdRolledForwardFrom=psce.pitCourseOffering.courseOffering.uniqueId and psce.pitStudent.pointInTimeData.uniqueId = " + rollForwardSessionForm.getPointInTimeSnapshotToRollCourseEnrollmentsForwardFrom().toString()};
        }
        org.hibernate.Session hibSession = LastLikeCourseDemandDAO.getInstance().getSession();
        hibSession.createQuery("delete LastLikeCourseDemand d where d.subjectArea.uniqueId in (select s.uniqueId from SubjectArea s where s.session.uniqueId=:toSessionId)").setLong("toSessionId", toSession.getUniqueId().longValue()).executeUpdate();
        for (int i = 0; i < query.length; ++i) {
            for (Object[] o : hibSession.createQuery(query[i]).setLong("toSessionId", toSession.getUniqueId().longValue()).list()) {
                Student s = (Student)o[0];
                CourseOffering co = (CourseOffering)o[1];
                Number priority = (Number)o[2];
                LastLikeCourseDemand d = new LastLikeCourseDemand();
                d.setPriority(priority.intValue());
                d.setSubjectArea(co.getSubjectArea());
                d.setCourseNbr(co.getCourseNbr());
                d.setCoursePermId(co.getPermId());
                d.setStudent(s);
                hibSession.saveOrUpdate((Object)d);
            }
        }
        hibSession.flush();
        hibSession.clear();
        if (ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue()) {
            hibSession.createQuery("update CourseOffering c set c.demand=(select count(distinct d.student) from LastLikeCourseDemand d where (c.subjectArea=d.subjectArea and c.courseNbr=d.courseNbr)) where c.subjectArea.uniqueId in (select sa.uniqueId from SubjectArea sa where sa.session.uniqueId=:sessionId)").setLong("sessionId", toSession.getUniqueId().longValue()).executeUpdate();
        } else {
            hibSession.createQuery("update CourseOffering c set c.demand=(select count(distinct d.student) from LastLikeCourseDemand d where (c.subjectArea=d.subjectArea and c.courseNbr=d.courseNbr)) where c.permId is null and c.subjectArea.uniqueId in (select sa.uniqueId from SubjectArea sa where sa.session.uniqueId=:sessionId)").setLong("sessionId", toSession.getUniqueId().longValue()).executeUpdate();
            hibSession.createQuery("update CourseOffering c set c.demand=(select count(distinct d.student) from LastLikeCourseDemand d where d.student.session=c.subjectArea.session and c.permId=d.coursePermId) where c.permId is not null and c.subjectArea.uniqueId in (select sa.uniqueId from SubjectArea sa where sa.session.uniqueId=:sessionId)").setLong("sessionId", toSession.getUniqueId().longValue()).executeUpdate();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rollCurriculaForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Hashtable code2major;
        AcademicArea area;
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollCurriculaForwardFrom());
        org.hibernate.Session hibSession = CurriculumDAO.getInstance().getSession();
        Hashtable<String, AcademicArea> areas = new Hashtable<String, AcademicArea>();
        for (AcademicArea academicArea : AcademicAreaDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            areas.put(academicArea.getAcademicAreaAbbreviation(), academicArea);
        }
        if (areas.isEmpty()) {
            for (AcademicArea academicArea : AcademicAreaDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                AcademicArea academicArea2 = (AcademicArea)academicArea.clone();
                academicArea2.setSession(toSession);
                academicArea2.setPosMajors(new HashSet<PosMajor>());
                academicArea2.setPosMinors(new HashSet<PosMinor>());
                hibSession.save((Object)academicArea2);
                areas.put(academicArea2.getAcademicAreaAbbreviation(), academicArea2);
            }
        }
        Hashtable<String, AcademicClassification> classifications = new Hashtable<String, AcademicClassification>();
        for (AcademicClassification academicClassification : AcademicClassificationDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            classifications.put(academicClassification.getCode(), academicClassification);
        }
        if (classifications.isEmpty()) {
            for (AcademicClassification academicClassification : AcademicClassificationDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                AcademicClassification academicClassification2 = (AcademicClassification)academicClassification.clone();
                academicClassification2.setSession(toSession);
                hibSession.save((Object)academicClassification2);
                classifications.put(academicClassification2.getCode(), academicClassification2);
            }
        }
        Hashtable<String, Degree> hashtable = new Hashtable<String, Degree>();
        for (Degree degree : DegreeDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            hashtable.put(degree.getReference(), degree);
        }
        if (hashtable.isEmpty()) {
            for (Degree degree : DegreeDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                Degree degree2 = (Degree)degree.clone();
                degree2.setSession(toSession);
                hibSession.save((Object)degree2);
                hashtable.put(degree2.getReference(), degree);
            }
        }
        Hashtable hashtable2 = new Hashtable();
        for (PosMajor posMajor : PosMajorDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            for (AcademicArea academicArea : posMajor.getAcademicAreas()) {
                void var14_67;
                Hashtable hashtable3 = (Hashtable)hashtable2.get(academicArea.getAcademicAreaAbbreviation());
                if (hashtable3 == null) {
                    Hashtable hashtable4 = new Hashtable();
                    hashtable2.put(academicArea.getAcademicAreaAbbreviation(), hashtable4);
                }
                var14_67.put(posMajor.getCode(), posMajor);
            }
        }
        if (hashtable2.isEmpty()) {
            for (PosMajor posMajor : PosMajorDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                HashSet<AcademicArea> hashSet = new HashSet<AcademicArea>();
                for (AcademicArea academicArea : posMajor.getAcademicAreas()) {
                    AcademicArea newArea = (AcademicArea)areas.get(academicArea.getAcademicAreaAbbreviation());
                    if (newArea == null) continue;
                    hashSet.add(newArea);
                }
                if (hashSet.isEmpty()) continue;
                PosMajor posMajor2 = (PosMajor)posMajor.clone();
                posMajor2.setSession(toSession);
                posMajor2.setAcademicAreas(hashSet);
                posMajor2.setConcentrations(new HashSet<PosMajorConcentration>());
                for (AcademicArea newArea : hashSet) {
                    void var16_90;
                    newArea.getPosMajors().add(posMajor2);
                    Hashtable hashtable5 = (Hashtable)hashtable2.get(newArea.getAcademicAreaAbbreviation());
                    if (hashtable5 == null) {
                        Hashtable hashtable6 = new Hashtable();
                        hashtable2.put(newArea.getAcademicAreaAbbreviation(), hashtable6);
                    }
                    var16_90.put(posMajor2.getCode(), posMajor2);
                }
                hibSession.save((Object)posMajor2);
                for (Object conc : posMajor.getConcentrations()) {
                    PosMajorConcentration posMajorConcentration = (PosMajorConcentration)((PosMajorConcentration)conc).clone();
                    posMajorConcentration.setMajor(posMajor2);
                    posMajor2.getConcentrations().add(posMajorConcentration);
                    hibSession.save((Object)posMajorConcentration);
                }
            }
        }
        Hashtable<String, Program> hashtable7 = new Hashtable<String, Program>();
        for (Program program : ProgramDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            hashtable7.put(program.getReference(), program);
        }
        if (hashtable7.isEmpty()) {
            for (Program program : ProgramDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                Program program2 = (Program)program.clone();
                program2.setSession(toSession);
                hibSession.save((Object)program2);
                hashtable7.put(program2.getReference(), program2);
            }
        }
        Hashtable<String, Campus> hashtable8 = new Hashtable<String, Campus>();
        for (Campus campus : CampusDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            hashtable8.put(campus.getReference(), campus);
        }
        if (hashtable8.isEmpty()) {
            for (Campus campus : CampusDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                Campus campus2 = (Campus)campus.clone();
                campus2.setSession(toSession);
                hibSession.save((Object)campus2);
                hashtable8.put(campus2.getReference(), campus2);
            }
        }
        Hashtable hashtable9 = new Hashtable();
        for (PosMinor posMinor : PosMinorDAO.getInstance().findBySession(hibSession, toSession.getUniqueId())) {
            for (AcademicArea academicArea : posMinor.getAcademicAreas()) {
                void var17_101;
                Hashtable hashtable10 = (Hashtable)hashtable9.get(academicArea.getAcademicAreaAbbreviation());
                if (hashtable10 == null) {
                    Hashtable hashtable11 = new Hashtable();
                    hashtable9.put(academicArea.getAcademicAreaAbbreviation(), hashtable11);
                }
                var17_101.put(posMinor.getCode(), posMinor);
            }
        }
        if (hashtable9.isEmpty()) {
            for (PosMinor posMinor : PosMinorDAO.getInstance().findBySession(hibSession, fromSession.getUniqueId())) {
                HashSet<AcademicArea> newAreas = new HashSet<AcademicArea>();
                for (AcademicArea academicArea : posMinor.getAcademicAreas()) {
                    AcademicArea newArea = (AcademicArea)areas.get(academicArea.getAcademicAreaAbbreviation());
                    if (newArea == null) continue;
                    newAreas.add(newArea);
                }
                if (newAreas.isEmpty()) continue;
                PosMinor posMinor2 = (PosMinor)posMinor.clone();
                posMinor2.setSession(toSession);
                posMinor2.setAcademicAreas(newAreas);
                for (AcademicArea newArea : newAreas) {
                    newArea.getPosMinors().add(posMinor2);
                    Hashtable<String, PosMinor> code2minor = (Hashtable<String, PosMinor>)hashtable9.get(newArea.getAcademicAreaAbbreviation());
                    if (code2minor == null) {
                        code2minor = new Hashtable<String, PosMinor>();
                        hashtable9.put(newArea.getAcademicAreaAbbreviation(), code2minor);
                    }
                    code2minor.put(posMinor2.getCode(), posMinor2);
                }
                hibSession.save((Object)posMinor2);
            }
        }
        Hashtable<Long, CourseOffering> hashtable12 = new Hashtable<Long, CourseOffering>();
        for (CourseOffering course : hibSession.createQuery("select co from CourseOffering co where co.uniqueIdRolledForwardFrom is not null and co.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list()) {
            hashtable12.put(course.getUniqueIdRolledForwardFrom(), course);
        }
        Iterator iterator = hibSession.createQuery("select c from Curriculum c where c.department.session=:sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list().iterator();
        while (iterator.hasNext()) {
            hibSession.delete(iterator.next());
        }
        hibSession.flush();
        Object var14_82 = null;
        block23: for (Curriculum curriculum : hibSession.createQuery("select c from Curriculum c where c.department.session=:sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            Curriculum curriculum2 = new Curriculum();
            curriculum2.setAbbv(curriculum.getAbbv());
            curriculum2.setName(curriculum.getName());
            curriculum2.setMultipleMajors(curriculum.isMultipleMajors());
            area = (AcademicArea)areas.get(curriculum.getAcademicArea().getAcademicAreaAbbreviation());
            if (area == null) continue;
            curriculum2.setAcademicArea(area);
            Department dept = curriculum.getDepartment().findSameDepartmentInSession(toSession);
            if (dept == null) {
                Department department;
                void var14_83;
                if (var14_83 == null && (department = Department.findByDeptCode("TEMP", toSession.getUniqueId())) == null) {
                    Department department2 = new Department();
                    department2.setAbbreviation("TEMP");
                    department2.setAllowReqRoom(false);
                    department2.setAllowReqTime(false);
                    department2.setAllowReqDistribution(false);
                    department2.setDeptCode("TEMP");
                    department2.setExternalManager(false);
                    department2.setExternalUniqueId(null);
                    department2.setName("Temp Department For New Curricula");
                    department2.setSession(toSession);
                    department2.setDistributionPrefPriority(0);
                    department2.setInheritInstructorPreferences(true);
                    department2.setAllowEvents(false);
                    department2.setAllowStudentScheduling(false);
                    toSession.addTodepartments(department2);
                    hibSession.save((Object)department2);
                }
                dept = var14_83;
            }
            curriculum2.setDepartment(dept);
            curriculum2.setMajors(new HashSet<PosMajor>());
            code2major = (Hashtable)hashtable2.get(area.getAcademicAreaAbbreviation());
            for (PosMajor major : curriculum.getMajors()) {
                PosMajor newMajor;
                PosMajor posMajor = newMajor = code2major == null ? null : (PosMajor)code2major.get(major.getCode());
                if (newMajor == null) continue block23;
                curriculum2.getMajors().add(newMajor);
            }
            curriculum2.setClassifications(new HashSet<CurriculumClassification>());
            Hashtable<Long, CurriculumCourseGroup> createdGroups = new Hashtable<Long, CurriculumCourseGroup>();
            for (CurriculumClassification clasf : curriculum.getClassifications()) {
                CurriculumClassification newClasf = new CurriculumClassification();
                AcademicClassification f = (AcademicClassification)classifications.get(clasf.getAcademicClassification().getCode());
                if (f == null) continue;
                newClasf.setAcademicClassification(f);
                newClasf.setCurriculum(curriculum2);
                newClasf.setName(clasf.getName());
                newClasf.setNrStudents(clasf.getNrStudents());
                newClasf.setOrd(clasf.getOrd());
                newClasf.setCourses(new HashSet<CurriculumCourse>());
                curriculum2.getClassifications().add(newClasf);
                for (CurriculumCourse course : clasf.getCourses()) {
                    CurriculumCourse newCourse = new CurriculumCourse();
                    newCourse.setOrd(course.getOrd());
                    newCourse.setPercShare(course.getPercShare());
                    CourseOffering co = (CourseOffering)hashtable12.get(course.getCourse().getUniqueId());
                    if (co == null) continue;
                    newCourse.setCourse(co);
                    newCourse.setClassification(newClasf);
                    newClasf.getCourses().add(newCourse);
                    newCourse.setGroups(new HashSet<CurriculumCourseGroup>());
                    for (CurriculumCourseGroup group : course.getGroups()) {
                        CurriculumCourseGroup newGroup = (CurriculumCourseGroup)createdGroups.get(group.getUniqueId());
                        if (newGroup == null) {
                            newGroup = new CurriculumCourseGroup();
                            newGroup.setColor(group.getColor());
                            newGroup.setName(group.getName());
                            newGroup.setType(group.getType());
                            newGroup.setCurriculum(curriculum2);
                            createdGroups.put(group.getUniqueId(), newGroup);
                        }
                        newCourse.getGroups().add(newGroup);
                    }
                }
            }
            hibSession.save((Object)curriculum2);
            for (CurriculumCourseGroup g : createdGroups.values()) {
                hibSession.saveOrUpdate((Object)g);
            }
        }
        if (hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list().isEmpty()) {
            for (CurriculumProjectionRule curriculumProjectionRule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
                CurriculumProjectionRule curriculumProjectionRule2 = new CurriculumProjectionRule();
                area = (AcademicArea)areas.get(curriculumProjectionRule.getAcademicArea().getAcademicAreaAbbreviation());
                if (area == null) continue;
                curriculumProjectionRule2.setAcademicArea(area);
                AcademicClassification clasf = (AcademicClassification)classifications.get(curriculumProjectionRule.getAcademicClassification().getCode());
                if (clasf == null) continue;
                curriculumProjectionRule2.setAcademicClassification(clasf);
                if (curriculumProjectionRule.getMajor() != null) {
                    PosMajor major;
                    code2major = (Hashtable)hashtable2.get(area.getAcademicAreaAbbreviation());
                    PosMajor posMajor = major = code2major == null ? null : (PosMajor)code2major.get(curriculumProjectionRule.getMajor().getCode());
                    if (major == null) continue;
                    curriculumProjectionRule2.setMajor(major);
                }
                curriculumProjectionRule2.setProjection(curriculumProjectionRule.getProjection());
                hibSession.save((Object)curriculumProjectionRule2);
            }
        }
        hibSession.flush();
        hibSession.clear();
    }

    public void rollSessionConfigurationForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Department newDepartment;
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollSessionConfigForwardFrom());
        org.hibernate.Session hibSession = SessionConfigDAO.getInstance().getSession();
        for (SessionConfig config : hibSession.createQuery("from SessionConfig where session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list()) {
            hibSession.delete((Object)config);
        }
        for (SessionConfig config : hibSession.createQuery("from SessionConfig where session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            SessionConfig newConfig = new SessionConfig();
            newConfig.setKey(config.getKey());
            newConfig.setDescription(config.getDescription());
            newConfig.setValue(config.getValue());
            newConfig.setSession(toSession);
            hibSession.save((Object)newConfig);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list()) {
            hibSession.delete((Object)note);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteDepartment where department.session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list()) {
            hibSession.delete((Object)note);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteSession where session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            StandardEventNoteSession newNote = new StandardEventNoteSession();
            newNote.setNote(note.getNote());
            newNote.setReference(note.getReference());
            newNote.setSession(toSession);
            hibSession.save((Object)newNote);
        }
        for (StandardEventNote note : hibSession.createQuery("from StandardEventNoteDepartment where department.session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            newDepartment = ((BaseStandardEventNoteDepartment)note).getDepartment().findSameDepartmentInSession(toSession);
            if (newDepartment == null) continue;
            StandardEventNoteDepartment newNote = new StandardEventNoteDepartment();
            newNote.setNote(note.getNote());
            newNote.setReference(note.getReference());
            newNote.setDepartment(newDepartment);
            hibSession.save((Object)newNote);
        }
        for (RoomTypeOption option : hibSession.createQuery("from RoomTypeOption where department.session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list()) {
            hibSession.delete((Object)option);
        }
        for (RoomTypeOption option : hibSession.createQuery("from RoomTypeOption where department.session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            newDepartment = option.getDepartment().findSameDepartmentInSession(toSession);
            if (newDepartment == null) continue;
            RoomTypeOption newOption = new RoomTypeOption();
            newOption.setBreakTime(option.getBreakTime());
            newOption.setDepartment(newDepartment);
            newOption.setMessage(option.getMessage());
            newOption.setRoomType(option.getRoomType());
            newOption.setStatus(RoomTypeOption.getDefaultStatus());
            hibSession.save((Object)newOption);
        }
        for (EventServiceProvider provider : hibSession.createQuery("from EventServiceProvider where session.uniqueId = :sessionId").setLong("sessionId", toSession.getUniqueId().longValue()).list()) {
            hibSession.delete((Object)provider);
        }
        for (EventServiceProvider provider : hibSession.createQuery("from EventServiceProvider where session.uniqueId = :sessionId").setLong("sessionId", fromSession.getUniqueId().longValue()).list()) {
            if (!provider.isVisible().booleanValue()) continue;
            EventServiceProvider newProvider = new EventServiceProvider();
            newProvider.setReference(provider.getReference());
            newProvider.setLabel(provider.getLabel());
            newProvider.setEmail(provider.getEmail());
            newProvider.setNote(provider.getNote());
            newProvider.setAllRooms(provider.getAllRooms());
            newProvider.setVisible(provider.getVisible());
            newProvider.setSession(toSession);
            if (provider.getDepartment() != null) {
                Department newDepartment2 = provider.getDepartment().findSameDepartmentInSession(toSession);
                if (newDepartment2 == null) continue;
                newProvider.setDepartment(newDepartment2);
            }
            hibSession.save((Object)newProvider);
        }
        this.rollGlobalInstructorAttributesForward(errors, fromSession, toSession);
        hibSession.flush();
        hibSession.clear();
        ApplicationProperties.clearSessionProperties(toSession.getUniqueId());
    }

    public void rollReservationsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        ArrayList subjects = new ArrayList();
        for (String subjectId : rollForwardSessionForm.getRollForwardReservationsSubjectIds()) {
            subjects.add(SubjectAreaDAO.getInstance().get(Long.valueOf(subjectId)));
        }
        if (subjects.isEmpty()) {
            return;
        }
        org.hibernate.Session hibSession = ReservationDAO.getInstance().getSession();
        if (rollForwardSessionForm.getRollForwardCourseReservations()) {
            Date expiration = null;
            if (rollForwardSessionForm.getExpirationCourseReservations() != null && !rollForwardSessionForm.getExpirationCourseReservations().isEmpty()) {
                try {
                    expiration = df.parse(rollForwardSessionForm.getExpirationCourseReservations());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            Date startDate = null;
            if (rollForwardSessionForm.getStartDateCourseReservations() != null && !rollForwardSessionForm.getStartDateCourseReservations().isEmpty()) {
                try {
                    startDate = df.parse(rollForwardSessionForm.getStartDateCourseReservations());
                }
                catch (ParseException subjectId) {
                    // empty catch block
                }
            }
            for (Object subject : subjects) {
                hibSession.createQuery("delete CourseReservation r where r.instructionalOffering.uniqueId in (select c.instructionalOffering.uniqueId from CourseOffering c where c.subjectArea.uniqueId = :subjectId and c.isControl = true)").setLong("subjectId", ((BaseSubjectArea)subject).getUniqueId().longValue()).executeUpdate();
                for (CourseReservation reservation : hibSession.createQuery("select distinct r from CourseReservation r inner join r.instructionalOffering.courseOfferings c where c.isControl = true and c.subjectArea.subjectAreaAbbreviation = :subject and c.subjectArea.department.session.uniqueId = :sessionId").setString("subject", ((BaseSubjectArea)subject).getSubjectAreaAbbreviation()).setLong("sessionId", rollForwardSessionForm.getSessionToRollReservationsForwardFrom().longValue()).list()) {
                    CourseReservation toReservation = this.rollCourseReservationForward(reservation, ((BaseSubjectArea)subject).getSession(), startDate, expiration);
                    if (toReservation == null) continue;
                    hibSession.saveOrUpdate((Object)toReservation);
                }
            }
        }
        if (rollForwardSessionForm.getRollForwardCurriculumReservations()) {
            Date expiration = null;
            if (rollForwardSessionForm.getExpirationCurriculumReservations() != null && !rollForwardSessionForm.getExpirationCurriculumReservations().isEmpty()) {
                try {
                    expiration = df.parse(rollForwardSessionForm.getExpirationCurriculumReservations());
                }
                catch (ParseException startDate) {
                    // empty catch block
                }
            }
            Date startDate = null;
            if (rollForwardSessionForm.getStartDateCurriculumReservations() != null && !rollForwardSessionForm.getStartDateCurriculumReservations().isEmpty()) {
                try {
                    startDate = df.parse(rollForwardSessionForm.getStartDateCurriculumReservations());
                }
                catch (ParseException subjectId) {
                    // empty catch block
                }
            }
            Hashtable<String, AcademicArea> areas = new Hashtable<String, AcademicArea>();
            for (AcademicArea academicArea : AcademicAreaDAO.getInstance().findBySession(hibSession, rollForwardSessionForm.getSessionToRollForwardTo())) {
                areas.put(academicArea.getAcademicAreaAbbreviation(), academicArea);
            }
            Hashtable<String, AcademicClassification> classifications = new Hashtable<String, AcademicClassification>();
            for (AcademicClassification clasf : AcademicClassificationDAO.getInstance().findBySession(hibSession, rollForwardSessionForm.getSessionToRollForwardTo())) {
                classifications.put(clasf.getCode(), clasf);
            }
            Hashtable<String, Map<String, PosMajor>> hashtable = new Hashtable<String, Map<String, PosMajor>>();
            Hashtable<String, Map<String, Map<String, PosMajorConcentration>>> concentrations = new Hashtable<String, Map<String, Map<String, PosMajorConcentration>>>();
            for (PosMajor posMajor : PosMajorDAO.getInstance().findBySession(hibSession, rollForwardSessionForm.getSessionToRollForwardTo())) {
                for (AcademicArea area : posMajor.getAcademicAreas()) {
                    Hashtable<String, PosMajor> code2major = (Hashtable<String, PosMajor>)hashtable.get(area.getAcademicAreaAbbreviation());
                    if (code2major == null) {
                        code2major = new Hashtable<String, PosMajor>();
                        hashtable.put(area.getAcademicAreaAbbreviation(), code2major);
                    }
                    code2major.put(posMajor.getCode(), posMajor);
                    if (posMajor.getConcentrations().isEmpty()) continue;
                    Hashtable majorCode2concentration = (Hashtable)concentrations.get(area.getAcademicAreaAbbreviation());
                    if (majorCode2concentration == null) {
                        majorCode2concentration = new Hashtable();
                        concentrations.put(area.getAcademicAreaAbbreviation(), majorCode2concentration);
                    }
                    Hashtable<String, PosMajorConcentration> code2concentration = new Hashtable<String, PosMajorConcentration>();
                    majorCode2concentration.put(posMajor.getCode(), code2concentration);
                    for (PosMajorConcentration conc : posMajor.getConcentrations()) {
                        code2concentration.put(conc.getCode(), conc);
                    }
                }
            }
            Hashtable<String, Map<String, PosMinor>> minors = new Hashtable<String, Map<String, PosMinor>>();
            for (PosMinor minor : PosMinorDAO.getInstance().findBySession(hibSession, rollForwardSessionForm.getSessionToRollForwardTo())) {
                for (AcademicArea area : minor.getAcademicAreas()) {
                    Hashtable<String, PosMinor> code2minor = (Hashtable<String, PosMinor>)minors.get(area.getAcademicAreaAbbreviation());
                    if (code2minor == null) {
                        code2minor = new Hashtable<String, PosMinor>();
                        minors.put(area.getAcademicAreaAbbreviation(), code2minor);
                    }
                    code2minor.put(minor.getCode(), minor);
                }
            }
            for (SubjectArea subject : subjects) {
                hibSession.createQuery("delete CurriculumReservation r where r.instructionalOffering.uniqueId in (select c.instructionalOffering.uniqueId from CourseOffering c where c.subjectArea.uniqueId = :subjectId and c.isControl = true)").setLong("subjectId", subject.getUniqueId().longValue()).executeUpdate();
                for (CurriculumReservation reservation : hibSession.createQuery("select distinct r from CurriculumReservation r inner join r.instructionalOffering.courseOfferings c where c.isControl = true and c.subjectArea.subjectAreaAbbreviation = :subject and c.subjectArea.department.session.uniqueId = :sessionId").setString("subject", subject.getSubjectAreaAbbreviation()).setLong("sessionId", rollForwardSessionForm.getSessionToRollReservationsForwardFrom().longValue()).list()) {
                    CurriculumReservation toReservation = this.rollCurriculumReservationForward(reservation, subject.getSession(), startDate, expiration, areas, classifications, hashtable, concentrations, minors);
                    if (toReservation == null) continue;
                    hibSession.saveOrUpdate((Object)toReservation);
                }
            }
        }
        if (rollForwardSessionForm.getRollForwardGroupReservations()) {
            Date expiration = null;
            if (rollForwardSessionForm.getExpirationGroupReservations() != null && !rollForwardSessionForm.getExpirationGroupReservations().isEmpty()) {
                try {
                    expiration = df.parse(rollForwardSessionForm.getExpirationGroupReservations());
                }
                catch (ParseException startDate) {
                    // empty catch block
                }
            }
            Date startDate = null;
            if (rollForwardSessionForm.getStartDateGroupReservations() != null && !rollForwardSessionForm.getStartDateGroupReservations().isEmpty()) {
                try {
                    startDate = df.parse(rollForwardSessionForm.getStartDateGroupReservations());
                }
                catch (ParseException areas) {
                    // empty catch block
                }
            }
            Hashtable<String, StudentGroup> groups = new Hashtable<String, StudentGroup>();
            for (StudentGroup studentGroup : StudentGroupDAO.getInstance().findBySession(hibSession, rollForwardSessionForm.getSessionToRollForwardTo())) {
                groups.put(studentGroup.getGroupAbbreviation(), studentGroup);
            }
            for (SubjectArea subjectArea : subjects) {
                hibSession.createQuery("delete StudentGroupReservation r where r.instructionalOffering.uniqueId in (select c.instructionalOffering.uniqueId from CourseOffering c where c.subjectArea.uniqueId = :subjectId and c.isControl = true)").setLong("subjectId", subjectArea.getUniqueId().longValue()).executeUpdate();
                for (StudentGroupReservation reservation : hibSession.createQuery("select distinct r from StudentGroupReservation r inner join r.instructionalOffering.courseOfferings c where c.isControl = true and c.subjectArea.subjectAreaAbbreviation = :subject and c.subjectArea.department.session.uniqueId = :sessionId").setString("subject", subjectArea.getSubjectAreaAbbreviation()).setLong("sessionId", rollForwardSessionForm.getSessionToRollReservationsForwardFrom().longValue()).list()) {
                    StudentGroupReservation studentGroupReservation = this.rollGroupReservationForward(reservation, subjectArea.getSession(), startDate, expiration, groups, rollForwardSessionForm.getCreateStudentGroupsIfNeeded());
                    if (studentGroupReservation == null) continue;
                    hibSession.saveOrUpdate((Object)studentGroupReservation);
                }
            }
        }
        hibSession.flush();
        hibSession.clear();
    }

    protected boolean rollReservationForward(Reservation fromReservation, Reservation toReservation, Session toSession, Date start, Date expiration) {
        Calendar cal;
        InstructionalOffering toOffering = InstructionalOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromReservation.getInstructionalOffering().getUniqueId());
        if (toOffering == null) {
            CourseOffering toCourse = CourseOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromReservation.getInstructionalOffering().getControllingCourseOffering().getUniqueId());
            if (toCourse == null) {
                toCourse = ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue() ? CourseOffering.findBySessionSubjAreaAbbvCourseNbr(toSession.getUniqueId(), fromReservation.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation(), fromReservation.getInstructionalOffering().getControllingCourseOffering().getCourseNbr()) : CourseOffering.findBySessionSubjAreaAbbvCourseNbrTitle(toSession.getUniqueId(), fromReservation.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation(), fromReservation.getInstructionalOffering().getControllingCourseOffering().getCourseNbr(), fromReservation.getInstructionalOffering().getControllingCourseOffering().getTitle());
            }
            if (toCourse != null) {
                toOffering = toCourse.getInstructionalOffering();
            }
        }
        if (toOffering == null) {
            return false;
        }
        toReservation.setInstructionalOffering(toOffering);
        if (fromReservation.getExpirationDate() != null) {
            if (expiration != null) {
                toReservation.setExpirationDate(expiration);
            } else {
                int nrDays = (int)Math.round((double)(fromReservation.getExpirationDate().getTime() - fromReservation.getInstructionalOffering().getSession().getSessionBeginDateTime().getTime()) / 8.64E7);
                cal = Calendar.getInstance();
                cal.setTime(toSession.getSessionBeginDateTime());
                cal.add(6, nrDays);
                toReservation.setExpirationDate(cal.getTime());
            }
        }
        if (fromReservation.getStartDate() != null) {
            if (start != null) {
                toReservation.setStartDate(start);
            } else {
                int nrDays = (int)Math.round((double)(fromReservation.getStartDate().getTime() - fromReservation.getInstructionalOffering().getSession().getSessionBeginDateTime().getTime()) / 8.64E7);
                cal = Calendar.getInstance();
                cal.setTime(toSession.getSessionBeginDateTime());
                cal.add(6, nrDays);
                toReservation.setStartDate(cal.getTime());
            }
        }
        toReservation.setInclusive(fromReservation.isInclusive());
        toReservation.setConfigurations(new HashSet<InstrOfferingConfig>());
        toReservation.setClasses(new HashSet<Class_>());
        for (InstrOfferingConfig fromConfig : fromReservation.getConfigurations()) {
            InstrOfferingConfig toConfig = InstrOfferingConfig.findByIdRolledForwardFrom(toSession.getUniqueId(), fromConfig.getUniqueId());
            if (toConfig == null) {
                for (InstrOfferingConfig c : toOffering.getInstrOfferingConfigs()) {
                    if (!c.getName().equals(fromConfig.getName())) continue;
                    toConfig = c;
                    break;
                }
            }
            if (toConfig == null) continue;
            toReservation.getConfigurations().add(toConfig);
        }
        for (Class_ fromClass : fromReservation.getClasses()) {
            Class_ c;
            Class_ toClass = Class_.findByIdRolledForwardFrom(toSession.getUniqueId(), fromClass.getUniqueId());
            if (toClass == null && fromClass.getExternalUniqueId() != null && (c = Class_.findByExternalId(toSession.getUniqueId(), fromClass.getExternalUniqueId())) != null && c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().equals(toOffering)) {
                toClass = c;
            }
            if (toClass == null) {
                block3: for (InstrOfferingConfig toConfig : toOffering.getInstrOfferingConfigs()) {
                    for (SchedulingSubpart toSubpart : toConfig.getSchedulingSubparts()) {
                        if (!toSubpart.getSchedulingSubpartSuffix().equals(fromClass.getSchedulingSubpart().getSchedulingSubpartSuffix())) continue;
                        for (Class_ c2 : toSubpart.getClasses()) {
                            if (!c2.getSectionNumber().equals(fromClass.getSectionNumber())) continue;
                            toClass = c2;
                            break block3;
                        }
                    }
                }
            }
            if (toClass == null) continue;
            toReservation.getClasses().add(toClass);
        }
        toReservation.setLimit(fromReservation.getLimit());
        return true;
    }

    protected CourseReservation rollCourseReservationForward(CourseReservation fromReservation, Session toSession, Date startDate, Date expiration) {
        CourseReservation toReservation = new CourseReservation();
        if (!this.rollReservationForward(fromReservation, toReservation, toSession, startDate, expiration)) {
            return null;
        }
        CourseOffering toCourse = CourseOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromReservation.getCourse().getUniqueId());
        if (toCourse == null) {
            toCourse = ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue() ? CourseOffering.findBySessionSubjAreaAbbvCourseNbr(toSession.getUniqueId(), fromReservation.getCourse().getSubjectArea().getSubjectAreaAbbreviation(), fromReservation.getCourse().getCourseNbr()) : CourseOffering.findBySessionSubjAreaAbbvCourseNbrTitle(toSession.getUniqueId(), fromReservation.getCourse().getSubjectArea().getSubjectAreaAbbreviation(), fromReservation.getCourse().getCourseNbr(), fromReservation.getCourse().getTitle());
        }
        if (toCourse == null || !toCourse.getInstructionalOffering().equals(toReservation.getInstructionalOffering())) {
            return null;
        }
        toReservation.setCourse(toCourse);
        return toReservation;
    }

    protected CurriculumReservation rollCurriculumReservationForward(CurriculumReservation fromReservation, Session toSession, Date startDate, Date expiration, Map<String, AcademicArea> areas, Map<String, AcademicClassification> classifications, Map<String, Map<String, PosMajor>> majors, Map<String, Map<String, Map<String, PosMajorConcentration>>> concentrations, Map<String, Map<String, PosMinor>> minors) {
        CurriculumReservation toReservation = new CurriculumReservation();
        if (fromReservation instanceof CurriculumOverrideReservation) {
            toReservation = new CurriculumOverrideReservation();
            ((CurriculumOverrideReservation)toReservation).setFlags(((CurriculumOverrideReservation)fromReservation).getFlags());
        }
        if (!this.rollReservationForward(fromReservation, toReservation, toSession, startDate, expiration)) {
            return null;
        }
        toReservation.setAreas(new HashSet<AcademicArea>());
        for (AcademicArea fromArea : fromReservation.getAreas()) {
            AcademicArea toArea = areas.get(fromArea.getAcademicAreaAbbreviation());
            if (toArea == null) continue;
            toReservation.getAreas().add(toArea);
        }
        if (toReservation.getAreas().isEmpty()) {
            return null;
        }
        toReservation.setClassifications(new HashSet<AcademicClassification>());
        for (AcademicClassification fromClasf : fromReservation.getClassifications()) {
            AcademicClassification toClasf = classifications.get(fromClasf.getCode());
            if (toClasf == null) continue;
            toReservation.getClassifications().add(toClasf);
        }
        toReservation.setMajors(new HashSet<PosMajor>());
        toReservation.setConcentrations(new HashSet<PosMajorConcentration>());
        toReservation.setMinors(new HashSet<PosMinor>());
        for (AcademicArea area : fromReservation.getAreas()) {
            Map<String, PosMinor> mn;
            Map<String, PosMajor> mj = majors.get(area.getAcademicAreaAbbreviation());
            Map<String, Map<String, PosMajorConcentration>> mj2cc = concentrations.get(area.getAcademicAreaAbbreviation());
            if (mj != null) {
                for (PosMajor fromMajor : fromReservation.getMajors()) {
                    PosMajor toMajor = mj.get(fromMajor.getCode());
                    if (toMajor == null) continue;
                    toReservation.getMajors().add(toMajor);
                }
            }
            if (mj2cc != null) {
                for (PosMajorConcentration fromConc : fromReservation.getConcentrations()) {
                    Map<String, PosMajorConcentration> cc = mj2cc.get(fromConc.getMajor().getCode());
                    PosMajorConcentration toConc = cc == null ? null : cc.get(fromConc.getCode());
                    if (toConc == null) continue;
                    toReservation.getConcentrations().add(toConc);
                }
            }
            if ((mn = minors.get(area.getAcademicAreaAbbreviation())) == null) continue;
            for (PosMinor fromMinor : fromReservation.getMinors()) {
                PosMinor toMinor = mn.get(fromMinor.getCode());
                if (toMinor == null) continue;
                toReservation.getMinors().add(toMinor);
            }
        }
        return toReservation;
    }

    protected StudentGroupReservation rollGroupReservationForward(StudentGroupReservation fromReservation, Session toSession, Date startDate, Date expiration, Map<String, StudentGroup> groups, boolean createStudentGroupIfNeeded) {
        StudentGroupReservation toReservation = new StudentGroupReservation();
        if (fromReservation instanceof GroupOverrideReservation) {
            toReservation = new GroupOverrideReservation();
            ((GroupOverrideReservation)toReservation).setFlags(((GroupOverrideReservation)fromReservation).getFlags());
        }
        if (fromReservation instanceof LearningCommunityReservation) {
            CourseOffering fromCourse = ((LearningCommunityReservation)fromReservation).getCourse();
            CourseOffering toCourse = CourseOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromCourse.getUniqueId());
            if (toCourse == null) {
                toCourse = ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue() ? CourseOffering.findBySessionSubjAreaAbbvCourseNbr(toSession.getUniqueId(), fromCourse.getSubjectArea().getSubjectAreaAbbreviation(), fromCourse.getCourseNbr()) : CourseOffering.findBySessionSubjAreaAbbvCourseNbrTitle(toSession.getUniqueId(), fromCourse.getSubjectArea().getSubjectAreaAbbreviation(), fromCourse.getCourseNbr(), fromCourse.getTitle());
            }
            if (toCourse == null) {
                return null;
            }
            toReservation = new LearningCommunityReservation();
            ((LearningCommunityReservation)toReservation).setCourse(toCourse);
        }
        if (!this.rollReservationForward(fromReservation, toReservation, toSession, startDate, expiration)) {
            return null;
        }
        StudentGroup group = groups.get(fromReservation.getGroup().getGroupAbbreviation());
        if (group == null) {
            if (createStudentGroupIfNeeded) {
                group = new StudentGroup();
                group.setSession(toSession);
                group.setExternalUniqueId(fromReservation.getGroup().getExternalUniqueId());
                group.setGroupAbbreviation(fromReservation.getGroup().getGroupAbbreviation());
                group.setGroupName(fromReservation.getGroup().getGroupName());
                group.setExpectedSize(fromReservation.getGroup().getExpectedSize());
                group.setType(fromReservation.getGroup().getType());
                StudentGroupDAO.getInstance().getSession().save((Object)group);
                groups.put(group.getGroupAbbreviation(), group);
            } else {
                return null;
            }
        }
        toReservation.setGroup(group);
        return toReservation;
    }

    public void rollTeachingRequestsForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        TeachingRequestDAO trDao = TeachingRequestDAO.getInstance();
        for (int i = 0; i < rollForwardSessionForm.getRollForwardTeachingRequestsSubjectIds().length; ++i) {
            SubjectArea toSubjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.parseLong(rollForwardSessionForm.getRollForwardTeachingRequestsSubjectIds()[i]));
            if (toSubjectArea == null) continue;
            this.iLog.info((Object)("Rolling forward teaching requests for:  " + toSubjectArea.getSubjectAreaAbbreviation()));
            for (InstructionalOffering toInstructionalOffering : OfferingCoordinatorDAO.getInstance().getQuery("select co.instructionalOffering from CourseOffering co where co.isControl = true and co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.uniqueIdRolledForwardFrom is not null").setLong("subjectAreaId", toSubjectArea.getUniqueId().longValue()).list()) {
                InstructionalOffering fromInstructionalOffering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(toInstructionalOffering.getUniqueIdRolledForwardFrom());
                if (fromInstructionalOffering == null) continue;
                Iterator<TeachingRequest> it = toInstructionalOffering.getTeachingRequests().iterator();
                while (it.hasNext()) {
                    trDao.delete(it.next());
                    it.remove();
                }
                for (TeachingRequest fromRequest : fromInstructionalOffering.getTeachingRequests()) {
                    TeachingRequest toRequest = new TeachingRequest();
                    toRequest.setOffering(toInstructionalOffering);
                    toRequest.setAssignCoordinator(fromRequest.isAssignCoordinator());
                    toRequest.setPercentShare(fromRequest.getPercentShare());
                    toRequest.setClassRequests(new HashSet<TeachingClassRequest>());
                    toRequest.setNbrInstructors(fromRequest.getNbrInstructors());
                    toRequest.setResponsibility(fromRequest.getResponsibility());
                    toRequest.setSameCommonPart(fromRequest.getSameCommonPart());
                    toRequest.setSameCoursePreference(fromRequest.getSameCoursePreference());
                    toRequest.setTeachingLoad(fromRequest.getTeachingLoad());
                    boolean valid = toRequest.isAssignCoordinator();
                    for (TeachingClassRequest fromTCR : fromRequest.getClassRequests()) {
                        Class_ toClass = Class_.findByIdRolledForwardFrom(toSubjectArea.getDepartment().getSessionId(), fromTCR.getTeachingClass().getUniqueId());
                        if (toClass == null) continue;
                        TeachingClassRequest toTCR = new TeachingClassRequest();
                        toTCR.setAssignInstructor(fromTCR.isAssignInstructor());
                        toTCR.setCanOverlap(fromTCR.isCanOverlap());
                        toTCR.setCommon(fromTCR.isCommon());
                        toTCR.setLead(fromTCR.isLead());
                        toTCR.setPercentShare(fromTCR.getPercentShare());
                        toTCR.setTeachingRequest(toRequest);
                        toTCR.setTeachingClass(toClass);
                        toRequest.addToclassRequests(toTCR);
                        if (!toTCR.isAssignInstructor().booleanValue()) continue;
                        valid = true;
                    }
                    if (!valid) continue;
                    toInstructionalOffering.addToteachingRequests(toRequest);
                    trDao.saveOrUpdate(toRequest);
                    this.rollForwardInstructorPrefs(fromRequest, toRequest, toSubjectArea.getDepartment().getSession());
                    this.rollForwardInstructorAttributePrefs(fromRequest, toRequest, toSubjectArea.getDepartment().getSession());
                }
            }
            trDao.getSession().flush();
            trDao.getSession().clear();
        }
    }

    private String convertParameter(org.hibernate.Session hibSession, String type, String value, RollForwardSessionForm form) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        for (SavedHQL.Option option : SavedHQL.Option.values()) {
            if (!type.equalsIgnoreCase(option.name())) continue;
            return option.rollForward(hibSession, value, form.getSessionToRollPeriodicTasksFrom(), form.getSessionToRollForwardTo());
        }
        return value;
    }

    public void rollPeriodicTasksForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        org.hibernate.Session hibSession = PeriodicTaskDAO.getInstance().getSession();
        HashSet<String> existing = new HashSet<String>();
        for (PeriodicTask task : hibSession.createQuery("from PeriodicTask where session = :sessionId").setLong("sessionId", rollForwardSessionForm.getSessionToRollForwardTo().longValue()).list()) {
            existing.add(task.getName());
        }
        Date now = new Date();
        Date firstDate = DateUtils.getDate(1, toSession.getStartMonth() - ApplicationProperty.DatePatternNrExessMonth.intValue(), toSession.getSessionStartYear());
        Date lastDate = DateUtils.getDate(1, toSession.getEndMonth() + ApplicationProperty.DatePatternNrExessMonth.intValue(), toSession.getSessionStartYear());
        for (PeriodicTask original : hibSession.createQuery("from PeriodicTask where session = :sessionId").setLong("sessionId", rollForwardSessionForm.getSessionToRollPeriodicTasksFrom().longValue()).list()) {
            if (existing.contains(original.getName())) continue;
            PeriodicTask task = new PeriodicTask();
            task = new PeriodicTask();
            task.setName(original.getName());
            task.setInputFile(original.getInputFile());
            task.setEmail(original.getEmail());
            task.setOwner(original.getOwner());
            task.setScript(original.getScript());
            task.setSession(toSession);
            task.setParameters(new HashSet<TaskParameter>());
            task.setSchedule(new HashSet<TaskExecution>());
            for (TaskParameter originalParameter : original.getParameters()) {
                TaskParameter parameter = new TaskParameter();
                parameter.setName(originalParameter.getName());
                parameter.setValue(originalParameter.getValue());
                for (ScriptParameter sp : task.getScript().getParameters()) {
                    if (!sp.getName().equals(originalParameter.getName())) continue;
                    parameter.setValue(this.convertParameter(hibSession, sp.getType(), originalParameter.getValue(), rollForwardSessionForm));
                }
                if (parameter.getValue() == null) continue;
                parameter.setTask(task);
                task.getParameters().add(parameter);
            }
            for (TaskExecution originalExecution : original.getSchedule()) {
                Date date = SaveTaskBackend.getScheduleDate(toSession, originalExecution.getExecutionDate(), originalExecution.getExecutionPeriod());
                if (date.before(now) || date.before(firstDate) || !date.before(lastDate)) continue;
                TaskExecution execution = new TaskExecution();
                execution.setCreatedDate(now);
                execution.setExecutionDate(originalExecution.getExecutionDate());
                execution.setExecutionPeriod(originalExecution.getExecutionPeriod());
                execution.setExecutionStatus(TaskInterface.ExecutionStatus.CREATED.ordinal());
                execution.setScheduledDate(date);
                execution.setTask(task);
                task.getSchedule().add(execution);
            }
            if (task.getSchedule().isEmpty()) continue;
            hibSession.save((Object)task);
        }
        hibSession.flush();
        hibSession.clear();
    }

    public void rollLearningManagementSystemInfoForward(RollForwardSessionAction.RollForwardErrors errors, RollForwardSessionForm rollForwardSessionForm) {
        Session toSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollForwardTo());
        Session fromSession = Session.getSessionById(rollForwardSessionForm.getSessionToRollDatePatternsForwardFrom());
        List<LearningManagementSystemInfo> fromLearningManagementSystems = LearningManagementSystemInfo.findAll(fromSession.getUniqueId());
        LearningManagementSystemInfo fromLms2 = null;
        LearningManagementSystemInfo toLms = null;
        LearningManagementSystemInfoDAO lmsDao = new LearningManagementSystemInfoDAO();
        try {
            for (LearningManagementSystemInfo fromLms2 : fromLearningManagementSystems) {
                if (fromLms2 == null) continue;
                toLms = (LearningManagementSystemInfo)fromLms2.clone();
                toLms.setSession(toSession);
                lmsDao.saveOrUpdate(toLms);
                lmsDao.getSession().flush();
            }
            lmsDao.getSession().flush();
            lmsDao.getSession().clear();
        }
        catch (Exception e) {
            String type = MSG.rollForwardLMSInfo();
            String msg = MSG.errorRollForwardFailedAll(type.toLowerCase());
            this.iLog.error((Object)msg, (Throwable)e);
            errors.addFieldError("rollForward", MSG.errorRollingForward(type, fromSession.getLabel(), toSession.getLabel(), msg));
        }
    }

    public boolean isSubpartTimeRollForward() {
        return this.subpartTimeRollForward;
    }

    public boolean isSubpartLocationRollForward() {
        return this.subpartLocationRollForward;
    }

    public boolean isClassPrefsPushUp() {
        return this.classPrefsPushUp;
    }

    public boolean isClassRollForward() {
        return this.classRollForward;
    }

    public boolean isRollForwardDistributions() {
        return this.rollForwardDistributions != DistributionMode.NONE;
    }

    public boolean isRollForwardDistributions(DistributionPref dp) {
        switch (this.rollForwardDistributions) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case SUBPART: {
                for (DistributionObject distObj : dp.getDistributionObjects()) {
                    if (!(distObj.getPrefGroup() instanceof Class_)) continue;
                    return false;
                }
                return true;
            }
            case MIXED: {
                for (DistributionObject distObj : dp.getDistributionObjects()) {
                    if (!(distObj.getPrefGroup() instanceof SchedulingSubpart)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public CancelledClassAction getCancelledClassAction() {
        return this.cancelledClassAction;
    }

    public boolean isResetClassSuffix() {
        return this.resetClassSuffix;
    }

    public static enum StudentEnrollmentMode {
        LAST_LIKE,
        STUDENT_CLASS_ENROLLMENTS,
        STUDENT_COURSE_REQUESTS,
        POINT_IN_TIME_CLASS_ENROLLMENTS;

    }

    public static enum DistributionMode {
        ALL,
        MIXED,
        SUBPART,
        NONE;

    }

    public static enum CancelledClassAction {
        REOPEN,
        KEEP,
        SKIP;

    }
}

