/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.ManageSolversAction;
import org.unitime.timetable.gwt.client.sectioning.PublishedSectioningSolutionsTable;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.service.StudentSectioningSolverService;

@GwtRpcImplements(value=MenuInterface.SolverInfoRpcRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
public class SolverInfoBackend
implements GwtRpcImplementation<MenuInterface.SolverInfoRpcRequest, MenuInterface.SolverInfoInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static CPSolverMessages SOLVERMSG = Localization.create(CPSolverMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    StudentSectioningSolverService studentSectioningSolverService;
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public MenuInterface.SolverInfoInterface execute(MenuInterface.SolverInfoRpcRequest request, SessionContext context) {
        CommonSolverInterface solver = this.studentSectioningSolverService.getSolver(false);
        if (solver == null) {
            solver = this.examinationSolverService.getSolver();
        }
        if (solver == null) {
            solver = this.courseTimetablingSolverService.getSolver();
        }
        if (solver == null) {
            solver = this.instructorSchedulingSolverService.getSolver();
        }
        if (solver == null && context.hasPermission(Right.StudentSectioningSolverDashboard)) {
            solver = this.studentSectioningSolverService.getPublishedSolver();
        }
        MenuInterface.SolverInfoInterface info = this.getInfo(solver, request.isIncludeSolutionInfo());
        if (solver != null && solver.getType() == SolverParameterGroup.SolverType.STUDENT && info != null && !context.hasPermission(Right.StudentSectioningSolver)) {
            info.setUrl("gwt.jsp?page=batchsctdash");
        }
        return info;
    }

    public MenuInterface.SolverInfoInterface getInfo(CommonSolverInterface solver, boolean includeSolutionInfo) {
        if (solver == null) {
            return null;
        }
        Map progress = solver.getProgress();
        if (progress == null) {
            return null;
        }
        MenuInterface.SolverInfoInterface ret = new MenuInterface.SolverInfoInterface();
        DataProperties properties = solver.getProperties();
        String progressStatus = (String)progress.get("STATUS");
        String progressPhase = (String)progress.get("PHASE");
        long progressCur = (Long)progress.get("PROGRESS");
        long progressMax = (Long)progress.get("MAX_PROGRESS");
        String version = (String)progress.get("VERSION");
        if (version == null || "-1".equals(version)) {
            version = "N/A";
        }
        double progressPercent = 100.0 * (double)(progressCur < progressMax ? progressCur : progressMax) / (double)progressMax;
        String ownerName = ManageSolversAction.getSolverOwner(properties);
        if (ownerName.length() > 50) {
            ownerName = ownerName.substring(0, 47) + "...";
        }
        Map<String, String> translations = null;
        switch (solver.getType()) {
            case COURSE: {
                ret.setType(MESSAGES.solverCourse());
                ret.setUrl("gwt.jsp?page=solver&type=course");
                translations = SOLVERMSG.courseInfoMessages();
                break;
            }
            case EXAM: {
                ret.setType(MESSAGES.solverExamination());
                ret.setUrl("gwt.jsp?page=solver&type=exam");
                translations = SOLVERMSG.examInfoMessages();
                break;
            }
            case STUDENT: {
                ret.setType(MESSAGES.solverStudent());
                ret.setUrl("gwt.jsp?page=solver&type=student");
                translations = SOLVERMSG.studentInfoMessages();
                break;
            }
            case INSTRUCTOR: {
                ret.setType(MESSAGES.solverInstructor());
                ret.setUrl("gwt.jsp?page=solver&type=instructor");
                translations = SOLVERMSG.instructorInfoMessages();
            }
        }
        ret.addPair(MESSAGES.fieldType(), ret.getType());
        ret.addPair(MESSAGES.fieldSolver(), progressStatus);
        ret.setSolver(progressStatus);
        ret.addPair(MESSAGES.fieldPhase(), progressPhase);
        if (progressMax > 0L) {
            ret.addPair(MESSAGES.fieldProgress(), (progressCur < progressMax ? progressCur : progressMax) + " of " + progressMax + " (" + new DecimalFormat("0.0").format(progressPercent) + "%)");
        }
        ret.addPair(MESSAGES.fieldOwner(), ownerName);
        ret.addPair(MESSAGES.fieldHost(), solver.getHost());
        ret.addPair(MESSAGES.fieldSession(), ((Session)SessionDAO.getInstance().get(properties.getPropertyLong("General.SessionId", null))).getLabel());
        MenuInterface.InfoPairInterface p = ret.addPair(MESSAGES.fieldVersion(), version);
        if (includeSolutionInfo) {
            Map<String, String> info = null;
            try {
                info = solver.statusSolutionInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (info != null && !info.isEmpty()) {
                p.setSeparator(true);
                TreeSet<String> keys = new TreeSet<String>(new PublishedSectioningSolutionsTable.InfoComparator());
                keys.addAll(info.keySet());
                for (String key : keys) {
                    String translatedKey;
                    String string = translatedKey = translations == null ? null : translations.get(key);
                    if (translatedKey != null) {
                        ret.addPair(translatedKey, info.get(key));
                        continue;
                    }
                    ret.addPair(key, info.get(key));
                }
            }
        }
        return ret;
    }
}

