/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.CourseRequest;

@SerializeWith(value=XOverrideSerializer.class)
public class XOverride
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String iExternalId = null;
    private Date iTimeStamp = null;
    private Integer iStatus = null;
    private Float iValue = null;

    public XOverride(String externalId, Date timeStamp, Integer status, Float value) {
        this.iExternalId = externalId;
        this.iTimeStamp = timeStamp;
        this.iStatus = status;
        this.iValue = value;
    }

    public XOverride(String externalId, Date timeStamp, Integer status) {
        this(externalId, timeStamp, status, null);
    }

    public XOverride(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XOverride(XOverride override) {
        this.iExternalId = override.iExternalId;
        this.iTimeStamp = override.iTimeStamp;
        this.iStatus = override.iStatus;
        this.iValue = override.iValue;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public Integer getStatus() {
        return this.iStatus;
    }

    public void setStatus(Integer status) {
        this.iStatus = status;
    }

    public Float getValue() {
        return this.iValue;
    }

    public boolean isPending() {
        return this.iStatus == null || this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    public boolean isApproved() {
        return this.iStatus != null && this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal();
    }

    public boolean isCancelled() {
        return this.iStatus != null && this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal();
    }

    public boolean isRejected() {
        return this.iStatus != null && this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal();
    }

    public boolean isNoChecked() {
        return this.iStatus != null && this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal();
    }

    public boolean isNotNeeded() {
        return this.iStatus != null && this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal();
    }

    public boolean isCancelledOrRejected() {
        return this.iStatus != null && (this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal() || this.iStatus.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iExternalId = (String)in.readObject();
        this.iTimeStamp = in.readBoolean() ? new Date(in.readLong()) : null;
        int status = in.readInt();
        this.iStatus = status < 0 ? null : Integer.valueOf(status);
        this.iValue = in.readBoolean() ? Float.valueOf(in.readFloat()) : null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.iExternalId);
        out.writeBoolean(this.iTimeStamp != null);
        if (this.iTimeStamp != null) {
            out.writeLong(this.iTimeStamp.getTime());
        }
        out.writeInt(this.iStatus == null ? -1 : this.iStatus);
        out.writeBoolean(this.iValue != null);
        if (this.iValue != null) {
            out.writeFloat(this.iValue.floatValue());
        }
    }

    public static class XOverrideSerializer
    implements Externalizer<XOverride> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XOverride object) throws IOException {
            object.writeExternal(output);
        }

        public XOverride readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XOverride(input);
        }
    }
}

