/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseMatcherProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.SkipDisabledCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

public class OnlineOnlyCourseMatcherProvider
implements CourseMatcherProvider {
    @Override
    public CourseMatcher getCourseMatcher(OnlineSectioningServer server, SessionContext context, Long studentId) {
        String filter = ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyStudentFilter", null);
        if (filter == null || filter.isEmpty()) {
            return new FallbackCourseMatcher();
        }
        if (server != null && !(server instanceof DatabaseServer)) {
            if (context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyAdminOverride", "false"))) {
                return new FallbackCourseMatcher();
            }
            if (context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyAdvisorOverride", "false"))) {
                return new FallbackCourseMatcher();
            }
            XStudent student = server.getStudent(studentId);
            if (student == null) {
                return new FallbackCourseMatcher();
            }
            if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                return new OnlineOnlyCourseMatcher(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyInstructionalModeRegExp"), ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyCourseNameRegExp"));
            }
            if ("true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyExclusiveCourses", "false"))) {
                return new NotOnlineOnlyCourseMatcher(ApplicationProperty.OnlineSchedulingParameter.value("Filter.ResidentialInstructionalModeRegExp"), ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyCourseNameRegExp"));
            }
            return new FallbackCourseMatcher();
        }
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        if (student == null) {
            return new FallbackCourseMatcher();
        }
        if (context.hasPermissionAnySession((Object)student.getSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyAdminOverride", "false"))) {
            return new FallbackCourseMatcher();
        }
        if (context.hasPermissionAnySession((Object)student.getSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyAdvisorOverride", "false"))) {
            return new FallbackCourseMatcher();
        }
        if (new Query(filter).match(new DbFindEnrollmentInfoAction.DbStudentMatcher(student))) {
            return new OnlineOnlyCourseMatcher(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyInstructionalModeRegExp"), ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyCourseNameRegExp"));
        }
        if ("true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyExclusiveCourses", "false"))) {
            return new NotOnlineOnlyCourseMatcher(ApplicationProperty.OnlineSchedulingParameter.value("Filter.ResidentialInstructionalModeRegExp"), ApplicationProperty.OnlineSchedulingParameter.value("Filter.OnlineOnlyCourseNameRegExp"));
        }
        return new FallbackCourseMatcher();
    }

    public static class NotOnlineOnlyCourseMatcher
    extends FallbackCourseMatcher {
        private static final long serialVersionUID = 1L;
        private String iInstructionalMode;
        private String iCourseRegExp;

        public NotOnlineOnlyCourseMatcher(String im, String cn) {
            this.iInstructionalMode = im;
            this.iCourseRegExp = cn;
        }

        @Override
        public boolean match(XCourseId course) {
            if (this.iCourseRegExp != null && !this.iCourseRegExp.isEmpty() && course.getCourseName().matches(this.iCourseRegExp)) {
                return false;
            }
            if (this.iInstructionalMode != null) {
                if (this.getServer() != null && !(this.getServer() instanceof DatabaseServer)) {
                    XOffering offering = this.getServer().getOffering(course.getOfferingId());
                    if (offering != null) {
                        for (XConfig config : offering.getConfigs()) {
                            if (!(this.iInstructionalMode.isEmpty() ? !(config.getInstructionalMethod() != null && config.getInstructionalMethod().getReference() != null && !config.getInstructionalMethod().getReference().isEmpty() || !this.iShowDisabled && !this.isEnabledForStudentScheduling(config)) : config.getInstructionalMethod() != null && config.getInstructionalMethod().getReference() != null && config.getInstructionalMethod().getReference().matches(this.iInstructionalMode) && (this.iShowDisabled || this.isEnabledForStudentScheduling(config)))) continue;
                            return true;
                        }
                    }
                } else {
                    InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId());
                    if (offering != null) {
                        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                            InstructionalMethod configIm = config.getEffectiveInstructionalMethod();
                            if (!(this.iInstructionalMode.isEmpty() ? !(configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty() || !this.iShowDisabled && !this.isEnabledForStudentScheduling(config)) : configIm != null && configIm.getReference() != null && configIm.getReference().matches(this.iInstructionalMode) && (this.iShowDisabled || this.isEnabledForStudentScheduling(config)))) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            return this.iShowDisabled || this.isEnabledForStudentScheduling(course);
        }
    }

    public static class OnlineOnlyCourseMatcher
    extends FallbackCourseMatcher {
        private static final long serialVersionUID = 1L;
        private String iInstructionalMode;
        private String iCourseRegExp;

        public OnlineOnlyCourseMatcher(String im, String cn) {
            this.iInstructionalMode = im;
            this.iCourseRegExp = cn;
        }

        @Override
        public boolean match(XCourseId course) {
            if (this.iCourseRegExp != null && !this.iCourseRegExp.isEmpty() && !course.getCourseName().matches(this.iCourseRegExp)) {
                return false;
            }
            if (this.iInstructionalMode != null) {
                if (this.getServer() != null && !(this.getServer() instanceof DatabaseServer)) {
                    XOffering offering = this.getServer().getOffering(course.getOfferingId());
                    if (offering != null) {
                        for (XConfig config : offering.getConfigs()) {
                            if (!(this.iInstructionalMode.isEmpty() ? !(config.getInstructionalMethod() != null && config.getInstructionalMethod().getReference() != null && !config.getInstructionalMethod().getReference().isEmpty() || !this.iShowDisabled && !this.isEnabledForStudentScheduling(config)) : config.getInstructionalMethod() != null && config.getInstructionalMethod().getReference() != null && config.getInstructionalMethod().getReference().matches(this.iInstructionalMode) && (this.iShowDisabled || this.isEnabledForStudentScheduling(config)))) continue;
                            return true;
                        }
                    }
                } else {
                    InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId());
                    if (offering != null) {
                        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                            InstructionalMethod configIm = config.getEffectiveInstructionalMethod();
                            if (!(this.iInstructionalMode.isEmpty() ? !(configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty() || !this.iShowDisabled && !this.isEnabledForStudentScheduling(config)) : configIm != null && configIm.getReference() != null && configIm.getReference().matches(this.iInstructionalMode) && (this.iShowDisabled || this.isEnabledForStudentScheduling(config)))) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            return this.iShowDisabled || this.isEnabledForStudentScheduling(course);
        }
    }

    public static class FallbackCourseMatcher
    extends SkipDisabledCourseMatcher {
        private static final long serialVersionUID = 1L;
        protected boolean iShowDisabled = "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.ShowDisabled", "true"));

        @Override
        protected boolean isEnabledForStudentScheduling(InstrOfferingConfig config) {
            if (this.iShowDisabledWhenNotLoaded) {
                return true;
            }
            return super.isEnabledForStudentScheduling(config);
        }

        @Override
        public boolean match(XCourseId course) {
            return this.iShowDisabled || this.isEnabledForStudentScheduling(course);
        }
    }
}

