/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;

public abstract class BaseAdvisor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iAcademicTitle;
    private String iEmail;
    private Session iSession;
    private Roles iRole;
    private Set<Student> iStudents;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_FIRST_NAME = "firstName";
    public static String PROP_MIDDLE_NAME = "middleName";
    public static String PROP_LAST_NAME = "lastName";
    public static String PROP_ACAD_TITLE = "academicTitle";
    public static String PROP_EMAIL = "email";

    public BaseAdvisor() {
        this.initialize();
    }

    public BaseAdvisor(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Roles getRole() {
        return this.iRole;
    }

    public void setRole(Roles role) {
        this.iRole = role;
    }

    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addTostudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Advisor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Advisor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Advisor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Advisor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Advisor[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tRole: " + this.getRole() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

