/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class TimePatternEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 2957933039987971879L;
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp;
    private Long iUniqueId;
    private String iType;
    private String iNrMtgs;
    private String iMinPerMtg;
    private String iSlotsPerMtg;
    private String iDayCodes;
    private String iStartTimes;
    private boolean iEditable;
    private boolean iVisible;
    private String iName;
    private List<Long> iDepartmentIds = new ArrayList<Long>();
    private Long iDepartmentId;
    private String iBreakTime;
    private Long iPreviousId;
    private Long iNextId;

    public TimePatternEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iName == null || this.iName.trim().isEmpty()) {
            action.addFieldError("form.name", MSG.errorRequiredField(MSG.columnTimePatternName()));
        } else {
            try {
                TimePattern pat = TimePattern.findByName(action.getSessionContext().getUser().getCurrentAcademicSessionId(), this.iName);
                if (pat != null && !pat.getUniqueId().equals(this.iUniqueId)) {
                    action.addFieldError("form.name", MSG.errorAlreadyExists(this.iName));
                }
            }
            catch (Exception e) {
                action.addFieldError("form.name", e.getMessage());
            }
        }
        try {
            if (Integer.parseInt(this.getNrMtgs()) <= 0 && this.getTypeInt() != TimePattern.TimePatternType.ExactTime.ordinal()) {
                action.addFieldError("form.nrMtgs", MSG.errorNumberOfMeetingsPerWeekRequired());
            }
        }
        catch (NumberFormatException e) {
            action.addFieldError("form.nrMtgs", MSG.errorNumberOfMeetingsPerWeekRequired());
        }
        try {
            if (Integer.parseInt(this.getMinPerMtg()) <= 0 && this.getTypeInt() != TimePattern.TimePatternType.ExactTime.ordinal()) {
                action.addFieldError("form.minPerMtg", MSG.errorMinutesPerMeetingRequired());
            }
        }
        catch (NumberFormatException e) {
            action.addFieldError("form.minPerMtg", MSG.errorMinutesPerMeetingRequired());
        }
        try {
            if (Integer.parseInt(this.getSlotsPerMtg()) <= 0 && this.getTypeInt() != TimePattern.TimePatternType.ExactTime.ordinal()) {
                action.addFieldError("form.slotsPerMtg", MSG.errorNumberOfSlotsPerMeetingRequired());
            }
        }
        catch (NumberFormatException e) {
            action.addFieldError("form.slotsPerMtg", MSG.errorNumberOfSlotsPerMeetingRequired());
        }
        if (this.getTypeInt() < 0) {
            action.addFieldError("form.type", MSG.errorRequiredField(MSG.columnTimePatternType()));
        }
        if (this.getBreakTime() == null || this.getBreakTime().isEmpty()) {
            this.setBreakTime("0");
        } else {
            try {
                Integer.parseInt(this.getBreakTime());
            }
            catch (NumberFormatException e) {
                action.addFieldError("form.breakTime", MSG.errorNotNumber(MSG.columnTimePatternBreakTime()));
            }
        }
        try {
            this.str2dayCodes(this.iDayCodes, "\n, ");
        }
        catch (Exception e) {
            action.addFieldError("form.dayCodes", e.getMessage());
        }
        try {
            this.str2startSlots(this.iStartTimes, "\n, ");
        }
        catch (Exception e) {
            action.addFieldError("form.startTimes", e.getMessage());
        }
        if (this.getTypeInt() != TimePattern.TimePatternType.Extended.ordinal() && this.getTypeInt() != TimePattern.TimePatternType.ExactTime.ordinal() && !this.iDepartmentIds.isEmpty()) {
            action.addFieldError("form.type", MSG.errorOnlyExtTimePatternHasDepartments());
        }
    }

    @Override
    public void reset() {
        this.iOp = "List";
        this.iUniqueId = -1L;
        this.iType = TimePattern.TimePatternType.Standard.name();
        this.iNrMtgs = "";
        this.iMinPerMtg = "";
        this.iSlotsPerMtg = "";
        this.iDayCodes = "";
        this.iStartTimes = "";
        this.iEditable = false;
        this.iVisible = false;
        this.iName = "";
        this.iBreakTime = "";
        this.iDepartmentId = null;
        this.iDepartmentIds.clear();
        this.iPreviousId = null;
        this.iNextId = null;
    }

    public void load(TimePattern tp, Long sessionId) {
        if (tp == null) {
            this.reset();
            this.iOp = MSG.actionSaveTimePattern();
            this.iVisible = true;
            this.iEditable = true;
        } else {
            this.setName(tp.getName());
            this.setVisible(tp.isVisible());
            this.setEditable(tp.isEditable());
            this.setTypeInt(tp.getType());
            this.setMinPerMtg(tp.getMinPerMtg().toString());
            this.setNrMtgs(tp.getNrMeetings().toString());
            this.setBreakTime(tp.getBreakTime().toString());
            this.setSlotsPerMtg(tp.getSlotsPerMtg().toString());
            this.setUniqueId(tp.getUniqueId());
            this.setDayCodes(TimePatternEditForm.dayCodes2str(tp.getDays(), this.getEditable() ? "\n" : ", "));
            this.setStartTimes(TimePatternEditForm.startSlots2str(tp.getTimes(), this.getEditable() ? "\n" : ", "));
            this.iDepartmentIds.clear();
            for (Department d : tp.getDepartments(sessionId)) {
                this.iDepartmentIds.add(d.getUniqueId());
            }
            this.iOp = MSG.actionUpdateTimePattern();
        }
    }

    public void update(TimePattern tp, org.hibernate.Session hibSession) throws Exception {
        tp.setName(this.getName());
        tp.setVisible(this.getVisible());
        tp.setType(this.getTypeInt());
        tp.setBreakTime(Integer.valueOf(this.getBreakTime()));
        if (this.getEditable()) {
            int oldDays = tp.getDays().size();
            int oldTimes = tp.getTimes().size();
            tp.setMinPerMtg(Integer.valueOf(this.getMinPerMtg()));
            tp.setNrMeetings(Integer.valueOf(this.getNrMtgs()));
            tp.setSlotsPerMtg(Integer.valueOf(this.getSlotsPerMtg()));
            for (TimePatternTime timePatternTime : tp.getTimes()) {
                hibSession.delete((Object)timePatternTime);
            }
            for (TimePatternDays timePatternDays : tp.getDays()) {
                hibSession.delete((Object)timePatternDays);
            }
            tp.setTimes(this.str2startSlots(this.getStartTimes(), "\n, "));
            tp.setDays(this.str2dayCodes(this.getDayCodes(), "\n, "));
            for (TimePatternTime timePatternTime : tp.getTimes()) {
                hibSession.save((Object)timePatternTime);
            }
            for (TimePatternDays timePatternDays : tp.getDays()) {
                hibSession.save((Object)timePatternDays);
            }
            if (tp.getSession() != null & tp.getSession().getStatusType().isAllowRollForward() && (oldDays != tp.getDays().size() || oldTimes != tp.getTimes().size())) {
                for (TimePref timePref : hibSession.createQuery("from TimePref tp where tp.timePattern.uniqueId = :tpid").setLong("tpid", tp.getUniqueId().longValue()).list()) {
                    timePref.setPreference(null);
                    hibSession.update((Object)timePref);
                }
            }
        }
        HashSet<Department> oldDepts = new HashSet<Department>(tp.getDepartments());
        for (Long departmentId : this.iDepartmentIds) {
            Department department = (Department)new DepartmentDAO().get(departmentId, hibSession);
            if (department == null || oldDepts.remove(department)) continue;
            tp.getDepartments().add(department);
            department.getTimePatterns().add(tp);
            hibSession.saveOrUpdate((Object)department);
        }
        for (Department d : oldDepts) {
            tp.getDepartments().remove(d);
            d.getTimePatterns().remove(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        hibSession.saveOrUpdate((Object)tp);
    }

    public TimePattern create(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        TimePattern tp = new TimePattern();
        tp.setName(this.getName());
        tp.setVisible(this.getVisible());
        tp.setType(this.getTypeInt());
        tp.setMinPerMtg(Integer.valueOf(this.getMinPerMtg()));
        tp.setNrMeetings(Integer.valueOf(this.getNrMtgs()));
        tp.setBreakTime(Integer.valueOf(this.getBreakTime()));
        tp.setSlotsPerMtg(Integer.valueOf(this.getSlotsPerMtg()));
        tp.setTimes(this.str2startSlots(this.getStartTimes(), "\n, "));
        tp.setDays(this.str2dayCodes(this.getDayCodes(), "\n, "));
        tp.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        for (TimePatternTime timePatternTime : tp.getTimes()) {
            hibSession.save((Object)timePatternTime);
        }
        for (TimePatternDays timePatternDays : tp.getDays()) {
            hibSession.save((Object)timePatternDays);
        }
        HashSet<Department> newDepts = new HashSet<Department>();
        for (Long departmentId : this.iDepartmentIds) {
            Department d = (Department)new DepartmentDAO().get(departmentId, hibSession);
            if (d == null) continue;
            newDepts.add(d);
        }
        tp.setDepartments(newDepts);
        hibSession.save((Object)tp);
        for (Department d : newDepts) {
            d.getTimePatterns().add(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        this.setUniqueId(tp.getUniqueId());
        return tp;
    }

    public TimePattern saveOrUpdate(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        TimePattern tp = null;
        if (this.getUniqueId().intValue() >= 0) {
            tp = (TimePattern)new TimePatternDAO().get(this.getUniqueId());
        }
        if (tp == null) {
            tp = this.create(context, hibSession);
            ChangeLog.addChange(hibSession, context, tp, ChangeLog.Source.TIME_PATTERN_EDIT, ChangeLog.Operation.CREATE, null, null);
        } else {
            this.update(tp, hibSession);
            ChangeLog.addChange(hibSession, context, tp, ChangeLog.Source.TIME_PATTERN_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        return tp;
    }

    public void delete(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        if (this.getUniqueId().intValue() < 0) {
            return;
        }
        if (!this.getEditable()) {
            return;
        }
        TimePattern tp = (TimePattern)new TimePatternDAO().get(this.getUniqueId(), hibSession);
        for (Department d : tp.getDepartments()) {
            d.getTimePatterns().remove(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        ChangeLog.addChange(hibSession, context, tp, ChangeLog.Source.TIME_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)tp);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    public List<ComboBoxLookup> getTypes() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (TimePattern.TimePatternType t : TimePattern.TimePatternType.values()) {
            ret.add(new ComboBoxLookup(t.getLabel(), t.name()));
        }
        return ret;
    }

    public int getTypeInt() {
        for (TimePattern.TimePatternType t : TimePattern.TimePatternType.values()) {
            if (!t.name().equals(this.iType)) continue;
            return t.ordinal();
        }
        return -1;
    }

    public void setTypeInt(int type) {
        this.iType = type < 0 ? "" : TimePattern.TimePatternType.values()[type].name();
    }

    public String getNrMtgs() {
        return this.iNrMtgs;
    }

    public void setNrMtgs(String nrMtgs) {
        this.iNrMtgs = nrMtgs;
    }

    public String getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(String breakTime) {
        this.iBreakTime = breakTime;
    }

    public String getMinPerMtg() {
        return this.iMinPerMtg;
    }

    public void setMinPerMtg(String minPerMtg) {
        this.iMinPerMtg = minPerMtg;
    }

    public String getSlotsPerMtg() {
        return this.iSlotsPerMtg;
    }

    public void setSlotsPerMtg(String slotsPerMtg) {
        this.iSlotsPerMtg = slotsPerMtg;
    }

    public String getDayCodes() {
        return this.iDayCodes;
    }

    public void setDayCodes(String dayCodes) {
        this.iDayCodes = dayCodes;
    }

    public String getStartTimes() {
        return this.iStartTimes;
    }

    public void setStartTimes(String startTimes) {
        this.iStartTimes = startTimes;
    }

    public boolean getEditable() {
        return this.iEditable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(boolean visible) {
        this.iVisible = visible;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public List<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(List<Long> departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public Long getDepartmentIds(int idx) {
        return this.iDepartmentIds.get(idx);
    }

    public void setDepartmentIds(int idx, Long value) {
        this.iDepartmentIds.set(idx, value);
    }

    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long deptId) {
        this.iDepartmentId = deptId;
    }

    public Long getNextId() {
        return this.iNextId;
    }

    public void setNextId(Long nextId) {
        this.iNextId = nextId;
    }

    public boolean getHasNext() {
        return this.iNextId != null && this.iNextId >= 0L;
    }

    public Long getPreviousId() {
        return this.iPreviousId;
    }

    public void setPreviousId(Long previousId) {
        this.iPreviousId = previousId;
    }

    public boolean getHasPrevious() {
        return this.iPreviousId != null && this.iPreviousId >= 0L;
    }

    public static String dayCodes2str(Collection dayCodes, String delim) {
        StringBuffer sb = new StringBuffer();
        Iterator i = new TreeSet(dayCodes).iterator();
        while (i.hasNext()) {
            int j;
            int dayCode = ((TimePatternDays)i.next()).getDayCode();
            int nrDays = 0;
            for (j = 0; j < Constants.NR_DAYS; ++j) {
                if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                ++nrDays;
            }
            for (j = 0; j < Constants.NR_DAYS; ++j) {
                if ((Constants.DAY_CODES[j] & dayCode) == 0) continue;
                sb.append(nrDays == 1 ? CONSTANTS.days()[j] : CONSTANTS.shortDays()[j]);
            }
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String startSlots2str(Collection startSlots, String delim) {
        StringBuffer sb = new StringBuffer();
        Iterator i = new TreeSet(startSlots).iterator();
        while (i.hasNext()) {
            int startSlot = ((TimePatternTime)i.next()).getStartSlot();
            int min = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int time = 100 * (min / 60) + min % 60;
            sb.append(time);
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static int getDayCode(String token, int day, int dayCode) {
        int code;
        if (day == Constants.NR_DAYS) {
            if (token.length() == 0) {
                return dayCode;
            }
            return -1;
        }
        if (token.startsWith(CONSTANTS.shortDays()[day]) && (code = TimePatternEditForm.getDayCode(token.substring(CONSTANTS.shortDays()[day].length()), day + 1, dayCode + Constants.DAY_CODES[day])) >= 0) {
            return code;
        }
        if (token.startsWith(CONSTANTS.days()[day]) && (code = TimePatternEditForm.getDayCode(token.substring(CONSTANTS.days()[day].length()), day + 1, dayCode + Constants.DAY_CODES[day])) >= 0) {
            return code;
        }
        return TimePatternEditForm.getDayCode(token, day + 1, dayCode);
    }

    public Set str2dayCodes(String dayCodes, String delim) throws Exception {
        TreeSet<TimePatternDays> ret = new TreeSet<TimePatternDays>();
        StringTokenizer stk = new StringTokenizer(dayCodes, delim == null ? " ,\t\n\r\f" : delim);
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (token.trim().length() == 0) continue;
            int dayCode = TimePatternEditForm.getDayCode(token.trim(), 0, 0);
            if (dayCode < 0) {
                throw new Exception(MSG.errorInvalidDaysForToken(token));
            }
            int nrDays = 0;
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                ++nrDays;
            }
            try {
                if (nrDays != Integer.parseInt(this.getNrMtgs())) {
                    throw new Exception(MSG.errorWrongNumberOfDaysForToken(token));
                }
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
            TimePatternDays days = new TimePatternDays();
            days.setDayCode(dayCode);
            if (ret.contains(days)) {
                throw new Exception(MSG.errorDuplicateDaysToken(token));
            }
            ret.add(days);
        }
        return ret;
    }

    public Set str2startSlots(String startTimes, String delim) throws Exception {
        TreeSet<TimePatternTime> ret = new TreeSet<TimePatternTime>();
        StringTokenizer stk = new StringTokenizer(startTimes, delim == null ? " ,\t\n\r\f" : delim);
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (token.trim().length() == 0) continue;
            int slot = -1;
            try {
                int time = Integer.parseInt(token.trim());
                int hour = time / 100;
                int min = time % 100;
                if (hour >= 24) {
                    throw new Exception(MSG.errorWrongHoursForTimeToken(token, hour));
                }
                if (min >= 60) {
                    throw new Exception(MSG.errorWrongMinutesForTimeToken(token, min));
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    throw new Exception(MSG.errorMinutesNotDivisibleByFiveForTimeToken(token, min));
                }
                try {
                    int endTime = hour * 60 + min + Constants.SLOT_LENGTH_MIN * Integer.parseInt(this.getSlotsPerMtg());
                    if (endTime / Constants.SLOT_LENGTH_MIN - Constants.FIRST_SLOT_TIME_MIN > 288) {
                        throw new Exception(MSG.errorTimeGoesOverMidnightForToken(token));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            }
            catch (NumberFormatException ex) {
                throw new Exception(MSG.errorTimeNotNumberForToken(token));
            }
            if (slot < 0) {
                throw new Exception(MSG.errorNotValidTimeForToken(token));
            }
            TimePatternTime time = new TimePatternTime();
            time.setStartSlot(slot);
            if (ret.contains(time)) {
                throw new Exception(MSG.errorDiplicateTimeToken(token));
            }
            ret.add(time);
        }
        return ret;
    }

    public String getExample() {
        try {
            TimePattern tp = new TimePattern(Long.MAX_VALUE);
            tp.setName(this.getName());
            tp.setVisible(this.getVisible());
            tp.setType(this.getTypeInt());
            tp.setMinPerMtg(Integer.valueOf(this.getMinPerMtg()));
            tp.setNrMeetings(Integer.valueOf(this.getNrMtgs()));
            tp.setBreakTime(Integer.valueOf(this.getBreakTime()));
            tp.setSlotsPerMtg(Integer.valueOf(this.getSlotsPerMtg()));
            tp.setTimes(this.str2startSlots(this.getStartTimes(), "\n, "));
            tp.setDays(this.str2dayCodes(this.getDayCodes(), "\n, "));
            if (tp.getTimes().isEmpty() || tp.getDays().isEmpty()) {
                return null;
            }
            RequiredTimeTable rtt = tp.getRequiredTimeTable(true);
            return rtt.print(false, false, false, false);
        }
        catch (Exception e) {
            return null;
        }
    }
}

