/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.IdValue;

public class ExamReportForm
implements UniTimeForm {
    private static final long serialVersionUID = -8009733200124355056L;
    protected static final ConstantsMessages CONST = Localization.create(ConstantsMessages.class);
    private String iOp = null;
    private boolean iShowSections = false;
    private Long iSubjectArea = null;
    private Collection iSubjectAreas = null;
    private String iTable = null;
    private int iNrColumns;
    private int iNrRows;
    private Long iExamType;

    @Override
    public void validate(UniTimeAction action) {
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iShowSections = false;
        this.iTable = null;
        this.iNrColumns = 0;
        this.iNrRows = 0;
        this.iExamType = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public boolean getShowSections() {
        return this.iShowSections;
    }

    public void setShowSections(boolean showSections) {
        this.iShowSections = showSections;
    }

    public Long getSubjectArea() {
        return this.iSubjectArea;
    }

    public String getSubjectAreaAbbv() {
        return ((SubjectArea)new SubjectAreaDAO().get(this.iSubjectArea)).getSubjectAreaAbbreviation();
    }

    public void setSubjectArea(Long subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public void load(SessionContext session) {
        this.setShowSections("1".equals(session.getUser().getProperty("ExamReport.showSections", "1")));
        ArrayList<IdValue> subjects = new ArrayList<IdValue>();
        subjects.add(new IdValue(null, CONST.select()));
        if (session.hasPermission(Right.DepartmentIndependent)) {
            subjects.add(new IdValue(-1L, CONST.all()));
        }
        TreeSet<SubjectArea> userSubjectAreas = SubjectArea.getUserSubjectAreas(session.getUser(), false);
        for (SubjectArea sa : userSubjectAreas) {
            subjects.add(new IdValue(sa.getUniqueId(), sa.getSubjectAreaAbbreviation()));
        }
        this.setSubjectAreas(subjects);
        this.setSubjectArea(session.getAttribute("ExamReport.subjectArea") == null ? null : (Long)session.getAttribute("ExamReport.subjectArea"));
        if (userSubjectAreas.size() == 1) {
            this.setSubjectArea(userSubjectAreas.first().getUniqueId());
        }
        this.setExamType(session.getAttribute("Exam.Type") == null ? this.iExamType : (Long)session.getAttribute("Exam.Type"));
    }

    public void save(SessionContext session) {
        session.getUser().setProperty("ExamReport.showSections", this.getShowSections() ? "1" : "0");
        if (this.getSubjectArea() == null) {
            session.removeAttribute("ExamReport.subjectArea");
        } else {
            session.setAttribute("ExamReport.subjectArea", (Object)this.getSubjectArea());
        }
        session.setAttribute("Exam.Type", (Object)this.getExamType());
    }

    public void setTable(String table, int cols, int rows) {
        this.iTable = table;
        this.iNrColumns = cols;
        this.iNrRows = rows;
    }

    public String getTable() {
        return this.iTable;
    }

    public int getNrRows() {
        return this.iNrRows;
    }

    public int getNrColumns() {
        return this.iNrColumns;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }
}

