/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ChameleonForm;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.ChameleonUserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Action(value="chameleon", results={@Result(name={"displayForm"}, type="tiles", location="chameleon.tiles"), @Result(name={"reload"}, type="redirect", location="/selectPrimaryRole.action")})
@TilesDefinition(name="chameleon.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Chameleon"), @TilesPutAttribute(name="body", value="/admin/chameleon.jsp"), @TilesPutAttribute(name="checkRole", value="false")})
public class ChameleonAction
extends UniTimeAction<ChameleonForm> {
    private static final long serialVersionUID = -8274614976659449939L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String uid;
    private String uname;

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public String execute() throws Exception {
        UserContext user;
        if (this.form == null) {
            this.form = new ChameleonForm();
            ((ChameleonForm)this.form).reset();
        }
        if ((user = this.sessionContext.getUser()) != null && user instanceof UserContext.Chameleon) {
            user = ((UserContext.Chameleon)((Object)user)).getOriginalUserContext();
        } else {
            this.sessionContext.checkPermission(Right.Chameleon);
        }
        ((ChameleonForm)this.form).setCanLookup(this.sessionContext.hasPermission(Right.HasRole));
        if (this.op == null) {
            this.op = ((ChameleonForm)this.form).getOp();
        } else {
            ((ChameleonForm)this.form).setOp(this.op);
        }
        if (this.uid != null && !this.uid.isEmpty() && ApplicationProperty.ChameleonAllowLookup.isTrue()) {
            ((ChameleonForm)this.form).setPuid(this.uid);
            ((ChameleonForm)this.form).setName(this.uname);
            this.op = MSG.actionChangeUser();
        }
        if ((this.op == null || this.op.isEmpty()) && user != null) {
            ((ChameleonForm)this.form).setPuid(user.getExternalUserId());
        }
        if (MSG.actionChangeUser().equals(this.op)) {
            if (((ChameleonForm)this.form).getPuid() == null || ((ChameleonForm)this.form).getPuid().isEmpty()) {
                this.addActionError(MSG.warnNoUser());
            } else {
                try {
                    this.doSwitch(user);
                    return "reload";
                }
                catch (Exception e) {
                    Debug.error(e);
                    this.addActionError(e.getMessage());
                }
            }
        }
        LookupTables.setupTimetableManagers(this.request);
        return "displayForm";
    }

    private void doSwitch(UserContext user) throws Exception {
        Authentication authentication;
        for (SessionAttribute a : SessionAttribute.values()) {
            this.request.getSession().removeAttribute(a.key());
        }
        if (user instanceof UserContext.Chameleon) {
            user = ((UserContext.Chameleon)((Object)user)).getOriginalUserContext();
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof ChameleonAuthentication) {
            authentication = ((ChameleonAuthentication)authentication).getOriginalAuthentication();
        }
        if (user.getExternalUserId().equals(((ChameleonForm)this.form).getPuid())) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        } else {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new ChameleonAuthentication(authentication, new ChameleonUserContext(((ChameleonForm)this.form).getPuid(), ((ChameleonForm)this.form).getName(), user)));
        }
    }

    public static class ChameleonAuthentication
    implements Authentication {
        private static final long serialVersionUID = 1L;
        private Authentication iOriginalAuthentication;
        private UserContext iUserContext;

        public ChameleonAuthentication(Authentication authentication, UserContext user) {
            this.iOriginalAuthentication = authentication;
            this.iUserContext = user;
            if (this.iOriginalAuthentication instanceof ChameleonAuthentication) {
                this.iOriginalAuthentication = ((ChameleonAuthentication)this.iOriginalAuthentication).getOriginalAuthentication();
            }
        }

        public Authentication getOriginalAuthentication() {
            return this.iOriginalAuthentication;
        }

        public String getName() {
            return this.iUserContext.getName();
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.iUserContext.getAuthorities();
        }

        public Object getCredentials() {
            return this.iOriginalAuthentication.getCredentials();
        }

        public Object getDetails() {
            return this.iOriginalAuthentication.getDetails();
        }

        public Object getPrincipal() {
            return this.iUserContext;
        }

        public boolean isAuthenticated() {
            return this.iOriginalAuthentication.isAuthenticated();
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            this.iOriginalAuthentication.setAuthenticated(isAuthenticated);
        }
    }
}

